% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_placement_group}
\alias{ec2_delete_placement_group}
\title{Deletes the specified placement group}
\usage{
ec2_delete_placement_group(DryRun, GroupName)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupName}{[required] The name of the placement group.}
}
\value{
An empty list.
}
\description{
Deletes the specified placement group. You must terminate all instances
in the placement group before you can delete the placement group. For
more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html}{Placement groups}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_placement_group(
  DryRun = TRUE|FALSE,
  GroupName = "string"
)
}
}

\examples{
\dontrun{
# This example deletes the specified placement group.
# 
svc$delete_placement_group(
  GroupName = "my-cluster"
)
}

}
\keyword{internal}
