% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_network_insights_analyses}
\alias{ec2_describe_network_insights_analyses}
\title{Describes one or more of your network insights analyses}
\usage{
ec2_describe_network_insights_analyses(NetworkInsightsAnalysisIds,
  NetworkInsightsPathId, AnalysisStartTime, AnalysisEndTime, Filters,
  MaxResults, DryRun, NextToken)
}
\arguments{
\item{NetworkInsightsAnalysisIds}{The ID of the network insights analyses. You must specify either
analysis IDs or a path ID.}

\item{NetworkInsightsPathId}{The ID of the path. You must specify either a path ID or analysis IDs.}

\item{AnalysisStartTime}{The time when the network insights analyses started.}

\item{AnalysisEndTime}{The time when the network insights analyses ended.}

\item{Filters}{The filters. The following are possible values:
\itemize{
\item PathFound - A Boolean value that indicates whether a feasible path
is found.
\item Status - The status of the analysis (running | succeeded | failed).
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token for the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  NetworkInsightsAnalyses = list(
    list(
      NetworkInsightsAnalysisId = "string",
      NetworkInsightsAnalysisArn = "string",
      NetworkInsightsPathId = "string",
      FilterInArns = list(
        "string"
      ),
      StartDate = as.POSIXct(
        "2015-01-01"
      ),
      Status = "running"|"succeeded"|"failed",
      StatusMessage = "string",
      NetworkPathFound = TRUE|FALSE,
      ForwardPathComponents = list(
        list(
          SequenceNumber = 123,
          AclRule = list(
            Cidr = "string",
            Egress = TRUE|FALSE,
            PortRange = list(
              From = 123,
              To = 123
            ),
            Protocol = "string",
            RuleAction = "string",
            RuleNumber = 123
          ),
          Component = list(
            Id = "string",
            Arn = "string"
          ),
          DestinationVpc = list(
            Id = "string",
            Arn = "string"
          ),
          OutboundHeader = list(
            DestinationAddresses = list(
              "string"
            ),
            DestinationPortRanges = list(
              list(
                From = 123,
                To = 123
              )
            ),
            Protocol = "string",
            SourceAddresses = list(
              "string"
            ),
            SourcePortRanges = list(
              list(
                From = 123,
                To = 123
              )
            )
          ),
          InboundHeader = list(
            DestinationAddresses = list(
              "string"
            ),
            DestinationPortRanges = list(
              list(
                From = 123,
                To = 123
              )
            ),
            Protocol = "string",
            SourceAddresses = list(
              "string"
            ),
            SourcePortRanges = list(
              list(
                From = 123,
                To = 123
              )
            )
          ),
          RouteTableRoute = list(
            DestinationCidr = "string",
            DestinationPrefixListId = "string",
            EgressOnlyInternetGatewayId = "string",
            GatewayId = "string",
            InstanceId = "string",
            NatGatewayId = "string",
            NetworkInterfaceId = "string",
            Origin = "string",
            TransitGatewayId = "string",
            VpcPeeringConnectionId = "string"
          ),
          SecurityGroupRule = list(
            Cidr = "string",
            Direction = "string",
            SecurityGroupId = "string",
            PortRange = list(
              From = 123,
              To = 123
            ),
            PrefixListId = "string",
            Protocol = "string"
          ),
          SourceVpc = list(
            Id = "string",
            Arn = "string"
          ),
          Subnet = list(
            Id = "string",
            Arn = "string"
          ),
          Vpc = list(
            Id = "string",
            Arn = "string"
          )
        )
      ),
      ReturnPathComponents = list(
        list(
          SequenceNumber = 123,
          AclRule = list(
            Cidr = "string",
            Egress = TRUE|FALSE,
            PortRange = list(
              From = 123,
              To = 123
            ),
            Protocol = "string",
            RuleAction = "string",
            RuleNumber = 123
          ),
          Component = list(
            Id = "string",
            Arn = "string"
          ),
          DestinationVpc = list(
            Id = "string",
            Arn = "string"
          ),
          OutboundHeader = list(
            DestinationAddresses = list(
              "string"
            ),
            DestinationPortRanges = list(
              list(
                From = 123,
                To = 123
              )
            ),
            Protocol = "string",
            SourceAddresses = list(
              "string"
            ),
            SourcePortRanges = list(
              list(
                From = 123,
                To = 123
              )
            )
          ),
          InboundHeader = list(
            DestinationAddresses = list(
              "string"
            ),
            DestinationPortRanges = list(
              list(
                From = 123,
                To = 123
              )
            ),
            Protocol = "string",
            SourceAddresses = list(
              "string"
            ),
            SourcePortRanges = list(
              list(
                From = 123,
                To = 123
              )
            )
          ),
          RouteTableRoute = list(
            DestinationCidr = "string",
            DestinationPrefixListId = "string",
            EgressOnlyInternetGatewayId = "string",
            GatewayId = "string",
            InstanceId = "string",
            NatGatewayId = "string",
            NetworkInterfaceId = "string",
            Origin = "string",
            TransitGatewayId = "string",
            VpcPeeringConnectionId = "string"
          ),
          SecurityGroupRule = list(
            Cidr = "string",
            Direction = "string",
            SecurityGroupId = "string",
            PortRange = list(
              From = 123,
              To = 123
            ),
            PrefixListId = "string",
            Protocol = "string"
          ),
          SourceVpc = list(
            Id = "string",
            Arn = "string"
          ),
          Subnet = list(
            Id = "string",
            Arn = "string"
          ),
          Vpc = list(
            Id = "string",
            Arn = "string"
          )
        )
      ),
      Explanations = list(
        list(
          Acl = list(
            Id = "string",
            Arn = "string"
          ),
          AclRule = list(
            Cidr = "string",
            Egress = TRUE|FALSE,
            PortRange = list(
              From = 123,
              To = 123
            ),
            Protocol = "string",
            RuleAction = "string",
            RuleNumber = 123
          ),
          Address = "string",
          Addresses = list(
            "string"
          ),
          AttachedTo = list(
            Id = "string",
            Arn = "string"
          ),
          AvailabilityZones = list(
            "string"
          ),
          Cidrs = list(
            "string"
          ),
          Component = list(
            Id = "string",
            Arn = "string"
          ),
          CustomerGateway = list(
            Id = "string",
            Arn = "string"
          ),
          Destination = list(
            Id = "string",
            Arn = "string"
          ),
          DestinationVpc = list(
            Id = "string",
            Arn = "string"
          ),
          Direction = "string",
          ExplanationCode = "string",
          IngressRouteTable = list(
            Id = "string",
            Arn = "string"
          ),
          InternetGateway = list(
            Id = "string",
            Arn = "string"
          ),
          LoadBalancerArn = "string",
          ClassicLoadBalancerListener = list(
            LoadBalancerPort = 123,
            InstancePort = 123
          ),
          LoadBalancerListenerPort = 123,
          LoadBalancerTarget = list(
            Address = "string",
            AvailabilityZone = "string",
            Instance = list(
              Id = "string",
              Arn = "string"
            ),
            Port = 123
          ),
          LoadBalancerTargetGroup = list(
            Id = "string",
            Arn = "string"
          ),
          LoadBalancerTargetGroups = list(
            list(
              Id = "string",
              Arn = "string"
            )
          ),
          LoadBalancerTargetPort = 123,
          ElasticLoadBalancerListener = list(
            Id = "string",
            Arn = "string"
          ),
          MissingComponent = "string",
          NatGateway = list(
            Id = "string",
            Arn = "string"
          ),
          NetworkInterface = list(
            Id = "string",
            Arn = "string"
          ),
          PacketField = "string",
          VpcPeeringConnection = list(
            Id = "string",
            Arn = "string"
          ),
          Port = 123,
          PortRanges = list(
            list(
              From = 123,
              To = 123
            )
          ),
          PrefixList = list(
            Id = "string",
            Arn = "string"
          ),
          Protocols = list(
            "string"
          ),
          RouteTableRoute = list(
            DestinationCidr = "string",
            DestinationPrefixListId = "string",
            EgressOnlyInternetGatewayId = "string",
            GatewayId = "string",
            InstanceId = "string",
            NatGatewayId = "string",
            NetworkInterfaceId = "string",
            Origin = "string",
            TransitGatewayId = "string",
            VpcPeeringConnectionId = "string"
          ),
          RouteTable = list(
            Id = "string",
            Arn = "string"
          ),
          SecurityGroup = list(
            Id = "string",
            Arn = "string"
          ),
          SecurityGroupRule = list(
            Cidr = "string",
            Direction = "string",
            SecurityGroupId = "string",
            PortRange = list(
              From = 123,
              To = 123
            ),
            PrefixListId = "string",
            Protocol = "string"
          ),
          SecurityGroups = list(
            list(
              Id = "string",
              Arn = "string"
            )
          ),
          SourceVpc = list(
            Id = "string",
            Arn = "string"
          ),
          State = "string",
          Subnet = list(
            Id = "string",
            Arn = "string"
          ),
          SubnetRouteTable = list(
            Id = "string",
            Arn = "string"
          ),
          Vpc = list(
            Id = "string",
            Arn = "string"
          ),
          VpcEndpoint = list(
            Id = "string",
            Arn = "string"
          ),
          VpnConnection = list(
            Id = "string",
            Arn = "string"
          ),
          VpnGateway = list(
            Id = "string",
            Arn = "string"
          )
        )
      ),
      AlternatePathHints = list(
        list(
          ComponentId = "string",
          ComponentArn = "string"
        )
      ),
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes one or more of your network insights analyses.
}
\section{Request syntax}{
\preformatted{svc$describe_network_insights_analyses(
  NetworkInsightsAnalysisIds = list(
    "string"
  ),
  NetworkInsightsPathId = "string",
  AnalysisStartTime = as.POSIXct(
    "2015-01-01"
  ),
  AnalysisEndTime = as.POSIXct(
    "2015-01-01"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  DryRun = TRUE|FALSE,
  NextToken = "string"
)
}
}

\keyword{internal}
