% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_prefix_lists}
\alias{ec2_describe_prefix_lists}
\title{Describes available AWS services in a prefix list format, which includes
the prefix list name and prefix list ID of the service and the IP
address range for the service}
\usage{
ec2_describe_prefix_lists(DryRun, Filters, MaxResults, NextToken,
  PrefixListIds)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters.
\itemize{
\item \code{prefix-list-id}: The ID of a prefix list.
\item \code{prefix-list-name}: The name of a prefix list.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{PrefixListIds}{One or more prefix list IDs.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  PrefixLists = list(
    list(
      Cidrs = list(
        "string"
      ),
      PrefixListId = "string",
      PrefixListName = "string"
    )
  )
)
}
}
\description{
Describes available AWS services in a prefix list format, which includes
the prefix list name and prefix list ID of the service and the IP
address range for the service.

We recommend that you use
\code{\link[=ec2_describe_managed_prefix_lists]{describe_managed_prefix_lists}}
instead.
}
\section{Request syntax}{
\preformatted{svc$describe_prefix_lists(
  DryRun = TRUE|FALSE,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  PrefixListIds = list(
    "string"
  )
)
}
}

\keyword{internal}
