% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_relational_database_bundles}
\alias{lightsail_get_relational_database_bundles}
\title{Returns the list of bundles that are available in Amazon Lightsail}
\usage{
lightsail_get_relational_database_bundles(pageToken)
}
\arguments{
\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial
\code{\link[=lightsail_get_relational_database_bundles]{get_relational_database_bundles}}
request. If your results are paginated, the response will return a next
page token that you can specify as the page token in a subsequent
request.}
}
\value{
A list with the following syntax:\preformatted{list(
  bundles = list(
    list(
      bundleId = "string",
      name = "string",
      price = 123.0,
      ramSizeInGb = 123.0,
      diskSizeInGb = 123,
      transferPerMonthInGb = 123,
      cpuCount = 123,
      isEncrypted = TRUE|FALSE,
      isActive = TRUE|FALSE
    )
  ),
  nextPageToken = "string"
)
}
}
\description{
Returns the list of bundles that are available in Amazon Lightsail. A
bundle describes the performance specifications for a database.

You can use a bundle ID to create a new database with explicit
performance specifications.
}
\section{Request syntax}{
\preformatted{svc$get_relational_database_bundles(
  pageToken = "string"
)
}
}

\keyword{internal}
