# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ec2_service.R
NULL

#' Accepts the Convertible Reserved Instance exchange quote described in
#' the GetReservedInstancesExchangeQuote call
#'
#' @description
#' Accepts the Convertible Reserved Instance exchange quote described in
#' the
#' [`get_reserved_instances_exchange_quote`][ec2_get_reserved_instances_exchange_quote]
#' call.
#'
#' @usage
#' ec2_accept_reserved_instances_exchange_quote(DryRun,
#'   ReservedInstanceIds, TargetConfigurations)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReservedInstanceIds &#91;required&#93; The IDs of the Convertible Reserved Instances to exchange for another
#' Convertible Reserved Instance of the same or higher value.
#' @param TargetConfigurations The configuration of the target Convertible Reserved Instance to
#' exchange for your current Convertible Reserved Instances.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ExchangeId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$accept_reserved_instances_exchange_quote(
#'   DryRun = TRUE|FALSE,
#'   ReservedInstanceIds = list(
#'     "string"
#'   ),
#'   TargetConfigurations = list(
#'     list(
#'       InstanceCount = 123,
#'       OfferingId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_reserved_instances_exchange_quote
ec2_accept_reserved_instances_exchange_quote <- function(DryRun = NULL, ReservedInstanceIds, TargetConfigurations = NULL) {
  op <- new_operation(
    name = "AcceptReservedInstancesExchangeQuote",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_reserved_instances_exchange_quote_input(DryRun = DryRun, ReservedInstanceIds = ReservedInstanceIds, TargetConfigurations = TargetConfigurations)
  output <- .ec2$accept_reserved_instances_exchange_quote_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_reserved_instances_exchange_quote <- ec2_accept_reserved_instances_exchange_quote

#' Accepts a request to associate subnets with a transit gateway multicast
#' domain
#'
#' @description
#' Accepts a request to associate subnets with a transit gateway multicast
#' domain.
#'
#' @usage
#' ec2_accept_transit_gateway_multicast_domain_associations(
#'   TransitGatewayMulticastDomainId, TransitGatewayAttachmentId, SubnetIds,
#'   DryRun)
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param TransitGatewayAttachmentId The ID of the transit gateway attachment.
#' @param SubnetIds The IDs of the subnets to associate with the transit gateway multicast
#' domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Associations = list(
#'     TransitGatewayMulticastDomainId = "string",
#'     TransitGatewayAttachmentId = "string",
#'     ResourceId = "string",
#'     ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering",
#'     ResourceOwnerId = "string",
#'     Subnets = list(
#'       list(
#'         SubnetId = "string",
#'         State = "pendingAcceptance"|"associating"|"associated"|"disassociating"|"disassociated"|"rejected"|"failed"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$accept_transit_gateway_multicast_domain_associations(
#'   TransitGatewayMulticastDomainId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_transit_gateway_multicast_domain_associations
ec2_accept_transit_gateway_multicast_domain_associations <- function(TransitGatewayMulticastDomainId = NULL, TransitGatewayAttachmentId = NULL, SubnetIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AcceptTransitGatewayMulticastDomainAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_transit_gateway_multicast_domain_associations_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, SubnetIds = SubnetIds, DryRun = DryRun)
  output <- .ec2$accept_transit_gateway_multicast_domain_associations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_transit_gateway_multicast_domain_associations <- ec2_accept_transit_gateway_multicast_domain_associations

#' Accepts a transit gateway peering attachment request
#'
#' @description
#' Accepts a transit gateway peering attachment request. The peering
#' attachment must be in the `pendingAcceptance` state.
#'
#' @usage
#' ec2_accept_transit_gateway_peering_attachment(
#'   TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayPeeringAttachment = list(
#'     TransitGatewayAttachmentId = "string",
#'     RequesterTgwInfo = list(
#'       TransitGatewayId = "string",
#'       OwnerId = "string",
#'       Region = "string"
#'     ),
#'     AccepterTgwInfo = list(
#'       TransitGatewayId = "string",
#'       OwnerId = "string",
#'       Region = "string"
#'     ),
#'     Status = list(
#'       Code = "string",
#'       Message = "string"
#'     ),
#'     State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$accept_transit_gateway_peering_attachment(
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_transit_gateway_peering_attachment
ec2_accept_transit_gateway_peering_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AcceptTransitGatewayPeeringAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_transit_gateway_peering_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$accept_transit_gateway_peering_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_transit_gateway_peering_attachment <- ec2_accept_transit_gateway_peering_attachment

#' Accepts a request to attach a VPC to a transit gateway
#'
#' @description
#' Accepts a request to attach a VPC to a transit gateway.
#' 
#' The VPC attachment must be in the `pendingAcceptance` state. Use
#' [`describe_transit_gateway_vpc_attachments`][ec2_describe_transit_gateway_vpc_attachments]
#' to view your pending VPC attachment requests. Use
#' [`reject_transit_gateway_vpc_attachment`][ec2_reject_transit_gateway_vpc_attachment]
#' to reject a VPC attachment request.
#'
#' @usage
#' ec2_accept_transit_gateway_vpc_attachment(TransitGatewayAttachmentId,
#'   DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayVpcAttachment = list(
#'     TransitGatewayAttachmentId = "string",
#'     TransitGatewayId = "string",
#'     VpcId = "string",
#'     VpcOwnerId = "string",
#'     State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Options = list(
#'       DnsSupport = "enable"|"disable",
#'       Ipv6Support = "enable"|"disable",
#'       ApplianceModeSupport = "enable"|"disable"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$accept_transit_gateway_vpc_attachment(
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_transit_gateway_vpc_attachment
ec2_accept_transit_gateway_vpc_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AcceptTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_transit_gateway_vpc_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$accept_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_transit_gateway_vpc_attachment <- ec2_accept_transit_gateway_vpc_attachment

#' Accepts one or more interface VPC endpoint connection requests to your
#' VPC endpoint service
#'
#' @description
#' Accepts one or more interface VPC endpoint connection requests to your
#' VPC endpoint service.
#'
#' @usage
#' ec2_accept_vpc_endpoint_connections(DryRun, ServiceId, VpcEndpointIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceId &#91;required&#93; The ID of the VPC endpoint service.
#' @param VpcEndpointIds &#91;required&#93; The IDs of one or more interface VPC endpoints.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Unsuccessful = list(
#'     list(
#'       Error = list(
#'         Code = "string",
#'         Message = "string"
#'       ),
#'       ResourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$accept_vpc_endpoint_connections(
#'   DryRun = TRUE|FALSE,
#'   ServiceId = "string",
#'   VpcEndpointIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_vpc_endpoint_connections
ec2_accept_vpc_endpoint_connections <- function(DryRun = NULL, ServiceId, VpcEndpointIds) {
  op <- new_operation(
    name = "AcceptVpcEndpointConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_vpc_endpoint_connections_input(DryRun = DryRun, ServiceId = ServiceId, VpcEndpointIds = VpcEndpointIds)
  output <- .ec2$accept_vpc_endpoint_connections_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_vpc_endpoint_connections <- ec2_accept_vpc_endpoint_connections

#' Accept a VPC peering connection request
#'
#' @description
#' Accept a VPC peering connection request. To accept a request, the VPC
#' peering connection must be in the `pending-acceptance` state, and you
#' must be the owner of the peer VPC. Use
#' [`describe_vpc_peering_connections`][ec2_describe_vpc_peering_connections]
#' to view your outstanding VPC peering connection requests.
#' 
#' For an inter-Region VPC peering connection request, you must accept the
#' VPC peering connection in the Region of the accepter VPC.
#'
#' @usage
#' ec2_accept_vpc_peering_connection(DryRun, VpcPeeringConnectionId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcPeeringConnectionId The ID of the VPC peering connection. You must specify this parameter in
#' the request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   VpcPeeringConnection = list(
#'     AccepterVpcInfo = list(
#'       CidrBlock = "string",
#'       Ipv6CidrBlockSet = list(
#'         list(
#'           Ipv6CidrBlock = "string"
#'         )
#'       ),
#'       CidrBlockSet = list(
#'         list(
#'           CidrBlock = "string"
#'         )
#'       ),
#'       OwnerId = "string",
#'       PeeringOptions = list(
#'         AllowDnsResolutionFromRemoteVpc = TRUE|FALSE,
#'         AllowEgressFromLocalClassicLinkToRemoteVpc = TRUE|FALSE,
#'         AllowEgressFromLocalVpcToRemoteClassicLink = TRUE|FALSE
#'       ),
#'       VpcId = "string",
#'       Region = "string"
#'     ),
#'     ExpirationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     RequesterVpcInfo = list(
#'       CidrBlock = "string",
#'       Ipv6CidrBlockSet = list(
#'         list(
#'           Ipv6CidrBlock = "string"
#'         )
#'       ),
#'       CidrBlockSet = list(
#'         list(
#'           CidrBlock = "string"
#'         )
#'       ),
#'       OwnerId = "string",
#'       PeeringOptions = list(
#'         AllowDnsResolutionFromRemoteVpc = TRUE|FALSE,
#'         AllowEgressFromLocalClassicLinkToRemoteVpc = TRUE|FALSE,
#'         AllowEgressFromLocalVpcToRemoteClassicLink = TRUE|FALSE
#'       ),
#'       VpcId = "string",
#'       Region = "string"
#'     ),
#'     Status = list(
#'       Code = "initiating-request"|"pending-acceptance"|"active"|"deleted"|"rejected"|"failed"|"expired"|"provisioning"|"deleting",
#'       Message = "string"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     VpcPeeringConnectionId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$accept_vpc_peering_connection(
#'   DryRun = TRUE|FALSE,
#'   VpcPeeringConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_vpc_peering_connection
ec2_accept_vpc_peering_connection <- function(DryRun = NULL, VpcPeeringConnectionId = NULL) {
  op <- new_operation(
    name = "AcceptVpcPeeringConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_vpc_peering_connection_input(DryRun = DryRun, VpcPeeringConnectionId = VpcPeeringConnectionId)
  output <- .ec2$accept_vpc_peering_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_vpc_peering_connection <- ec2_accept_vpc_peering_connection

#' Advertises an IPv4 or IPv6 address range that is provisioned for use
#' with your AWS resources through bring your own IP addresses (BYOIP)
#'
#' @description
#' Advertises an IPv4 or IPv6 address range that is provisioned for use
#' with your AWS resources through bring your own IP addresses (BYOIP).
#' 
#' You can perform this operation at most once every 10 seconds, even if
#' you specify different address ranges each time.
#' 
#' We recommend that you stop advertising the BYOIP CIDR from other
#' locations when you advertise it from AWS. To minimize down time, you can
#' configure your AWS resources to use an address from a BYOIP CIDR before
#' it is advertised, and then simultaneously stop advertising it from the
#' current location and start advertising it through AWS.
#' 
#' It can take a few minutes before traffic to the specified addresses
#' starts routing to AWS because of BGP propagation delays.
#' 
#' To stop advertising the BYOIP CIDR, use
#' [`withdraw_byoip_cidr`][ec2_withdraw_byoip_cidr].
#'
#' @usage
#' ec2_advertise_byoip_cidr(Cidr, DryRun)
#'
#' @param Cidr &#91;required&#93; The address range, in CIDR notation. This must be the exact range that
#' you provisioned. You can't advertise only a portion of the provisioned
#' range.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ByoipCidr = list(
#'     Cidr = "string",
#'     Description = "string",
#'     StatusMessage = "string",
#'     State = "advertised"|"deprovisioned"|"failed-deprovision"|"failed-provision"|"pending-deprovision"|"pending-provision"|"provisioned"|"provisioned-not-publicly-advertisable"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$advertise_byoip_cidr(
#'   Cidr = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_advertise_byoip_cidr
ec2_advertise_byoip_cidr <- function(Cidr, DryRun = NULL) {
  op <- new_operation(
    name = "AdvertiseByoipCidr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$advertise_byoip_cidr_input(Cidr = Cidr, DryRun = DryRun)
  output <- .ec2$advertise_byoip_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$advertise_byoip_cidr <- ec2_advertise_byoip_cidr

#' Allocates an Elastic IP address to your AWS account
#'
#' @description
#' Allocates an Elastic IP address to your AWS account. After you allocate
#' the Elastic IP address you can associate it with an instance or network
#' interface. After you release an Elastic IP address, it is released to
#' the IP address pool and can be allocated to a different AWS account.
#' 
#' You can allocate an Elastic IP address from an address pool owned by AWS
#' or from an address pool created from a public IPv4 address range that
#' you have brought to AWS for use with your AWS resources using bring your
#' own IP addresses (BYOIP). For more information, see [Bring Your Own IP
#' Addresses
#' (BYOIP)](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' \[EC2-VPC\] If you release an Elastic IP address, you might be able to
#' recover it. You cannot recover an Elastic IP address that you released
#' after it is allocated to another AWS account. You cannot recover an
#' Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP
#' address that you released, specify it in this operation.
#' 
#' An Elastic IP address is for use either in the EC2-Classic platform or
#' in a VPC. By default, you can allocate 5 Elastic IP addresses for
#' EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per
#' Region.
#' 
#' For more information, see [Elastic IP
#' Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' You can allocate a carrier IP address which is a public IP address from
#' a telecommunication carrier, to a network interface which resides in a
#' subnet in a Wavelength Zone (for example an EC2 instance).
#'
#' @usage
#' ec2_allocate_address(Domain, Address, PublicIpv4Pool,
#'   NetworkBorderGroup, CustomerOwnedIpv4Pool, DryRun, TagSpecifications)
#'
#' @param Domain Indicates whether the Elastic IP address is for use with instances in a
#' VPC or instances in EC2-Classic.
#' 
#' Default: If the Region supports EC2-Classic, the default is `standard`.
#' Otherwise, the default is `vpc`.
#' @param Address \[EC2-VPC\] The Elastic IP address to recover or an IPv4 address from an
#' address pool.
#' @param PublicIpv4Pool The ID of an address pool that you own. Use this parameter to let Amazon
#' EC2 select an address from the address pool. To specify a specific
#' address from the address pool, use the `Address` parameter instead.
#' @param NetworkBorderGroup A unique set of Availability Zones, Local Zones, or Wavelength Zones
#' from which AWS advertises IP addresses. Use this parameter to limit the
#' IP address to this location. IP addresses cannot move between network
#' border groups.
#' 
#' Use [`describe_availability_zones`][ec2_describe_availability_zones] to
#' view the network border groups.
#' 
#' You cannot use a network border group with EC2 Classic. If you attempt
#' this operation on EC2 classic, you will receive an
#' `InvalidParameterCombination` error. For more information, see [Error
#' Codes](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html).
#' @param CustomerOwnedIpv4Pool The ID of a customer-owned address pool. Use this parameter to let
#' Amazon EC2 select an address from the address pool. Alternatively,
#' specify a specific address from the address pool.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param TagSpecifications The tags to assign to the Elastic IP address.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PublicIp = "string",
#'   AllocationId = "string",
#'   PublicIpv4Pool = "string",
#'   NetworkBorderGroup = "string",
#'   Domain = "vpc"|"standard",
#'   CustomerOwnedIp = "string",
#'   CustomerOwnedIpv4Pool = "string",
#'   CarrierIp = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$allocate_address(
#'   Domain = "vpc"|"standard",
#'   Address = "string",
#'   PublicIpv4Pool = "string",
#'   NetworkBorderGroup = "string",
#'   CustomerOwnedIpv4Pool = "string",
#'   DryRun = TRUE|FALSE,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example allocates an Elastic IP address to use with an instance in
#' # a VPC.
#' svc$allocate_address(
#'   Domain = "vpc"
#' )
#' 
#' # This example allocates an Elastic IP address to use with an instance in
#' # EC2-Classic.
#' svc$allocate_address()
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_allocate_address
ec2_allocate_address <- function(Domain = NULL, Address = NULL, PublicIpv4Pool = NULL, NetworkBorderGroup = NULL, CustomerOwnedIpv4Pool = NULL, DryRun = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "AllocateAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$allocate_address_input(Domain = Domain, Address = Address, PublicIpv4Pool = PublicIpv4Pool, NetworkBorderGroup = NetworkBorderGroup, CustomerOwnedIpv4Pool = CustomerOwnedIpv4Pool, DryRun = DryRun, TagSpecifications = TagSpecifications)
  output <- .ec2$allocate_address_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$allocate_address <- ec2_allocate_address

#' Allocates a Dedicated Host to your account
#'
#' @description
#' Allocates a Dedicated Host to your account. At a minimum, specify the
#' supported instance type or instance family, the Availability Zone in
#' which to allocate the host, and the number of hosts to allocate.
#'
#' @usage
#' ec2_allocate_hosts(AutoPlacement, AvailabilityZone, ClientToken,
#'   InstanceType, InstanceFamily, Quantity, TagSpecifications, HostRecovery)
#'
#' @param AutoPlacement Indicates whether the host accepts any untargeted instance launches that
#' match its instance type configuration, or if it only accepts Host
#' tenancy instance launches that specify its unique host ID. For more
#' information, see [Understanding Instance Placement and Host
#' Affinity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' Default: `on`
#' @param AvailabilityZone &#91;required&#93; The Availability Zone in which to allocate the Dedicated Host.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param InstanceType Specifies the instance type to be supported by the Dedicated Hosts. If
#' you specify an instance type, the Dedicated Hosts support instances of
#' the specified instance type only.
#' 
#' If you want the Dedicated Hosts to support multiple instance types in a
#' specific instance family, omit this parameter and specify
#' **InstanceFamily** instead. You cannot specify **InstanceType** and
#' **InstanceFamily** in the same request.
#' @param InstanceFamily Specifies the instance family to be supported by the Dedicated Hosts. If
#' you specify an instance family, the Dedicated Hosts support multiple
#' instance types within that instance family.
#' 
#' If you want the Dedicated Hosts to support a specific instance type
#' only, omit this parameter and specify **InstanceType** instead. You
#' cannot specify **InstanceFamily** and **InstanceType** in the same
#' request.
#' @param Quantity &#91;required&#93; The number of Dedicated Hosts to allocate to your account with these
#' parameters.
#' @param TagSpecifications The tags to apply to the Dedicated Host during creation.
#' @param HostRecovery Indicates whether to enable or disable host recovery for the Dedicated
#' Host. Host recovery is disabled by default. For more information, see
#' [Host
#' Recovery](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' Default: `off`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   HostIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$allocate_hosts(
#'   AutoPlacement = "on"|"off",
#'   AvailabilityZone = "string",
#'   ClientToken = "string",
#'   InstanceType = "string",
#'   InstanceFamily = "string",
#'   Quantity = 123,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   HostRecovery = "on"|"off"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_allocate_hosts
ec2_allocate_hosts <- function(AutoPlacement = NULL, AvailabilityZone, ClientToken = NULL, InstanceType = NULL, InstanceFamily = NULL, Quantity, TagSpecifications = NULL, HostRecovery = NULL) {
  op <- new_operation(
    name = "AllocateHosts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$allocate_hosts_input(AutoPlacement = AutoPlacement, AvailabilityZone = AvailabilityZone, ClientToken = ClientToken, InstanceType = InstanceType, InstanceFamily = InstanceFamily, Quantity = Quantity, TagSpecifications = TagSpecifications, HostRecovery = HostRecovery)
  output <- .ec2$allocate_hosts_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$allocate_hosts <- ec2_allocate_hosts

#' Applies a security group to the association between the target network
#' and the Client VPN endpoint
#'
#' @description
#' Applies a security group to the association between the target network
#' and the Client VPN endpoint. This action replaces the existing security
#' groups with the specified security groups.
#'
#' @usage
#' ec2_apply_security_groups_to_client_vpn_target_network(
#'   ClientVpnEndpointId, VpcId, SecurityGroupIds, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param VpcId &#91;required&#93; The ID of the VPC in which the associated target network is located.
#' @param SecurityGroupIds &#91;required&#93; The IDs of the security groups to apply to the associated target
#' network. Up to 5 security groups can be applied to an associated target
#' network.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SecurityGroupIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$apply_security_groups_to_client_vpn_target_network(
#'   ClientVpnEndpointId = "string",
#'   VpcId = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_apply_security_groups_to_client_vpn_target_network
ec2_apply_security_groups_to_client_vpn_target_network <- function(ClientVpnEndpointId, VpcId, SecurityGroupIds, DryRun = NULL) {
  op <- new_operation(
    name = "ApplySecurityGroupsToClientVpnTargetNetwork",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$apply_security_groups_to_client_vpn_target_network_input(ClientVpnEndpointId = ClientVpnEndpointId, VpcId = VpcId, SecurityGroupIds = SecurityGroupIds, DryRun = DryRun)
  output <- .ec2$apply_security_groups_to_client_vpn_target_network_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$apply_security_groups_to_client_vpn_target_network <- ec2_apply_security_groups_to_client_vpn_target_network

#' Assigns one or more IPv6 addresses to the specified network interface
#'
#' @description
#' Assigns one or more IPv6 addresses to the specified network interface.
#' You can specify one or more specific IPv6 addresses, or you can specify
#' the number of IPv6 addresses to be automatically assigned from within
#' the subnet's IPv6 CIDR block range. You can assign as many IPv6
#' addresses to a network interface as you can assign private IPv4
#' addresses, and the limit varies per instance type. For information, see
#' [IP Addresses Per Network Interface Per Instance
#' Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' You must specify either the IPv6 addresses or the IPv6 address count in
#' the request.
#'
#' @usage
#' ec2_assign_ipv_6_addresses(Ipv6AddressCount, Ipv6Addresses,
#'   NetworkInterfaceId)
#'
#' @param Ipv6AddressCount The number of IPv6 addresses to assign to the network interface. Amazon
#' EC2 automatically selects the IPv6 addresses from the subnet range. You
#' can't use this option if specifying specific IPv6 addresses.
#' @param Ipv6Addresses One or more specific IPv6 addresses to be assigned to the network
#' interface. You can't use this option if you're specifying a number of
#' IPv6 addresses.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AssignedIpv6Addresses = list(
#'     "string"
#'   ),
#'   NetworkInterfaceId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$assign_ipv_6_addresses(
#'   Ipv6AddressCount = 123,
#'   Ipv6Addresses = list(
#'     "string"
#'   ),
#'   NetworkInterfaceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_assign_ipv_6_addresses
ec2_assign_ipv_6_addresses <- function(Ipv6AddressCount = NULL, Ipv6Addresses = NULL, NetworkInterfaceId) {
  op <- new_operation(
    name = "AssignIpv6Addresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$assign_ipv_6_addresses_input(Ipv6AddressCount = Ipv6AddressCount, Ipv6Addresses = Ipv6Addresses, NetworkInterfaceId = NetworkInterfaceId)
  output <- .ec2$assign_ipv_6_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$assign_ipv_6_addresses <- ec2_assign_ipv_6_addresses

#' Assigns one or more secondary private IP addresses to the specified
#' network interface
#'
#' @description
#' Assigns one or more secondary private IP addresses to the specified
#' network interface.
#' 
#' You can specify one or more specific secondary IP addresses, or you can
#' specify the number of secondary IP addresses to be automatically
#' assigned within the subnet's CIDR block range. The number of secondary
#' IP addresses that you can assign to an instance varies by instance type.
#' For information about instance types, see [Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon Elastic Compute Cloud User Guide*. For more information
#' about Elastic IP addresses, see [Elastic IP
#' Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' When you move a secondary private IP address to another network
#' interface, any Elastic IP address that is associated with the IP address
#' is also moved.
#' 
#' Remapping an IP address is an asynchronous operation. When you move an
#' IP address from one network interface to another, check
#' `network/interfaces/macs/mac/local-ipv4s` in the instance metadata to
#' confirm that the remapping is complete.
#' 
#' You must specify either the IP addresses or the IP address count in the
#' request.
#'
#' @usage
#' ec2_assign_private_ip_addresses(AllowReassignment, NetworkInterfaceId,
#'   PrivateIpAddresses, SecondaryPrivateIpAddressCount)
#'
#' @param AllowReassignment Indicates whether to allow an IP address that is already assigned to
#' another network interface or instance to be reassigned to the specified
#' network interface.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param PrivateIpAddresses One or more IP addresses to be assigned as a secondary private IP
#' address to the network interface. You can't specify this parameter when
#' also specifying a number of secondary IP addresses.
#' 
#' If you don't specify an IP address, Amazon EC2 automatically selects an
#' IP address within the subnet range.
#' @param SecondaryPrivateIpAddressCount The number of secondary IP addresses to assign to the network interface.
#' You can't specify this parameter when also specifying private IP
#' addresses.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkInterfaceId = "string",
#'   AssignedPrivateIpAddresses = list(
#'     list(
#'       PrivateIpAddress = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$assign_private_ip_addresses(
#'   AllowReassignment = TRUE|FALSE,
#'   NetworkInterfaceId = "string",
#'   PrivateIpAddresses = list(
#'     "string"
#'   ),
#'   SecondaryPrivateIpAddressCount = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example assigns the specified secondary private IP address to the
#' # specified network interface.
#' svc$assign_private_ip_addresses(
#'   NetworkInterfaceId = "eni-e5aa89a3",
#'   PrivateIpAddresses = list(
#'     "10.0.0.82"
#'   )
#' )
#' 
#' # This example assigns two secondary private IP addresses to the specified
#' # network interface. Amazon EC2 automatically assigns these IP addresses
#' # from the available IP addresses in the CIDR block range of the subnet
#' # the network interface is associated with.
#' svc$assign_private_ip_addresses(
#'   NetworkInterfaceId = "eni-e5aa89a3",
#'   SecondaryPrivateIpAddressCount = 2L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_assign_private_ip_addresses
ec2_assign_private_ip_addresses <- function(AllowReassignment = NULL, NetworkInterfaceId, PrivateIpAddresses = NULL, SecondaryPrivateIpAddressCount = NULL) {
  op <- new_operation(
    name = "AssignPrivateIpAddresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$assign_private_ip_addresses_input(AllowReassignment = AllowReassignment, NetworkInterfaceId = NetworkInterfaceId, PrivateIpAddresses = PrivateIpAddresses, SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount)
  output <- .ec2$assign_private_ip_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$assign_private_ip_addresses <- ec2_assign_private_ip_addresses

#' Associates an Elastic IP address, or carrier IP address (for instances
#' that are in subnets in Wavelength Zones) with an instance or a network
#' interface
#'
#' @description
#' Associates an Elastic IP address, or carrier IP address (for instances
#' that are in subnets in Wavelength Zones) with an instance or a network
#' interface. Before you can use an Elastic IP address, you must allocate
#' it to your account.
#' 
#' An Elastic IP address is for use in either the EC2-Classic platform or
#' in a VPC. For more information, see [Elastic IP
#' Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' \[EC2-Classic, VPC in an EC2-VPC-only account\] If the Elastic IP
#' address is already associated with a different instance, it is
#' disassociated from that instance and associated with the specified
#' instance. If you associate an Elastic IP address with an instance that
#' has an existing Elastic IP address, the existing address is
#' disassociated from the instance, but remains allocated to your account.
#' 
#' \[VPC in an EC2-Classic account\] If you don't specify a private IP
#' address, the Elastic IP address is associated with the primary IP
#' address. If the Elastic IP address is already associated with a
#' different instance or a network interface, you get an error unless you
#' allow reassociation. You cannot associate an Elastic IP address with an
#' instance or network interface that has an existing Elastic IP address.
#' 
#' \[Subnets in Wavelength Zones\] You can associate an IP address from the
#' telecommunication carrier to the instance or network interface.
#' 
#' You cannot associate an Elastic IP address with an interface in a
#' different network border group.
#' 
#' This is an idempotent operation. If you perform the operation more than
#' once, Amazon EC2 doesn't return an error, and you may be charged for
#' each time the Elastic IP address is remapped to the same instance. For
#' more information, see the *Elastic IP Addresses* section of [Amazon EC2
#' Pricing](https://aws.amazon.com/ec2/pricing/).
#'
#' @usage
#' ec2_associate_address(AllocationId, InstanceId, PublicIp,
#'   AllowReassociation, DryRun, NetworkInterfaceId, PrivateIpAddress)
#'
#' @param AllocationId \[EC2-VPC\] The allocation ID. This is required for EC2-VPC.
#' @param InstanceId The ID of the instance. This is required for EC2-Classic. For EC2-VPC,
#' you can specify either the instance ID or the network interface ID, but
#' not both. The operation fails if you specify an instance ID unless
#' exactly one network interface is attached.
#' @param PublicIp The Elastic IP address to associate with the instance. This is required
#' for EC2-Classic.
#' @param AllowReassociation \[EC2-VPC\] For a VPC in an EC2-Classic account, specify true to allow
#' an Elastic IP address that is already associated with an instance or
#' network interface to be reassociated with the specified instance or
#' network interface. Otherwise, the operation fails. In a VPC in an
#' EC2-VPC-only account, reassociation is automatic, therefore you can
#' specify false to ensure the operation fails if the Elastic IP address is
#' already associated with another resource.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId \[EC2-VPC\] The ID of the network interface. If the instance has more
#' than one network interface, you must specify a network interface ID.
#' 
#' For EC2-VPC, you can specify either the instance ID or the network
#' interface ID, but not both.
#' @param PrivateIpAddress \[EC2-VPC\] The primary or secondary private IP address to associate
#' with the Elastic IP address. If no private IP address is specified, the
#' Elastic IP address is associated with the primary private IP address.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AssociationId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_address(
#'   AllocationId = "string",
#'   InstanceId = "string",
#'   PublicIp = "string",
#'   AllowReassociation = TRUE|FALSE,
#'   DryRun = TRUE|FALSE,
#'   NetworkInterfaceId = "string",
#'   PrivateIpAddress = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example associates the specified Elastic IP address with the
#' # specified instance in a VPC.
#' svc$associate_address(
#'   AllocationId = "eipalloc-64d5890a",
#'   InstanceId = "i-0b263919b6498b123"
#' )
#' 
#' # This example associates the specified Elastic IP address with the
#' # specified network interface.
#' svc$associate_address(
#'   AllocationId = "eipalloc-64d5890a",
#'   NetworkInterfaceId = "eni-1a2b3c4d"
#' )
#' 
#' # This example associates an Elastic IP address with an instance in
#' # EC2-Classic.
#' svc$associate_address(
#'   InstanceId = "i-07ffe74c7330ebf53",
#'   PublicIp = "198.51.100.0"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_associate_address
ec2_associate_address <- function(AllocationId = NULL, InstanceId = NULL, PublicIp = NULL, AllowReassociation = NULL, DryRun = NULL, NetworkInterfaceId = NULL, PrivateIpAddress = NULL) {
  op <- new_operation(
    name = "AssociateAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_address_input(AllocationId = AllocationId, InstanceId = InstanceId, PublicIp = PublicIp, AllowReassociation = AllowReassociation, DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId, PrivateIpAddress = PrivateIpAddress)
  output <- .ec2$associate_address_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_address <- ec2_associate_address

#' Associates a target network with a Client VPN endpoint
#'
#' @description
#' Associates a target network with a Client VPN endpoint. A target network
#' is a subnet in a VPC. You can associate multiple subnets from the same
#' VPC with a Client VPN endpoint. You can associate only one subnet in
#' each Availability Zone. We recommend that you associate at least two
#' subnets to provide Availability Zone redundancy.
#' 
#' If you specified a VPC when you created the Client VPN endpoint or if
#' you have previous subnet associations, the specified subnet must be in
#' the same VPC. To specify a subnet that's in a different VPC, you must
#' first modify the Client VPN endpoint
#' ([`modify_client_vpn_endpoint`][ec2_modify_client_vpn_endpoint]) and
#' change the VPC that's associated with it.
#'
#' @usage
#' ec2_associate_client_vpn_target_network(ClientVpnEndpointId, SubnetId,
#'   ClientToken, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param SubnetId &#91;required&#93; The ID of the subnet to associate with the Client VPN endpoint.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AssociationId = "string",
#'   Status = list(
#'     Code = "associating"|"associated"|"association-failed"|"disassociating"|"disassociated",
#'     Message = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_client_vpn_target_network(
#'   ClientVpnEndpointId = "string",
#'   SubnetId = "string",
#'   ClientToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_client_vpn_target_network
ec2_associate_client_vpn_target_network <- function(ClientVpnEndpointId, SubnetId, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateClientVpnTargetNetwork",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_client_vpn_target_network_input(ClientVpnEndpointId = ClientVpnEndpointId, SubnetId = SubnetId, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$associate_client_vpn_target_network_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_client_vpn_target_network <- ec2_associate_client_vpn_target_network

#' Associates a set of DHCP options (that you've previously created) with
#' the specified VPC, or associates no DHCP options with the VPC
#'
#' @description
#' Associates a set of DHCP options (that you've previously created) with
#' the specified VPC, or associates no DHCP options with the VPC.
#' 
#' After you associate the options with the VPC, any existing instances and
#' all new instances that you launch in that VPC use the options. You don't
#' need to restart or relaunch the instances. They automatically pick up
#' the changes within a few hours, depending on how frequently the instance
#' renews its DHCP lease. You can explicitly renew the lease using the
#' operating system on the instance.
#' 
#' For more information, see [DHCP Options
#' Sets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_associate_dhcp_options(DhcpOptionsId, VpcId, DryRun)
#'
#' @param DhcpOptionsId &#91;required&#93; The ID of the DHCP options set, or `default` to associate no DHCP
#' options with the VPC.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_dhcp_options(
#'   DhcpOptionsId = "string",
#'   VpcId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example associates the specified DHCP options set with the
#' # specified VPC.
#' svc$associate_dhcp_options(
#'   DhcpOptionsId = "dopt-d9070ebb",
#'   VpcId = "vpc-a01106c2"
#' )
#' 
#' # This example associates the default DHCP options set with the specified
#' # VPC.
#' svc$associate_dhcp_options(
#'   DhcpOptionsId = "default",
#'   VpcId = "vpc-a01106c2"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_associate_dhcp_options
ec2_associate_dhcp_options <- function(DhcpOptionsId, VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateDhcpOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_dhcp_options_input(DhcpOptionsId = DhcpOptionsId, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$associate_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_dhcp_options <- ec2_associate_dhcp_options

#' Associates an AWS Identity and Access Management (IAM) role with an AWS
#' Certificate Manager (ACM) certificate
#'
#' @description
#' Associates an AWS Identity and Access Management (IAM) role with an AWS
#' Certificate Manager (ACM) certificate. This enables the certificate to
#' be used by the ACM for Nitro Enclaves application inside an enclave. For
#' more information, see [AWS Certificate Manager for Nitro
#' Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html)
#' in the *AWS Nitro Enclaves User Guide*.
#' 
#' When the IAM role is associated with the ACM certificate, places the
#' certificate, certificate chain, and encrypted private key in an Amazon
#' S3 bucket that only the associated IAM role can access. The private key
#' of the certificate is encrypted with an AWS-managed KMS customer master
#' (CMK) that has an attached attestation-based CMK policy.
#' 
#' To enable the IAM role to access the Amazon S3 object, you must grant it
#' permission to call `s3:GetObject` on the Amazon S3 bucket returned by
#' the command. To enable the IAM role to access the AWS KMS CMK, you must
#' grant it permission to call `kms:Decrypt` on AWS KMS CMK returned by the
#' command. For more information, see [Grant the role permission to access
#' the certificate and encryption
#' key](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy)
#' in the *AWS Nitro Enclaves User Guide*.
#'
#' @usage
#' ec2_associate_enclave_certificate_iam_role(CertificateArn, RoleArn,
#'   DryRun)
#'
#' @param CertificateArn The ARN of the ACM certificate with which to associate the IAM role.
#' @param RoleArn The ARN of the IAM role to associate with the ACM certificate. You can
#' associate up to 16 IAM roles with an ACM certificate.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CertificateS3BucketName = "string",
#'   CertificateS3ObjectKey = "string",
#'   EncryptionKmsKeyId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_enclave_certificate_iam_role(
#'   CertificateArn = "string",
#'   RoleArn = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_enclave_certificate_iam_role
ec2_associate_enclave_certificate_iam_role <- function(CertificateArn = NULL, RoleArn = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateEnclaveCertificateIamRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_enclave_certificate_iam_role_input(CertificateArn = CertificateArn, RoleArn = RoleArn, DryRun = DryRun)
  output <- .ec2$associate_enclave_certificate_iam_role_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_enclave_certificate_iam_role <- ec2_associate_enclave_certificate_iam_role

#' Associates an IAM instance profile with a running or stopped instance
#'
#' @description
#' Associates an IAM instance profile with a running or stopped instance.
#' You cannot associate more than one IAM instance profile with an
#' instance.
#'
#' @usage
#' ec2_associate_iam_instance_profile(IamInstanceProfile, InstanceId)
#'
#' @param IamInstanceProfile &#91;required&#93; The IAM instance profile.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IamInstanceProfileAssociation = list(
#'     AssociationId = "string",
#'     InstanceId = "string",
#'     IamInstanceProfile = list(
#'       Arn = "string",
#'       Id = "string"
#'     ),
#'     State = "associating"|"associated"|"disassociating"|"disassociated",
#'     Timestamp = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_iam_instance_profile(
#'   IamInstanceProfile = list(
#'     Arn = "string",
#'     Name = "string"
#'   ),
#'   InstanceId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example associates an IAM instance profile named admin-role with
#' # the specified instance.
#' svc$associate_iam_instance_profile(
#'   IamInstanceProfile = list(
#'     Name = "admin-role"
#'   ),
#'   InstanceId = "i-123456789abcde123"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_associate_iam_instance_profile
ec2_associate_iam_instance_profile <- function(IamInstanceProfile, InstanceId) {
  op <- new_operation(
    name = "AssociateIamInstanceProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_iam_instance_profile_input(IamInstanceProfile = IamInstanceProfile, InstanceId = InstanceId)
  output <- .ec2$associate_iam_instance_profile_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_iam_instance_profile <- ec2_associate_iam_instance_profile

#' Associates a subnet in your VPC or an internet gateway or virtual
#' private gateway attached to your VPC with a route table in your VPC
#'
#' @description
#' Associates a subnet in your VPC or an internet gateway or virtual
#' private gateway attached to your VPC with a route table in your VPC.
#' This association causes traffic from the subnet or gateway to be routed
#' according to the routes in the route table. The action returns an
#' association ID, which you need in order to disassociate the route table
#' later. A route table can be associated with multiple subnets.
#' 
#' For more information, see [Route
#' Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_associate_route_table(DryRun, RouteTableId, SubnetId, GatewayId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#' @param SubnetId The ID of the subnet.
#' @param GatewayId The ID of the internet gateway or virtual private gateway.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AssociationId = "string",
#'   AssociationState = list(
#'     State = "associating"|"associated"|"disassociating"|"disassociated"|"failed",
#'     StatusMessage = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_route_table(
#'   DryRun = TRUE|FALSE,
#'   RouteTableId = "string",
#'   SubnetId = "string",
#'   GatewayId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example associates the specified route table with the specified
#' # subnet.
#' svc$associate_route_table(
#'   RouteTableId = "rtb-22574640",
#'   SubnetId = "subnet-9d4a7b6"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_associate_route_table
ec2_associate_route_table <- function(DryRun = NULL, RouteTableId, SubnetId = NULL, GatewayId = NULL) {
  op <- new_operation(
    name = "AssociateRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_route_table_input(DryRun = DryRun, RouteTableId = RouteTableId, SubnetId = SubnetId, GatewayId = GatewayId)
  output <- .ec2$associate_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_route_table <- ec2_associate_route_table

#' Associates a CIDR block with your subnet
#'
#' @description
#' Associates a CIDR block with your subnet. You can only associate a
#' single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a
#' prefix length of /64.
#'
#' @usage
#' ec2_associate_subnet_cidr_block(Ipv6CidrBlock, SubnetId)
#'
#' @param Ipv6CidrBlock &#91;required&#93; The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix
#' length.
#' @param SubnetId &#91;required&#93; The ID of your subnet.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Ipv6CidrBlockAssociation = list(
#'     AssociationId = "string",
#'     Ipv6CidrBlock = "string",
#'     Ipv6CidrBlockState = list(
#'       State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
#'       StatusMessage = "string"
#'     )
#'   ),
#'   SubnetId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_subnet_cidr_block(
#'   Ipv6CidrBlock = "string",
#'   SubnetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_subnet_cidr_block
ec2_associate_subnet_cidr_block <- function(Ipv6CidrBlock, SubnetId) {
  op <- new_operation(
    name = "AssociateSubnetCidrBlock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_subnet_cidr_block_input(Ipv6CidrBlock = Ipv6CidrBlock, SubnetId = SubnetId)
  output <- .ec2$associate_subnet_cidr_block_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_subnet_cidr_block <- ec2_associate_subnet_cidr_block

#' Associates the specified subnets and transit gateway attachments with
#' the specified transit gateway multicast domain
#'
#' @description
#' Associates the specified subnets and transit gateway attachments with
#' the specified transit gateway multicast domain.
#' 
#' The transit gateway attachment must be in the available state before you
#' can add a resource. Use
#' [`describe_transit_gateway_attachments`][ec2_describe_transit_gateway_attachments]
#' to see the state of the attachment.
#'
#' @usage
#' ec2_associate_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId, TransitGatewayAttachmentId, SubnetIds,
#'   DryRun)
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param TransitGatewayAttachmentId The ID of the transit gateway attachment to associate with the transit
#' gateway multicast domain.
#' @param SubnetIds The IDs of the subnets to associate with the transit gateway multicast
#' domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Associations = list(
#'     TransitGatewayMulticastDomainId = "string",
#'     TransitGatewayAttachmentId = "string",
#'     ResourceId = "string",
#'     ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering",
#'     ResourceOwnerId = "string",
#'     Subnets = list(
#'       list(
#'         SubnetId = "string",
#'         State = "pendingAcceptance"|"associating"|"associated"|"disassociating"|"disassociated"|"rejected"|"failed"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_transit_gateway_multicast_domain
ec2_associate_transit_gateway_multicast_domain <- function(TransitGatewayMulticastDomainId = NULL, TransitGatewayAttachmentId = NULL, SubnetIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_transit_gateway_multicast_domain_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, SubnetIds = SubnetIds, DryRun = DryRun)
  output <- .ec2$associate_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_transit_gateway_multicast_domain <- ec2_associate_transit_gateway_multicast_domain

#' Associates the specified attachment with the specified transit gateway
#' route table
#'
#' @description
#' Associates the specified attachment with the specified transit gateway
#' route table. You can associate only one route table with an attachment.
#'
#' @usage
#' ec2_associate_transit_gateway_route_table(TransitGatewayRouteTableId,
#'   TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Association = list(
#'     TransitGatewayRouteTableId = "string",
#'     TransitGatewayAttachmentId = "string",
#'     ResourceId = "string",
#'     ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering",
#'     State = "associating"|"associated"|"disassociating"|"disassociated"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_transit_gateway_route_table(
#'   TransitGatewayRouteTableId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_transit_gateway_route_table
ec2_associate_transit_gateway_route_table <- function(TransitGatewayRouteTableId, TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_transit_gateway_route_table_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$associate_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_transit_gateway_route_table <- ec2_associate_transit_gateway_route_table

#' Associates a CIDR block with your VPC
#'
#' @description
#' Associates a CIDR block with your VPC. You can associate a secondary
#' IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR
#' block from an IPv6 address pool that you provisioned through bring your
#' own IP addresses
#' ([BYOIP](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)).
#' The IPv6 CIDR block size is fixed at /56.
#' 
#' You must specify one of the following in the request: an IPv4 CIDR
#' block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block.
#' 
#' For more information about associating CIDR blocks with your VPC and
#' applicable restrictions, see [VPC and Subnet
#' Sizing](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_associate_vpc_cidr_block(AmazonProvidedIpv6CidrBlock, CidrBlock,
#'   VpcId, Ipv6CidrBlockNetworkBorderGroup, Ipv6Pool, Ipv6CidrBlock)
#'
#' @param AmazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
#' the VPC. You cannot specify the range of IPv6 addresses, or the size of
#' the CIDR block.
#' @param CidrBlock An IPv4 CIDR block to associate with the VPC.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param Ipv6CidrBlockNetworkBorderGroup The name of the location from which we advertise the IPV6 CIDR block.
#' Use this parameter to limit the CIDR block to this location.
#' 
#' You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
#' parameter.
#' 
#' You can have one IPv6 CIDR block association per network border group.
#' @param Ipv6Pool The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
#' block.
#' @param Ipv6CidrBlock An IPv6 CIDR block from the IPv6 address pool. You must also specify
#' `Ipv6Pool` in the request.
#' 
#' To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Ipv6CidrBlockAssociation = list(
#'     AssociationId = "string",
#'     Ipv6CidrBlock = "string",
#'     Ipv6CidrBlockState = list(
#'       State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
#'       StatusMessage = "string"
#'     ),
#'     NetworkBorderGroup = "string",
#'     Ipv6Pool = "string"
#'   ),
#'   CidrBlockAssociation = list(
#'     AssociationId = "string",
#'     CidrBlock = "string",
#'     CidrBlockState = list(
#'       State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
#'       StatusMessage = "string"
#'     )
#'   ),
#'   VpcId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_vpc_cidr_block(
#'   AmazonProvidedIpv6CidrBlock = TRUE|FALSE,
#'   CidrBlock = "string",
#'   VpcId = "string",
#'   Ipv6CidrBlockNetworkBorderGroup = "string",
#'   Ipv6Pool = "string",
#'   Ipv6CidrBlock = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_vpc_cidr_block
ec2_associate_vpc_cidr_block <- function(AmazonProvidedIpv6CidrBlock = NULL, CidrBlock = NULL, VpcId, Ipv6CidrBlockNetworkBorderGroup = NULL, Ipv6Pool = NULL, Ipv6CidrBlock = NULL) {
  op <- new_operation(
    name = "AssociateVpcCidrBlock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_vpc_cidr_block_input(AmazonProvidedIpv6CidrBlock = AmazonProvidedIpv6CidrBlock, CidrBlock = CidrBlock, VpcId = VpcId, Ipv6CidrBlockNetworkBorderGroup = Ipv6CidrBlockNetworkBorderGroup, Ipv6Pool = Ipv6Pool, Ipv6CidrBlock = Ipv6CidrBlock)
  output <- .ec2$associate_vpc_cidr_block_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_vpc_cidr_block <- ec2_associate_vpc_cidr_block

#' Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
#' or more of the VPC's security groups
#'
#' @description
#' Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
#' or more of the VPC's security groups. You cannot link an EC2-Classic
#' instance to more than one VPC at a time. You can only link an instance
#' that's in the `running` state. An instance is automatically unlinked
#' from a VPC when it's stopped - you can link it to the VPC again when you
#' restart it.
#' 
#' After you've linked an instance, you cannot change the VPC security
#' groups that are associated with it. To change the security groups, you
#' must first unlink the instance, and then link it again.
#' 
#' Linking your instance to a VPC is sometimes referred to as *attaching*
#' your instance.
#'
#' @usage
#' ec2_attach_classic_link_vpc(DryRun, Groups, InstanceId, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Groups &#91;required&#93; The ID of one or more of the VPC's security groups. You cannot specify
#' security groups from a different VPC.
#' @param InstanceId &#91;required&#93; The ID of an EC2-Classic instance to link to the ClassicLink-enabled
#' VPC.
#' @param VpcId &#91;required&#93; The ID of a ClassicLink-enabled VPC.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Return = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$attach_classic_link_vpc(
#'   DryRun = TRUE|FALSE,
#'   Groups = list(
#'     "string"
#'   ),
#'   InstanceId = "string",
#'   VpcId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_attach_classic_link_vpc
ec2_attach_classic_link_vpc <- function(DryRun = NULL, Groups, InstanceId, VpcId) {
  op <- new_operation(
    name = "AttachClassicLinkVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_classic_link_vpc_input(DryRun = DryRun, Groups = Groups, InstanceId = InstanceId, VpcId = VpcId)
  output <- .ec2$attach_classic_link_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_classic_link_vpc <- ec2_attach_classic_link_vpc

#' Attaches an internet gateway or a virtual private gateway to a VPC,
#' enabling connectivity between the internet and the VPC
#'
#' @description
#' Attaches an internet gateway or a virtual private gateway to a VPC,
#' enabling connectivity between the internet and the VPC. For more
#' information about your VPC and internet gateway, see the [Amazon Virtual
#' Private Cloud User
#' Guide](https://docs.aws.amazon.com/vpc/latest/userguide/).
#'
#' @usage
#' ec2_attach_internet_gateway(DryRun, InternetGatewayId, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayId &#91;required&#93; The ID of the internet gateway.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$attach_internet_gateway(
#'   DryRun = TRUE|FALSE,
#'   InternetGatewayId = "string",
#'   VpcId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example attaches the specified Internet gateway to the specified
#' # VPC.
#' svc$attach_internet_gateway(
#'   InternetGatewayId = "igw-c0a643a9",
#'   VpcId = "vpc-a01106c2"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_attach_internet_gateway
ec2_attach_internet_gateway <- function(DryRun = NULL, InternetGatewayId, VpcId) {
  op <- new_operation(
    name = "AttachInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_internet_gateway_input(DryRun = DryRun, InternetGatewayId = InternetGatewayId, VpcId = VpcId)
  output <- .ec2$attach_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_internet_gateway <- ec2_attach_internet_gateway

#' Attaches a network interface to an instance
#'
#' @description
#' Attaches a network interface to an instance.
#'
#' @usage
#' ec2_attach_network_interface(DeviceIndex, DryRun, InstanceId,
#'   NetworkInterfaceId, NetworkCardIndex)
#'
#' @param DeviceIndex &#91;required&#93; The index of the device for the network interface attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param NetworkCardIndex The index of the network card. Some instance types support multiple
#' network cards. The primary network interface must be assigned to network
#' card index 0. The default is network card index 0.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AttachmentId = "string",
#'   NetworkCardIndex = 123
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$attach_network_interface(
#'   DeviceIndex = 123,
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string",
#'   NetworkInterfaceId = "string",
#'   NetworkCardIndex = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example attaches the specified network interface to the specified
#' # instance.
#' svc$attach_network_interface(
#'   DeviceIndex = 1L,
#'   InstanceId = "i-1234567890abcdef0",
#'   NetworkInterfaceId = "eni-e5aa89a3"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_attach_network_interface
ec2_attach_network_interface <- function(DeviceIndex, DryRun = NULL, InstanceId, NetworkInterfaceId, NetworkCardIndex = NULL) {
  op <- new_operation(
    name = "AttachNetworkInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_network_interface_input(DeviceIndex = DeviceIndex, DryRun = DryRun, InstanceId = InstanceId, NetworkInterfaceId = NetworkInterfaceId, NetworkCardIndex = NetworkCardIndex)
  output <- .ec2$attach_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_network_interface <- ec2_attach_network_interface

#' Attaches an EBS volume to a running or stopped instance and exposes it
#' to the instance with the specified device name
#'
#' @description
#' Attaches an EBS volume to a running or stopped instance and exposes it
#' to the instance with the specified device name.
#' 
#' Encrypted EBS volumes must be attached to instances that support Amazon
#' EBS encryption. For more information, see [Amazon EBS
#' encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' After you attach an EBS volume, you must make it available. For more
#' information, see [Making an EBS volume available for
#' use](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html).
#' 
#' If a volume has an AWS Marketplace product code:
#' 
#' -   The volume can be attached only to a stopped instance.
#' 
#' -   AWS Marketplace product codes are copied from the volume to the
#'     instance.
#' 
#' -   You must be subscribed to the product.
#' 
#' -   The instance type and operating system of the instance must support
#'     the product. For example, you can't detach a volume from a Windows
#'     instance and attach it to a Linux instance.
#' 
#' For more information, see [Attaching Amazon EBS
#' volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_attach_volume(Device, InstanceId, VolumeId, DryRun)
#'
#' @param Device &#91;required&#93; The device name (for example, `/dev/sdh` or `xvdh`).
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param VolumeId &#91;required&#93; The ID of the EBS volume. The volume and instance must be within the
#' same Availability Zone.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AttachTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Device = "string",
#'   InstanceId = "string",
#'   State = "attaching"|"attached"|"detaching"|"detached"|"busy",
#'   VolumeId = "string",
#'   DeleteOnTermination = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$attach_volume(
#'   Device = "string",
#'   InstanceId = "string",
#'   VolumeId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example attaches a volume (`vol-1234567890abcdef0`) to an
#' # instance (`i-01474ef662b89480`) as `/dev/sdf`.
#' svc$attach_volume(
#'   Device = "/dev/sdf",
#'   InstanceId = "i-01474ef662b89480",
#'   VolumeId = "vol-1234567890abcdef0"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_attach_volume
ec2_attach_volume <- function(Device, InstanceId, VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "AttachVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_volume_input(Device = Device, InstanceId = InstanceId, VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$attach_volume_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_volume <- ec2_attach_volume

#' Attaches a virtual private gateway to a VPC
#'
#' @description
#' Attaches a virtual private gateway to a VPC. You can attach one virtual
#' private gateway to one VPC at a time.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_attach_vpn_gateway(VpcId, VpnGatewayId, DryRun)
#'
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param VpnGatewayId &#91;required&#93; The ID of the virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   VpcAttachment = list(
#'     State = "attaching"|"attached"|"detaching"|"detached",
#'     VpcId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$attach_vpn_gateway(
#'   VpcId = "string",
#'   VpnGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_attach_vpn_gateway
ec2_attach_vpn_gateway <- function(VpcId, VpnGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "AttachVpnGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_vpn_gateway_input(VpcId = VpcId, VpnGatewayId = VpnGatewayId, DryRun = DryRun)
  output <- .ec2$attach_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_vpn_gateway <- ec2_attach_vpn_gateway

#' Adds an ingress authorization rule to a Client VPN endpoint
#'
#' @description
#' Adds an ingress authorization rule to a Client VPN endpoint. Ingress
#' authorization rules act as firewall rules that grant access to networks.
#' You must configure ingress authorization rules to enable clients to
#' access resources in AWS or on-premises networks.
#'
#' @usage
#' ec2_authorize_client_vpn_ingress(ClientVpnEndpointId, TargetNetworkCidr,
#'   AccessGroupId, AuthorizeAllGroups, Description, ClientToken, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param TargetNetworkCidr &#91;required&#93; The IPv4 address range, in CIDR notation, of the network for which
#' access is being authorized.
#' @param AccessGroupId The ID of the group to grant access to, for example, the Active
#' Directory group or identity provider (IdP) group. Required if
#' `AuthorizeAllGroups` is `false` or not specified.
#' @param AuthorizeAllGroups Indicates whether to grant access to all clients. Specify `true` to
#' grant all clients who successfully establish a VPN connection access to
#' the network. Must be set to `true` if `AccessGroupId` is not specified.
#' @param Description A brief description of the authorization rule.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Status = list(
#'     Code = "authorizing"|"active"|"failed"|"revoking",
#'     Message = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$authorize_client_vpn_ingress(
#'   ClientVpnEndpointId = "string",
#'   TargetNetworkCidr = "string",
#'   AccessGroupId = "string",
#'   AuthorizeAllGroups = TRUE|FALSE,
#'   Description = "string",
#'   ClientToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_authorize_client_vpn_ingress
ec2_authorize_client_vpn_ingress <- function(ClientVpnEndpointId, TargetNetworkCidr, AccessGroupId = NULL, AuthorizeAllGroups = NULL, Description = NULL, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AuthorizeClientVpnIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$authorize_client_vpn_ingress_input(ClientVpnEndpointId = ClientVpnEndpointId, TargetNetworkCidr = TargetNetworkCidr, AccessGroupId = AccessGroupId, AuthorizeAllGroups = AuthorizeAllGroups, Description = Description, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$authorize_client_vpn_ingress_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$authorize_client_vpn_ingress <- ec2_authorize_client_vpn_ingress

#' &#91;VPC only&#93; Adds the specified egress rules to a security group
#' for use with a VPC
#'
#' @description
#' \[VPC only\] Adds the specified egress rules to a security group for use
#' with a VPC.
#' 
#' An outbound rule permits instances to send traffic to the specified IPv4
#' or IPv6 CIDR address ranges, or to the instances associated with the
#' specified destination security groups.
#' 
#' You specify a protocol for each rule (for example, TCP). For the TCP and
#' UDP protocols, you must also specify the destination port or port range.
#' For the ICMP protocol, you must also specify the ICMP type and code. You
#' can use -1 for the type or code to mean all types or all codes.
#' 
#' Rule changes are propagated to affected instances as quickly as
#' possible. However, a small delay might occur.
#' 
#' For more information about VPC security group limits, see [Amazon VPC
#' Limits](https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
#'
#' @usage
#' ec2_authorize_security_group_egress(DryRun, GroupId, IpPermissions,
#'   CidrIp, FromPort, IpProtocol, ToPort, SourceSecurityGroupName,
#'   SourceSecurityGroupOwnerId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupId &#91;required&#93; The ID of the security group.
#' @param IpPermissions The sets of IP permissions. You can't specify a destination security
#' group and a CIDR IP address range in the same set of permissions.
#' @param CidrIp Not supported. Use a set of IP permissions to specify the CIDR.
#' @param FromPort Not supported. Use a set of IP permissions to specify the port.
#' @param IpProtocol Not supported. Use a set of IP permissions to specify the protocol name
#' or number.
#' @param ToPort Not supported. Use a set of IP permissions to specify the port.
#' @param SourceSecurityGroupName Not supported. Use a set of IP permissions to specify a destination
#' security group.
#' @param SourceSecurityGroupOwnerId Not supported. Use a set of IP permissions to specify a destination
#' security group.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$authorize_security_group_egress(
#'   DryRun = TRUE|FALSE,
#'   GroupId = "string",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 123,
#'       IpProtocol = "string",
#'       IpRanges = list(
#'         list(
#'           CidrIp = "string",
#'           Description = "string"
#'         )
#'       ),
#'       Ipv6Ranges = list(
#'         list(
#'           CidrIpv6 = "string",
#'           Description = "string"
#'         )
#'       ),
#'       PrefixListIds = list(
#'         list(
#'           Description = "string",
#'           PrefixListId = "string"
#'         )
#'       ),
#'       ToPort = 123,
#'       UserIdGroupPairs = list(
#'         list(
#'           Description = "string",
#'           GroupId = "string",
#'           GroupName = "string",
#'           PeeringStatus = "string",
#'           UserId = "string",
#'           VpcId = "string",
#'           VpcPeeringConnectionId = "string"
#'         )
#'       )
#'     )
#'   ),
#'   CidrIp = "string",
#'   FromPort = 123,
#'   IpProtocol = "string",
#'   ToPort = 123,
#'   SourceSecurityGroupName = "string",
#'   SourceSecurityGroupOwnerId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example adds a rule that grants access to the specified address
#' # ranges on TCP port 80.
#' svc$authorize_security_group_egress(
#'   GroupId = "sg-1a2b3c4d",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 80L,
#'       IpProtocol = "tcp",
#'       IpRanges = list(
#'         list(
#'           CidrIp = "10.0.0.0/16"
#'         )
#'       ),
#'       ToPort = 80L
#'     )
#'   )
#' )
#' 
#' # This example adds a rule that grants access to the specified security
#' # group on TCP port 80.
#' svc$authorize_security_group_egress(
#'   GroupId = "sg-1a2b3c4d",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 80L,
#'       IpProtocol = "tcp",
#'       ToPort = 80L,
#'       UserIdGroupPairs = list(
#'         list(
#'           GroupId = "sg-4b51a32f"
#'         )
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_authorize_security_group_egress
ec2_authorize_security_group_egress <- function(DryRun = NULL, GroupId, IpPermissions = NULL, CidrIp = NULL, FromPort = NULL, IpProtocol = NULL, ToPort = NULL, SourceSecurityGroupName = NULL, SourceSecurityGroupOwnerId = NULL) {
  op <- new_operation(
    name = "AuthorizeSecurityGroupEgress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$authorize_security_group_egress_input(DryRun = DryRun, GroupId = GroupId, IpPermissions = IpPermissions, CidrIp = CidrIp, FromPort = FromPort, IpProtocol = IpProtocol, ToPort = ToPort, SourceSecurityGroupName = SourceSecurityGroupName, SourceSecurityGroupOwnerId = SourceSecurityGroupOwnerId)
  output <- .ec2$authorize_security_group_egress_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$authorize_security_group_egress <- ec2_authorize_security_group_egress

#' Adds the specified ingress rules to a security group
#'
#' @description
#' Adds the specified ingress rules to a security group.
#' 
#' An inbound rule permits instances to receive traffic from the specified
#' IPv4 or IPv6 CIDR address ranges, or from the instances associated with
#' the specified destination security groups.
#' 
#' You specify a protocol for each rule (for example, TCP). For TCP and
#' UDP, you must also specify the destination port or port range. For
#' ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You
#' can use -1 to mean all types or all codes.
#' 
#' Rule changes are propagated to instances within the security group as
#' quickly as possible. However, a small delay might occur.
#' 
#' For more information about VPC security group limits, see [Amazon VPC
#' Limits](https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
#'
#' @usage
#' ec2_authorize_security_group_ingress(CidrIp, FromPort, GroupId,
#'   GroupName, IpPermissions, IpProtocol, SourceSecurityGroupName,
#'   SourceSecurityGroupOwnerId, ToPort, DryRun)
#'
#' @param CidrIp The IPv4 address range, in CIDR format. You can't specify this parameter
#' when specifying a source security group. To specify an IPv6 address
#' range, use a set of IP permissions.
#' 
#' Alternatively, use a set of IP permissions to specify multiple rules and
#' a description for the rule.
#' @param FromPort The start of port range for the TCP and UDP protocols, or an ICMP type
#' number. For the ICMP type number, use `-1` to specify all types. If you
#' specify all ICMP types, you must specify all codes.
#' 
#' Alternatively, use a set of IP permissions to specify multiple rules and
#' a description for the rule.
#' @param GroupId The ID of the security group. You must specify either the security group
#' ID or the security group name in the request. For security groups in a
#' nondefault VPC, you must specify the security group ID.
#' @param GroupName \[EC2-Classic, default VPC\] The name of the security group. You must
#' specify either the security group ID or the security group name in the
#' request.
#' @param IpPermissions The sets of IP permissions.
#' @param IpProtocol The IP protocol name (`tcp`, `udp`, `icmp`) or number (see [Protocol
#' Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
#' To specify `icmpv6`, use a set of IP permissions.
#' 
#' \[VPC only\] Use `-1` to specify all protocols. If you specify `-1` or a
#' protocol other than `tcp`, `udp`, or `icmp`, traffic on all ports is
#' allowed, regardless of any ports you specify.
#' 
#' Alternatively, use a set of IP permissions to specify multiple rules and
#' a description for the rule.
#' @param SourceSecurityGroupName \[EC2-Classic, default VPC\] The name of the source security group. You
#' can't specify this parameter in combination with the following
#' parameters: the CIDR IP address range, the start of the port range, the
#' IP protocol, and the end of the port range. Creates rules that grant
#' full ICMP, UDP, and TCP access. To create a rule with a specific IP
#' protocol and port range, use a set of IP permissions instead. For
#' EC2-VPC, the source security group must be in the same VPC.
#' @param SourceSecurityGroupOwnerId \[nondefault VPC\] The AWS account ID for the source security group, if
#' the source security group is in a different account. You can't specify
#' this parameter in combination with the following parameters: the CIDR IP
#' address range, the IP protocol, the start of the port range, and the end
#' of the port range. Creates rules that grant full ICMP, UDP, and TCP
#' access. To create a rule with a specific IP protocol and port range, use
#' a set of IP permissions instead.
#' @param ToPort The end of port range for the TCP and UDP protocols, or an ICMP code
#' number. For the ICMP code number, use `-1` to specify all codes. If you
#' specify all ICMP types, you must specify all codes.
#' 
#' Alternatively, use a set of IP permissions to specify multiple rules and
#' a description for the rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$authorize_security_group_ingress(
#'   CidrIp = "string",
#'   FromPort = 123,
#'   GroupId = "string",
#'   GroupName = "string",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 123,
#'       IpProtocol = "string",
#'       IpRanges = list(
#'         list(
#'           CidrIp = "string",
#'           Description = "string"
#'         )
#'       ),
#'       Ipv6Ranges = list(
#'         list(
#'           CidrIpv6 = "string",
#'           Description = "string"
#'         )
#'       ),
#'       PrefixListIds = list(
#'         list(
#'           Description = "string",
#'           PrefixListId = "string"
#'         )
#'       ),
#'       ToPort = 123,
#'       UserIdGroupPairs = list(
#'         list(
#'           Description = "string",
#'           GroupId = "string",
#'           GroupName = "string",
#'           PeeringStatus = "string",
#'           UserId = "string",
#'           VpcId = "string",
#'           VpcPeeringConnectionId = "string"
#'         )
#'       )
#'     )
#'   ),
#'   IpProtocol = "string",
#'   SourceSecurityGroupName = "string",
#'   SourceSecurityGroupOwnerId = "string",
#'   ToPort = 123,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example enables inbound traffic on TCP port 22 (SSH). The rule
#' # includes a description to help you identify it later.
#' svc$authorize_security_group_ingress(
#'   GroupId = "sg-903004f8",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 22L,
#'       IpProtocol = "tcp",
#'       IpRanges = list(
#'         list(
#'           CidrIp = "203.0.113.0/24",
#'           Description = "SSH access from the LA office"
#'         )
#'       ),
#'       ToPort = 22L
#'     )
#'   )
#' )
#' 
#' # This example enables inbound traffic on TCP port 80 from the specified
#' # security group. The group must be in the same VPC or a peer VPC.
#' # Incoming traffic is allowed based on the private IP addresses of
#' # instances that are associated with the specified security group.
#' svc$authorize_security_group_ingress(
#'   GroupId = "sg-111aaa22",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 80L,
#'       IpProtocol = "tcp",
#'       ToPort = 80L,
#'       UserIdGroupPairs = list(
#'         list(
#'           Description = "HTTP access from other instances",
#'           GroupId = "sg-1a2b3c4d"
#'         )
#'       )
#'     )
#'   )
#' )
#' 
#' # This example adds an inbound rule that allows RDP traffic from the
#' # specified IPv6 address range. The rule includes a description to help
#' # you identify it later.
#' svc$authorize_security_group_ingress(
#'   GroupId = "sg-123abc12 ",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 3389L,
#'       IpProtocol = "tcp",
#'       Ipv6Ranges = list(
#'         list(
#'           CidrIpv6 = "2001:db8:1234:1a00::/64",
#'           Description = "RDP access from the NY office"
#'         )
#'       ),
#'       ToPort = 3389L
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_authorize_security_group_ingress
ec2_authorize_security_group_ingress <- function(CidrIp = NULL, FromPort = NULL, GroupId = NULL, GroupName = NULL, IpPermissions = NULL, IpProtocol = NULL, SourceSecurityGroupName = NULL, SourceSecurityGroupOwnerId = NULL, ToPort = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AuthorizeSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$authorize_security_group_ingress_input(CidrIp = CidrIp, FromPort = FromPort, GroupId = GroupId, GroupName = GroupName, IpPermissions = IpPermissions, IpProtocol = IpProtocol, SourceSecurityGroupName = SourceSecurityGroupName, SourceSecurityGroupOwnerId = SourceSecurityGroupOwnerId, ToPort = ToPort, DryRun = DryRun)
  output <- .ec2$authorize_security_group_ingress_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$authorize_security_group_ingress <- ec2_authorize_security_group_ingress

#' Bundles an Amazon instance store-backed Windows instance
#'
#' @description
#' Bundles an Amazon instance store-backed Windows instance.
#' 
#' During bundling, only the root device volume (C:\\) is bundled. Data on
#' other instance store volumes is not preserved.
#' 
#' This action is not applicable for Linux/Unix instances or Windows
#' instances that are backed by Amazon EBS.
#'
#' @usage
#' ec2_bundle_instance(InstanceId, Storage, DryRun)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance to bundle.
#' 
#' Type: String
#' 
#' Default: None
#' 
#' Required: Yes
#' @param Storage &#91;required&#93; The bucket in which to store the AMI. You can specify a bucket that you
#' already own or a new bucket that Amazon EC2 creates on your behalf. If
#' you specify a bucket that belongs to someone else, Amazon EC2 returns an
#' error.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   BundleTask = list(
#'     BundleId = "string",
#'     BundleTaskError = list(
#'       Code = "string",
#'       Message = "string"
#'     ),
#'     InstanceId = "string",
#'     Progress = "string",
#'     StartTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     State = "pending"|"waiting-for-shutdown"|"bundling"|"storing"|"cancelling"|"complete"|"failed",
#'     Storage = list(
#'       S3 = list(
#'         AWSAccessKeyId = "string",
#'         Bucket = "string",
#'         Prefix = "string",
#'         UploadPolicy = raw,
#'         UploadPolicySignature = "string"
#'       )
#'     ),
#'     UpdateTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$bundle_instance(
#'   InstanceId = "string",
#'   Storage = list(
#'     S3 = list(
#'       AWSAccessKeyId = "string",
#'       Bucket = "string",
#'       Prefix = "string",
#'       UploadPolicy = raw,
#'       UploadPolicySignature = "string"
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_bundle_instance
ec2_bundle_instance <- function(InstanceId, Storage, DryRun = NULL) {
  op <- new_operation(
    name = "BundleInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$bundle_instance_input(InstanceId = InstanceId, Storage = Storage, DryRun = DryRun)
  output <- .ec2$bundle_instance_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$bundle_instance <- ec2_bundle_instance

#' Cancels a bundling operation for an instance store-backed Windows
#' instance
#'
#' @description
#' Cancels a bundling operation for an instance store-backed Windows
#' instance.
#'
#' @usage
#' ec2_cancel_bundle_task(BundleId, DryRun)
#'
#' @param BundleId &#91;required&#93; The ID of the bundle task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   BundleTask = list(
#'     BundleId = "string",
#'     BundleTaskError = list(
#'       Code = "string",
#'       Message = "string"
#'     ),
#'     InstanceId = "string",
#'     Progress = "string",
#'     StartTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     State = "pending"|"waiting-for-shutdown"|"bundling"|"storing"|"cancelling"|"complete"|"failed",
#'     Storage = list(
#'       S3 = list(
#'         AWSAccessKeyId = "string",
#'         Bucket = "string",
#'         Prefix = "string",
#'         UploadPolicy = raw,
#'         UploadPolicySignature = "string"
#'       )
#'     ),
#'     UpdateTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$cancel_bundle_task(
#'   BundleId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_bundle_task
ec2_cancel_bundle_task <- function(BundleId, DryRun = NULL) {
  op <- new_operation(
    name = "CancelBundleTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_bundle_task_input(BundleId = BundleId, DryRun = DryRun)
  output <- .ec2$cancel_bundle_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_bundle_task <- ec2_cancel_bundle_task

#' Cancels the specified Capacity Reservation, releases the reserved
#' capacity, and changes the Capacity Reservation's state to cancelled
#'
#' @description
#' Cancels the specified Capacity Reservation, releases the reserved
#' capacity, and changes the Capacity Reservation's state to `cancelled`.
#' 
#' Instances running in the reserved capacity continue running until you
#' stop them. Stopped instances that target the Capacity Reservation can no
#' longer launch. Modify these instances to either target a different
#' Capacity Reservation, launch On-Demand Instance capacity, or run in any
#' open Capacity Reservation that has matching attributes and sufficient
#' capacity.
#'
#' @usage
#' ec2_cancel_capacity_reservation(CapacityReservationId, DryRun)
#'
#' @param CapacityReservationId &#91;required&#93; The ID of the Capacity Reservation to be cancelled.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Return = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$cancel_capacity_reservation(
#'   CapacityReservationId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_capacity_reservation
ec2_cancel_capacity_reservation <- function(CapacityReservationId, DryRun = NULL) {
  op <- new_operation(
    name = "CancelCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_capacity_reservation_input(CapacityReservationId = CapacityReservationId, DryRun = DryRun)
  output <- .ec2$cancel_capacity_reservation_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_capacity_reservation <- ec2_cancel_capacity_reservation

#' Cancels an active conversion task
#'
#' @description
#' Cancels an active conversion task. The task can be the import of an
#' instance or volume. The action removes all artifacts of the conversion,
#' including a partially uploaded volume or instance. If the conversion is
#' complete or is in the process of transferring the final disk image, the
#' command fails and returns an exception.
#' 
#' For more information, see [Importing a Virtual Machine Using the Amazon
#' EC2 CLI](http://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf).
#'
#' @usage
#' ec2_cancel_conversion_task(ConversionTaskId, DryRun, ReasonMessage)
#'
#' @param ConversionTaskId &#91;required&#93; The ID of the conversion task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReasonMessage The reason for canceling the conversion task.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_conversion_task(
#'   ConversionTaskId = "string",
#'   DryRun = TRUE|FALSE,
#'   ReasonMessage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_conversion_task
ec2_cancel_conversion_task <- function(ConversionTaskId, DryRun = NULL, ReasonMessage = NULL) {
  op <- new_operation(
    name = "CancelConversionTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_conversion_task_input(ConversionTaskId = ConversionTaskId, DryRun = DryRun, ReasonMessage = ReasonMessage)
  output <- .ec2$cancel_conversion_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_conversion_task <- ec2_cancel_conversion_task

#' Cancels an active export task
#'
#' @description
#' Cancels an active export task. The request removes all artifacts of the
#' export, including any partially-created Amazon S3 objects. If the export
#' task is complete or is in the process of transferring the final disk
#' image, the command fails and returns an error.
#'
#' @usage
#' ec2_cancel_export_task(ExportTaskId)
#'
#' @param ExportTaskId &#91;required&#93; The ID of the export task. This is the ID returned by
#' [`create_instance_export_task`][ec2_create_instance_export_task].
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_export_task(
#'   ExportTaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_export_task
ec2_cancel_export_task <- function(ExportTaskId) {
  op <- new_operation(
    name = "CancelExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_export_task_input(ExportTaskId = ExportTaskId)
  output <- .ec2$cancel_export_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_export_task <- ec2_cancel_export_task

#' Cancels an in-process import virtual machine or import snapshot task
#'
#' @description
#' Cancels an in-process import virtual machine or import snapshot task.
#'
#' @usage
#' ec2_cancel_import_task(CancelReason, DryRun, ImportTaskId)
#'
#' @param CancelReason The reason for canceling the task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ImportTaskId The ID of the import image or import snapshot task to be canceled.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImportTaskId = "string",
#'   PreviousState = "string",
#'   State = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$cancel_import_task(
#'   CancelReason = "string",
#'   DryRun = TRUE|FALSE,
#'   ImportTaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_import_task
ec2_cancel_import_task <- function(CancelReason = NULL, DryRun = NULL, ImportTaskId = NULL) {
  op <- new_operation(
    name = "CancelImportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_import_task_input(CancelReason = CancelReason, DryRun = DryRun, ImportTaskId = ImportTaskId)
  output <- .ec2$cancel_import_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_import_task <- ec2_cancel_import_task

#' Cancels the specified Reserved Instance listing in the Reserved Instance
#' Marketplace
#'
#' @description
#' Cancels the specified Reserved Instance listing in the Reserved Instance
#' Marketplace.
#' 
#' For more information, see [Reserved Instance
#' Marketplace](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_cancel_reserved_instances_listing(ReservedInstancesListingId)
#'
#' @param ReservedInstancesListingId &#91;required&#93; The ID of the Reserved Instance listing.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ReservedInstancesListings = list(
#'     list(
#'       ClientToken = "string",
#'       CreateDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       InstanceCounts = list(
#'         list(
#'           InstanceCount = 123,
#'           State = "available"|"sold"|"cancelled"|"pending"
#'         )
#'       ),
#'       PriceSchedules = list(
#'         list(
#'           Active = TRUE|FALSE,
#'           CurrencyCode = "USD",
#'           Price = 123.0,
#'           Term = 123
#'         )
#'       ),
#'       ReservedInstancesId = "string",
#'       ReservedInstancesListingId = "string",
#'       Status = "active"|"pending"|"cancelled"|"closed",
#'       StatusMessage = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       UpdateDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$cancel_reserved_instances_listing(
#'   ReservedInstancesListingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_reserved_instances_listing
ec2_cancel_reserved_instances_listing <- function(ReservedInstancesListingId) {
  op <- new_operation(
    name = "CancelReservedInstancesListing",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_reserved_instances_listing_input(ReservedInstancesListingId = ReservedInstancesListingId)
  output <- .ec2$cancel_reserved_instances_listing_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_reserved_instances_listing <- ec2_cancel_reserved_instances_listing

#' Cancels the specified Spot Fleet requests
#'
#' @description
#' Cancels the specified Spot Fleet requests.
#' 
#' After you cancel a Spot Fleet request, the Spot Fleet launches no new
#' Spot Instances. You must specify whether the Spot Fleet should also
#' terminate its Spot Instances. If you terminate the instances, the Spot
#' Fleet request enters the `cancelled_terminating` state. Otherwise, the
#' Spot Fleet request enters the `cancelled_running` state and the
#' instances continue to run until they are interrupted or you terminate
#' them manually.
#'
#' @usage
#' ec2_cancel_spot_fleet_requests(DryRun, SpotFleetRequestIds,
#'   TerminateInstances)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotFleetRequestIds &#91;required&#93; The IDs of the Spot Fleet requests.
#' @param TerminateInstances &#91;required&#93; Indicates whether to terminate instances for a Spot Fleet request if it
#' is canceled successfully.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SuccessfulFleetRequests = list(
#'     list(
#'       CurrentSpotFleetRequestState = "submitted"|"active"|"cancelled"|"failed"|"cancelled_running"|"cancelled_terminating"|"modifying",
#'       PreviousSpotFleetRequestState = "submitted"|"active"|"cancelled"|"failed"|"cancelled_running"|"cancelled_terminating"|"modifying",
#'       SpotFleetRequestId = "string"
#'     )
#'   ),
#'   UnsuccessfulFleetRequests = list(
#'     list(
#'       Error = list(
#'         Code = "fleetRequestIdDoesNotExist"|"fleetRequestIdMalformed"|"fleetRequestNotInCancellableState"|"unexpectedError",
#'         Message = "string"
#'       ),
#'       SpotFleetRequestId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$cancel_spot_fleet_requests(
#'   DryRun = TRUE|FALSE,
#'   SpotFleetRequestIds = list(
#'     "string"
#'   ),
#'   TerminateInstances = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example cancels the specified Spot fleet request and terminates its
#' # associated Spot Instances.
#' svc$cancel_spot_fleet_requests(
#'   SpotFleetRequestIds = list(
#'     "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"
#'   ),
#'   TerminateInstances = TRUE
#' )
#' 
#' # This example cancels the specified Spot fleet request without
#' # terminating its associated Spot Instances.
#' svc$cancel_spot_fleet_requests(
#'   SpotFleetRequestIds = list(
#'     "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"
#'   ),
#'   TerminateInstances = FALSE
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_spot_fleet_requests
ec2_cancel_spot_fleet_requests <- function(DryRun = NULL, SpotFleetRequestIds, TerminateInstances) {
  op <- new_operation(
    name = "CancelSpotFleetRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_spot_fleet_requests_input(DryRun = DryRun, SpotFleetRequestIds = SpotFleetRequestIds, TerminateInstances = TerminateInstances)
  output <- .ec2$cancel_spot_fleet_requests_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_spot_fleet_requests <- ec2_cancel_spot_fleet_requests

#' Cancels one or more Spot Instance requests
#'
#' @description
#' Cancels one or more Spot Instance requests.
#' 
#' Canceling a Spot Instance request does not terminate running Spot
#' Instances associated with the request.
#'
#' @usage
#' ec2_cancel_spot_instance_requests(DryRun, SpotInstanceRequestIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotInstanceRequestIds &#91;required&#93; One or more Spot Instance request IDs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CancelledSpotInstanceRequests = list(
#'     list(
#'       SpotInstanceRequestId = "string",
#'       State = "active"|"open"|"closed"|"cancelled"|"completed"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$cancel_spot_instance_requests(
#'   DryRun = TRUE|FALSE,
#'   SpotInstanceRequestIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example cancels a Spot Instance request.
#' svc$cancel_spot_instance_requests(
#'   SpotInstanceRequestIds = list(
#'     "sir-08b93456"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_spot_instance_requests
ec2_cancel_spot_instance_requests <- function(DryRun = NULL, SpotInstanceRequestIds) {
  op <- new_operation(
    name = "CancelSpotInstanceRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_spot_instance_requests_input(DryRun = DryRun, SpotInstanceRequestIds = SpotInstanceRequestIds)
  output <- .ec2$cancel_spot_instance_requests_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_spot_instance_requests <- ec2_cancel_spot_instance_requests

#' Determines whether a product code is associated with an instance
#'
#' @description
#' Determines whether a product code is associated with an instance. This
#' action can only be used by the owner of the product code. It is useful
#' when a product code owner must verify whether another user's instance is
#' eligible for support.
#'
#' @usage
#' ec2_confirm_product_instance(InstanceId, ProductCode, DryRun)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param ProductCode &#91;required&#93; The product code. This must be a product code that you own.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   OwnerId = "string",
#'   Return = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$confirm_product_instance(
#'   InstanceId = "string",
#'   ProductCode = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example determines whether the specified product code is associated
#' # with the specified instance.
#' svc$confirm_product_instance(
#'   InstanceId = "i-1234567890abcdef0",
#'   ProductCode = "774F4FF8"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_confirm_product_instance
ec2_confirm_product_instance <- function(InstanceId, ProductCode, DryRun = NULL) {
  op <- new_operation(
    name = "ConfirmProductInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$confirm_product_instance_input(InstanceId = InstanceId, ProductCode = ProductCode, DryRun = DryRun)
  output <- .ec2$confirm_product_instance_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$confirm_product_instance <- ec2_confirm_product_instance

#' Copies the specified Amazon FPGA Image (AFI) to the current Region
#'
#' @description
#' Copies the specified Amazon FPGA Image (AFI) to the current Region.
#'
#' @usage
#' ec2_copy_fpga_image(DryRun, SourceFpgaImageId, Description, Name,
#'   SourceRegion, ClientToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SourceFpgaImageId &#91;required&#93; The ID of the source AFI.
#' @param Description The description for the new AFI.
#' @param Name The name for the new AFI. The default is the name of the source AFI.
#' @param SourceRegion &#91;required&#93; The Region that contains the source AFI.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FpgaImageId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$copy_fpga_image(
#'   DryRun = TRUE|FALSE,
#'   SourceFpgaImageId = "string",
#'   Description = "string",
#'   Name = "string",
#'   SourceRegion = "string",
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_copy_fpga_image
ec2_copy_fpga_image <- function(DryRun = NULL, SourceFpgaImageId, Description = NULL, Name = NULL, SourceRegion, ClientToken = NULL) {
  op <- new_operation(
    name = "CopyFpgaImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$copy_fpga_image_input(DryRun = DryRun, SourceFpgaImageId = SourceFpgaImageId, Description = Description, Name = Name, SourceRegion = SourceRegion, ClientToken = ClientToken)
  output <- .ec2$copy_fpga_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$copy_fpga_image <- ec2_copy_fpga_image

#' Initiates the copy of an AMI from the specified source Region to the
#' current Region
#'
#' @description
#' Initiates the copy of an AMI from the specified source Region to the
#' current Region. You specify the destination Region by using its endpoint
#' when making the request.
#' 
#' Copies of encrypted backing snapshots for the AMI are encrypted. Copies
#' of unencrypted backing snapshots remain unencrypted, unless you set
#' `Encrypted` during the copy operation. You cannot create an unencrypted
#' copy of an encrypted backing snapshot.
#' 
#' For more information about the prerequisites and limits when copying an
#' AMI, see [Copying an
#' AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_copy_image(ClientToken, Description, Encrypted, KmsKeyId, Name,
#'   SourceImageId, SourceRegion, DryRun)
#'
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure idempotency of
#' the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param Description A description for the new AMI in the destination Region.
#' @param Encrypted Specifies whether the destination snapshots of the copied image should
#' be encrypted. You can encrypt a copy of an unencrypted snapshot, but you
#' cannot create an unencrypted copy of an encrypted snapshot. The default
#' CMK for EBS is used unless you specify a non-default AWS Key Management
#' Service (AWS KMS) CMK using `KmsKeyId`. For more information, see
#' [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param KmsKeyId The identifier of the symmetric AWS Key Management Service (AWS KMS)
#' customer master key (CMK) to use when creating encrypted volumes. If
#' this parameter is not specified, your AWS managed CMK for EBS is used.
#' If you specify a CMK, you must also set the encrypted state to `true`.
#' 
#' You can specify a CMK using any of the following:
#' 
#' -   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Key alias. For example, alias/ExampleAlias.
#' 
#' -   Key ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Alias ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
#' 
#' AWS authenticates the CMK asynchronously. Therefore, if you specify an
#' identifier that is not valid, the action can appear to complete, but
#' eventually fails.
#' 
#' The specified CMK must exist in the destination Region.
#' 
#' Amazon EBS does not support asymmetric CMKs.
#' @param Name &#91;required&#93; The name of the new AMI in the destination Region.
#' @param SourceImageId &#91;required&#93; The ID of the AMI to copy.
#' @param SourceRegion &#91;required&#93; The name of the Region that contains the AMI to copy.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$copy_image(
#'   ClientToken = "string",
#'   Description = "string",
#'   Encrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   Name = "string",
#'   SourceImageId = "string",
#'   SourceRegion = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example copies the specified AMI from the us-east-1 region to the
#' # current region.
#' svc$copy_image(
#'   Description = "",
#'   Name = "My server",
#'   SourceImageId = "ami-5731123e",
#'   SourceRegion = "us-east-1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_copy_image
ec2_copy_image <- function(ClientToken = NULL, Description = NULL, Encrypted = NULL, KmsKeyId = NULL, Name, SourceImageId, SourceRegion, DryRun = NULL) {
  op <- new_operation(
    name = "CopyImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$copy_image_input(ClientToken = ClientToken, Description = Description, Encrypted = Encrypted, KmsKeyId = KmsKeyId, Name = Name, SourceImageId = SourceImageId, SourceRegion = SourceRegion, DryRun = DryRun)
  output <- .ec2$copy_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$copy_image <- ec2_copy_image

#' Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
#' S3
#'
#' @description
#' Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
#' S3. You can copy the snapshot within the same Region or from one Region
#' to another. You can use the snapshot to create EBS volumes or Amazon
#' Machine Images (AMIs).
#' 
#' Copies of encrypted EBS snapshots remain encrypted. Copies of
#' unencrypted snapshots remain unencrypted, unless you enable encryption
#' for the snapshot copy operation. By default, encrypted snapshot copies
#' use the default AWS Key Management Service (AWS KMS) customer master key
#' (CMK); however, you can specify a different CMK.
#' 
#' To copy an encrypted snapshot that has been shared from another account,
#' you must have permissions for the CMK used to encrypt the snapshot.
#' 
#' Snapshots created by copying another snapshot have an arbitrary volume
#' ID that should not be used for any purpose.
#' 
#' For more information, see [Copying an Amazon EBS
#' snapshot](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_copy_snapshot(Description, DestinationRegion, Encrypted, KmsKeyId,
#'   PresignedUrl, SourceRegion, SourceSnapshotId, TagSpecifications, DryRun)
#'
#' @param Description A description for the EBS snapshot.
#' @param DestinationRegion The destination Region to use in the `PresignedUrl` parameter of a
#' snapshot copy operation. This parameter is only valid for specifying the
#' destination Region in a `PresignedUrl` parameter, where it is required.
#' 
#' The snapshot copy is sent to the regional endpoint that you sent the
#' HTTP request to (for example, `ec2.us-east-1.amazonaws.com`). With the
#' AWS CLI, this is specified using the `--region` parameter or the default
#' Region in your AWS configuration file.
#' @param Encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is
#' not enabled, enable encryption using this parameter. Otherwise, omit
#' this parameter. Encrypted snapshots are encrypted, even if you omit this
#' parameter and encryption by default is not enabled. You cannot set this
#' parameter to false. For more information, see [Amazon EBS
#' encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param KmsKeyId The identifier of the AWS Key Management Service (AWS KMS) customer
#' master key (CMK) to use for Amazon EBS encryption. If this parameter is
#' not specified, your AWS managed CMK for EBS is used. If `KmsKeyId` is
#' specified, the encrypted state must be `true`.
#' 
#' You can specify the CMK using any of the following:
#' 
#' -   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Key alias. For example, alias/ExampleAlias.
#' 
#' -   Key ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Alias ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
#' 
#' AWS authenticates the CMK asynchronously. Therefore, if you specify an
#' ID, alias, or ARN that is not valid, the action can appear to complete,
#' but eventually fails.
#' @param PresignedUrl When you copy an encrypted source snapshot using the Amazon EC2 Query
#' API, you must supply a pre-signed URL. This parameter is optional for
#' unencrypted snapshots. For more information, see [Query
#' requests](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html).
#' 
#' The `PresignedUrl` should use the snapshot source endpoint, the
#' [`copy_snapshot`][ec2_copy_snapshot] action, and include the
#' `SourceRegion`, `SourceSnapshotId`, and `DestinationRegion` parameters.
#' The `PresignedUrl` must be signed using AWS Signature Version 4. Because
#' EBS snapshots are stored in Amazon S3, the signing algorithm for this
#' parameter uses the same logic that is described in [Authenticating
#' Requests: Using Query Parameters (AWS Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' in the *Amazon Simple Storage Service API Reference*. An invalid or
#' improperly signed `PresignedUrl` will cause the copy operation to fail
#' asynchronously, and the snapshot will move to an `error` state.
#' @param SourceRegion &#91;required&#93; The ID of the Region that contains the snapshot to be copied.
#' @param SourceSnapshotId &#91;required&#93; The ID of the EBS snapshot to copy.
#' @param TagSpecifications The tags to apply to the new snapshot.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SnapshotId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$copy_snapshot(
#'   Description = "string",
#'   DestinationRegion = "string",
#'   Encrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   PresignedUrl = "string",
#'   SourceRegion = "string",
#'   SourceSnapshotId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example copies a snapshot with the snapshot ID of
#' # `snap-066877671789bd71b` from the `us-west-2` region to the
#' # `us-east-1` region and adds a short description to identify the
#' # snapshot.
#' svc$copy_snapshot(
#'   Description = "This is my copied snapshot.",
#'   DestinationRegion = "us-east-1",
#'   SourceRegion = "us-west-2",
#'   SourceSnapshotId = "snap-066877671789bd71b"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_copy_snapshot
ec2_copy_snapshot <- function(Description = NULL, DestinationRegion = NULL, Encrypted = NULL, KmsKeyId = NULL, PresignedUrl = NULL, SourceRegion, SourceSnapshotId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CopySnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$copy_snapshot_input(Description = Description, DestinationRegion = DestinationRegion, Encrypted = Encrypted, KmsKeyId = KmsKeyId, PresignedUrl = PresignedUrl, SourceRegion = SourceRegion, SourceSnapshotId = SourceSnapshotId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$copy_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$copy_snapshot <- ec2_copy_snapshot

#' Creates a new Capacity Reservation with the specified attributes
#'
#' @description
#' Creates a new Capacity Reservation with the specified attributes.
#' 
#' Capacity Reservations enable you to reserve capacity for your Amazon EC2
#' instances in a specific Availability Zone for any duration. This gives
#' you the flexibility to selectively add capacity reservations and still
#' get the Regional RI discounts for that usage. By creating Capacity
#' Reservations, you ensure that you always have access to Amazon EC2
#' capacity when you need it, for as long as you need it. For more
#' information, see [Capacity
#' Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' Your request to create a Capacity Reservation could fail if Amazon EC2
#' does not have sufficient capacity to fulfill the request. If your
#' request fails due to Amazon EC2 capacity constraints, either try again
#' at a later time, try in a different Availability Zone, or request a
#' smaller capacity reservation. If your application is flexible across
#' instance types and sizes, try to create a Capacity Reservation with
#' different instance attributes.
#' 
#' Your request could also fail if the requested quantity exceeds your
#' On-Demand Instance limit for the selected instance type. If your request
#' fails due to limit constraints, increase your On-Demand Instance limit
#' for the required instance type and try again. For more information about
#' increasing your instance limits, see [Amazon EC2 Service
#' Limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_capacity_reservation(ClientToken, InstanceType,
#'   InstancePlatform, AvailabilityZone, AvailabilityZoneId, Tenancy,
#'   InstanceCount, EbsOptimized, EphemeralStorage, EndDate, EndDateType,
#'   InstanceMatchCriteria, TagSpecifications, DryRun)
#'
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param InstanceType &#91;required&#93; The instance type for which to reserve capacity. For more information,
#' see [Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param InstancePlatform &#91;required&#93; The type of operating system for which to reserve capacity.
#' @param AvailabilityZone The Availability Zone in which to create the Capacity Reservation.
#' @param AvailabilityZoneId The ID of the Availability Zone in which to create the Capacity
#' Reservation.
#' @param Tenancy Indicates the tenancy of the Capacity Reservation. A Capacity
#' Reservation can have one of the following tenancy settings:
#' 
#' -   `default` - The Capacity Reservation is created on hardware that is
#'     shared with other AWS accounts.
#' 
#' -   `dedicated` - The Capacity Reservation is created on single-tenant
#'     hardware that is dedicated to a single AWS account.
#' @param InstanceCount &#91;required&#93; The number of instances for which to reserve capacity.
#' @param EbsOptimized Indicates whether the Capacity Reservation supports EBS-optimized
#' instances. This optimization provides dedicated throughput to Amazon EBS
#' and an optimized configuration stack to provide optimal I/O performance.
#' This optimization isn't available with all instance types. Additional
#' usage charges apply when using an EBS- optimized instance.
#' @param EphemeralStorage Indicates whether the Capacity Reservation supports instances with
#' temporary, block-level storage.
#' @param EndDate The date and time at which the Capacity Reservation expires. When a
#' Capacity Reservation expires, the reserved capacity is released and you
#' can no longer launch instances into it. The Capacity Reservation's state
#' changes to `expired` when it reaches its end date and time.
#' 
#' You must provide an `EndDate` value if `EndDateType` is `limited`. Omit
#' `EndDate` if `EndDateType` is `unlimited`.
#' 
#' If the `EndDateType` is `limited`, the Capacity Reservation is cancelled
#' within an hour from the specified time. For example, if you specify
#' 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end
#' between 13:30:55 and 14:30:55 on 5/31/2019.
#' @param EndDateType Indicates the way in which the Capacity Reservation ends. A Capacity
#' Reservation can have one of the following end types:
#' 
#' -   `unlimited` - The Capacity Reservation remains active until you
#'     explicitly cancel it. Do not provide an `EndDate` if the
#'     `EndDateType` is `unlimited`.
#' 
#' -   `limited` - The Capacity Reservation expires automatically at a
#'     specified date and time. You must provide an `EndDate` value if the
#'     `EndDateType` value is `limited`.
#' @param InstanceMatchCriteria Indicates the type of instance launches that the Capacity Reservation
#' accepts. The options include:
#' 
#' -   `open` - The Capacity Reservation automatically matches all
#'     instances that have matching attributes (instance type, platform,
#'     and Availability Zone). Instances that have matching attributes run
#'     in the Capacity Reservation automatically without specifying any
#'     additional parameters.
#' 
#' -   `targeted` - The Capacity Reservation only accepts instances that
#'     have matching attributes (instance type, platform, and Availability
#'     Zone), and explicitly target the Capacity Reservation. This ensures
#'     that only permitted instances can use the reserved capacity.
#' 
#' Default: `open`
#' @param TagSpecifications The tags to apply to the Capacity Reservation during launch.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CapacityReservation = list(
#'     CapacityReservationId = "string",
#'     OwnerId = "string",
#'     CapacityReservationArn = "string",
#'     AvailabilityZoneId = "string",
#'     InstanceType = "string",
#'     InstancePlatform = "Linux/UNIX"|"Red Hat Enterprise Linux"|"SUSE Linux"|"Windows"|"Windows with SQL Server"|"Windows with SQL Server Enterprise"|"Windows with SQL Server Standard"|"Windows with SQL Server Web"|"Linux with SQL Server Standard"|"Linux with SQL Server Web"|"Linux with SQL Server Enterprise",
#'     AvailabilityZone = "string",
#'     Tenancy = "default"|"dedicated",
#'     TotalInstanceCount = 123,
#'     AvailableInstanceCount = 123,
#'     EbsOptimized = TRUE|FALSE,
#'     EphemeralStorage = TRUE|FALSE,
#'     State = "active"|"expired"|"cancelled"|"pending"|"failed",
#'     EndDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EndDateType = "unlimited"|"limited",
#'     InstanceMatchCriteria = "open"|"targeted",
#'     CreateDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_capacity_reservation(
#'   ClientToken = "string",
#'   InstanceType = "string",
#'   InstancePlatform = "Linux/UNIX"|"Red Hat Enterprise Linux"|"SUSE Linux"|"Windows"|"Windows with SQL Server"|"Windows with SQL Server Enterprise"|"Windows with SQL Server Standard"|"Windows with SQL Server Web"|"Linux with SQL Server Standard"|"Linux with SQL Server Web"|"Linux with SQL Server Enterprise",
#'   AvailabilityZone = "string",
#'   AvailabilityZoneId = "string",
#'   Tenancy = "default"|"dedicated",
#'   InstanceCount = 123,
#'   EbsOptimized = TRUE|FALSE,
#'   EphemeralStorage = TRUE|FALSE,
#'   EndDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndDateType = "unlimited"|"limited",
#'   InstanceMatchCriteria = "open"|"targeted",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_capacity_reservation
ec2_create_capacity_reservation <- function(ClientToken = NULL, InstanceType, InstancePlatform, AvailabilityZone = NULL, AvailabilityZoneId = NULL, Tenancy = NULL, InstanceCount, EbsOptimized = NULL, EphemeralStorage = NULL, EndDate = NULL, EndDateType = NULL, InstanceMatchCriteria = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_capacity_reservation_input(ClientToken = ClientToken, InstanceType = InstanceType, InstancePlatform = InstancePlatform, AvailabilityZone = AvailabilityZone, AvailabilityZoneId = AvailabilityZoneId, Tenancy = Tenancy, InstanceCount = InstanceCount, EbsOptimized = EbsOptimized, EphemeralStorage = EphemeralStorage, EndDate = EndDate, EndDateType = EndDateType, InstanceMatchCriteria = InstanceMatchCriteria, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_capacity_reservation_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_capacity_reservation <- ec2_create_capacity_reservation

#' Creates a carrier gateway
#'
#' @description
#' Creates a carrier gateway. For more information about carrier gateways,
#' see [Carrier
#' gateways](https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway)
#' in the *AWS Wavelength Developer Guide*.
#'
#' @usage
#' ec2_create_carrier_gateway(VpcId, TagSpecifications, DryRun,
#'   ClientToken)
#'
#' @param VpcId &#91;required&#93; The ID of the VPC to associate with the carrier gateway.
#' @param TagSpecifications The tags to associate with the carrier gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CarrierGateway = list(
#'     CarrierGatewayId = "string",
#'     VpcId = "string",
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     OwnerId = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_carrier_gateway(
#'   VpcId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_carrier_gateway
ec2_create_carrier_gateway <- function(VpcId, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateCarrierGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_carrier_gateway_input(VpcId = VpcId, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_carrier_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_carrier_gateway <- ec2_create_carrier_gateway

#' Creates a Client VPN endpoint
#'
#' @description
#' Creates a Client VPN endpoint. A Client VPN endpoint is the resource you
#' create and configure to enable and manage client VPN sessions. It is the
#' destination endpoint at which all client VPN sessions are terminated.
#'
#' @usage
#' ec2_create_client_vpn_endpoint(ClientCidrBlock, ServerCertificateArn,
#'   AuthenticationOptions, ConnectionLogOptions, DnsServers,
#'   TransportProtocol, VpnPort, Description, SplitTunnel, DryRun,
#'   ClientToken, TagSpecifications, SecurityGroupIds, VpcId,
#'   SelfServicePortal, ClientConnectOptions)
#'
#' @param ClientCidrBlock &#91;required&#93; The IPv4 address range, in CIDR notation, from which to assign client IP
#' addresses. The address range cannot overlap with the local CIDR of the
#' VPC in which the associated subnet is located, or the routes that you
#' add manually. The address range cannot be changed after the Client VPN
#' endpoint has been created. The CIDR block should be /22 or greater.
#' @param ServerCertificateArn &#91;required&#93; The ARN of the server certificate. For more information, see the [AWS
#' Certificate Manager User
#' Guide](https://docs.aws.amazon.com/acm/latest/userguide/).
#' @param AuthenticationOptions &#91;required&#93; Information about the authentication method to be used to authenticate
#' clients.
#' @param ConnectionLogOptions &#91;required&#93; Information about the client connection logging options.
#' 
#' If you enable client connection logging, data about client connections
#' is sent to a Cloudwatch Logs log stream. The following information is
#' logged:
#' 
#' -   Client connection requests
#' 
#' -   Client connection results (successful and unsuccessful)
#' 
#' -   Reasons for unsuccessful client connection requests
#' 
#' -   Client connection termination time
#' @param DnsServers Information about the DNS servers to be used for DNS resolution. A
#' Client VPN endpoint can have up to two DNS servers. If no DNS server is
#' specified, the DNS address configured on the device is used for the DNS
#' server.
#' @param TransportProtocol The transport protocol to be used by the VPN session.
#' 
#' Default value: `udp`
#' @param VpnPort The port number to assign to the Client VPN endpoint for TCP and UDP
#' traffic.
#' 
#' Valid Values: `443` | `1194`
#' 
#' Default Value: `443`
#' @param Description A brief description of the Client VPN endpoint.
#' @param SplitTunnel Indicates whether split-tunnel is enabled on the AWS Client VPN
#' endpoint.
#' 
#' By default, split-tunnel on a VPN endpoint is disabled.
#' 
#' For information about split-tunnel VPN endpoints, see [Split-Tunnel AWS
#' Client VPN
#' Endpoint](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html)
#' in the *AWS Client VPN Administrator Guide*.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param TagSpecifications The tags to apply to the Client VPN endpoint during creation.
#' @param SecurityGroupIds The IDs of one or more security groups to apply to the target network.
#' You must also specify the ID of the VPC that contains the security
#' groups.
#' @param VpcId The ID of the VPC to associate with the Client VPN endpoint. If no
#' security group IDs are specified in the request, the default security
#' group for the VPC is applied.
#' @param SelfServicePortal Specify whether to enable the self-service portal for the Client VPN
#' endpoint.
#' 
#' Default Value: `enabled`
#' @param ClientConnectOptions The options for managing connection authorization for new client
#' connections.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ClientVpnEndpointId = "string",
#'   Status = list(
#'     Code = "pending-associate"|"available"|"deleting"|"deleted",
#'     Message = "string"
#'   ),
#'   DnsName = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_client_vpn_endpoint(
#'   ClientCidrBlock = "string",
#'   ServerCertificateArn = "string",
#'   AuthenticationOptions = list(
#'     list(
#'       Type = "certificate-authentication"|"directory-service-authentication"|"federated-authentication",
#'       ActiveDirectory = list(
#'         DirectoryId = "string"
#'       ),
#'       MutualAuthentication = list(
#'         ClientRootCertificateChainArn = "string"
#'       ),
#'       FederatedAuthentication = list(
#'         SAMLProviderArn = "string",
#'         SelfServiceSAMLProviderArn = "string"
#'       )
#'     )
#'   ),
#'   ConnectionLogOptions = list(
#'     Enabled = TRUE|FALSE,
#'     CloudwatchLogGroup = "string",
#'     CloudwatchLogStream = "string"
#'   ),
#'   DnsServers = list(
#'     "string"
#'   ),
#'   TransportProtocol = "tcp"|"udp",
#'   VpnPort = 123,
#'   Description = "string",
#'   SplitTunnel = TRUE|FALSE,
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   VpcId = "string",
#'   SelfServicePortal = "enabled"|"disabled",
#'   ClientConnectOptions = list(
#'     Enabled = TRUE|FALSE,
#'     LambdaFunctionArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_client_vpn_endpoint
ec2_create_client_vpn_endpoint <- function(ClientCidrBlock, ServerCertificateArn, AuthenticationOptions, ConnectionLogOptions, DnsServers = NULL, TransportProtocol = NULL, VpnPort = NULL, Description = NULL, SplitTunnel = NULL, DryRun = NULL, ClientToken = NULL, TagSpecifications = NULL, SecurityGroupIds = NULL, VpcId = NULL, SelfServicePortal = NULL, ClientConnectOptions = NULL) {
  op <- new_operation(
    name = "CreateClientVpnEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_client_vpn_endpoint_input(ClientCidrBlock = ClientCidrBlock, ServerCertificateArn = ServerCertificateArn, AuthenticationOptions = AuthenticationOptions, ConnectionLogOptions = ConnectionLogOptions, DnsServers = DnsServers, TransportProtocol = TransportProtocol, VpnPort = VpnPort, Description = Description, SplitTunnel = SplitTunnel, DryRun = DryRun, ClientToken = ClientToken, TagSpecifications = TagSpecifications, SecurityGroupIds = SecurityGroupIds, VpcId = VpcId, SelfServicePortal = SelfServicePortal, ClientConnectOptions = ClientConnectOptions)
  output <- .ec2$create_client_vpn_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_client_vpn_endpoint <- ec2_create_client_vpn_endpoint

#' Adds a route to a network to a Client VPN endpoint
#'
#' @description
#' Adds a route to a network to a Client VPN endpoint. Each Client VPN
#' endpoint has a route table that describes the available destination
#' network routes. Each route in the route table specifies the path for
#' traﬃc to speciﬁc resources or networks.
#'
#' @usage
#' ec2_create_client_vpn_route(ClientVpnEndpointId, DestinationCidrBlock,
#'   TargetVpcSubnetId, Description, ClientToken, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint to which to add the route.
#' @param DestinationCidrBlock &#91;required&#93; The IPv4 address range, in CIDR notation, of the route destination. For
#' example:
#' 
#' -   To add a route for Internet access, enter `0.0.0.0/0`
#' 
#' -   To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR
#'     range
#' 
#' -   To add a route for an on-premises network, enter the AWS
#'     Site-to-Site VPN connection's IPv4 CIDR range
#' 
#' -   To add a route for the local network, enter the client CIDR range
#' @param TargetVpcSubnetId &#91;required&#93; The ID of the subnet through which you want to route traffic. The
#' specified subnet must be an existing target network of the Client VPN
#' endpoint.
#' 
#' Alternatively, if you're adding a route for the local network, specify
#' `local`.
#' @param Description A brief description of the route.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Status = list(
#'     Code = "creating"|"active"|"failed"|"deleting",
#'     Message = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_client_vpn_route(
#'   ClientVpnEndpointId = "string",
#'   DestinationCidrBlock = "string",
#'   TargetVpcSubnetId = "string",
#'   Description = "string",
#'   ClientToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_client_vpn_route
ec2_create_client_vpn_route <- function(ClientVpnEndpointId, DestinationCidrBlock, TargetVpcSubnetId, Description = NULL, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateClientVpnRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_client_vpn_route_input(ClientVpnEndpointId = ClientVpnEndpointId, DestinationCidrBlock = DestinationCidrBlock, TargetVpcSubnetId = TargetVpcSubnetId, Description = Description, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$create_client_vpn_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_client_vpn_route <- ec2_create_client_vpn_route

#' Provides information to AWS about your VPN customer gateway device
#'
#' @description
#' Provides information to AWS about your VPN customer gateway device. The
#' customer gateway is the appliance at your end of the VPN connection.
#' (The device on the AWS side of the VPN connection is the virtual private
#' gateway.) You must provide the internet-routable IP address of the
#' customer gateway's external interface. The IP address must be static and
#' can be behind a device performing network address translation (NAT).
#' 
#' For devices that use Border Gateway Protocol (BGP), you can also provide
#' the device's BGP Autonomous System Number (ASN). You can use an existing
#' ASN assigned to your network. If you don't have an ASN already, you can
#' use a private ASN (in the 64512 - 65534 range).
#' 
#' Amazon EC2 supports all 4-byte ASN numbers in the range of 1 -
#' 2147483647, with the exception of the following:
#' 
#' -   7224 - reserved in the `us-east-1` Region
#' 
#' -   9059 - reserved in the `eu-west-1` Region
#' 
#' -   17943 - reserved in the `ap-southeast-1` Region
#' 
#' -   10124 - reserved in the `ap-northeast-1` Region
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#' 
#' To create more than one customer gateway with the same VPN type, IP
#' address, and BGP ASN, specify a unique device name for each customer
#' gateway. Identical requests return information about the existing
#' customer gateway and do not create new customer gateways.
#'
#' @usage
#' ec2_create_customer_gateway(BgpAsn, PublicIp, CertificateArn, Type,
#'   TagSpecifications, DeviceName, DryRun)
#'
#' @param BgpAsn &#91;required&#93; For devices that support BGP, the customer gateway's BGP ASN.
#' 
#' Default: 65000
#' @param PublicIp The Internet-routable IP address for the customer gateway's outside
#' interface. The address must be static.
#' @param CertificateArn The Amazon Resource Name (ARN) for the customer gateway certificate.
#' @param Type &#91;required&#93; The type of VPN connection that this customer gateway supports
#' (`ipsec.1`).
#' @param TagSpecifications The tags to apply to the customer gateway.
#' @param DeviceName A name for the customer gateway device.
#' 
#' Length Constraints: Up to 255 characters.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CustomerGateway = list(
#'     BgpAsn = "string",
#'     CustomerGatewayId = "string",
#'     IpAddress = "string",
#'     CertificateArn = "string",
#'     State = "string",
#'     Type = "string",
#'     DeviceName = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_customer_gateway(
#'   BgpAsn = 123,
#'   PublicIp = "string",
#'   CertificateArn = "string",
#'   Type = "ipsec.1",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DeviceName = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a customer gateway with the specified IP address
#' # for its outside interface.
#' svc$create_customer_gateway(
#'   BgpAsn = 65534L,
#'   PublicIp = "12.1.2.3",
#'   Type = "ipsec.1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_customer_gateway
ec2_create_customer_gateway <- function(BgpAsn, PublicIp = NULL, CertificateArn = NULL, Type, TagSpecifications = NULL, DeviceName = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateCustomerGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_customer_gateway_input(BgpAsn = BgpAsn, PublicIp = PublicIp, CertificateArn = CertificateArn, Type = Type, TagSpecifications = TagSpecifications, DeviceName = DeviceName, DryRun = DryRun)
  output <- .ec2$create_customer_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_customer_gateway <- ec2_create_customer_gateway

#' Creates a default subnet with a size /20 IPv4 CIDR block in the
#' specified Availability Zone in your default VPC
#'
#' @description
#' Creates a default subnet with a size `/20` IPv4 CIDR block in the
#' specified Availability Zone in your default VPC. You can have only one
#' default subnet per Availability Zone. For more information, see
#' [Creating a Default
#' Subnet](https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_default_subnet(AvailabilityZone, DryRun)
#'
#' @param AvailabilityZone &#91;required&#93; The Availability Zone in which to create the default subnet.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Subnet = list(
#'     AvailabilityZone = "string",
#'     AvailabilityZoneId = "string",
#'     AvailableIpAddressCount = 123,
#'     CidrBlock = "string",
#'     DefaultForAz = TRUE|FALSE,
#'     MapPublicIpOnLaunch = TRUE|FALSE,
#'     MapCustomerOwnedIpOnLaunch = TRUE|FALSE,
#'     CustomerOwnedIpv4Pool = "string",
#'     State = "pending"|"available",
#'     SubnetId = "string",
#'     VpcId = "string",
#'     OwnerId = "string",
#'     AssignIpv6AddressOnCreation = TRUE|FALSE,
#'     Ipv6CidrBlockAssociationSet = list(
#'       list(
#'         AssociationId = "string",
#'         Ipv6CidrBlock = "string",
#'         Ipv6CidrBlockState = list(
#'           State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
#'           StatusMessage = "string"
#'         )
#'       )
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     SubnetArn = "string",
#'     OutpostArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_default_subnet(
#'   AvailabilityZone = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_default_subnet
ec2_create_default_subnet <- function(AvailabilityZone, DryRun = NULL) {
  op <- new_operation(
    name = "CreateDefaultSubnet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_default_subnet_input(AvailabilityZone = AvailabilityZone, DryRun = DryRun)
  output <- .ec2$create_default_subnet_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_default_subnet <- ec2_create_default_subnet

#' Creates a default VPC with a size /16 IPv4 CIDR block and a default
#' subnet in each Availability Zone
#'
#' @description
#' Creates a default VPC with a size `/16` IPv4 CIDR block and a default
#' subnet in each Availability Zone. For more information about the
#' components of a default VPC, see [Default VPC and Default
#' Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html)
#' in the *Amazon Virtual Private Cloud User Guide*. You cannot specify the
#' components of the default VPC yourself.
#' 
#' If you deleted your previous default VPC, you can create a default VPC.
#' You cannot have more than one default VPC per Region.
#' 
#' If your account supports EC2-Classic, you cannot use this action to
#' create a default VPC in a Region that supports EC2-Classic. If you want
#' a default VPC in a Region that supports EC2-Classic, see "I really want
#' a default VPC for my existing EC2 account. Is that possible?" in the
#' [Default VPCs FAQ](https://aws.amazon.com/vpc/faqs/#Default_VPCs).
#'
#' @usage
#' ec2_create_default_vpc(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Vpc = list(
#'     CidrBlock = "string",
#'     DhcpOptionsId = "string",
#'     State = "pending"|"available",
#'     VpcId = "string",
#'     OwnerId = "string",
#'     InstanceTenancy = "default"|"dedicated"|"host",
#'     Ipv6CidrBlockAssociationSet = list(
#'       list(
#'         AssociationId = "string",
#'         Ipv6CidrBlock = "string",
#'         Ipv6CidrBlockState = list(
#'           State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
#'           StatusMessage = "string"
#'         ),
#'         NetworkBorderGroup = "string",
#'         Ipv6Pool = "string"
#'       )
#'     ),
#'     CidrBlockAssociationSet = list(
#'       list(
#'         AssociationId = "string",
#'         CidrBlock = "string",
#'         CidrBlockState = list(
#'           State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
#'           StatusMessage = "string"
#'         )
#'       )
#'     ),
#'     IsDefault = TRUE|FALSE,
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_default_vpc(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_default_vpc
ec2_create_default_vpc <- function(DryRun = NULL) {
  op <- new_operation(
    name = "CreateDefaultVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_default_vpc_input(DryRun = DryRun)
  output <- .ec2$create_default_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_default_vpc <- ec2_create_default_vpc

#' Creates a set of DHCP options for your VPC
#'
#' @description
#' Creates a set of DHCP options for your VPC. After creating the set, you
#' must associate it with the VPC, causing all existing and new instances
#' that you launch in the VPC to use this set of DHCP options. The
#' following are the individual DHCP options you can specify. For more
#' information about the options, see [RFC
#' 2132](https://www.ietf.org/rfc/rfc2132.txt).
#' 
#' -   `domain-name-servers` - The IP addresses of up to four domain name
#'     servers, or AmazonProvidedDNS. The default DHCP option set specifies
#'     AmazonProvidedDNS. If specifying more than one domain name server,
#'     specify the IP addresses in a single parameter, separated by commas.
#'     To have your instance receive a custom DNS hostname as specified in
#'     `domain-name`, you must set `domain-name-servers` to a custom DNS
#'     server.
#' 
#' -   `domain-name` - If you're using AmazonProvidedDNS in `us-east-1`,
#'     specify `ec2.internal`. If you're using AmazonProvidedDNS in another
#'     Region, specify `region.compute.internal` (for example,
#'     `ap-northeast-1.compute.internal`). Otherwise, specify a domain name
#'     (for example, `ExampleCompany.com`). This value is used to complete
#'     unqualified DNS hostnames. **Important**: Some Linux operating
#'     systems accept multiple domain names separated by spaces. However,
#'     Windows and other Linux operating systems treat the value as a
#'     single domain, which results in unexpected behavior. If your DHCP
#'     options set is associated with a VPC that has instances with
#'     multiple operating systems, specify only one domain name.
#' 
#' -   `ntp-servers` - The IP addresses of up to four Network Time Protocol
#'     (NTP) servers.
#' 
#' -   `netbios-name-servers` - The IP addresses of up to four NetBIOS name
#'     servers.
#' 
#' -   `netbios-node-type` - The NetBIOS node type (1, 2, 4, or 8). We
#'     recommend that you specify 2 (broadcast and multicast are not
#'     currently supported). For more information about these node types,
#'     see [RFC 2132](https://www.ietf.org/rfc/rfc2132.txt).
#' 
#' Your VPC automatically starts out with a set of DHCP options that
#' includes only a DNS server that we provide (AmazonProvidedDNS). If you
#' create a set of options, and if your VPC has an internet gateway, make
#' sure to set the `domain-name-servers` option either to
#' `AmazonProvidedDNS` or to a domain name server of your choice. For more
#' information, see [DHCP Options
#' Sets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_dhcp_options(DhcpConfigurations, TagSpecifications, DryRun)
#'
#' @param DhcpConfigurations &#91;required&#93; A DHCP configuration option.
#' @param TagSpecifications The tags to assign to the DHCP option.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DhcpOptions = list(
#'     DhcpConfigurations = list(
#'       list(
#'         Key = "string",
#'         Values = list(
#'           list(
#'             Value = "string"
#'           )
#'         )
#'       )
#'     ),
#'     DhcpOptionsId = "string",
#'     OwnerId = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_dhcp_options(
#'   DhcpConfigurations = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a DHCP options set.
#' svc$create_dhcp_options(
#'   DhcpConfigurations = list(
#'     list(
#'       Key = "domain-name-servers",
#'       Values = list(
#'         "10.2.5.1",
#'         "10.2.5.2"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_dhcp_options
ec2_create_dhcp_options <- function(DhcpConfigurations, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateDhcpOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_dhcp_options_input(DhcpConfigurations = DhcpConfigurations, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_dhcp_options <- ec2_create_dhcp_options

#' &#91;IPv6 only&#93; Creates an egress-only internet gateway for your VPC
#'
#' @description
#' \[IPv6 only\] Creates an egress-only internet gateway for your VPC. An
#' egress-only internet gateway is used to enable outbound communication
#' over IPv6 from instances in your VPC to the internet, and prevents hosts
#' outside of your VPC from initiating an IPv6 connection with your
#' instance.
#'
#' @usage
#' ec2_create_egress_only_internet_gateway(ClientToken, DryRun, VpcId,
#'   TagSpecifications)
#'
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC for which to create the egress-only internet gateway.
#' @param TagSpecifications The tags to assign to the egress-only internet gateway.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ClientToken = "string",
#'   EgressOnlyInternetGateway = list(
#'     Attachments = list(
#'       list(
#'         State = "attaching"|"attached"|"detaching"|"detached",
#'         VpcId = "string"
#'       )
#'     ),
#'     EgressOnlyInternetGatewayId = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_egress_only_internet_gateway(
#'   ClientToken = "string",
#'   DryRun = TRUE|FALSE,
#'   VpcId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_egress_only_internet_gateway
ec2_create_egress_only_internet_gateway <- function(ClientToken = NULL, DryRun = NULL, VpcId, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateEgressOnlyInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_egress_only_internet_gateway_input(ClientToken = ClientToken, DryRun = DryRun, VpcId = VpcId, TagSpecifications = TagSpecifications)
  output <- .ec2$create_egress_only_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_egress_only_internet_gateway <- ec2_create_egress_only_internet_gateway

#' Launches an EC2 Fleet
#'
#' @description
#' Launches an EC2 Fleet.
#' 
#' You can create a single EC2 Fleet that includes multiple launch
#' specifications that vary by instance type, AMI, Availability Zone, or
#' subnet.
#' 
#' For more information, see [Launching an EC2
#' Fleet](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_fleet(DryRun, ClientToken, SpotOptions, OnDemandOptions,
#'   ExcessCapacityTerminationPolicy, LaunchTemplateConfigs,
#'   TargetCapacitySpecification, TerminateInstancesWithExpiration, Type,
#'   ValidFrom, ValidUntil, ReplaceUnhealthyInstances, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param SpotOptions Describes the configuration of Spot Instances in an EC2 Fleet.
#' @param OnDemandOptions Describes the configuration of On-Demand Instances in an EC2 Fleet.
#' @param ExcessCapacityTerminationPolicy Indicates whether running instances should be terminated if the total
#' target capacity of the EC2 Fleet is decreased below the current size of
#' the EC2 Fleet.
#' @param LaunchTemplateConfigs &#91;required&#93; The configuration for the EC2 Fleet.
#' @param TargetCapacitySpecification &#91;required&#93; The number of units to request.
#' @param TerminateInstancesWithExpiration Indicates whether running instances should be terminated when the EC2
#' Fleet expires.
#' @param Type The type of request. The default value is `maintain`.
#' 
#' -   `maintain` - The EC2 Fleet plaees an asynchronous request for your
#'     desired capacity, and continues to maintain your desired Spot
#'     capacity by replenishing interrupted Spot Instances.
#' 
#' -   `request` - The EC2 Fleet places an asynchronous one-time request
#'     for your desired capacity, but does submit Spot requests in
#'     alternative capacity pools if Spot capacity is unavailable, and does
#'     not maintain Spot capacity if Spot Instances are interrupted.
#' 
#' -   `instant` - The EC2 Fleet places a synchronous one-time request for
#'     your desired capacity, and returns errors for any instances that
#'     could not be launched.
#' 
#' For more information, see [EC2 Fleet request
#' types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param ValidFrom The start date and time of the request, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). The default is to start fulfilling
#' the request immediately.
#' @param ValidUntil The end date and time of the request, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). At this point, no new EC2 Fleet
#' requests are placed or able to fulfill the request. If no value is
#' specified, the request remains until you cancel it.
#' @param ReplaceUnhealthyInstances Indicates whether EC2 Fleet should replace unhealthy instances.
#' @param TagSpecifications The key-value pair for tagging the EC2 Fleet request on creation. The
#' value for `ResourceType` must be `fleet`, otherwise the fleet request
#' fails. To tag instances at launch, specify the tags in the [launch
#' template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template).
#' For information about tagging after launch, see [Tagging your
#' resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FleetId = "string",
#'   Errors = list(
#'     list(
#'       LaunchTemplateAndOverrides = list(
#'         LaunchTemplateSpecification = list(
#'           LaunchTemplateId = "string",
#'           LaunchTemplateName = "string",
#'           Version = "string"
#'         ),
#'         Overrides = list(
#'           InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'           MaxPrice = "string",
#'           SubnetId = "string",
#'           AvailabilityZone = "string",
#'           WeightedCapacity = 123.0,
#'           Priority = 123.0,
#'           Placement = list(
#'             GroupName = "string"
#'           )
#'         )
#'       ),
#'       Lifecycle = "spot"|"on-demand",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   ),
#'   Instances = list(
#'     list(
#'       LaunchTemplateAndOverrides = list(
#'         LaunchTemplateSpecification = list(
#'           LaunchTemplateId = "string",
#'           LaunchTemplateName = "string",
#'           Version = "string"
#'         ),
#'         Overrides = list(
#'           InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'           MaxPrice = "string",
#'           SubnetId = "string",
#'           AvailabilityZone = "string",
#'           WeightedCapacity = 123.0,
#'           Priority = 123.0,
#'           Placement = list(
#'             GroupName = "string"
#'           )
#'         )
#'       ),
#'       Lifecycle = "spot"|"on-demand",
#'       InstanceIds = list(
#'         "string"
#'       ),
#'       InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'       Platform = "Windows"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_fleet(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   SpotOptions = list(
#'     AllocationStrategy = "lowest-price"|"diversified"|"capacity-optimized",
#'     MaintenanceStrategies = list(
#'       CapacityRebalance = list(
#'         ReplacementStrategy = "launch"
#'       )
#'     ),
#'     InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate",
#'     InstancePoolsToUseCount = 123,
#'     SingleInstanceType = TRUE|FALSE,
#'     SingleAvailabilityZone = TRUE|FALSE,
#'     MinTargetCapacity = 123,
#'     MaxTotalPrice = "string"
#'   ),
#'   OnDemandOptions = list(
#'     AllocationStrategy = "lowest-price"|"prioritized",
#'     CapacityReservationOptions = list(
#'       UsageStrategy = "use-capacity-reservations-first"
#'     ),
#'     SingleInstanceType = TRUE|FALSE,
#'     SingleAvailabilityZone = TRUE|FALSE,
#'     MinTargetCapacity = 123,
#'     MaxTotalPrice = "string"
#'   ),
#'   ExcessCapacityTerminationPolicy = "no-termination"|"termination",
#'   LaunchTemplateConfigs = list(
#'     list(
#'       LaunchTemplateSpecification = list(
#'         LaunchTemplateId = "string",
#'         LaunchTemplateName = "string",
#'         Version = "string"
#'       ),
#'       Overrides = list(
#'         list(
#'           InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'           MaxPrice = "string",
#'           SubnetId = "string",
#'           AvailabilityZone = "string",
#'           WeightedCapacity = 123.0,
#'           Priority = 123.0,
#'           Placement = list(
#'             AvailabilityZone = "string",
#'             Affinity = "string",
#'             GroupName = "string",
#'             PartitionNumber = 123,
#'             HostId = "string",
#'             Tenancy = "default"|"dedicated"|"host",
#'             SpreadDomain = "string",
#'             HostResourceGroupArn = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   TargetCapacitySpecification = list(
#'     TotalTargetCapacity = 123,
#'     OnDemandTargetCapacity = 123,
#'     SpotTargetCapacity = 123,
#'     DefaultTargetCapacityType = "spot"|"on-demand"
#'   ),
#'   TerminateInstancesWithExpiration = TRUE|FALSE,
#'   Type = "request"|"maintain"|"instant",
#'   ValidFrom = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ValidUntil = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ReplaceUnhealthyInstances = TRUE|FALSE,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_fleet
ec2_create_fleet <- function(DryRun = NULL, ClientToken = NULL, SpotOptions = NULL, OnDemandOptions = NULL, ExcessCapacityTerminationPolicy = NULL, LaunchTemplateConfigs, TargetCapacitySpecification, TerminateInstancesWithExpiration = NULL, Type = NULL, ValidFrom = NULL, ValidUntil = NULL, ReplaceUnhealthyInstances = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_fleet_input(DryRun = DryRun, ClientToken = ClientToken, SpotOptions = SpotOptions, OnDemandOptions = OnDemandOptions, ExcessCapacityTerminationPolicy = ExcessCapacityTerminationPolicy, LaunchTemplateConfigs = LaunchTemplateConfigs, TargetCapacitySpecification = TargetCapacitySpecification, TerminateInstancesWithExpiration = TerminateInstancesWithExpiration, Type = Type, ValidFrom = ValidFrom, ValidUntil = ValidUntil, ReplaceUnhealthyInstances = ReplaceUnhealthyInstances, TagSpecifications = TagSpecifications)
  output <- .ec2$create_fleet_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_fleet <- ec2_create_fleet

#' Creates one or more flow logs to capture information about IP traffic
#' for a specific network interface, subnet, or VPC
#'
#' @description
#' Creates one or more flow logs to capture information about IP traffic
#' for a specific network interface, subnet, or VPC.
#' 
#' Flow log data for a monitored network interface is recorded as flow log
#' records, which are log events consisting of fields that describe the
#' traffic flow. For more information, see [Flow Log
#' Records](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' When publishing to CloudWatch Logs, flow log records are published to a
#' log group, and each network interface has a unique log stream in the log
#' group. When publishing to Amazon S3, flow log records for all of the
#' monitored network interfaces are published to a single log file object
#' that is stored in the specified bucket.
#' 
#' For more information, see [VPC Flow
#' Logs](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_flow_logs(DryRun, ClientToken, DeliverLogsPermissionArn,
#'   LogGroupName, ResourceIds, ResourceType, TrafficType,
#'   LogDestinationType, LogDestination, LogFormat, TagSpecifications,
#'   MaxAggregationInterval)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param DeliverLogsPermissionArn The ARN for the IAM role that permits Amazon EC2 to publish flow logs to
#' a CloudWatch Logs log group in your account.
#' 
#' If you specify `LogDestinationType` as `s3`, do not specify
#' `DeliverLogsPermissionArn` or `LogGroupName`.
#' @param LogGroupName The name of a new or existing CloudWatch Logs log group where Amazon EC2
#' publishes your flow logs.
#' 
#' If you specify `LogDestinationType` as `s3`, do not specify
#' `DeliverLogsPermissionArn` or `LogGroupName`.
#' @param ResourceIds &#91;required&#93; The ID of the subnet, network interface, or VPC for which you want to
#' create a flow log.
#' 
#' Constraints: Maximum of 1000 resources
#' @param ResourceType &#91;required&#93; The type of resource for which to create the flow log. For example, if
#' you specified a VPC ID for the `ResourceId` property, specify `VPC` for
#' this property.
#' @param TrafficType &#91;required&#93; The type of traffic to log. You can log traffic that the resource
#' accepts or rejects, or all traffic.
#' @param LogDestinationType Specifies the type of destination to which the flow log data is to be
#' published. Flow log data can be published to CloudWatch Logs or Amazon
#' S3. To publish flow log data to CloudWatch Logs, specify
#' `cloud-watch-logs`. To publish flow log data to Amazon S3, specify `s3`.
#' 
#' If you specify `LogDestinationType` as `s3`, do not specify
#' `DeliverLogsPermissionArn` or `LogGroupName`.
#' 
#' Default: `cloud-watch-logs`
#' @param LogDestination Specifies the destination to which the flow log data is to be published.
#' Flow log data can be published to a CloudWatch Logs log group or an
#' Amazon S3 bucket. The value specified for this parameter depends on the
#' value specified for `LogDestinationType`.
#' 
#' If `LogDestinationType` is not specified or `cloud-watch-logs`, specify
#' the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For
#' example, to publish to a log group called `my-logs`, specify
#' `arn:aws:logs:us-east-1:123456789012:log-group:my-logs`. Alternatively,
#' use `LogGroupName` instead.
#' 
#' If LogDestinationType is `s3`, specify the ARN of the Amazon S3 bucket.
#' You can also specify a subfolder in the bucket. To specify a subfolder
#' in the bucket, use the following ARN format:
#' `bucket_ARN/subfolder_name/`. For example, to specify a subfolder named
#' `my-logs` in a bucket named `my-bucket`, use the following ARN:
#' `arn:aws:s3:::my-bucket/my-logs/`. You cannot use `AWSLogs` as a
#' subfolder name. This is a reserved term.
#' @param LogFormat The fields to include in the flow log record, in the order in which they
#' should appear. For a list of available fields, see [Flow Log
#' Records](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records).
#' If you omit this parameter, the flow log is created using the default
#' format. If you specify this parameter, you must specify at least one
#' field.
#' 
#' Specify the fields using the `${field-id}` format, separated by spaces.
#' For the AWS CLI, use single quotation marks (' ') to surround the
#' parameter value.
#' @param TagSpecifications The tags to apply to the flow logs.
#' @param MaxAggregationInterval The maximum interval of time during which a flow of packets is captured
#' and aggregated into a flow log record. You can specify 60 seconds (1
#' minute) or 600 seconds (10 minutes).
#' 
#' When a network interface is attached to a [Nitro-based
#' instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances),
#' the aggregation interval is always 60 seconds or less, regardless of the
#' value that you specify.
#' 
#' Default: 600
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ClientToken = "string",
#'   FlowLogIds = list(
#'     "string"
#'   ),
#'   Unsuccessful = list(
#'     list(
#'       Error = list(
#'         Code = "string",
#'         Message = "string"
#'       ),
#'       ResourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_flow_logs(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   DeliverLogsPermissionArn = "string",
#'   LogGroupName = "string",
#'   ResourceIds = list(
#'     "string"
#'   ),
#'   ResourceType = "VPC"|"Subnet"|"NetworkInterface",
#'   TrafficType = "ACCEPT"|"REJECT"|"ALL",
#'   LogDestinationType = "cloud-watch-logs"|"s3",
#'   LogDestination = "string",
#'   LogFormat = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   MaxAggregationInterval = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_flow_logs
ec2_create_flow_logs <- function(DryRun = NULL, ClientToken = NULL, DeliverLogsPermissionArn = NULL, LogGroupName = NULL, ResourceIds, ResourceType, TrafficType, LogDestinationType = NULL, LogDestination = NULL, LogFormat = NULL, TagSpecifications = NULL, MaxAggregationInterval = NULL) {
  op <- new_operation(
    name = "CreateFlowLogs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_flow_logs_input(DryRun = DryRun, ClientToken = ClientToken, DeliverLogsPermissionArn = DeliverLogsPermissionArn, LogGroupName = LogGroupName, ResourceIds = ResourceIds, ResourceType = ResourceType, TrafficType = TrafficType, LogDestinationType = LogDestinationType, LogDestination = LogDestination, LogFormat = LogFormat, TagSpecifications = TagSpecifications, MaxAggregationInterval = MaxAggregationInterval)
  output <- .ec2$create_flow_logs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_flow_logs <- ec2_create_flow_logs

#' Creates an Amazon FPGA Image (AFI) from the specified design checkpoint
#' (DCP)
#'
#' @description
#' Creates an Amazon FPGA Image (AFI) from the specified design checkpoint
#' (DCP).
#' 
#' The create operation is asynchronous. To verify that the AFI is ready
#' for use, check the output logs.
#' 
#' An AFI contains the FPGA bitstream that is ready to download to an FPGA.
#' You can securely deploy an AFI on multiple FPGA-accelerated instances.
#' For more information, see the [AWS FPGA Hardware Development
#' Kit](https://github.com/aws/aws-fpga/).
#'
#' @usage
#' ec2_create_fpga_image(DryRun, InputStorageLocation, LogsStorageLocation,
#'   Description, Name, ClientToken, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InputStorageLocation &#91;required&#93; The location of the encrypted design checkpoint in Amazon S3. The input
#' must be a tarball.
#' @param LogsStorageLocation The location in Amazon S3 for the output logs.
#' @param Description A description for the AFI.
#' @param Name A name for the AFI.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param TagSpecifications The tags to apply to the FPGA image during creation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FpgaImageId = "string",
#'   FpgaImageGlobalId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_fpga_image(
#'   DryRun = TRUE|FALSE,
#'   InputStorageLocation = list(
#'     Bucket = "string",
#'     Key = "string"
#'   ),
#'   LogsStorageLocation = list(
#'     Bucket = "string",
#'     Key = "string"
#'   ),
#'   Description = "string",
#'   Name = "string",
#'   ClientToken = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_fpga_image
ec2_create_fpga_image <- function(DryRun = NULL, InputStorageLocation, LogsStorageLocation = NULL, Description = NULL, Name = NULL, ClientToken = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateFpgaImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_fpga_image_input(DryRun = DryRun, InputStorageLocation = InputStorageLocation, LogsStorageLocation = LogsStorageLocation, Description = Description, Name = Name, ClientToken = ClientToken, TagSpecifications = TagSpecifications)
  output <- .ec2$create_fpga_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_fpga_image <- ec2_create_fpga_image

#' Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
#' is either running or stopped
#'
#' @description
#' Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
#' is either running or stopped.
#' 
#' If you customized your instance with instance store volumes or EBS
#' volumes in addition to the root device volume, the new AMI contains
#' block device mapping information for those volumes. When you launch an
#' instance from this new AMI, the instance automatically launches with
#' those additional volumes.
#' 
#' For more information, see [Creating Amazon EBS-Backed Linux
#' AMIs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_image(BlockDeviceMappings, Description, DryRun, InstanceId,
#'   Name, NoReboot, TagSpecifications)
#'
#' @param BlockDeviceMappings The block device mappings. This parameter cannot be used to modify the
#' encryption status of existing volumes or snapshots. To create an AMI
#' with encrypted snapshots, use the [`copy_image`][ec2_copy_image] action.
#' @param Description A description for the new image.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param Name &#91;required&#93; A name for the new image.
#' 
#' Constraints: 3-128 alphanumeric characters, parentheses (()), square
#' brackets (\[\]), spaces ( ), periods (.), slashes (/), dashes (-),
#' single quotes ('), at-signs (@@), or underscores(_)
#' @param NoReboot By default, Amazon EC2 attempts to shut down and reboot the instance
#' before creating the image. If the `No Reboot` option is set, Amazon EC2
#' doesn't shut down the instance before creating the image. When this
#' option is used, file system integrity on the created image can't be
#' guaranteed.
#' @param TagSpecifications The tags to apply to the AMI and snapshots on creation. You can tag the
#' AMI, the snapshots, or both.
#' 
#' -   To tag the AMI, the value for `ResourceType` must be `image`.
#' 
#' -   To tag the snapshots that are created of the root volume and of
#'     other EBS volumes that are attached to the instance, the value for
#'     `ResourceType` must be `snapshot`. The same tag is applied to all of
#'     the snapshots that are created.
#' 
#' If you specify other values for `ResourceType`, the request fails.
#' 
#' To tag an AMI or snapshot after it has been created, see
#' [`create_tags`][ec2_create_tags].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_image(
#'   BlockDeviceMappings = list(
#'     list(
#'       DeviceName = "string",
#'       VirtualName = "string",
#'       Ebs = list(
#'         DeleteOnTermination = TRUE|FALSE,
#'         Iops = 123,
#'         SnapshotId = "string",
#'         VolumeSize = 123,
#'         VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
#'         KmsKeyId = "string",
#'         Throughput = 123,
#'         Encrypted = TRUE|FALSE
#'       ),
#'       NoDevice = "string"
#'     )
#'   ),
#'   Description = "string",
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string",
#'   Name = "string",
#'   NoReboot = TRUE|FALSE,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates an AMI from the specified instance and adds an EBS
#' # volume with the device name /dev/sdh and an instance store volume with
#' # the device name /dev/sdc.
#' svc$create_image(
#'   BlockDeviceMappings = list(
#'     list(
#'       DeviceName = "/dev/sdh",
#'       Ebs = list(
#'         VolumeSize = "100"
#'       )
#'     ),
#'     list(
#'       DeviceName = "/dev/sdc",
#'       VirtualName = "ephemeral1"
#'     )
#'   ),
#'   Description = "An AMI for my server",
#'   InstanceId = "i-1234567890abcdef0",
#'   Name = "My server",
#'   NoReboot = TRUE
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_image
ec2_create_image <- function(BlockDeviceMappings = NULL, Description = NULL, DryRun = NULL, InstanceId, Name, NoReboot = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_image_input(BlockDeviceMappings = BlockDeviceMappings, Description = Description, DryRun = DryRun, InstanceId = InstanceId, Name = Name, NoReboot = NoReboot, TagSpecifications = TagSpecifications)
  output <- .ec2$create_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_image <- ec2_create_image

#' Exports a running or stopped instance to an Amazon S3 bucket
#'
#' @description
#' Exports a running or stopped instance to an Amazon S3 bucket.
#' 
#' For information about the supported operating systems, image formats,
#' and known limitations for the types of instances you can export, see
#' [Exporting an Instance as a VM Using VM
#' Import/Export](https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html)
#' in the *VM Import/Export User Guide*.
#'
#' @usage
#' ec2_create_instance_export_task(Description, ExportToS3Task, InstanceId,
#'   TargetEnvironment, TagSpecifications)
#'
#' @param Description A description for the conversion task or the resource being exported.
#' The maximum length is 255 characters.
#' @param ExportToS3Task &#91;required&#93; The format and location for an instance export task.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param TargetEnvironment &#91;required&#93; The target virtualization environment.
#' @param TagSpecifications The tags to apply to the instance export task during creation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ExportTask = list(
#'     Description = "string",
#'     ExportTaskId = "string",
#'     ExportToS3Task = list(
#'       ContainerFormat = "ova",
#'       DiskImageFormat = "VMDK"|"RAW"|"VHD",
#'       S3Bucket = "string",
#'       S3Key = "string"
#'     ),
#'     InstanceExportDetails = list(
#'       InstanceId = "string",
#'       TargetEnvironment = "citrix"|"vmware"|"microsoft"
#'     ),
#'     State = "active"|"cancelling"|"cancelled"|"completed",
#'     StatusMessage = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_instance_export_task(
#'   Description = "string",
#'   ExportToS3Task = list(
#'     ContainerFormat = "ova",
#'     DiskImageFormat = "VMDK"|"RAW"|"VHD",
#'     S3Bucket = "string",
#'     S3Prefix = "string"
#'   ),
#'   InstanceId = "string",
#'   TargetEnvironment = "citrix"|"vmware"|"microsoft",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_instance_export_task
ec2_create_instance_export_task <- function(Description = NULL, ExportToS3Task, InstanceId, TargetEnvironment, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateInstanceExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_instance_export_task_input(Description = Description, ExportToS3Task = ExportToS3Task, InstanceId = InstanceId, TargetEnvironment = TargetEnvironment, TagSpecifications = TagSpecifications)
  output <- .ec2$create_instance_export_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_instance_export_task <- ec2_create_instance_export_task

#' Creates an internet gateway for use with a VPC
#'
#' @description
#' Creates an internet gateway for use with a VPC. After creating the
#' internet gateway, you attach it to a VPC using
#' [`attach_internet_gateway`][ec2_attach_internet_gateway].
#' 
#' For more information about your VPC and internet gateway, see the
#' [Amazon Virtual Private Cloud User
#' Guide](https://docs.aws.amazon.com/vpc/latest/userguide/).
#'
#' @usage
#' ec2_create_internet_gateway(TagSpecifications, DryRun)
#'
#' @param TagSpecifications The tags to assign to the internet gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InternetGateway = list(
#'     Attachments = list(
#'       list(
#'         State = "attaching"|"attached"|"detaching"|"detached",
#'         VpcId = "string"
#'       )
#'     ),
#'     InternetGatewayId = "string",
#'     OwnerId = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_internet_gateway(
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates an Internet gateway.
#' svc$create_internet_gateway()
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_internet_gateway
ec2_create_internet_gateway <- function(TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_internet_gateway_input(TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_internet_gateway <- ec2_create_internet_gateway

#' Creates a 2048-bit RSA key pair with the specified name
#'
#' @description
#' Creates a 2048-bit RSA key pair with the specified name. Amazon EC2
#' stores the public key and displays the private key for you to save to a
#' file. The private key is returned as an unencrypted PEM encoded PKCS#1
#' private key. If a key with the specified name already exists, Amazon EC2
#' returns an error.
#' 
#' You can have up to five thousand key pairs per Region.
#' 
#' The key pair returned to you is available only in the Region in which
#' you create it. If you prefer, you can create your own key pair using a
#' third-party tool and upload it to any Region using
#' [`import_key_pair`][ec2_import_key_pair].
#' 
#' For more information, see [Key
#' Pairs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_key_pair(KeyName, DryRun, TagSpecifications)
#'
#' @param KeyName &#91;required&#93; A unique name for the key pair.
#' 
#' Constraints: Up to 255 ASCII characters
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param TagSpecifications The tags to apply to the new key pair.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   KeyFingerprint = "string",
#'   KeyMaterial = "string",
#'   KeyName = "string",
#'   KeyPairId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_key_pair(
#'   KeyName = "string",
#'   DryRun = TRUE|FALSE,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a key pair named my-key-pair.
#' svc$create_key_pair(
#'   KeyName = "my-key-pair"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_key_pair
ec2_create_key_pair <- function(KeyName, DryRun = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_key_pair_input(KeyName = KeyName, DryRun = DryRun, TagSpecifications = TagSpecifications)
  output <- .ec2$create_key_pair_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_key_pair <- ec2_create_key_pair

#' Creates a launch template
#'
#' @description
#' Creates a launch template. A launch template contains the parameters to
#' launch an instance. When you launch an instance using
#' [`run_instances`][ec2_run_instances], you can specify a launch template
#' instead of providing the launch parameters in the request. For more
#' information, see [Launching an instance from a launch
#' template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html)in
#' the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_launch_template(DryRun, ClientToken, LaunchTemplateName,
#'   VersionDescription, LaunchTemplateData, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' 
#' Constraint: Maximum 128 ASCII characters.
#' @param LaunchTemplateName &#91;required&#93; A name for the launch template.
#' @param VersionDescription A description for the first version of the launch template.
#' @param LaunchTemplateData &#91;required&#93; The information for the launch template.
#' @param TagSpecifications The tags to apply to the launch template during creation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LaunchTemplate = list(
#'     LaunchTemplateId = "string",
#'     LaunchTemplateName = "string",
#'     CreateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CreatedBy = "string",
#'     DefaultVersionNumber = 123,
#'     LatestVersionNumber = 123,
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   Warning = list(
#'     Errors = list(
#'       list(
#'         Code = "string",
#'         Message = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_launch_template(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   LaunchTemplateName = "string",
#'   VersionDescription = "string",
#'   LaunchTemplateData = list(
#'     KernelId = "string",
#'     EbsOptimized = TRUE|FALSE,
#'     IamInstanceProfile = list(
#'       Arn = "string",
#'       Name = "string"
#'     ),
#'     BlockDeviceMappings = list(
#'       list(
#'         DeviceName = "string",
#'         VirtualName = "string",
#'         Ebs = list(
#'           Encrypted = TRUE|FALSE,
#'           DeleteOnTermination = TRUE|FALSE,
#'           Iops = 123,
#'           KmsKeyId = "string",
#'           SnapshotId = "string",
#'           VolumeSize = 123,
#'           VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
#'           Throughput = 123
#'         ),
#'         NoDevice = "string"
#'       )
#'     ),
#'     NetworkInterfaces = list(
#'       list(
#'         AssociateCarrierIpAddress = TRUE|FALSE,
#'         AssociatePublicIpAddress = TRUE|FALSE,
#'         DeleteOnTermination = TRUE|FALSE,
#'         Description = "string",
#'         DeviceIndex = 123,
#'         Groups = list(
#'           "string"
#'         ),
#'         InterfaceType = "string",
#'         Ipv6AddressCount = 123,
#'         Ipv6Addresses = list(
#'           list(
#'             Ipv6Address = "string"
#'           )
#'         ),
#'         NetworkInterfaceId = "string",
#'         PrivateIpAddress = "string",
#'         PrivateIpAddresses = list(
#'           list(
#'             Primary = TRUE|FALSE,
#'             PrivateIpAddress = "string"
#'           )
#'         ),
#'         SecondaryPrivateIpAddressCount = 123,
#'         SubnetId = "string",
#'         NetworkCardIndex = 123
#'       )
#'     ),
#'     ImageId = "string",
#'     InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'     KeyName = "string",
#'     Monitoring = list(
#'       Enabled = TRUE|FALSE
#'     ),
#'     Placement = list(
#'       AvailabilityZone = "string",
#'       Affinity = "string",
#'       GroupName = "string",
#'       HostId = "string",
#'       Tenancy = "default"|"dedicated"|"host",
#'       SpreadDomain = "string",
#'       HostResourceGroupArn = "string",
#'       PartitionNumber = 123
#'     ),
#'     RamDiskId = "string",
#'     DisableApiTermination = TRUE|FALSE,
#'     InstanceInitiatedShutdownBehavior = "stop"|"terminate",
#'     UserData = "string",
#'     TagSpecifications = list(
#'       list(
#'         ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'         Tags = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         )
#'       )
#'     ),
#'     ElasticGpuSpecifications = list(
#'       list(
#'         Type = "string"
#'       )
#'     ),
#'     ElasticInferenceAccelerators = list(
#'       list(
#'         Type = "string",
#'         Count = 123
#'       )
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     InstanceMarketOptions = list(
#'       MarketType = "spot",
#'       SpotOptions = list(
#'         MaxPrice = "string",
#'         SpotInstanceType = "one-time"|"persistent",
#'         BlockDurationMinutes = 123,
#'         ValidUntil = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate"
#'       )
#'     ),
#'     CreditSpecification = list(
#'       CpuCredits = "string"
#'     ),
#'     CpuOptions = list(
#'       CoreCount = 123,
#'       ThreadsPerCore = 123
#'     ),
#'     CapacityReservationSpecification = list(
#'       CapacityReservationPreference = "open"|"none",
#'       CapacityReservationTarget = list(
#'         CapacityReservationId = "string",
#'         CapacityReservationResourceGroupArn = "string"
#'       )
#'     ),
#'     LicenseSpecifications = list(
#'       list(
#'         LicenseConfigurationArn = "string"
#'       )
#'     ),
#'     HibernationOptions = list(
#'       Configured = TRUE|FALSE
#'     ),
#'     MetadataOptions = list(
#'       HttpTokens = "optional"|"required",
#'       HttpPutResponseHopLimit = 123,
#'       HttpEndpoint = "disabled"|"enabled"
#'     ),
#'     EnclaveOptions = list(
#'       Enabled = TRUE|FALSE
#'     )
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a launch template that specifies the subnet in
#' # which to launch the instance, assigns a public IP address and an IPv6
#' # address to the instance, and creates a tag for the instance.
#' svc$create_launch_template(
#'   LaunchTemplateData = list(
#'     ImageId = "ami-8c1be5f6",
#'     InstanceType = "t2.small",
#'     NetworkInterfaces = list(
#'       list(
#'         AssociatePublicIpAddress = TRUE,
#'         DeviceIndex = 0L,
#'         Ipv6AddressCount = 1L,
#'         SubnetId = "subnet-7b16de0c"
#'       )
#'     ),
#'     TagSpecifications = list(
#'       list(
#'         ResourceType = "instance",
#'         Tags = list(
#'           list(
#'             Key = "Name",
#'             Value = "webserver"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   LaunchTemplateName = "my-template",
#'   VersionDescription = "WebVersion1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_launch_template
ec2_create_launch_template <- function(DryRun = NULL, ClientToken = NULL, LaunchTemplateName, VersionDescription = NULL, LaunchTemplateData, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateLaunchTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_launch_template_input(DryRun = DryRun, ClientToken = ClientToken, LaunchTemplateName = LaunchTemplateName, VersionDescription = VersionDescription, LaunchTemplateData = LaunchTemplateData, TagSpecifications = TagSpecifications)
  output <- .ec2$create_launch_template_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_launch_template <- ec2_create_launch_template

#' Creates a new version for a launch template
#'
#' @description
#' Creates a new version for a launch template. You can specify an existing
#' version of launch template from which to base the new version.
#' 
#' Launch template versions are numbered in the order in which they are
#' created. You cannot specify, change, or replace the numbering of launch
#' template versions.
#' 
#' For more information, see [Managing launch template
#' versions](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions)in
#' the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_launch_template_version(DryRun, ClientToken,
#'   LaunchTemplateId, LaunchTemplateName, SourceVersion, VersionDescription,
#'   LaunchTemplateData)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' 
#' Constraint: Maximum 128 ASCII characters.
#' @param LaunchTemplateId The ID of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param LaunchTemplateName The name of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param SourceVersion The version number of the launch template version on which to base the
#' new version. The new version inherits the same launch parameters as the
#' source version, except for parameters that you specify in
#' `LaunchTemplateData`. Snapshots applied to the block device mapping are
#' ignored when creating a new version unless they are explicitly included.
#' @param VersionDescription A description for the version of the launch template.
#' @param LaunchTemplateData &#91;required&#93; The information for the launch template.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LaunchTemplateVersion = list(
#'     LaunchTemplateId = "string",
#'     LaunchTemplateName = "string",
#'     VersionNumber = 123,
#'     VersionDescription = "string",
#'     CreateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CreatedBy = "string",
#'     DefaultVersion = TRUE|FALSE,
#'     LaunchTemplateData = list(
#'       KernelId = "string",
#'       EbsOptimized = TRUE|FALSE,
#'       IamInstanceProfile = list(
#'         Arn = "string",
#'         Name = "string"
#'       ),
#'       BlockDeviceMappings = list(
#'         list(
#'           DeviceName = "string",
#'           VirtualName = "string",
#'           Ebs = list(
#'             Encrypted = TRUE|FALSE,
#'             DeleteOnTermination = TRUE|FALSE,
#'             Iops = 123,
#'             KmsKeyId = "string",
#'             SnapshotId = "string",
#'             VolumeSize = 123,
#'             VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
#'             Throughput = 123
#'           ),
#'           NoDevice = "string"
#'         )
#'       ),
#'       NetworkInterfaces = list(
#'         list(
#'           AssociateCarrierIpAddress = TRUE|FALSE,
#'           AssociatePublicIpAddress = TRUE|FALSE,
#'           DeleteOnTermination = TRUE|FALSE,
#'           Description = "string",
#'           DeviceIndex = 123,
#'           Groups = list(
#'             "string"
#'           ),
#'           InterfaceType = "string",
#'           Ipv6AddressCount = 123,
#'           Ipv6Addresses = list(
#'             list(
#'               Ipv6Address = "string"
#'             )
#'           ),
#'           NetworkInterfaceId = "string",
#'           PrivateIpAddress = "string",
#'           PrivateIpAddresses = list(
#'             list(
#'               Primary = TRUE|FALSE,
#'               PrivateIpAddress = "string"
#'             )
#'           ),
#'           SecondaryPrivateIpAddressCount = 123,
#'           SubnetId = "string",
#'           NetworkCardIndex = 123
#'         )
#'       ),
#'       ImageId = "string",
#'       InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'       KeyName = "string",
#'       Monitoring = list(
#'         Enabled = TRUE|FALSE
#'       ),
#'       Placement = list(
#'         AvailabilityZone = "string",
#'         Affinity = "string",
#'         GroupName = "string",
#'         HostId = "string",
#'         Tenancy = "default"|"dedicated"|"host",
#'         SpreadDomain = "string",
#'         HostResourceGroupArn = "string",
#'         PartitionNumber = 123
#'       ),
#'       RamDiskId = "string",
#'       DisableApiTermination = TRUE|FALSE,
#'       InstanceInitiatedShutdownBehavior = "stop"|"terminate",
#'       UserData = "string",
#'       TagSpecifications = list(
#'         list(
#'           ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'           Tags = list(
#'             list(
#'               Key = "string",
#'               Value = "string"
#'             )
#'           )
#'         )
#'       ),
#'       ElasticGpuSpecifications = list(
#'         list(
#'           Type = "string"
#'         )
#'       ),
#'       ElasticInferenceAccelerators = list(
#'         list(
#'           Type = "string",
#'           Count = 123
#'         )
#'       ),
#'       SecurityGroupIds = list(
#'         "string"
#'       ),
#'       SecurityGroups = list(
#'         "string"
#'       ),
#'       InstanceMarketOptions = list(
#'         MarketType = "spot",
#'         SpotOptions = list(
#'           MaxPrice = "string",
#'           SpotInstanceType = "one-time"|"persistent",
#'           BlockDurationMinutes = 123,
#'           ValidUntil = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate"
#'         )
#'       ),
#'       CreditSpecification = list(
#'         CpuCredits = "string"
#'       ),
#'       CpuOptions = list(
#'         CoreCount = 123,
#'         ThreadsPerCore = 123
#'       ),
#'       CapacityReservationSpecification = list(
#'         CapacityReservationPreference = "open"|"none",
#'         CapacityReservationTarget = list(
#'           CapacityReservationId = "string",
#'           CapacityReservationResourceGroupArn = "string"
#'         )
#'       ),
#'       LicenseSpecifications = list(
#'         list(
#'           LicenseConfigurationArn = "string"
#'         )
#'       ),
#'       HibernationOptions = list(
#'         Configured = TRUE|FALSE
#'       ),
#'       MetadataOptions = list(
#'         State = "pending"|"applied",
#'         HttpTokens = "optional"|"required",
#'         HttpPutResponseHopLimit = 123,
#'         HttpEndpoint = "disabled"|"enabled"
#'       ),
#'       EnclaveOptions = list(
#'         Enabled = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   Warning = list(
#'     Errors = list(
#'       list(
#'         Code = "string",
#'         Message = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_launch_template_version(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   LaunchTemplateId = "string",
#'   LaunchTemplateName = "string",
#'   SourceVersion = "string",
#'   VersionDescription = "string",
#'   LaunchTemplateData = list(
#'     KernelId = "string",
#'     EbsOptimized = TRUE|FALSE,
#'     IamInstanceProfile = list(
#'       Arn = "string",
#'       Name = "string"
#'     ),
#'     BlockDeviceMappings = list(
#'       list(
#'         DeviceName = "string",
#'         VirtualName = "string",
#'         Ebs = list(
#'           Encrypted = TRUE|FALSE,
#'           DeleteOnTermination = TRUE|FALSE,
#'           Iops = 123,
#'           KmsKeyId = "string",
#'           SnapshotId = "string",
#'           VolumeSize = 123,
#'           VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
#'           Throughput = 123
#'         ),
#'         NoDevice = "string"
#'       )
#'     ),
#'     NetworkInterfaces = list(
#'       list(
#'         AssociateCarrierIpAddress = TRUE|FALSE,
#'         AssociatePublicIpAddress = TRUE|FALSE,
#'         DeleteOnTermination = TRUE|FALSE,
#'         Description = "string",
#'         DeviceIndex = 123,
#'         Groups = list(
#'           "string"
#'         ),
#'         InterfaceType = "string",
#'         Ipv6AddressCount = 123,
#'         Ipv6Addresses = list(
#'           list(
#'             Ipv6Address = "string"
#'           )
#'         ),
#'         NetworkInterfaceId = "string",
#'         PrivateIpAddress = "string",
#'         PrivateIpAddresses = list(
#'           list(
#'             Primary = TRUE|FALSE,
#'             PrivateIpAddress = "string"
#'           )
#'         ),
#'         SecondaryPrivateIpAddressCount = 123,
#'         SubnetId = "string",
#'         NetworkCardIndex = 123
#'       )
#'     ),
#'     ImageId = "string",
#'     InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'     KeyName = "string",
#'     Monitoring = list(
#'       Enabled = TRUE|FALSE
#'     ),
#'     Placement = list(
#'       AvailabilityZone = "string",
#'       Affinity = "string",
#'       GroupName = "string",
#'       HostId = "string",
#'       Tenancy = "default"|"dedicated"|"host",
#'       SpreadDomain = "string",
#'       HostResourceGroupArn = "string",
#'       PartitionNumber = 123
#'     ),
#'     RamDiskId = "string",
#'     DisableApiTermination = TRUE|FALSE,
#'     InstanceInitiatedShutdownBehavior = "stop"|"terminate",
#'     UserData = "string",
#'     TagSpecifications = list(
#'       list(
#'         ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'         Tags = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         )
#'       )
#'     ),
#'     ElasticGpuSpecifications = list(
#'       list(
#'         Type = "string"
#'       )
#'     ),
#'     ElasticInferenceAccelerators = list(
#'       list(
#'         Type = "string",
#'         Count = 123
#'       )
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     InstanceMarketOptions = list(
#'       MarketType = "spot",
#'       SpotOptions = list(
#'         MaxPrice = "string",
#'         SpotInstanceType = "one-time"|"persistent",
#'         BlockDurationMinutes = 123,
#'         ValidUntil = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate"
#'       )
#'     ),
#'     CreditSpecification = list(
#'       CpuCredits = "string"
#'     ),
#'     CpuOptions = list(
#'       CoreCount = 123,
#'       ThreadsPerCore = 123
#'     ),
#'     CapacityReservationSpecification = list(
#'       CapacityReservationPreference = "open"|"none",
#'       CapacityReservationTarget = list(
#'         CapacityReservationId = "string",
#'         CapacityReservationResourceGroupArn = "string"
#'       )
#'     ),
#'     LicenseSpecifications = list(
#'       list(
#'         LicenseConfigurationArn = "string"
#'       )
#'     ),
#'     HibernationOptions = list(
#'       Configured = TRUE|FALSE
#'     ),
#'     MetadataOptions = list(
#'       HttpTokens = "optional"|"required",
#'       HttpPutResponseHopLimit = 123,
#'       HttpEndpoint = "disabled"|"enabled"
#'     ),
#'     EnclaveOptions = list(
#'       Enabled = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a new launch template version based on version 1 of
#' # the specified launch template and specifies a different AMI ID.
#' svc$create_launch_template_version(
#'   LaunchTemplateData = list(
#'     ImageId = "ami-c998b6b2"
#'   ),
#'   LaunchTemplateId = "lt-0abcd290751193123",
#'   SourceVersion = "1",
#'   VersionDescription = "WebVersion2"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_launch_template_version
ec2_create_launch_template_version <- function(DryRun = NULL, ClientToken = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, SourceVersion = NULL, VersionDescription = NULL, LaunchTemplateData) {
  op <- new_operation(
    name = "CreateLaunchTemplateVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_launch_template_version_input(DryRun = DryRun, ClientToken = ClientToken, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, SourceVersion = SourceVersion, VersionDescription = VersionDescription, LaunchTemplateData = LaunchTemplateData)
  output <- .ec2$create_launch_template_version_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_launch_template_version <- ec2_create_launch_template_version

#' Creates a static route for the specified local gateway route table
#'
#' @description
#' Creates a static route for the specified local gateway route table.
#'
#' @usage
#' ec2_create_local_gateway_route(DestinationCidrBlock,
#'   LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId, DryRun)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range used for destination matches. Routing decisions are based
#' on the most specific match.
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param LocalGatewayVirtualInterfaceGroupId &#91;required&#93; The ID of the virtual interface group.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Route = list(
#'     DestinationCidrBlock = "string",
#'     LocalGatewayVirtualInterfaceGroupId = "string",
#'     Type = "static"|"propagated",
#'     State = "pending"|"active"|"blackhole"|"deleting"|"deleted",
#'     LocalGatewayRouteTableId = "string",
#'     LocalGatewayRouteTableArn = "string",
#'     OwnerId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_local_gateway_route(
#'   DestinationCidrBlock = "string",
#'   LocalGatewayRouteTableId = "string",
#'   LocalGatewayVirtualInterfaceGroupId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_local_gateway_route
ec2_create_local_gateway_route <- function(DestinationCidrBlock, LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId, DryRun = NULL) {
  op <- new_operation(
    name = "CreateLocalGatewayRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_local_gateway_route_input(DestinationCidrBlock = DestinationCidrBlock, LocalGatewayRouteTableId = LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId = LocalGatewayVirtualInterfaceGroupId, DryRun = DryRun)
  output <- .ec2$create_local_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_local_gateway_route <- ec2_create_local_gateway_route

#' Associates the specified VPC with the specified local gateway route
#' table
#'
#' @description
#' Associates the specified VPC with the specified local gateway route
#' table.
#'
#' @usage
#' ec2_create_local_gateway_route_table_vpc_association(
#'   LocalGatewayRouteTableId, VpcId, TagSpecifications, DryRun)
#'
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param TagSpecifications The tags to assign to the local gateway route table VPC association.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LocalGatewayRouteTableVpcAssociation = list(
#'     LocalGatewayRouteTableVpcAssociationId = "string",
#'     LocalGatewayRouteTableId = "string",
#'     LocalGatewayRouteTableArn = "string",
#'     LocalGatewayId = "string",
#'     VpcId = "string",
#'     OwnerId = "string",
#'     State = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_local_gateway_route_table_vpc_association(
#'   LocalGatewayRouteTableId = "string",
#'   VpcId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_local_gateway_route_table_vpc_association
ec2_create_local_gateway_route_table_vpc_association <- function(LocalGatewayRouteTableId, VpcId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateLocalGatewayRouteTableVpcAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_local_gateway_route_table_vpc_association_input(LocalGatewayRouteTableId = LocalGatewayRouteTableId, VpcId = VpcId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_local_gateway_route_table_vpc_association_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_local_gateway_route_table_vpc_association <- ec2_create_local_gateway_route_table_vpc_association

#' Creates a managed prefix list
#'
#' @description
#' Creates a managed prefix list. You can specify one or more entries for
#' the prefix list. Each entry consists of a CIDR block and an optional
#' description.
#' 
#' You must specify the maximum number of entries for the prefix list. The
#' maximum number of entries cannot be changed later.
#'
#' @usage
#' ec2_create_managed_prefix_list(DryRun, PrefixListName, Entries,
#'   MaxEntries, TagSpecifications, AddressFamily, ClientToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param PrefixListName &#91;required&#93; A name for the prefix list.
#' 
#' Constraints: Up to 255 characters in length. The name cannot start with
#' `com.amazonaws`.
#' @param Entries One or more entries for the prefix list.
#' @param MaxEntries &#91;required&#93; The maximum number of entries for the prefix list.
#' @param TagSpecifications The tags to apply to the prefix list during creation.
#' @param AddressFamily &#91;required&#93; The IP address type.
#' 
#' Valid Values: `IPv4` | `IPv6`
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' 
#' Constraints: Up to 255 UTF-8 characters in length.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PrefixList = list(
#'     PrefixListId = "string",
#'     AddressFamily = "string",
#'     State = "create-in-progress"|"create-complete"|"create-failed"|"modify-in-progress"|"modify-complete"|"modify-failed"|"restore-in-progress"|"restore-complete"|"restore-failed"|"delete-in-progress"|"delete-complete"|"delete-failed",
#'     StateMessage = "string",
#'     PrefixListArn = "string",
#'     PrefixListName = "string",
#'     MaxEntries = 123,
#'     Version = 123,
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     OwnerId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_managed_prefix_list(
#'   DryRun = TRUE|FALSE,
#'   PrefixListName = "string",
#'   Entries = list(
#'     list(
#'       Cidr = "string",
#'       Description = "string"
#'     )
#'   ),
#'   MaxEntries = 123,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   AddressFamily = "string",
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_managed_prefix_list
ec2_create_managed_prefix_list <- function(DryRun = NULL, PrefixListName, Entries = NULL, MaxEntries, TagSpecifications = NULL, AddressFamily, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateManagedPrefixList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_managed_prefix_list_input(DryRun = DryRun, PrefixListName = PrefixListName, Entries = Entries, MaxEntries = MaxEntries, TagSpecifications = TagSpecifications, AddressFamily = AddressFamily, ClientToken = ClientToken)
  output <- .ec2$create_managed_prefix_list_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_managed_prefix_list <- ec2_create_managed_prefix_list

#' Creates a NAT gateway in the specified public subnet
#'
#' @description
#' Creates a NAT gateway in the specified public subnet. This action
#' creates a network interface in the specified subnet with a private IP
#' address from the IP address range of the subnet. Internet-bound traffic
#' from a private subnet can be routed to the NAT gateway, therefore
#' enabling instances in the private subnet to connect to the internet. For
#' more information, see [NAT
#' Gateways](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_nat_gateway(AllocationId, ClientToken, DryRun, SubnetId,
#'   TagSpecifications)
#'
#' @param AllocationId &#91;required&#93; The allocation ID of an Elastic IP address to associate with the NAT
#' gateway. If the Elastic IP address is associated with another resource,
#' you must first disassociate it.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' 
#' Constraint: Maximum 64 ASCII characters.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SubnetId &#91;required&#93; The subnet in which to create the NAT gateway.
#' @param TagSpecifications The tags to assign to the NAT gateway.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ClientToken = "string",
#'   NatGateway = list(
#'     CreateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DeleteTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     FailureCode = "string",
#'     FailureMessage = "string",
#'     NatGatewayAddresses = list(
#'       list(
#'         AllocationId = "string",
#'         NetworkInterfaceId = "string",
#'         PrivateIp = "string",
#'         PublicIp = "string"
#'       )
#'     ),
#'     NatGatewayId = "string",
#'     ProvisionedBandwidth = list(
#'       ProvisionTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Provisioned = "string",
#'       RequestTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Requested = "string",
#'       Status = "string"
#'     ),
#'     State = "pending"|"failed"|"available"|"deleting"|"deleted",
#'     SubnetId = "string",
#'     VpcId = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_nat_gateway(
#'   AllocationId = "string",
#'   ClientToken = "string",
#'   DryRun = TRUE|FALSE,
#'   SubnetId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a NAT gateway in subnet subnet-1a2b3c4d and
#' # associates an Elastic IP address with the allocation ID
#' # eipalloc-37fc1a52 with the NAT gateway.
#' svc$create_nat_gateway(
#'   AllocationId = "eipalloc-37fc1a52",
#'   SubnetId = "subnet-1a2b3c4d"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_nat_gateway
ec2_create_nat_gateway <- function(AllocationId, ClientToken = NULL, DryRun = NULL, SubnetId, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateNatGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_nat_gateway_input(AllocationId = AllocationId, ClientToken = ClientToken, DryRun = DryRun, SubnetId = SubnetId, TagSpecifications = TagSpecifications)
  output <- .ec2$create_nat_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_nat_gateway <- ec2_create_nat_gateway

#' Creates a network ACL in a VPC
#'
#' @description
#' Creates a network ACL in a VPC. Network ACLs provide an optional layer
#' of security (in addition to security groups) for the instances in your
#' VPC.
#' 
#' For more information, see [Network
#' ACLs](https://docs.aws.amazon.com/vpc/latest/userguide/) in the *Amazon
#' Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_network_acl(DryRun, VpcId, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param TagSpecifications The tags to assign to the network ACL.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkAcl = list(
#'     Associations = list(
#'       list(
#'         NetworkAclAssociationId = "string",
#'         NetworkAclId = "string",
#'         SubnetId = "string"
#'       )
#'     ),
#'     Entries = list(
#'       list(
#'         CidrBlock = "string",
#'         Egress = TRUE|FALSE,
#'         IcmpTypeCode = list(
#'           Code = 123,
#'           Type = 123
#'         ),
#'         Ipv6CidrBlock = "string",
#'         PortRange = list(
#'           From = 123,
#'           To = 123
#'         ),
#'         Protocol = "string",
#'         RuleAction = "allow"|"deny",
#'         RuleNumber = 123
#'       )
#'     ),
#'     IsDefault = TRUE|FALSE,
#'     NetworkAclId = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     VpcId = "string",
#'     OwnerId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_network_acl(
#'   DryRun = TRUE|FALSE,
#'   VpcId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a network ACL for the specified VPC.
#' svc$create_network_acl(
#'   VpcId = "vpc-a01106c2"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_acl
ec2_create_network_acl <- function(DryRun = NULL, VpcId, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateNetworkAcl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_network_acl_input(DryRun = DryRun, VpcId = VpcId, TagSpecifications = TagSpecifications)
  output <- .ec2$create_network_acl_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_acl <- ec2_create_network_acl

#' Creates an entry (a rule) in a network ACL with the specified rule
#' number
#'
#' @description
#' Creates an entry (a rule) in a network ACL with the specified rule
#' number. Each network ACL has a set of numbered ingress rules and a
#' separate set of numbered egress rules. When determining whether a packet
#' should be allowed in or out of a subnet associated with the ACL, we
#' process the entries in the ACL according to the rule numbers, in
#' ascending order. Each network ACL has a set of ingress rules and a
#' separate set of egress rules.
#' 
#' We recommend that you leave room between the rule numbers (for example,
#' 100, 110, 120, ...), and not number them one right after the other (for
#' example, 101, 102, 103, ...). This makes it easier to add a rule between
#' existing ones without having to renumber the rules.
#' 
#' After you add an entry, you can't modify it; you must either replace it,
#' or create an entry and delete the old one.
#' 
#' For more information about network ACLs, see [Network
#' ACLs](https://docs.aws.amazon.com/vpc/latest/userguide/) in the *Amazon
#' Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_network_acl_entry(CidrBlock, DryRun, Egress, IcmpTypeCode,
#'   Ipv6CidrBlock, NetworkAclId, PortRange, Protocol, RuleAction,
#'   RuleNumber)
#'
#' @param CidrBlock The IPv4 network range to allow or deny, in CIDR notation (for example
#' `172.16.0.0/24`). We modify the specified CIDR block to its canonical
#' form; for example, if you specify `100.68.0.18/18`, we modify it to
#' `100.68.0.0/18`.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Egress &#91;required&#93; Indicates whether this is an egress rule (rule is applied to traffic
#' leaving the subnet).
#' @param IcmpTypeCode ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying
#' protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.
#' @param Ipv6CidrBlock The IPv6 network range to allow or deny, in CIDR notation (for example
#' `2001:db8:1234:1a00::/64`).
#' @param NetworkAclId &#91;required&#93; The ID of the network ACL.
#' @param PortRange TCP or UDP protocols: The range of ports the rule applies to. Required
#' if specifying protocol 6 (TCP) or 17 (UDP).
#' @param Protocol &#91;required&#93; The protocol number. A value of "-1" means all protocols. If you specify
#' "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1"
#' (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP
#' types or codes that you specify. If you specify protocol "58" (ICMPv6)
#' and specify an IPv4 CIDR block, traffic for all ICMP types and codes
#' allowed, regardless of any that you specify. If you specify protocol
#' "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP
#' type and code.
#' @param RuleAction &#91;required&#93; Indicates whether to allow or deny the traffic that matches the rule.
#' @param RuleNumber &#91;required&#93; The rule number for the entry (for example, 100). ACL entries are
#' processed in ascending order by rule number.
#' 
#' Constraints: Positive integer from 1 to 32766. The range 32767 to 65535
#' is reserved for internal use.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_network_acl_entry(
#'   CidrBlock = "string",
#'   DryRun = TRUE|FALSE,
#'   Egress = TRUE|FALSE,
#'   IcmpTypeCode = list(
#'     Code = 123,
#'     Type = 123
#'   ),
#'   Ipv6CidrBlock = "string",
#'   NetworkAclId = "string",
#'   PortRange = list(
#'     From = 123,
#'     To = 123
#'   ),
#'   Protocol = "string",
#'   RuleAction = "allow"|"deny",
#'   RuleNumber = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates an entry for the specified network ACL. The rule
#' # allows ingress traffic from anywhere (0.0.0.0/0) on UDP port 53 (DNS)
#' # into any associated subnet.
#' svc$create_network_acl_entry(
#'   CidrBlock = "0.0.0.0/0",
#'   Egress = FALSE,
#'   NetworkAclId = "acl-5fb85d36",
#'   PortRange = list(
#'     From = 53L,
#'     To = 53L
#'   ),
#'   Protocol = "17",
#'   RuleAction = "allow",
#'   RuleNumber = 100L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_acl_entry
ec2_create_network_acl_entry <- function(CidrBlock = NULL, DryRun = NULL, Egress, IcmpTypeCode = NULL, Ipv6CidrBlock = NULL, NetworkAclId, PortRange = NULL, Protocol, RuleAction, RuleNumber) {
  op <- new_operation(
    name = "CreateNetworkAclEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_network_acl_entry_input(CidrBlock = CidrBlock, DryRun = DryRun, Egress = Egress, IcmpTypeCode = IcmpTypeCode, Ipv6CidrBlock = Ipv6CidrBlock, NetworkAclId = NetworkAclId, PortRange = PortRange, Protocol = Protocol, RuleAction = RuleAction, RuleNumber = RuleNumber)
  output <- .ec2$create_network_acl_entry_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_acl_entry <- ec2_create_network_acl_entry

#' Creates a path to analyze for reachability
#'
#' @description
#' Creates a path to analyze for reachability.
#' 
#' Reachability Analyzer enables you to analyze and debug network
#' reachability between two resources in your virtual private cloud (VPC).
#' For more information, see [What is Reachability
#' Analyzer](https://docs.aws.amazon.com/vpc/latest/reachability/).
#'
#' @usage
#' ec2_create_network_insights_path(SourceIp, DestinationIp, Source,
#'   Destination, Protocol, DestinationPort, TagSpecifications, DryRun,
#'   ClientToken)
#'
#' @param SourceIp The IP address of the AWS resource that is the source of the path.
#' @param DestinationIp The IP address of the AWS resource that is the destination of the path.
#' @param Source &#91;required&#93; The AWS resource that is the source of the path.
#' @param Destination &#91;required&#93; The AWS resource that is the destination of the path.
#' @param Protocol &#91;required&#93; The protocol.
#' @param DestinationPort The destination port.
#' @param TagSpecifications The tags to add to the path.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkInsightsPath = list(
#'     NetworkInsightsPathId = "string",
#'     NetworkInsightsPathArn = "string",
#'     CreatedDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Source = "string",
#'     Destination = "string",
#'     SourceIp = "string",
#'     DestinationIp = "string",
#'     Protocol = "tcp"|"udp",
#'     DestinationPort = 123,
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_network_insights_path(
#'   SourceIp = "string",
#'   DestinationIp = "string",
#'   Source = "string",
#'   Destination = "string",
#'   Protocol = "tcp"|"udp",
#'   DestinationPort = 123,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_insights_path
ec2_create_network_insights_path <- function(SourceIp = NULL, DestinationIp = NULL, Source, Destination, Protocol, DestinationPort = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken) {
  op <- new_operation(
    name = "CreateNetworkInsightsPath",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_network_insights_path_input(SourceIp = SourceIp, DestinationIp = DestinationIp, Source = Source, Destination = Destination, Protocol = Protocol, DestinationPort = DestinationPort, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_network_insights_path_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_insights_path <- ec2_create_network_insights_path

#' Creates a network interface in the specified subnet
#'
#' @description
#' Creates a network interface in the specified subnet.
#' 
#' For more information about network interfaces, see [Elastic Network
#' Interfaces](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_network_interface(Description, DryRun, Groups,
#'   Ipv6AddressCount, Ipv6Addresses, PrivateIpAddress, PrivateIpAddresses,
#'   SecondaryPrivateIpAddressCount, InterfaceType, SubnetId,
#'   TagSpecifications)
#'
#' @param Description A description for the network interface.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Groups The IDs of one or more security groups.
#' @param Ipv6AddressCount The number of IPv6 addresses to assign to a network interface. Amazon
#' EC2 automatically selects the IPv6 addresses from the subnet range. You
#' can't use this option if specifying specific IPv6 addresses. If your
#' subnet has the `AssignIpv6AddressOnCreation` attribute set to `true`,
#' you can specify `0` to override this setting.
#' @param Ipv6Addresses One or more specific IPv6 addresses from the IPv6 CIDR block range of
#' your subnet. You can't use this option if you're specifying a number of
#' IPv6 addresses.
#' @param PrivateIpAddress The primary private IPv4 address of the network interface. If you don't
#' specify an IPv4 address, Amazon EC2 selects one for you from the
#' subnet's IPv4 CIDR range. If you specify an IP address, you cannot
#' indicate any IP addresses specified in `privateIpAddresses` as primary
#' (only one IP address can be designated as primary).
#' @param PrivateIpAddresses One or more private IPv4 addresses.
#' @param SecondaryPrivateIpAddressCount The number of secondary private IPv4 addresses to assign to a network
#' interface. When you specify a number of secondary IPv4 addresses, Amazon
#' EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You
#' can't specify this option and specify more than one private IP address
#' using `privateIpAddresses`.
#' 
#' The number of IP addresses you can assign to a network interface varies
#' by instance type. For more information, see [IP Addresses Per ENI Per
#' Instance
#' Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' @param InterfaceType Indicates the type of network interface. To create an Elastic Fabric
#' Adapter (EFA), specify `efa`. For more information, see [Elastic Fabric
#' Adapter](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param SubnetId &#91;required&#93; The ID of the subnet to associate with the network interface.
#' @param TagSpecifications The tags to apply to the new network interface.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkInterface = list(
#'     Association = list(
#'       AllocationId = "string",
#'       AssociationId = "string",
#'       IpOwnerId = "string",
#'       PublicDnsName = "string",
#'       PublicIp = "string",
#'       CustomerOwnedIp = "string",
#'       CarrierIp = "string"
#'     ),
#'     Attachment = list(
#'       AttachTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       AttachmentId = "string",
#'       DeleteOnTermination = TRUE|FALSE,
#'       DeviceIndex = 123,
#'       NetworkCardIndex = 123,
#'       InstanceId = "string",
#'       InstanceOwnerId = "string",
#'       Status = "attaching"|"attached"|"detaching"|"detached"
#'     ),
#'     AvailabilityZone = "string",
#'     Description = "string",
#'     Groups = list(
#'       list(
#'         GroupName = "string",
#'         GroupId = "string"
#'       )
#'     ),
#'     InterfaceType = "interface"|"natGateway"|"efa",
#'     Ipv6Addresses = list(
#'       list(
#'         Ipv6Address = "string"
#'       )
#'     ),
#'     MacAddress = "string",
#'     NetworkInterfaceId = "string",
#'     OutpostArn = "string",
#'     OwnerId = "string",
#'     PrivateDnsName = "string",
#'     PrivateIpAddress = "string",
#'     PrivateIpAddresses = list(
#'       list(
#'         Association = list(
#'           AllocationId = "string",
#'           AssociationId = "string",
#'           IpOwnerId = "string",
#'           PublicDnsName = "string",
#'           PublicIp = "string",
#'           CustomerOwnedIp = "string",
#'           CarrierIp = "string"
#'         ),
#'         Primary = TRUE|FALSE,
#'         PrivateDnsName = "string",
#'         PrivateIpAddress = "string"
#'       )
#'     ),
#'     RequesterId = "string",
#'     RequesterManaged = TRUE|FALSE,
#'     SourceDestCheck = TRUE|FALSE,
#'     Status = "available"|"associated"|"attaching"|"in-use"|"detaching",
#'     SubnetId = "string",
#'     TagSet = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     VpcId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_network_interface(
#'   Description = "string",
#'   DryRun = TRUE|FALSE,
#'   Groups = list(
#'     "string"
#'   ),
#'   Ipv6AddressCount = 123,
#'   Ipv6Addresses = list(
#'     list(
#'       Ipv6Address = "string"
#'     )
#'   ),
#'   PrivateIpAddress = "string",
#'   PrivateIpAddresses = list(
#'     list(
#'       Primary = TRUE|FALSE,
#'       PrivateIpAddress = "string"
#'     )
#'   ),
#'   SecondaryPrivateIpAddressCount = 123,
#'   InterfaceType = "efa",
#'   SubnetId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a network interface for the specified subnet.
#' svc$create_network_interface(
#'   Description = "my network interface",
#'   Groups = list(
#'     "sg-903004f8"
#'   ),
#'   PrivateIpAddress = "10.0.2.17",
#'   SubnetId = "subnet-9d4a7b6c"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_interface
ec2_create_network_interface <- function(Description = NULL, DryRun = NULL, Groups = NULL, Ipv6AddressCount = NULL, Ipv6Addresses = NULL, PrivateIpAddress = NULL, PrivateIpAddresses = NULL, SecondaryPrivateIpAddressCount = NULL, InterfaceType = NULL, SubnetId, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateNetworkInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_network_interface_input(Description = Description, DryRun = DryRun, Groups = Groups, Ipv6AddressCount = Ipv6AddressCount, Ipv6Addresses = Ipv6Addresses, PrivateIpAddress = PrivateIpAddress, PrivateIpAddresses = PrivateIpAddresses, SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount, InterfaceType = InterfaceType, SubnetId = SubnetId, TagSpecifications = TagSpecifications)
  output <- .ec2$create_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_interface <- ec2_create_network_interface

#' Grants an AWS-authorized account permission to attach the specified
#' network interface to an instance in their account
#'
#' @description
#' Grants an AWS-authorized account permission to attach the specified
#' network interface to an instance in their account.
#' 
#' You can grant permission to a single AWS account only, and only one
#' account at a time.
#'
#' @usage
#' ec2_create_network_interface_permission(NetworkInterfaceId,
#'   AwsAccountId, AwsService, Permission, DryRun)
#'
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param AwsAccountId The AWS account ID.
#' @param AwsService The AWS service. Currently not supported.
#' @param Permission &#91;required&#93; The type of permission to grant.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InterfacePermission = list(
#'     NetworkInterfacePermissionId = "string",
#'     NetworkInterfaceId = "string",
#'     AwsAccountId = "string",
#'     AwsService = "string",
#'     Permission = "INSTANCE-ATTACH"|"EIP-ASSOCIATE",
#'     PermissionState = list(
#'       State = "pending"|"granted"|"revoking"|"revoked",
#'       StatusMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_network_interface_permission(
#'   NetworkInterfaceId = "string",
#'   AwsAccountId = "string",
#'   AwsService = "string",
#'   Permission = "INSTANCE-ATTACH"|"EIP-ASSOCIATE",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_interface_permission
ec2_create_network_interface_permission <- function(NetworkInterfaceId, AwsAccountId = NULL, AwsService = NULL, Permission, DryRun = NULL) {
  op <- new_operation(
    name = "CreateNetworkInterfacePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_network_interface_permission_input(NetworkInterfaceId = NetworkInterfaceId, AwsAccountId = AwsAccountId, AwsService = AwsService, Permission = Permission, DryRun = DryRun)
  output <- .ec2$create_network_interface_permission_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_interface_permission <- ec2_create_network_interface_permission

#' Creates a placement group in which to launch instances
#'
#' @description
#' Creates a placement group in which to launch instances. The strategy of
#' the placement group determines how the instances are organized within
#' the group.
#' 
#' A `cluster` placement group is a logical grouping of instances within a
#' single Availability Zone that benefit from low network latency, high
#' network throughput. A `spread` placement group places instances on
#' distinct hardware. A `partition` placement group places groups of
#' instances in different partitions, where instances in one partition do
#' not share the same hardware with instances in another partition.
#' 
#' For more information, see [Placement
#' groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_placement_group(DryRun, GroupName, Strategy, PartitionCount,
#'   TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupName A name for the placement group. Must be unique within the scope of your
#' account for the Region.
#' 
#' Constraints: Up to 255 ASCII characters
#' @param Strategy The placement strategy.
#' @param PartitionCount The number of partitions. Valid only when **Strategy** is set to
#' `partition`.
#' @param TagSpecifications The tags to apply to the new placement group.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PlacementGroup = list(
#'     GroupName = "string",
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     Strategy = "cluster"|"spread"|"partition",
#'     PartitionCount = 123,
#'     GroupId = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_placement_group(
#'   DryRun = TRUE|FALSE,
#'   GroupName = "string",
#'   Strategy = "cluster"|"spread"|"partition",
#'   PartitionCount = 123,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a placement group with the specified name.
#' svc$create_placement_group(
#'   GroupName = "my-cluster",
#'   Strategy = "cluster"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_placement_group
ec2_create_placement_group <- function(DryRun = NULL, GroupName = NULL, Strategy = NULL, PartitionCount = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreatePlacementGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_placement_group_input(DryRun = DryRun, GroupName = GroupName, Strategy = Strategy, PartitionCount = PartitionCount, TagSpecifications = TagSpecifications)
  output <- .ec2$create_placement_group_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_placement_group <- ec2_create_placement_group

#' Creates a listing for Amazon EC2 Standard Reserved Instances to be sold
#' in the Reserved Instance Marketplace
#'
#' @description
#' Creates a listing for Amazon EC2 Standard Reserved Instances to be sold
#' in the Reserved Instance Marketplace. You can submit one Standard
#' Reserved Instance listing at a time. To get a list of your Standard
#' Reserved Instances, you can use the
#' [`describe_reserved_instances`][ec2_describe_reserved_instances]
#' operation.
#' 
#' Only Standard Reserved Instances can be sold in the Reserved Instance
#' Marketplace. Convertible Reserved Instances cannot be sold.
#' 
#' The Reserved Instance Marketplace matches sellers who want to resell
#' Standard Reserved Instance capacity that they no longer need with buyers
#' who want to purchase additional capacity. Reserved Instances bought and
#' sold through the Reserved Instance Marketplace work like any other
#' Reserved Instances.
#' 
#' To sell your Standard Reserved Instances, you must first register as a
#' seller in the Reserved Instance Marketplace. After completing the
#' registration process, you can create a Reserved Instance Marketplace
#' listing of some or all of your Standard Reserved Instances, and specify
#' the upfront price to receive for them. Your Standard Reserved Instance
#' listings then become available for purchase. To view the details of your
#' Standard Reserved Instance listing, you can use the
#' [`describe_reserved_instances_listings`][ec2_describe_reserved_instances_listings]
#' operation.
#' 
#' For more information, see [Reserved Instance
#' Marketplace](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_reserved_instances_listing(ClientToken, InstanceCount,
#'   PriceSchedules, ReservedInstancesId)
#'
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier you provide to ensure idempotency of
#' your listings. This helps avoid duplicate listings. For more
#' information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param InstanceCount &#91;required&#93; The number of instances that are a part of a Reserved Instance account
#' to be listed in the Reserved Instance Marketplace. This number should be
#' less than or equal to the instance count associated with the Reserved
#' Instance ID specified in this call.
#' @param PriceSchedules &#91;required&#93; A list specifying the price of the Standard Reserved Instance for each
#' month remaining in the Reserved Instance term.
#' @param ReservedInstancesId &#91;required&#93; The ID of the active Standard Reserved Instance.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ReservedInstancesListings = list(
#'     list(
#'       ClientToken = "string",
#'       CreateDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       InstanceCounts = list(
#'         list(
#'           InstanceCount = 123,
#'           State = "available"|"sold"|"cancelled"|"pending"
#'         )
#'       ),
#'       PriceSchedules = list(
#'         list(
#'           Active = TRUE|FALSE,
#'           CurrencyCode = "USD",
#'           Price = 123.0,
#'           Term = 123
#'         )
#'       ),
#'       ReservedInstancesId = "string",
#'       ReservedInstancesListingId = "string",
#'       Status = "active"|"pending"|"cancelled"|"closed",
#'       StatusMessage = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       UpdateDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_reserved_instances_listing(
#'   ClientToken = "string",
#'   InstanceCount = 123,
#'   PriceSchedules = list(
#'     list(
#'       CurrencyCode = "USD",
#'       Price = 123.0,
#'       Term = 123
#'     )
#'   ),
#'   ReservedInstancesId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_reserved_instances_listing
ec2_create_reserved_instances_listing <- function(ClientToken, InstanceCount, PriceSchedules, ReservedInstancesId) {
  op <- new_operation(
    name = "CreateReservedInstancesListing",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_reserved_instances_listing_input(ClientToken = ClientToken, InstanceCount = InstanceCount, PriceSchedules = PriceSchedules, ReservedInstancesId = ReservedInstancesId)
  output <- .ec2$create_reserved_instances_listing_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_reserved_instances_listing <- ec2_create_reserved_instances_listing

#' Creates a route in a route table within a VPC
#'
#' @description
#' Creates a route in a route table within a VPC.
#' 
#' You must specify one of the following targets: internet gateway or
#' virtual private gateway, NAT instance, NAT gateway, VPC peering
#' connection, network interface, egress-only internet gateway, or transit
#' gateway.
#' 
#' When determining how to route traffic, we use the route with the most
#' specific match. For example, traffic is destined for the IPv4 address
#' `192.0.2.3`, and the route table includes the following two IPv4 routes:
#' 
#' -   `192.0.2.0/24` (goes to some target A)
#' 
#' -   `192.0.2.0/28` (goes to some target B)
#' 
#' Both routes apply to the traffic destined for `192.0.2.3`. However, the
#' second route in the list covers a smaller number of IP addresses and is
#' therefore more specific, so we use that route to determine where to
#' target the traffic.
#' 
#' For more information about route tables, see [Route
#' Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_route(DestinationCidrBlock, DestinationIpv6CidrBlock,
#'   DestinationPrefixListId, DryRun, VpcEndpointId,
#'   EgressOnlyInternetGatewayId, GatewayId, InstanceId, NatGatewayId,
#'   TransitGatewayId, LocalGatewayId, CarrierGatewayId, NetworkInterfaceId,
#'   RouteTableId, VpcPeeringConnectionId)
#'
#' @param DestinationCidrBlock The IPv4 CIDR address block used for the destination match. Routing
#' decisions are based on the most specific match. We modify the specified
#' CIDR block to its canonical form; for example, if you specify
#' `100.68.0.18/18`, we modify it to `100.68.0.0/18`.
#' @param DestinationIpv6CidrBlock The IPv6 CIDR block used for the destination match. Routing decisions
#' are based on the most specific match.
#' @param DestinationPrefixListId The ID of a prefix list used for the destination match.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointId The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints
#' only.
#' @param EgressOnlyInternetGatewayId \[IPv6 traffic only\] The ID of an egress-only internet gateway.
#' @param GatewayId The ID of an internet gateway or virtual private gateway attached to
#' your VPC.
#' @param InstanceId The ID of a NAT instance in your VPC. The operation fails if you specify
#' an instance ID unless exactly one network interface is attached.
#' @param NatGatewayId \[IPv4 traffic only\] The ID of a NAT gateway.
#' @param TransitGatewayId The ID of a transit gateway.
#' @param LocalGatewayId The ID of the local gateway.
#' @param CarrierGatewayId The ID of the carrier gateway.
#' 
#' You can only use this option when the VPC contains a subnet which is
#' associated with a Wavelength Zone.
#' @param NetworkInterfaceId The ID of a network interface.
#' @param RouteTableId &#91;required&#93; The ID of the route table for the route.
#' @param VpcPeeringConnectionId The ID of a VPC peering connection.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Return = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_route(
#'   DestinationCidrBlock = "string",
#'   DestinationIpv6CidrBlock = "string",
#'   DestinationPrefixListId = "string",
#'   DryRun = TRUE|FALSE,
#'   VpcEndpointId = "string",
#'   EgressOnlyInternetGatewayId = "string",
#'   GatewayId = "string",
#'   InstanceId = "string",
#'   NatGatewayId = "string",
#'   TransitGatewayId = "string",
#'   LocalGatewayId = "string",
#'   CarrierGatewayId = "string",
#'   NetworkInterfaceId = "string",
#'   RouteTableId = "string",
#'   VpcPeeringConnectionId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a route for the specified route table. The route
#' # matches all traffic (0.0.0.0/0) and routes it to the specified Internet
#' # gateway.
#' svc$create_route(
#'   DestinationCidrBlock = "0.0.0.0/0",
#'   GatewayId = "igw-c0a643a9",
#'   RouteTableId = "rtb-22574640"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_route
ec2_create_route <- function(DestinationCidrBlock = NULL, DestinationIpv6CidrBlock = NULL, DestinationPrefixListId = NULL, DryRun = NULL, VpcEndpointId = NULL, EgressOnlyInternetGatewayId = NULL, GatewayId = NULL, InstanceId = NULL, NatGatewayId = NULL, TransitGatewayId = NULL, LocalGatewayId = NULL, CarrierGatewayId = NULL, NetworkInterfaceId = NULL, RouteTableId, VpcPeeringConnectionId = NULL) {
  op <- new_operation(
    name = "CreateRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_route_input(DestinationCidrBlock = DestinationCidrBlock, DestinationIpv6CidrBlock = DestinationIpv6CidrBlock, DestinationPrefixListId = DestinationPrefixListId, DryRun = DryRun, VpcEndpointId = VpcEndpointId, EgressOnlyInternetGatewayId = EgressOnlyInternetGatewayId, GatewayId = GatewayId, InstanceId = InstanceId, NatGatewayId = NatGatewayId, TransitGatewayId = TransitGatewayId, LocalGatewayId = LocalGatewayId, CarrierGatewayId = CarrierGatewayId, NetworkInterfaceId = NetworkInterfaceId, RouteTableId = RouteTableId, VpcPeeringConnectionId = VpcPeeringConnectionId)
  output <- .ec2$create_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_route <- ec2_create_route

#' Creates a route table for the specified VPC
#'
#' @description
#' Creates a route table for the specified VPC. After you create a route
#' table, you can add routes and associate the table with a subnet.
#' 
#' For more information, see [Route
#' Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_route_table(DryRun, VpcId, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param TagSpecifications The tags to assign to the route table.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RouteTable = list(
#'     Associations = list(
#'       list(
#'         Main = TRUE|FALSE,
#'         RouteTableAssociationId = "string",
#'         RouteTableId = "string",
#'         SubnetId = "string",
#'         GatewayId = "string",
#'         AssociationState = list(
#'           State = "associating"|"associated"|"disassociating"|"disassociated"|"failed",
#'           StatusMessage = "string"
#'         )
#'       )
#'     ),
#'     PropagatingVgws = list(
#'       list(
#'         GatewayId = "string"
#'       )
#'     ),
#'     RouteTableId = "string",
#'     Routes = list(
#'       list(
#'         DestinationCidrBlock = "string",
#'         DestinationIpv6CidrBlock = "string",
#'         DestinationPrefixListId = "string",
#'         EgressOnlyInternetGatewayId = "string",
#'         GatewayId = "string",
#'         InstanceId = "string",
#'         InstanceOwnerId = "string",
#'         NatGatewayId = "string",
#'         TransitGatewayId = "string",
#'         LocalGatewayId = "string",
#'         CarrierGatewayId = "string",
#'         NetworkInterfaceId = "string",
#'         Origin = "CreateRouteTable"|"CreateRoute"|"EnableVgwRoutePropagation",
#'         State = "active"|"blackhole",
#'         VpcPeeringConnectionId = "string"
#'       )
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     VpcId = "string",
#'     OwnerId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_route_table(
#'   DryRun = TRUE|FALSE,
#'   VpcId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a route table for the specified VPC.
#' svc$create_route_table(
#'   VpcId = "vpc-a01106c2"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_route_table
ec2_create_route_table <- function(DryRun = NULL, VpcId, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_route_table_input(DryRun = DryRun, VpcId = VpcId, TagSpecifications = TagSpecifications)
  output <- .ec2$create_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_route_table <- ec2_create_route_table

#' Creates a security group
#'
#' @description
#' Creates a security group.
#' 
#' A security group acts as a virtual firewall for your instance to control
#' inbound and outbound traffic. For more information, see [Amazon EC2
#' Security
#' Groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-security-groups.html)
#' in the *Amazon Elastic Compute Cloud User Guide* and [Security Groups
#' for Your
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' When you create a security group, you specify a friendly name of your
#' choice. You can have a security group for use in EC2-Classic with the
#' same name as a security group for use in a VPC. However, you can't have
#' two security groups for use in EC2-Classic with the same name or two
#' security groups for use in a VPC with the same name.
#' 
#' You have a default security group for use in EC2-Classic and a default
#' security group for use in your VPC. If you don't specify a security
#' group when you launch an instance, the instance is launched into the
#' appropriate default security group. A default security group includes a
#' default rule that grants instances unrestricted network access to each
#' other.
#' 
#' You can add or remove rules from your security groups using
#' [`authorize_security_group_ingress`][ec2_authorize_security_group_ingress],
#' [`authorize_security_group_egress`][ec2_authorize_security_group_egress],
#' [`revoke_security_group_ingress`][ec2_revoke_security_group_ingress],
#' and [`revoke_security_group_egress`][ec2_revoke_security_group_egress].
#' 
#' For more information about VPC security group limits, see [Amazon VPC
#' Limits](https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
#'
#' @usage
#' ec2_create_security_group(Description, GroupName, VpcId,
#'   TagSpecifications, DryRun)
#'
#' @param Description &#91;required&#93; A description for the security group. This is informational only.
#' 
#' Constraints: Up to 255 characters in length
#' 
#' Constraints for EC2-Classic: ASCII characters
#' 
#' Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
#' ._-:/()#,@@\[\]+=&;\{\}!$*
#' @param GroupName &#91;required&#93; The name of the security group.
#' 
#' Constraints: Up to 255 characters in length. Cannot start with `sg-`.
#' 
#' Constraints for EC2-Classic: ASCII characters
#' 
#' Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
#' ._-:/()#,@@\[\]+=&;\{\}!$*
#' @param VpcId \[EC2-VPC\] The ID of the VPC. Required for EC2-VPC.
#' @param TagSpecifications The tags to assign to the security group.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   GroupId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_security_group(
#'   Description = "string",
#'   GroupName = "string",
#'   VpcId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a security group for the specified VPC.
#' svc$create_security_group(
#'   Description = "My security group",
#'   GroupName = "my-security-group",
#'   VpcId = "vpc-1a2b3c4d"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_security_group
ec2_create_security_group <- function(Description, GroupName, VpcId = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_security_group_input(Description = Description, GroupName = GroupName, VpcId = VpcId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_security_group_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_security_group <- ec2_create_security_group

#' Creates a snapshot of an EBS volume and stores it in Amazon S3
#'
#' @description
#' Creates a snapshot of an EBS volume and stores it in Amazon S3. You can
#' use snapshots for backups, to make copies of EBS volumes, and to save
#' data before shutting down an instance.
#' 
#' When a snapshot is created, any AWS Marketplace product codes that are
#' associated with the source volume are propagated to the snapshot.
#' 
#' You can take a snapshot of an attached volume that is in use. However,
#' snapshots only capture data that has been written to your EBS volume at
#' the time the snapshot command is issued; this might exclude any data
#' that has been cached by any applications or the operating system. If you
#' can pause any file systems on the volume long enough to take a snapshot,
#' your snapshot should be complete. However, if you cannot pause all file
#' writes to the volume, you should unmount the volume from within the
#' instance, issue the snapshot command, and then remount the volume to
#' ensure a consistent and complete snapshot. You may remount and use your
#' volume while the snapshot status is `pending`.
#' 
#' To create a snapshot for EBS volumes that serve as root devices, you
#' should stop the instance before taking the snapshot.
#' 
#' Snapshots that are taken from encrypted volumes are automatically
#' encrypted. Volumes that are created from encrypted snapshots are also
#' automatically encrypted. Your encrypted volumes and any associated
#' snapshots always remain protected.
#' 
#' You can tag your snapshots during creation. For more information, see
#' [Tagging your Amazon EC2
#' resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' For more information, see [Amazon Elastic Block
#' Store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html)
#' and [Amazon EBS
#' encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_snapshot(Description, VolumeId, TagSpecifications, DryRun)
#'
#' @param Description A description for the snapshot.
#' @param VolumeId &#91;required&#93; The ID of the EBS volume.
#' @param TagSpecifications The tags to apply to the snapshot during creation.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DataEncryptionKeyId = "string",
#'   Description = "string",
#'   Encrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   OwnerId = "string",
#'   Progress = "string",
#'   SnapshotId = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   State = "pending"|"completed"|"error",
#'   StateMessage = "string",
#'   VolumeId = "string",
#'   VolumeSize = 123,
#'   OwnerAlias = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshot(
#'   Description = "string",
#'   VolumeId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a snapshot of the volume with a volume ID of
#' # `vol-1234567890abcdef0` and a short description to identify the
#' # snapshot.
#' svc$create_snapshot(
#'   Description = "This is my root volume snapshot.",
#'   VolumeId = "vol-1234567890abcdef0"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_snapshot
ec2_create_snapshot <- function(Description = NULL, VolumeId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_snapshot_input(Description = Description, VolumeId = VolumeId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_snapshot <- ec2_create_snapshot

#' Creates crash-consistent snapshots of multiple EBS volumes and stores
#' the data in S3
#'
#' @description
#' Creates crash-consistent snapshots of multiple EBS volumes and stores
#' the data in S3. Volumes are chosen by specifying an instance. Any
#' attached volumes will produce one snapshot each that is crash-consistent
#' across the instance. Boot volumes can be excluded by changing the
#' parameters.
#'
#' @usage
#' ec2_create_snapshots(Description, InstanceSpecification,
#'   TagSpecifications, DryRun, CopyTagsFromSource)
#'
#' @param Description A description propagated to every snapshot specified by the instance.
#' @param InstanceSpecification &#91;required&#93; The instance to specify which volumes should be included in the
#' snapshots.
#' @param TagSpecifications Tags to apply to every snapshot specified by the instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param CopyTagsFromSource Copies the tags from the specified volume to corresponding snapshot.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Snapshots = list(
#'     list(
#'       Description = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       Encrypted = TRUE|FALSE,
#'       VolumeId = "string",
#'       State = "pending"|"completed"|"error",
#'       VolumeSize = 123,
#'       StartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Progress = "string",
#'       OwnerId = "string",
#'       SnapshotId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshots(
#'   Description = "string",
#'   InstanceSpecification = list(
#'     InstanceId = "string",
#'     ExcludeBootVolume = TRUE|FALSE
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   CopyTagsFromSource = "volume"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_snapshots
ec2_create_snapshots <- function(Description = NULL, InstanceSpecification, TagSpecifications = NULL, DryRun = NULL, CopyTagsFromSource = NULL) {
  op <- new_operation(
    name = "CreateSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_snapshots_input(Description = Description, InstanceSpecification = InstanceSpecification, TagSpecifications = TagSpecifications, DryRun = DryRun, CopyTagsFromSource = CopyTagsFromSource)
  output <- .ec2$create_snapshots_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_snapshots <- ec2_create_snapshots

#' Creates a data feed for Spot Instances, enabling you to view Spot
#' Instance usage logs
#'
#' @description
#' Creates a data feed for Spot Instances, enabling you to view Spot
#' Instance usage logs. You can create one data feed per AWS account. For
#' more information, see [Spot Instance data
#' feed](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#'
#' @usage
#' ec2_create_spot_datafeed_subscription(Bucket, DryRun, Prefix)
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket in which to store the Spot Instance
#' data feed. For more information about bucket names, see [Rules for
#' bucket
#' naming](https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules)
#' in the *Amazon S3 Developer Guide*.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Prefix The prefix for the data feed file names.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SpotDatafeedSubscription = list(
#'     Bucket = "string",
#'     Fault = list(
#'       Code = "string",
#'       Message = "string"
#'     ),
#'     OwnerId = "string",
#'     Prefix = "string",
#'     State = "Active"|"Inactive"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_spot_datafeed_subscription(
#'   Bucket = "string",
#'   DryRun = TRUE|FALSE,
#'   Prefix = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a Spot Instance data feed for your AWS account.
#' svc$create_spot_datafeed_subscription(
#'   Bucket = "my-s3-bucket",
#'   Prefix = "spotdata"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_spot_datafeed_subscription
ec2_create_spot_datafeed_subscription <- function(Bucket, DryRun = NULL, Prefix = NULL) {
  op <- new_operation(
    name = "CreateSpotDatafeedSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_spot_datafeed_subscription_input(Bucket = Bucket, DryRun = DryRun, Prefix = Prefix)
  output <- .ec2$create_spot_datafeed_subscription_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_spot_datafeed_subscription <- ec2_create_spot_datafeed_subscription

#' Creates a subnet in a specified VPC
#'
#' @description
#' Creates a subnet in a specified VPC.
#' 
#' You must specify an IPv4 CIDR block for the subnet. After you create a
#' subnet, you can't change its CIDR block. The allowed block size is
#' between a /16 netmask (65,536 IP addresses) and /28 netmask (16 IP
#' addresses). The CIDR block must not overlap with the CIDR block of an
#' existing subnet in the VPC.
#' 
#' If you've associated an IPv6 CIDR block with your VPC, you can create a
#' subnet with an IPv6 CIDR block that uses a /64 prefix length.
#' 
#' AWS reserves both the first four and the last IPv4 address in each
#' subnet's CIDR block. They're not available for use.
#' 
#' If you add more than one subnet to a VPC, they're set up in a star
#' topology with a logical router in the middle.
#' 
#' When you stop an instance in a subnet, it retains its private IPv4
#' address. It's therefore possible to have a subnet with no running
#' instances (they're all stopped), but no remaining IP addresses
#' available.
#' 
#' For more information about subnets, see [Your VPC and
#' Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_subnet(TagSpecifications, AvailabilityZone,
#'   AvailabilityZoneId, CidrBlock, Ipv6CidrBlock, OutpostArn, VpcId, DryRun)
#'
#' @param TagSpecifications The tags to assign to the subnet.
#' @param AvailabilityZone The Availability Zone or Local Zone for the subnet.
#' 
#' Default: AWS selects one for you. If you create more than one subnet in
#' your VPC, we do not necessarily select a different zone for each subnet.
#' 
#' To create a subnet in a Local Zone, set this value to the Local Zone ID,
#' for example `us-west-2-lax-1a`. For information about the Regions that
#' support Local Zones, see [Available
#' Regions](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' To create a subnet in an Outpost, set this value to the Availability
#' Zone for the Outpost and specify the Outpost ARN.
#' @param AvailabilityZoneId The AZ ID or the Local Zone ID of the subnet.
#' @param CidrBlock &#91;required&#93; The IPv4 network range for the subnet, in CIDR notation. For example,
#' `10.0.0.0/24`. We modify the specified CIDR block to its canonical form;
#' for example, if you specify `100.68.0.18/18`, we modify it to
#' `100.68.0.0/18`.
#' @param Ipv6CidrBlock The IPv6 network range for the subnet, in CIDR notation. The subnet size
#' must use a /64 prefix length.
#' @param OutpostArn The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost
#' ARN, you must also specify the Availability Zone of the Outpost subnet.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Subnet = list(
#'     AvailabilityZone = "string",
#'     AvailabilityZoneId = "string",
#'     AvailableIpAddressCount = 123,
#'     CidrBlock = "string",
#'     DefaultForAz = TRUE|FALSE,
#'     MapPublicIpOnLaunch = TRUE|FALSE,
#'     MapCustomerOwnedIpOnLaunch = TRUE|FALSE,
#'     CustomerOwnedIpv4Pool = "string",
#'     State = "pending"|"available",
#'     SubnetId = "string",
#'     VpcId = "string",
#'     OwnerId = "string",
#'     AssignIpv6AddressOnCreation = TRUE|FALSE,
#'     Ipv6CidrBlockAssociationSet = list(
#'       list(
#'         AssociationId = "string",
#'         Ipv6CidrBlock = "string",
#'         Ipv6CidrBlockState = list(
#'           State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
#'           StatusMessage = "string"
#'         )
#'       )
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     SubnetArn = "string",
#'     OutpostArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_subnet(
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   AvailabilityZone = "string",
#'   AvailabilityZoneId = "string",
#'   CidrBlock = "string",
#'   Ipv6CidrBlock = "string",
#'   OutpostArn = "string",
#'   VpcId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a subnet in the specified VPC with the specified
#' # CIDR block. We recommend that you let us select an Availability Zone for
#' # you.
#' svc$create_subnet(
#'   CidrBlock = "10.0.1.0/24",
#'   VpcId = "vpc-a01106c2"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_subnet
ec2_create_subnet <- function(TagSpecifications = NULL, AvailabilityZone = NULL, AvailabilityZoneId = NULL, CidrBlock, Ipv6CidrBlock = NULL, OutpostArn = NULL, VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "CreateSubnet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_subnet_input(TagSpecifications = TagSpecifications, AvailabilityZone = AvailabilityZone, AvailabilityZoneId = AvailabilityZoneId, CidrBlock = CidrBlock, Ipv6CidrBlock = Ipv6CidrBlock, OutpostArn = OutpostArn, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$create_subnet_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_subnet <- ec2_create_subnet

#' Adds or overwrites only the specified tags for the specified Amazon EC2
#' resource or resources
#'
#' @description
#' Adds or overwrites only the specified tags for the specified Amazon EC2
#' resource or resources. When you specify an existing tag key, the value
#' is overwritten with the new value. Each resource can have a maximum of
#' 50 tags. Each tag consists of a key and optional value. Tag keys must be
#' unique per resource.
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon Elastic Compute Cloud User Guide*. For more information
#' about creating IAM policies that control users' access to resources
#' based on tags, see [Supported Resource-Level Permissions for Amazon EC2
#' API
#' Actions](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#ec2-supported-iam-actions-resources)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_tags(DryRun, Resources, Tags)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Resources &#91;required&#93; The IDs of the resources, separated by spaces.
#' 
#' Constraints: Up to 1000 resource IDs. We recommend breaking up this
#' request into smaller batches.
#' @param Tags &#91;required&#93; The tags. The `value` parameter is required, but if you don't want the
#' tag to have a value, specify the parameter with no value, and we set the
#' value to an empty string.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_tags(
#'   DryRun = TRUE|FALSE,
#'   Resources = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example adds the tag Stack=production to the specified image, or
#' # overwrites an existing tag for the AMI where the tag key is Stack.
#' svc$create_tags(
#'   Resources = list(
#'     "ami-78a54011"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "Stack",
#'       Value = "production"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_tags
ec2_create_tags <- function(DryRun = NULL, Resources, Tags) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_tags_input(DryRun = DryRun, Resources = Resources, Tags = Tags)
  output <- .ec2$create_tags_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_tags <- ec2_create_tags

#' Creates a Traffic Mirror filter
#'
#' @description
#' Creates a Traffic Mirror filter.
#' 
#' A Traffic Mirror filter is a set of rules that defines the traffic to
#' mirror.
#' 
#' By default, no traffic is mirrored. To mirror traffic, use
#' [`create_traffic_mirror_filter_rule`][ec2_create_traffic_mirror_filter_rule]
#' to add Traffic Mirror rules to the filter. The rules you add define what
#' traffic gets mirrored. You can also use
#' [`modify_traffic_mirror_filter_network_services`][ec2_modify_traffic_mirror_filter_network_services]
#' to mirror supported network services.
#'
#' @usage
#' ec2_create_traffic_mirror_filter(Description, TagSpecifications, DryRun,
#'   ClientToken)
#'
#' @param Description The description of the Traffic Mirror filter.
#' @param TagSpecifications The tags to assign to a Traffic Mirror filter.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrafficMirrorFilter = list(
#'     TrafficMirrorFilterId = "string",
#'     IngressFilterRules = list(
#'       list(
#'         TrafficMirrorFilterRuleId = "string",
#'         TrafficMirrorFilterId = "string",
#'         TrafficDirection = "ingress"|"egress",
#'         RuleNumber = 123,
#'         RuleAction = "accept"|"reject",
#'         Protocol = 123,
#'         DestinationPortRange = list(
#'           FromPort = 123,
#'           ToPort = 123
#'         ),
#'         SourcePortRange = list(
#'           FromPort = 123,
#'           ToPort = 123
#'         ),
#'         DestinationCidrBlock = "string",
#'         SourceCidrBlock = "string",
#'         Description = "string"
#'       )
#'     ),
#'     EgressFilterRules = list(
#'       list(
#'         TrafficMirrorFilterRuleId = "string",
#'         TrafficMirrorFilterId = "string",
#'         TrafficDirection = "ingress"|"egress",
#'         RuleNumber = 123,
#'         RuleAction = "accept"|"reject",
#'         Protocol = 123,
#'         DestinationPortRange = list(
#'           FromPort = 123,
#'           ToPort = 123
#'         ),
#'         SourcePortRange = list(
#'           FromPort = 123,
#'           ToPort = 123
#'         ),
#'         DestinationCidrBlock = "string",
#'         SourceCidrBlock = "string",
#'         Description = "string"
#'       )
#'     ),
#'     NetworkServices = list(
#'       "amazon-dns"
#'     ),
#'     Description = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_mirror_filter(
#'   Description = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_filter
ec2_create_traffic_mirror_filter <- function(Description = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_traffic_mirror_filter_input(Description = Description, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_filter_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_filter <- ec2_create_traffic_mirror_filter

#' Creates a Traffic Mirror filter rule
#'
#' @description
#' Creates a Traffic Mirror filter rule.
#' 
#' A Traffic Mirror rule defines the Traffic Mirror source traffic to
#' mirror.
#' 
#' You need the Traffic Mirror filter ID when you create the rule.
#'
#' @usage
#' ec2_create_traffic_mirror_filter_rule(TrafficMirrorFilterId,
#'   TrafficDirection, RuleNumber, RuleAction, DestinationPortRange,
#'   SourcePortRange, Protocol, DestinationCidrBlock, SourceCidrBlock,
#'   Description, DryRun, ClientToken)
#'
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the filter that this rule is associated with.
#' @param TrafficDirection &#91;required&#93; The type of traffic (`ingress` | `egress`).
#' @param RuleNumber &#91;required&#93; The number of the Traffic Mirror rule. This number must be unique for
#' each Traffic Mirror rule in a given direction. The rules are processed
#' in ascending order by rule number.
#' @param RuleAction &#91;required&#93; The action to take (`accept` | `reject`) on the filtered traffic.
#' @param DestinationPortRange The destination port range.
#' @param SourcePortRange The source port range.
#' @param Protocol The protocol, for example UDP, to assign to the Traffic Mirror rule.
#' 
#' For information about the protocol value, see [Protocol
#' Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
#' on the Internet Assigned Numbers Authority (IANA) website.
#' @param DestinationCidrBlock &#91;required&#93; The destination CIDR block to assign to the Traffic Mirror rule.
#' @param SourceCidrBlock &#91;required&#93; The source CIDR block to assign to the Traffic Mirror rule.
#' @param Description The description of the Traffic Mirror rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrafficMirrorFilterRule = list(
#'     TrafficMirrorFilterRuleId = "string",
#'     TrafficMirrorFilterId = "string",
#'     TrafficDirection = "ingress"|"egress",
#'     RuleNumber = 123,
#'     RuleAction = "accept"|"reject",
#'     Protocol = 123,
#'     DestinationPortRange = list(
#'       FromPort = 123,
#'       ToPort = 123
#'     ),
#'     SourcePortRange = list(
#'       FromPort = 123,
#'       ToPort = 123
#'     ),
#'     DestinationCidrBlock = "string",
#'     SourceCidrBlock = "string",
#'     Description = "string"
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_mirror_filter_rule(
#'   TrafficMirrorFilterId = "string",
#'   TrafficDirection = "ingress"|"egress",
#'   RuleNumber = 123,
#'   RuleAction = "accept"|"reject",
#'   DestinationPortRange = list(
#'     FromPort = 123,
#'     ToPort = 123
#'   ),
#'   SourcePortRange = list(
#'     FromPort = 123,
#'     ToPort = 123
#'   ),
#'   Protocol = 123,
#'   DestinationCidrBlock = "string",
#'   SourceCidrBlock = "string",
#'   Description = "string",
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_filter_rule
ec2_create_traffic_mirror_filter_rule <- function(TrafficMirrorFilterId, TrafficDirection, RuleNumber, RuleAction, DestinationPortRange = NULL, SourcePortRange = NULL, Protocol = NULL, DestinationCidrBlock, SourceCidrBlock, Description = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorFilterRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_traffic_mirror_filter_rule_input(TrafficMirrorFilterId = TrafficMirrorFilterId, TrafficDirection = TrafficDirection, RuleNumber = RuleNumber, RuleAction = RuleAction, DestinationPortRange = DestinationPortRange, SourcePortRange = SourcePortRange, Protocol = Protocol, DestinationCidrBlock = DestinationCidrBlock, SourceCidrBlock = SourceCidrBlock, Description = Description, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_filter_rule_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_filter_rule <- ec2_create_traffic_mirror_filter_rule

#' Creates a Traffic Mirror session
#'
#' @description
#' Creates a Traffic Mirror session.
#' 
#' A Traffic Mirror session actively copies packets from a Traffic Mirror
#' source to a Traffic Mirror target. Create a filter, and then assign it
#' to the session to define a subset of the traffic to mirror, for example
#' all TCP traffic.
#' 
#' The Traffic Mirror source and the Traffic Mirror target (monitoring
#' appliances) can be in the same VPC, or in a different VPC connected via
#' VPC peering or a transit gateway.
#' 
#' By default, no traffic is mirrored. Use
#' [`create_traffic_mirror_filter`][ec2_create_traffic_mirror_filter] to
#' create filter rules that specify the traffic to mirror.
#'
#' @usage
#' ec2_create_traffic_mirror_session(NetworkInterfaceId,
#'   TrafficMirrorTargetId, TrafficMirrorFilterId, PacketLength,
#'   SessionNumber, VirtualNetworkId, Description, TagSpecifications, DryRun,
#'   ClientToken)
#'
#' @param NetworkInterfaceId &#91;required&#93; The ID of the source network interface.
#' @param TrafficMirrorTargetId &#91;required&#93; The ID of the Traffic Mirror target.
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the Traffic Mirror filter.
#' @param PacketLength The number of bytes in each packet to mirror. These are bytes after the
#' VXLAN header. Do not specify this parameter when you want to mirror the
#' entire packet. To mirror a subset of the packet, set this to the length
#' (in bytes) that you want to mirror. For example, if you set this value
#' to 100, then the first 100 bytes that meet the filter criteria are
#' copied to the target.
#' 
#' If you do not want to mirror the entire packet, use the `PacketLength`
#' parameter to specify the number of bytes in each packet to mirror.
#' @param SessionNumber &#91;required&#93; The session number determines the order in which sessions are evaluated
#' when an interface is used by multiple sessions. The first session with a
#' matching filter is the one that mirrors the packets.
#' 
#' Valid values are 1-32766.
#' @param VirtualNetworkId The VXLAN ID for the Traffic Mirror session. For more information about
#' the VXLAN protocol, see [RFC
#' 7348](https://datatracker.ietf.org/doc/html/rfc7348). If you do not
#' specify a `VirtualNetworkId`, an account-wide unique id is chosen at
#' random.
#' @param Description The description of the Traffic Mirror session.
#' @param TagSpecifications The tags to assign to a Traffic Mirror session.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrafficMirrorSession = list(
#'     TrafficMirrorSessionId = "string",
#'     TrafficMirrorTargetId = "string",
#'     TrafficMirrorFilterId = "string",
#'     NetworkInterfaceId = "string",
#'     OwnerId = "string",
#'     PacketLength = 123,
#'     SessionNumber = 123,
#'     VirtualNetworkId = 123,
#'     Description = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_mirror_session(
#'   NetworkInterfaceId = "string",
#'   TrafficMirrorTargetId = "string",
#'   TrafficMirrorFilterId = "string",
#'   PacketLength = 123,
#'   SessionNumber = 123,
#'   VirtualNetworkId = 123,
#'   Description = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_session
ec2_create_traffic_mirror_session <- function(NetworkInterfaceId, TrafficMirrorTargetId, TrafficMirrorFilterId, PacketLength = NULL, SessionNumber, VirtualNetworkId = NULL, Description = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_traffic_mirror_session_input(NetworkInterfaceId = NetworkInterfaceId, TrafficMirrorTargetId = TrafficMirrorTargetId, TrafficMirrorFilterId = TrafficMirrorFilterId, PacketLength = PacketLength, SessionNumber = SessionNumber, VirtualNetworkId = VirtualNetworkId, Description = Description, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_session_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_session <- ec2_create_traffic_mirror_session

#' Creates a target for your Traffic Mirror session
#'
#' @description
#' Creates a target for your Traffic Mirror session.
#' 
#' A Traffic Mirror target is the destination for mirrored traffic. The
#' Traffic Mirror source and the Traffic Mirror target (monitoring
#' appliances) can be in the same VPC, or in different VPCs connected via
#' VPC peering or a transit gateway.
#' 
#' A Traffic Mirror target can be a network interface, or a Network Load
#' Balancer.
#' 
#' To use the target in a Traffic Mirror session, use
#' [`create_traffic_mirror_session`][ec2_create_traffic_mirror_session].
#'
#' @usage
#' ec2_create_traffic_mirror_target(NetworkInterfaceId,
#'   NetworkLoadBalancerArn, Description, TagSpecifications, DryRun,
#'   ClientToken)
#'
#' @param NetworkInterfaceId The network interface ID that is associated with the target.
#' @param NetworkLoadBalancerArn The Amazon Resource Name (ARN) of the Network Load Balancer that is
#' associated with the target.
#' @param Description The description of the Traffic Mirror target.
#' @param TagSpecifications The tags to assign to the Traffic Mirror target.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrafficMirrorTarget = list(
#'     TrafficMirrorTargetId = "string",
#'     NetworkInterfaceId = "string",
#'     NetworkLoadBalancerArn = "string",
#'     Type = "network-interface"|"network-load-balancer",
#'     Description = "string",
#'     OwnerId = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_mirror_target(
#'   NetworkInterfaceId = "string",
#'   NetworkLoadBalancerArn = "string",
#'   Description = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_target
ec2_create_traffic_mirror_target <- function(NetworkInterfaceId = NULL, NetworkLoadBalancerArn = NULL, Description = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_traffic_mirror_target_input(NetworkInterfaceId = NetworkInterfaceId, NetworkLoadBalancerArn = NetworkLoadBalancerArn, Description = Description, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_target_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_target <- ec2_create_traffic_mirror_target

#' Creates a transit gateway
#'
#' @description
#' Creates a transit gateway.
#' 
#' You can use a transit gateway to interconnect your virtual private
#' clouds (VPC) and on-premises networks. After the transit gateway enters
#' the `available` state, you can attach your VPCs and VPN connections to
#' the transit gateway.
#' 
#' To attach your VPCs, use
#' [`create_transit_gateway_vpc_attachment`][ec2_create_transit_gateway_vpc_attachment].
#' 
#' To attach a VPN connection, use
#' [`create_customer_gateway`][ec2_create_customer_gateway] to create a
#' customer gateway and specify the ID of the customer gateway and the ID
#' of the transit gateway in a call to
#' [`create_vpn_connection`][ec2_create_vpn_connection].
#' 
#' When you create a transit gateway, we create a default transit gateway
#' route table and use it as the default association route table and the
#' default propagation route table. You can use
#' [`create_transit_gateway_route_table`][ec2_create_transit_gateway_route_table]
#' to create additional transit gateway route tables. If you disable
#' automatic route propagation, we do not create a default transit gateway
#' route table. You can use
#' [`enable_transit_gateway_route_table_propagation`][ec2_enable_transit_gateway_route_table_propagation]
#' to propagate routes from a resource attachment to a transit gateway
#' route table. If you disable automatic associations, you can use
#' [`associate_transit_gateway_route_table`][ec2_associate_transit_gateway_route_table]
#' to associate a resource attachment with a transit gateway route table.
#'
#' @usage
#' ec2_create_transit_gateway(Description, Options, TagSpecifications,
#'   DryRun)
#'
#' @param Description A description of the transit gateway.
#' @param Options The transit gateway options.
#' @param TagSpecifications The tags to apply to the transit gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGateway = list(
#'     TransitGatewayId = "string",
#'     TransitGatewayArn = "string",
#'     State = "pending"|"available"|"modifying"|"deleting"|"deleted",
#'     OwnerId = "string",
#'     Description = "string",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Options = list(
#'       AmazonSideAsn = 123,
#'       TransitGatewayCidrBlocks = list(
#'         "string"
#'       ),
#'       AutoAcceptSharedAttachments = "enable"|"disable",
#'       DefaultRouteTableAssociation = "enable"|"disable",
#'       AssociationDefaultRouteTableId = "string",
#'       DefaultRouteTablePropagation = "enable"|"disable",
#'       PropagationDefaultRouteTableId = "string",
#'       VpnEcmpSupport = "enable"|"disable",
#'       DnsSupport = "enable"|"disable",
#'       MulticastSupport = "enable"|"disable"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway(
#'   Description = "string",
#'   Options = list(
#'     AmazonSideAsn = 123,
#'     AutoAcceptSharedAttachments = "enable"|"disable",
#'     DefaultRouteTableAssociation = "enable"|"disable",
#'     DefaultRouteTablePropagation = "enable"|"disable",
#'     VpnEcmpSupport = "enable"|"disable",
#'     DnsSupport = "enable"|"disable",
#'     MulticastSupport = "enable"|"disable",
#'     TransitGatewayCidrBlocks = list(
#'       "string"
#'     )
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway
ec2_create_transit_gateway <- function(Description = NULL, Options = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_input(Description = Description, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway <- ec2_create_transit_gateway

#' Creates a Connect attachment from a specified transit gateway attachment
#'
#' @description
#' Creates a Connect attachment from a specified transit gateway
#' attachment. A Connect attachment is a GRE-based tunnel attachment that
#' you can use to establish a connection between a transit gateway and an
#' appliance.
#' 
#' A Connect attachment uses an existing VPC or AWS Direct Connect
#' attachment as the underlying transport mechanism.
#'
#' @usage
#' ec2_create_transit_gateway_connect(TransportTransitGatewayAttachmentId,
#'   Options, TagSpecifications, DryRun)
#'
#' @param TransportTransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway attachment. You can specify a VPC
#' attachment or a AWS Direct Connect attachment.
#' @param Options &#91;required&#93; The Connect attachment options.
#' @param TagSpecifications The tags to apply to the Connect attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayConnect = list(
#'     TransitGatewayAttachmentId = "string",
#'     TransportTransitGatewayAttachmentId = "string",
#'     TransitGatewayId = "string",
#'     State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Options = list(
#'       Protocol = "gre"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_connect(
#'   TransportTransitGatewayAttachmentId = "string",
#'   Options = list(
#'     Protocol = "gre"
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_connect
ec2_create_transit_gateway_connect <- function(TransportTransitGatewayAttachmentId, Options, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayConnect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_connect_input(TransportTransitGatewayAttachmentId = TransportTransitGatewayAttachmentId, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_connect_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_connect <- ec2_create_transit_gateway_connect

#' Creates a Connect peer for a specified transit gateway Connect
#' attachment between a transit gateway and an appliance
#'
#' @description
#' Creates a Connect peer for a specified transit gateway Connect
#' attachment between a transit gateway and an appliance.
#' 
#' The peer address and transit gateway address must be the same IP address
#' family (IPv4 or IPv6).
#' 
#' For more information, see [Connect
#' peers](https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer)
#' in the *Transit Gateways Guide*.
#'
#' @usage
#' ec2_create_transit_gateway_connect_peer(TransitGatewayAttachmentId,
#'   TransitGatewayAddress, PeerAddress, BgpOptions, InsideCidrBlocks,
#'   TagSpecifications, DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the Connect attachment.
#' @param TransitGatewayAddress The peer IP address (GRE outer IP address) on the transit gateway side
#' of the Connect peer, which must be specified from a transit gateway CIDR
#' block. If not specified, Amazon automatically assigns the first
#' available IP address from the transit gateway CIDR block.
#' @param PeerAddress &#91;required&#93; The peer IP address (GRE outer IP address) on the appliance side of the
#' Connect peer.
#' @param BgpOptions The BGP options for the Connect peer.
#' @param InsideCidrBlocks &#91;required&#93; The range of inside IP addresses that are used for BGP peering. You must
#' specify a size /29 IPv4 CIDR block from the `169.254.0.0/16` range. The
#' first address from the range must be configured on the appliance as the
#' BGP IP address. You can also optionally specify a size /125 IPv6 CIDR
#' block from the `fd00::/8` range.
#' @param TagSpecifications The tags to apply to the Connect peer.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayConnectPeer = list(
#'     TransitGatewayAttachmentId = "string",
#'     TransitGatewayConnectPeerId = "string",
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ConnectPeerConfiguration = list(
#'       TransitGatewayAddress = "string",
#'       PeerAddress = "string",
#'       InsideCidrBlocks = list(
#'         "string"
#'       ),
#'       Protocol = "gre",
#'       BgpConfigurations = list(
#'         list(
#'           TransitGatewayAsn = 123,
#'           PeerAsn = 123,
#'           TransitGatewayAddress = "string",
#'           PeerAddress = "string",
#'           BgpStatus = "up"|"down"
#'         )
#'       )
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_connect_peer(
#'   TransitGatewayAttachmentId = "string",
#'   TransitGatewayAddress = "string",
#'   PeerAddress = "string",
#'   BgpOptions = list(
#'     PeerAsn = 123
#'   ),
#'   InsideCidrBlocks = list(
#'     "string"
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_connect_peer
ec2_create_transit_gateway_connect_peer <- function(TransitGatewayAttachmentId, TransitGatewayAddress = NULL, PeerAddress, BgpOptions = NULL, InsideCidrBlocks, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayConnectPeer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_connect_peer_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, TransitGatewayAddress = TransitGatewayAddress, PeerAddress = PeerAddress, BgpOptions = BgpOptions, InsideCidrBlocks = InsideCidrBlocks, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_connect_peer_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_connect_peer <- ec2_create_transit_gateway_connect_peer

#' Creates a multicast domain using the specified transit gateway
#'
#' @description
#' Creates a multicast domain using the specified transit gateway.
#' 
#' The transit gateway must be in the available state before you create a
#' domain. Use [`describe_transit_gateways`][ec2_describe_transit_gateways]
#' to see the state of transit gateway.
#'
#' @usage
#' ec2_create_transit_gateway_multicast_domain(TransitGatewayId, Options,
#'   TagSpecifications, DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param Options The options for the transit gateway multicast domain.
#' @param TagSpecifications The tags for the transit gateway multicast domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayMulticastDomain = list(
#'     TransitGatewayMulticastDomainId = "string",
#'     TransitGatewayId = "string",
#'     TransitGatewayMulticastDomainArn = "string",
#'     OwnerId = "string",
#'     Options = list(
#'       Igmpv2Support = "enable"|"disable",
#'       StaticSourcesSupport = "enable"|"disable",
#'       AutoAcceptSharedAssociations = "enable"|"disable"
#'     ),
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_multicast_domain(
#'   TransitGatewayId = "string",
#'   Options = list(
#'     Igmpv2Support = "enable"|"disable",
#'     StaticSourcesSupport = "enable"|"disable",
#'     AutoAcceptSharedAssociations = "enable"|"disable"
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_multicast_domain
ec2_create_transit_gateway_multicast_domain <- function(TransitGatewayId, Options = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_multicast_domain_input(TransitGatewayId = TransitGatewayId, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_multicast_domain <- ec2_create_transit_gateway_multicast_domain

#' Requests a transit gateway peering attachment between the specified
#' transit gateway (requester) and a peer transit gateway (accepter)
#'
#' @description
#' Requests a transit gateway peering attachment between the specified
#' transit gateway (requester) and a peer transit gateway (accepter). The
#' transit gateways must be in different Regions. The peer transit gateway
#' can be in your account or a different AWS account.
#' 
#' After you create the peering attachment, the owner of the accepter
#' transit gateway must accept the attachment request.
#'
#' @usage
#' ec2_create_transit_gateway_peering_attachment(TransitGatewayId,
#'   PeerTransitGatewayId, PeerAccountId, PeerRegion, TagSpecifications,
#'   DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param PeerTransitGatewayId &#91;required&#93; The ID of the peer transit gateway with which to create the peering
#' attachment.
#' @param PeerAccountId &#91;required&#93; The AWS account ID of the owner of the peer transit gateway.
#' @param PeerRegion &#91;required&#93; The Region where the peer transit gateway is located.
#' @param TagSpecifications The tags to apply to the transit gateway peering attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayPeeringAttachment = list(
#'     TransitGatewayAttachmentId = "string",
#'     RequesterTgwInfo = list(
#'       TransitGatewayId = "string",
#'       OwnerId = "string",
#'       Region = "string"
#'     ),
#'     AccepterTgwInfo = list(
#'       TransitGatewayId = "string",
#'       OwnerId = "string",
#'       Region = "string"
#'     ),
#'     Status = list(
#'       Code = "string",
#'       Message = "string"
#'     ),
#'     State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_peering_attachment(
#'   TransitGatewayId = "string",
#'   PeerTransitGatewayId = "string",
#'   PeerAccountId = "string",
#'   PeerRegion = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_peering_attachment
ec2_create_transit_gateway_peering_attachment <- function(TransitGatewayId, PeerTransitGatewayId, PeerAccountId, PeerRegion, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayPeeringAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_peering_attachment_input(TransitGatewayId = TransitGatewayId, PeerTransitGatewayId = PeerTransitGatewayId, PeerAccountId = PeerAccountId, PeerRegion = PeerRegion, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_peering_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_peering_attachment <- ec2_create_transit_gateway_peering_attachment

#' Creates a reference (route) to a prefix list in a specified transit
#' gateway route table
#'
#' @description
#' Creates a reference (route) to a prefix list in a specified transit
#' gateway route table.
#'
#' @usage
#' ec2_create_transit_gateway_prefix_list_reference(
#'   TransitGatewayRouteTableId, PrefixListId, TransitGatewayAttachmentId,
#'   Blackhole, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param PrefixListId &#91;required&#93; The ID of the prefix list that is used for destination matches.
#' @param TransitGatewayAttachmentId The ID of the attachment to which traffic is routed.
#' @param Blackhole Indicates whether to drop traffic that matches this route.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayPrefixListReference = list(
#'     TransitGatewayRouteTableId = "string",
#'     PrefixListId = "string",
#'     PrefixListOwnerId = "string",
#'     State = "pending"|"available"|"modifying"|"deleting",
#'     Blackhole = TRUE|FALSE,
#'     TransitGatewayAttachment = list(
#'       TransitGatewayAttachmentId = "string",
#'       ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering",
#'       ResourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_prefix_list_reference(
#'   TransitGatewayRouteTableId = "string",
#'   PrefixListId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   Blackhole = TRUE|FALSE,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_prefix_list_reference
ec2_create_transit_gateway_prefix_list_reference <- function(TransitGatewayRouteTableId, PrefixListId, TransitGatewayAttachmentId = NULL, Blackhole = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayPrefixListReference",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_prefix_list_reference_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, PrefixListId = PrefixListId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, Blackhole = Blackhole, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_prefix_list_reference_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_prefix_list_reference <- ec2_create_transit_gateway_prefix_list_reference

#' Creates a static route for the specified transit gateway route table
#'
#' @description
#' Creates a static route for the specified transit gateway route table.
#'
#' @usage
#' ec2_create_transit_gateway_route(DestinationCidrBlock,
#'   TransitGatewayRouteTableId, TransitGatewayAttachmentId, Blackhole,
#'   DryRun)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range used for destination matches. Routing decisions are based
#' on the most specific match.
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param TransitGatewayAttachmentId The ID of the attachment.
#' @param Blackhole Indicates whether to drop traffic that matches this route.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Route = list(
#'     DestinationCidrBlock = "string",
#'     PrefixListId = "string",
#'     TransitGatewayAttachments = list(
#'       list(
#'         ResourceId = "string",
#'         TransitGatewayAttachmentId = "string",
#'         ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering"
#'       )
#'     ),
#'     Type = "static"|"propagated",
#'     State = "pending"|"active"|"blackhole"|"deleting"|"deleted"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_route(
#'   DestinationCidrBlock = "string",
#'   TransitGatewayRouteTableId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   Blackhole = TRUE|FALSE,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_route
ec2_create_transit_gateway_route <- function(DestinationCidrBlock, TransitGatewayRouteTableId, TransitGatewayAttachmentId = NULL, Blackhole = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_route_input(DestinationCidrBlock = DestinationCidrBlock, TransitGatewayRouteTableId = TransitGatewayRouteTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, Blackhole = Blackhole, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_route <- ec2_create_transit_gateway_route

#' Creates a route table for the specified transit gateway
#'
#' @description
#' Creates a route table for the specified transit gateway.
#'
#' @usage
#' ec2_create_transit_gateway_route_table(TransitGatewayId,
#'   TagSpecifications, DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param TagSpecifications The tags to apply to the transit gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayRouteTable = list(
#'     TransitGatewayRouteTableId = "string",
#'     TransitGatewayId = "string",
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     DefaultAssociationRouteTable = TRUE|FALSE,
#'     DefaultPropagationRouteTable = TRUE|FALSE,
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_route_table(
#'   TransitGatewayId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_route_table
ec2_create_transit_gateway_route_table <- function(TransitGatewayId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_route_table_input(TransitGatewayId = TransitGatewayId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_route_table <- ec2_create_transit_gateway_route_table

#' Attaches the specified VPC to the specified transit gateway
#'
#' @description
#' Attaches the specified VPC to the specified transit gateway.
#' 
#' If you attach a VPC with a CIDR range that overlaps the CIDR range of a
#' VPC that is already attached, the new VPC CIDR range is not propagated
#' to the default propagation route table.
#' 
#' To send VPC traffic to an attached transit gateway, add a route to the
#' VPC route table using [`create_route`][ec2_create_route].
#'
#' @usage
#' ec2_create_transit_gateway_vpc_attachment(TransitGatewayId, VpcId,
#'   SubnetIds, Options, TagSpecifications, DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param SubnetIds &#91;required&#93; The IDs of one or more subnets. You can specify only one subnet per
#' Availability Zone. You must specify at least one subnet, but we
#' recommend that you specify two subnets for better availability. The
#' transit gateway uses one IP address from each specified subnet.
#' @param Options The VPC attachment options.
#' @param TagSpecifications The tags to apply to the VPC attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayVpcAttachment = list(
#'     TransitGatewayAttachmentId = "string",
#'     TransitGatewayId = "string",
#'     VpcId = "string",
#'     VpcOwnerId = "string",
#'     State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Options = list(
#'       DnsSupport = "enable"|"disable",
#'       Ipv6Support = "enable"|"disable",
#'       ApplianceModeSupport = "enable"|"disable"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_vpc_attachment(
#'   TransitGatewayId = "string",
#'   VpcId = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   Options = list(
#'     DnsSupport = "enable"|"disable",
#'     Ipv6Support = "enable"|"disable",
#'     ApplianceModeSupport = "enable"|"disable"
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_vpc_attachment
ec2_create_transit_gateway_vpc_attachment <- function(TransitGatewayId, VpcId, SubnetIds, Options = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_vpc_attachment_input(TransitGatewayId = TransitGatewayId, VpcId = VpcId, SubnetIds = SubnetIds, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_vpc_attachment <- ec2_create_transit_gateway_vpc_attachment

#' Creates an EBS volume that can be attached to an instance in the same
#' Availability Zone
#'
#' @description
#' Creates an EBS volume that can be attached to an instance in the same
#' Availability Zone.
#' 
#' You can create a new empty volume or restore a volume from an EBS
#' snapshot. Any AWS Marketplace product codes from the snapshot are
#' propagated to the volume.
#' 
#' You can create encrypted volumes. Encrypted volumes must be attached to
#' instances that support Amazon EBS encryption. Volumes that are created
#' from encrypted snapshots are also automatically encrypted. For more
#' information, see [Amazon EBS
#' encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' You can tag your volumes during creation. For more information, see
#' [Tagging your Amazon EC2
#' resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' For more information, see [Creating an Amazon EBS
#' volume](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_volume(AvailabilityZone, Encrypted, Iops, KmsKeyId,
#'   OutpostArn, Size, SnapshotId, VolumeType, DryRun, TagSpecifications,
#'   MultiAttachEnabled, Throughput)
#'
#' @param AvailabilityZone &#91;required&#93; The Availability Zone in which to create the volume.
#' @param Encrypted Indicates whether the volume should be encrypted. The effect of setting
#' the encryption state to `true` depends on the volume origin (new or from
#' a snapshot), starting encryption state, ownership, and whether
#' encryption by default is enabled. For more information, see [Encryption
#' by
#' default](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' Encrypted Amazon EBS volumes must be attached to instances that support
#' Amazon EBS encryption. For more information, see [Supported instance
#' types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances).
#' @param Iops The number of I/O operations per second (IOPS). For `gp3`, `io1`, and
#' `io2` volumes, this represents the number of IOPS that are provisioned
#' for the volume. For `gp2` volumes, this represents the baseline
#' performance of the volume and the rate at which the volume accumulates
#' I/O credits for bursting.
#' 
#' The following are the supported values for each volume type:
#' 
#' -   `gp3`: 3,000-16,000 IOPS
#' 
#' -   `io1`: 100-64,000 IOPS
#' 
#' -   `io2`: 100-64,000 IOPS
#' 
#' For `io1` and `io2` volumes, we guarantee 64,000 IOPS only for
#' [Instances built on the Nitro
#' System](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances).
#' Other instance families guarantee performance up to 32,000 IOPS.
#' 
#' This parameter is required for `io1` and `io2` volumes. The default for
#' `gp3` volumes is 3,000 IOPS. This parameter is not supported for `gp2`,
#' `st1`, `sc1`, or `standard` volumes.
#' @param KmsKeyId The identifier of the AWS Key Management Service (AWS KMS) customer
#' master key (CMK) to use for Amazon EBS encryption. If this parameter is
#' not specified, your AWS managed CMK for EBS is used. If `KmsKeyId` is
#' specified, the encrypted state must be `true`.
#' 
#' You can specify the CMK using any of the following:
#' 
#' -   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Key alias. For example, alias/ExampleAlias.
#' 
#' -   Key ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Alias ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
#' 
#' AWS authenticates the CMK asynchronously. Therefore, if you specify an
#' ID, alias, or ARN that is not valid, the action can appear to complete,
#' but eventually fails.
#' @param OutpostArn The Amazon Resource Name (ARN) of the Outpost.
#' @param Size The size of the volume, in GiBs. You must specify either a snapshot ID
#' or a volume size. If you specify a snapshot, the default is the snapshot
#' size. You can specify a volume size that is equal to or larger than the
#' snapshot size.
#' 
#' The following are the supported volumes sizes for each volume type:
#' 
#' -   `gp2` and `gp3`: 1-16,384
#' 
#' -   `io1` and `io2`: 4-16,384
#' 
#' -   `st1` and `sc1`: 125-16,384
#' 
#' -   `standard`: 1-1,024
#' @param SnapshotId The snapshot from which to create the volume. You must specify either a
#' snapshot ID or a volume size.
#' @param VolumeType The volume type. This parameter can be one of the following values:
#' 
#' -   General Purpose SSD: `gp2` | `gp3`
#' 
#' -   Provisioned IOPS SSD: `io1` | `io2`
#' 
#' -   Throughput Optimized HDD: `st1`
#' 
#' -   Cold HDD: `sc1`
#' 
#' -   Magnetic: `standard`
#' 
#' For more information, see [Amazon EBS volume
#' types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' Default: `gp2`
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param TagSpecifications The tags to apply to the volume during creation.
#' @param MultiAttachEnabled Indicates whether to enable Amazon EBS Multi-Attach. If you enable
#' Multi-Attach, you can attach the volume to up to 16 [Instances built on
#' the Nitro
#' System](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances)
#' in the same Availability Zone. This parameter is supported with `io1`
#' and `io2` volumes only. For more information, see [Amazon EBS
#' Multi-Attach](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param Throughput The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
#' 
#' This parameter is valid only for `gp3` volumes.
#' 
#' Valid Range: Minimum value of 125. Maximum value of 1000.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Attachments = list(
#'     list(
#'       AttachTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Device = "string",
#'       InstanceId = "string",
#'       State = "attaching"|"attached"|"detaching"|"detached"|"busy",
#'       VolumeId = "string",
#'       DeleteOnTermination = TRUE|FALSE
#'     )
#'   ),
#'   AvailabilityZone = "string",
#'   CreateTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Encrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   OutpostArn = "string",
#'   Size = 123,
#'   SnapshotId = "string",
#'   State = "creating"|"available"|"in-use"|"deleting"|"deleted"|"error",
#'   VolumeId = "string",
#'   Iops = 123,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
#'   FastRestored = TRUE|FALSE,
#'   MultiAttachEnabled = TRUE|FALSE,
#'   Throughput = 123
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_volume(
#'   AvailabilityZone = "string",
#'   Encrypted = TRUE|FALSE,
#'   Iops = 123,
#'   KmsKeyId = "string",
#'   OutpostArn = "string",
#'   Size = 123,
#'   SnapshotId = "string",
#'   VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
#'   DryRun = TRUE|FALSE,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   MultiAttachEnabled = TRUE|FALSE,
#'   Throughput = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates an 80 GiB General Purpose (SSD) volume in the
#' # Availability Zone `us-east-1a`.
#' svc$create_volume(
#'   AvailabilityZone = "us-east-1a",
#'   Size = 80L,
#'   VolumeType = "gp2"
#' )
#' 
#' # This example creates a new Provisioned IOPS (SSD) volume with 1000
#' # provisioned IOPS from a snapshot in the Availability Zone
#' # `us-east-1a`.
#' svc$create_volume(
#'   AvailabilityZone = "us-east-1a",
#'   Iops = 1000L,
#'   SnapshotId = "snap-066877671789bd71b",
#'   VolumeType = "io1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_volume
ec2_create_volume <- function(AvailabilityZone, Encrypted = NULL, Iops = NULL, KmsKeyId = NULL, OutpostArn = NULL, Size = NULL, SnapshotId = NULL, VolumeType = NULL, DryRun = NULL, TagSpecifications = NULL, MultiAttachEnabled = NULL, Throughput = NULL) {
  op <- new_operation(
    name = "CreateVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_volume_input(AvailabilityZone = AvailabilityZone, Encrypted = Encrypted, Iops = Iops, KmsKeyId = KmsKeyId, OutpostArn = OutpostArn, Size = Size, SnapshotId = SnapshotId, VolumeType = VolumeType, DryRun = DryRun, TagSpecifications = TagSpecifications, MultiAttachEnabled = MultiAttachEnabled, Throughput = Throughput)
  output <- .ec2$create_volume_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_volume <- ec2_create_volume

#' Creates a VPC with the specified IPv4 CIDR block
#'
#' @description
#' Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you
#' can create uses a /28 netmask (16 IPv4 addresses), and the largest uses
#' a /16 netmask (65,536 IPv4 addresses). For more information about how
#' large to make your VPC, see [Your VPC and
#' Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' You can optionally request an IPv6 CIDR block for the VPC. You can
#' request an Amazon-provided IPv6 CIDR block from Amazon's pool of IPv6
#' addresses, or an IPv6 CIDR block from an IPv6 address pool that you
#' provisioned through bring your own IP addresses
#' ([BYOIP](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)).
#' 
#' By default, each instance you launch in the VPC has the default DHCP
#' options, which include only a default DNS server that we provide
#' (AmazonProvidedDNS). For more information, see [DHCP Options
#' Sets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' You can specify the instance tenancy value for the VPC when you create
#' it. You can't change this value for the VPC after you create it. For
#' more information, see [Dedicated
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_vpc(CidrBlock, AmazonProvidedIpv6CidrBlock, Ipv6Pool,
#'   Ipv6CidrBlock, DryRun, InstanceTenancy, Ipv6CidrBlockNetworkBorderGroup,
#'   TagSpecifications)
#'
#' @param CidrBlock &#91;required&#93; The IPv4 network range for the VPC, in CIDR notation. For example,
#' `10.0.0.0/16`. We modify the specified CIDR block to its canonical form;
#' for example, if you specify `100.68.0.18/18`, we modify it to
#' `100.68.0.0/18`.
#' @param AmazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
#' the VPC. You cannot specify the range of IP addresses, or the size of
#' the CIDR block.
#' @param Ipv6Pool The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
#' block.
#' @param Ipv6CidrBlock The IPv6 CIDR block from the IPv6 address pool. You must also specify
#' `Ipv6Pool` in the request.
#' 
#' To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTenancy The tenancy options for instances launched into the VPC. For `default`,
#' instances are launched with shared tenancy by default. You can launch
#' instances with any tenancy into a shared tenancy VPC. For `dedicated`,
#' instances are launched as dedicated tenancy instances by default. You
#' can only launch instances with a tenancy of `dedicated` or `host` into a
#' dedicated tenancy VPC.
#' 
#' **Important:** The `host` value cannot be used with this parameter. Use
#' the `default` or `dedicated` values only.
#' 
#' Default: `default`
#' @param Ipv6CidrBlockNetworkBorderGroup The name of the location from which we advertise the IPV6 CIDR block.
#' Use this parameter to limit the address to this location.
#' 
#' You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
#' parameter.
#' @param TagSpecifications The tags to assign to the VPC.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Vpc = list(
#'     CidrBlock = "string",
#'     DhcpOptionsId = "string",
#'     State = "pending"|"available",
#'     VpcId = "string",
#'     OwnerId = "string",
#'     InstanceTenancy = "default"|"dedicated"|"host",
#'     Ipv6CidrBlockAssociationSet = list(
#'       list(
#'         AssociationId = "string",
#'         Ipv6CidrBlock = "string",
#'         Ipv6CidrBlockState = list(
#'           State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
#'           StatusMessage = "string"
#'         ),
#'         NetworkBorderGroup = "string",
#'         Ipv6Pool = "string"
#'       )
#'     ),
#'     CidrBlockAssociationSet = list(
#'       list(
#'         AssociationId = "string",
#'         CidrBlock = "string",
#'         CidrBlockState = list(
#'           State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
#'           StatusMessage = "string"
#'         )
#'       )
#'     ),
#'     IsDefault = TRUE|FALSE,
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc(
#'   CidrBlock = "string",
#'   AmazonProvidedIpv6CidrBlock = TRUE|FALSE,
#'   Ipv6Pool = "string",
#'   Ipv6CidrBlock = "string",
#'   DryRun = TRUE|FALSE,
#'   InstanceTenancy = "default"|"dedicated"|"host",
#'   Ipv6CidrBlockNetworkBorderGroup = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a VPC with the specified CIDR block.
#' svc$create_vpc(
#'   CidrBlock = "10.0.0.0/16"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc
ec2_create_vpc <- function(CidrBlock, AmazonProvidedIpv6CidrBlock = NULL, Ipv6Pool = NULL, Ipv6CidrBlock = NULL, DryRun = NULL, InstanceTenancy = NULL, Ipv6CidrBlockNetworkBorderGroup = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_input(CidrBlock = CidrBlock, AmazonProvidedIpv6CidrBlock = AmazonProvidedIpv6CidrBlock, Ipv6Pool = Ipv6Pool, Ipv6CidrBlock = Ipv6CidrBlock, DryRun = DryRun, InstanceTenancy = InstanceTenancy, Ipv6CidrBlockNetworkBorderGroup = Ipv6CidrBlockNetworkBorderGroup, TagSpecifications = TagSpecifications)
  output <- .ec2$create_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc <- ec2_create_vpc

#' Creates a VPC endpoint for a specified service
#'
#' @description
#' Creates a VPC endpoint for a specified service. An endpoint enables you
#' to create a private connection between your VPC and the service. The
#' service may be provided by AWS, an AWS Marketplace Partner, or another
#' AWS account. For more information, see [VPC
#' Endpoints](https://docs.aws.amazon.com/vpc/latest/privatelink/vpc-endpoints.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' A `gateway` endpoint serves as a target for a route in your route table
#' for traffic destined for the AWS service. You can specify an endpoint
#' policy to attach to the endpoint, which will control access to the
#' service from your VPC. You can also specify the VPC route tables that
#' use the endpoint.
#' 
#' An `interface` endpoint is a network interface in your subnet that
#' serves as an endpoint for communicating with the specified service. You
#' can specify the subnets in which to create an endpoint, and the security
#' groups to associate with the endpoint network interface.
#' 
#' A `GatewayLoadBalancer` endpoint is a network interface in your subnet
#' that serves an endpoint for communicating with a Gateway Load Balancer
#' that you've configured as a VPC endpoint service.
#' 
#' Use
#' [`describe_vpc_endpoint_services`][ec2_describe_vpc_endpoint_services]
#' to get a list of supported services.
#'
#' @usage
#' ec2_create_vpc_endpoint(DryRun, VpcEndpointType, VpcId, ServiceName,
#'   PolicyDocument, RouteTableIds, SubnetIds, SecurityGroupIds, ClientToken,
#'   PrivateDnsEnabled, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointType The type of endpoint.
#' 
#' Default: Gateway
#' @param VpcId &#91;required&#93; The ID of the VPC in which the endpoint will be used.
#' @param ServiceName &#91;required&#93; The service name. To get a list of available services, use the
#' [`describe_vpc_endpoint_services`][ec2_describe_vpc_endpoint_services]
#' request, or get the name from the service provider.
#' @param PolicyDocument (Interface and gateway endpoints) A policy to attach to the endpoint
#' that controls access to the service. The policy must be in valid JSON
#' format. If this parameter is not specified, we attach a default policy
#' that allows full access to the service.
#' @param RouteTableIds (Gateway endpoint) One or more route table IDs.
#' @param SubnetIds (Interface and Gateway Load Balancer endpoints) The ID of one or more
#' subnets in which to create an endpoint network interface. For a Gateway
#' Load Balancer endpoint, you can specify one subnet only.
#' @param SecurityGroupIds (Interface endpoint) The ID of one or more security groups to associate
#' with the endpoint network interface.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param PrivateDnsEnabled (Interface endpoint) Indicates whether to associate a private hosted
#' zone with the specified VPC. The private hosted zone contains a record
#' set for the default public DNS name for the service for the Region (for
#' example, `kinesis.us-east-1.amazonaws.com`), which resolves to the
#' private IP addresses of the endpoint network interfaces in the VPC. This
#' enables you to make requests to the default public DNS name for the
#' service instead of the public DNS names that are automatically generated
#' by the VPC endpoint service.
#' 
#' To use a private hosted zone, you must set the following VPC attributes
#' to `true`: `enableDnsHostnames` and `enableDnsSupport`. Use
#' [`modify_vpc_attribute`][ec2_modify_vpc_attribute] to set the VPC
#' attributes.
#' 
#' Default: `true`
#' @param TagSpecifications The tags to associate with the endpoint.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   VpcEndpoint = list(
#'     VpcEndpointId = "string",
#'     VpcEndpointType = "Interface"|"Gateway"|"GatewayLoadBalancer",
#'     VpcId = "string",
#'     ServiceName = "string",
#'     State = "PendingAcceptance"|"Pending"|"Available"|"Deleting"|"Deleted"|"Rejected"|"Failed"|"Expired",
#'     PolicyDocument = "string",
#'     RouteTableIds = list(
#'       "string"
#'     ),
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     Groups = list(
#'       list(
#'         GroupId = "string",
#'         GroupName = "string"
#'       )
#'     ),
#'     PrivateDnsEnabled = TRUE|FALSE,
#'     RequesterManaged = TRUE|FALSE,
#'     NetworkInterfaceIds = list(
#'       "string"
#'     ),
#'     DnsEntries = list(
#'       list(
#'         DnsName = "string",
#'         HostedZoneId = "string"
#'       )
#'     ),
#'     CreationTimestamp = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     OwnerId = "string",
#'     LastError = list(
#'       Message = "string",
#'       Code = "string"
#'     )
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc_endpoint(
#'   DryRun = TRUE|FALSE,
#'   VpcEndpointType = "Interface"|"Gateway"|"GatewayLoadBalancer",
#'   VpcId = "string",
#'   ServiceName = "string",
#'   PolicyDocument = "string",
#'   RouteTableIds = list(
#'     "string"
#'   ),
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   ClientToken = "string",
#'   PrivateDnsEnabled = TRUE|FALSE,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_endpoint
ec2_create_vpc_endpoint <- function(DryRun = NULL, VpcEndpointType = NULL, VpcId, ServiceName, PolicyDocument = NULL, RouteTableIds = NULL, SubnetIds = NULL, SecurityGroupIds = NULL, ClientToken = NULL, PrivateDnsEnabled = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_endpoint_input(DryRun = DryRun, VpcEndpointType = VpcEndpointType, VpcId = VpcId, ServiceName = ServiceName, PolicyDocument = PolicyDocument, RouteTableIds = RouteTableIds, SubnetIds = SubnetIds, SecurityGroupIds = SecurityGroupIds, ClientToken = ClientToken, PrivateDnsEnabled = PrivateDnsEnabled, TagSpecifications = TagSpecifications)
  output <- .ec2$create_vpc_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_endpoint <- ec2_create_vpc_endpoint

#' Creates a connection notification for a specified VPC endpoint or VPC
#' endpoint service
#'
#' @description
#' Creates a connection notification for a specified VPC endpoint or VPC
#' endpoint service. A connection notification notifies you of specific
#' endpoint events. You must create an SNS topic to receive notifications.
#' For more information, see [Create a
#' Topic](https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html)
#' in the *Amazon Simple Notification Service Developer Guide*.
#' 
#' You can create a connection notification for interface endpoints only.
#'
#' @usage
#' ec2_create_vpc_endpoint_connection_notification(DryRun, ServiceId,
#'   VpcEndpointId, ConnectionNotificationArn, ConnectionEvents, ClientToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceId The ID of the endpoint service.
#' @param VpcEndpointId The ID of the endpoint.
#' @param ConnectionNotificationArn &#91;required&#93; The ARN of the SNS topic for the notifications.
#' @param ConnectionEvents &#91;required&#93; One or more endpoint events for which to receive notifications. Valid
#' values are `Accept`, `Connect`, `Delete`, and `Reject`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConnectionNotification = list(
#'     ConnectionNotificationId = "string",
#'     ServiceId = "string",
#'     VpcEndpointId = "string",
#'     ConnectionNotificationType = "Topic",
#'     ConnectionNotificationArn = "string",
#'     ConnectionEvents = list(
#'       "string"
#'     ),
#'     ConnectionNotificationState = "Enabled"|"Disabled"
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc_endpoint_connection_notification(
#'   DryRun = TRUE|FALSE,
#'   ServiceId = "string",
#'   VpcEndpointId = "string",
#'   ConnectionNotificationArn = "string",
#'   ConnectionEvents = list(
#'     "string"
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_endpoint_connection_notification
ec2_create_vpc_endpoint_connection_notification <- function(DryRun = NULL, ServiceId = NULL, VpcEndpointId = NULL, ConnectionNotificationArn, ConnectionEvents, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpointConnectionNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_endpoint_connection_notification_input(DryRun = DryRun, ServiceId = ServiceId, VpcEndpointId = VpcEndpointId, ConnectionNotificationArn = ConnectionNotificationArn, ConnectionEvents = ConnectionEvents, ClientToken = ClientToken)
  output <- .ec2$create_vpc_endpoint_connection_notification_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_endpoint_connection_notification <- ec2_create_vpc_endpoint_connection_notification

#' Creates a VPC endpoint service configuration to which service consumers
#' (AWS accounts, IAM users, and IAM roles) can connect
#'
#' @description
#' Creates a VPC endpoint service configuration to which service consumers
#' (AWS accounts, IAM users, and IAM roles) can connect.
#' 
#' To create an endpoint service configuration, you must first create one
#' of the following for your service:
#' 
#' -   A [Network Load
#'     Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html).
#'     Service consumers connect to your service using an interface
#'     endpoint.
#' 
#' -   A [Gateway Load
#'     Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/introduction.html).
#'     Service consumers connect to your service using a Gateway Load
#'     Balancer endpoint.
#' 
#' For more information, see [VPC Endpoint
#' Services](https://docs.aws.amazon.com/vpc/latest/privatelink/endpoint-service.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' If you set the private DNS name, you must prove that you own the private
#' DNS domain name. For more information, see [VPC Endpoint Service Private
#' DNS Name
#' Verification](https://docs.aws.amazon.com/vpc/latest/privatelink/endpoint-services-dns-validation.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_vpc_endpoint_service_configuration(DryRun,
#'   AcceptanceRequired, PrivateDnsName, NetworkLoadBalancerArns,
#'   GatewayLoadBalancerArns, ClientToken, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param AcceptanceRequired Indicates whether requests from service consumers to create an endpoint
#' to your service must be accepted. To accept a request, use
#' [`accept_vpc_endpoint_connections`][ec2_accept_vpc_endpoint_connections].
#' @param PrivateDnsName (Interface endpoint configuration) The private DNS name to assign to the
#' VPC endpoint service.
#' @param NetworkLoadBalancerArns The Amazon Resource Names (ARNs) of one or more Network Load Balancers
#' for your service.
#' @param GatewayLoadBalancerArns The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param TagSpecifications The tags to associate with the service.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceConfiguration = list(
#'     ServiceType = list(
#'       list(
#'         ServiceType = "Interface"|"Gateway"|"GatewayLoadBalancer"
#'       )
#'     ),
#'     ServiceId = "string",
#'     ServiceName = "string",
#'     ServiceState = "Pending"|"Available"|"Deleting"|"Deleted"|"Failed",
#'     AvailabilityZones = list(
#'       "string"
#'     ),
#'     AcceptanceRequired = TRUE|FALSE,
#'     ManagesVpcEndpoints = TRUE|FALSE,
#'     NetworkLoadBalancerArns = list(
#'       "string"
#'     ),
#'     GatewayLoadBalancerArns = list(
#'       "string"
#'     ),
#'     BaseEndpointDnsNames = list(
#'       "string"
#'     ),
#'     PrivateDnsName = "string",
#'     PrivateDnsNameConfiguration = list(
#'       State = "pendingVerification"|"verified"|"failed",
#'       Type = "string",
#'       Value = "string",
#'       Name = "string"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc_endpoint_service_configuration(
#'   DryRun = TRUE|FALSE,
#'   AcceptanceRequired = TRUE|FALSE,
#'   PrivateDnsName = "string",
#'   NetworkLoadBalancerArns = list(
#'     "string"
#'   ),
#'   GatewayLoadBalancerArns = list(
#'     "string"
#'   ),
#'   ClientToken = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_endpoint_service_configuration
ec2_create_vpc_endpoint_service_configuration <- function(DryRun = NULL, AcceptanceRequired = NULL, PrivateDnsName = NULL, NetworkLoadBalancerArns = NULL, GatewayLoadBalancerArns = NULL, ClientToken = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpointServiceConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_endpoint_service_configuration_input(DryRun = DryRun, AcceptanceRequired = AcceptanceRequired, PrivateDnsName = PrivateDnsName, NetworkLoadBalancerArns = NetworkLoadBalancerArns, GatewayLoadBalancerArns = GatewayLoadBalancerArns, ClientToken = ClientToken, TagSpecifications = TagSpecifications)
  output <- .ec2$create_vpc_endpoint_service_configuration_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_endpoint_service_configuration <- ec2_create_vpc_endpoint_service_configuration

#' Requests a VPC peering connection between two VPCs: a requester VPC that
#' you own and an accepter VPC with which to create the connection
#'
#' @description
#' Requests a VPC peering connection between two VPCs: a requester VPC that
#' you own and an accepter VPC with which to create the connection. The
#' accepter VPC can belong to another AWS account and can be in a different
#' Region to the requester VPC. The requester VPC and accepter VPC cannot
#' have overlapping CIDR blocks.
#' 
#' Limitations and rules apply to a VPC peering connection. For more
#' information, see the
#' [limitations](https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations)
#' section in the *VPC Peering Guide*.
#' 
#' The owner of the accepter VPC must accept the peering request to
#' activate the peering connection. The VPC peering connection request
#' expires after 7 days, after which it cannot be accepted or rejected.
#' 
#' If you create a VPC peering connection request between VPCs with
#' overlapping CIDR blocks, the VPC peering connection has a status of
#' `failed`.
#'
#' @usage
#' ec2_create_vpc_peering_connection(DryRun, PeerOwnerId, PeerVpcId, VpcId,
#'   PeerRegion, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param PeerOwnerId The AWS account ID of the owner of the accepter VPC.
#' 
#' Default: Your AWS account ID
#' @param PeerVpcId The ID of the VPC with which you are creating the VPC peering
#' connection. You must specify this parameter in the request.
#' @param VpcId The ID of the requester VPC. You must specify this parameter in the
#' request.
#' @param PeerRegion The Region code for the accepter VPC, if the accepter VPC is located in
#' a Region other than the Region in which you make the request.
#' 
#' Default: The Region in which you make the request.
#' @param TagSpecifications The tags to assign to the peering connection.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   VpcPeeringConnection = list(
#'     AccepterVpcInfo = list(
#'       CidrBlock = "string",
#'       Ipv6CidrBlockSet = list(
#'         list(
#'           Ipv6CidrBlock = "string"
#'         )
#'       ),
#'       CidrBlockSet = list(
#'         list(
#'           CidrBlock = "string"
#'         )
#'       ),
#'       OwnerId = "string",
#'       PeeringOptions = list(
#'         AllowDnsResolutionFromRemoteVpc = TRUE|FALSE,
#'         AllowEgressFromLocalClassicLinkToRemoteVpc = TRUE|FALSE,
#'         AllowEgressFromLocalVpcToRemoteClassicLink = TRUE|FALSE
#'       ),
#'       VpcId = "string",
#'       Region = "string"
#'     ),
#'     ExpirationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     RequesterVpcInfo = list(
#'       CidrBlock = "string",
#'       Ipv6CidrBlockSet = list(
#'         list(
#'           Ipv6CidrBlock = "string"
#'         )
#'       ),
#'       CidrBlockSet = list(
#'         list(
#'           CidrBlock = "string"
#'         )
#'       ),
#'       OwnerId = "string",
#'       PeeringOptions = list(
#'         AllowDnsResolutionFromRemoteVpc = TRUE|FALSE,
#'         AllowEgressFromLocalClassicLinkToRemoteVpc = TRUE|FALSE,
#'         AllowEgressFromLocalVpcToRemoteClassicLink = TRUE|FALSE
#'       ),
#'       VpcId = "string",
#'       Region = "string"
#'     ),
#'     Status = list(
#'       Code = "initiating-request"|"pending-acceptance"|"active"|"deleted"|"rejected"|"failed"|"expired"|"provisioning"|"deleting",
#'       Message = "string"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     VpcPeeringConnectionId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc_peering_connection(
#'   DryRun = TRUE|FALSE,
#'   PeerOwnerId = "string",
#'   PeerVpcId = "string",
#'   VpcId = "string",
#'   PeerRegion = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_peering_connection
ec2_create_vpc_peering_connection <- function(DryRun = NULL, PeerOwnerId = NULL, PeerVpcId = NULL, VpcId = NULL, PeerRegion = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateVpcPeeringConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_peering_connection_input(DryRun = DryRun, PeerOwnerId = PeerOwnerId, PeerVpcId = PeerVpcId, VpcId = VpcId, PeerRegion = PeerRegion, TagSpecifications = TagSpecifications)
  output <- .ec2$create_vpc_peering_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_peering_connection <- ec2_create_vpc_peering_connection

#' Creates a VPN connection between an existing virtual private gateway or
#' transit gateway and a customer gateway
#'
#' @description
#' Creates a VPN connection between an existing virtual private gateway or
#' transit gateway and a customer gateway. The supported connection type is
#' `ipsec.1`.
#' 
#' The response includes information that you need to give to your network
#' administrator to configure your customer gateway.
#' 
#' We strongly recommend that you use HTTPS when calling this operation
#' because the response contains sensitive cryptographic information for
#' configuring your customer gateway device.
#' 
#' If you decide to shut down your VPN connection for any reason and later
#' create a new VPN connection, you must reconfigure your customer gateway
#' with the new information returned from this call.
#' 
#' This is an idempotent operation. If you perform the operation more than
#' once, Amazon EC2 doesn't return an error.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_create_vpn_connection(CustomerGatewayId, Type, VpnGatewayId,
#'   TransitGatewayId, DryRun, Options, TagSpecifications)
#'
#' @param CustomerGatewayId &#91;required&#93; The ID of the customer gateway.
#' @param Type &#91;required&#93; The type of VPN connection (`ipsec.1`).
#' @param VpnGatewayId The ID of the virtual private gateway. If you specify a virtual private
#' gateway, you cannot specify a transit gateway.
#' @param TransitGatewayId The ID of the transit gateway. If you specify a transit gateway, you
#' cannot specify a virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Options The options for the VPN connection.
#' @param TagSpecifications The tags to apply to the VPN connection.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   VpnConnection = list(
#'     CustomerGatewayConfiguration = "string",
#'     CustomerGatewayId = "string",
#'     Category = "string",
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     Type = "ipsec.1",
#'     VpnConnectionId = "string",
#'     VpnGatewayId = "string",
#'     TransitGatewayId = "string",
#'     Options = list(
#'       EnableAcceleration = TRUE|FALSE,
#'       StaticRoutesOnly = TRUE|FALSE,
#'       LocalIpv4NetworkCidr = "string",
#'       RemoteIpv4NetworkCidr = "string",
#'       LocalIpv6NetworkCidr = "string",
#'       RemoteIpv6NetworkCidr = "string",
#'       TunnelInsideIpVersion = "ipv4"|"ipv6",
#'       TunnelOptions = list(
#'         list(
#'           OutsideIpAddress = "string",
#'           TunnelInsideCidr = "string",
#'           TunnelInsideIpv6Cidr = "string",
#'           PreSharedKey = "string",
#'           Phase1LifetimeSeconds = 123,
#'           Phase2LifetimeSeconds = 123,
#'           RekeyMarginTimeSeconds = 123,
#'           RekeyFuzzPercentage = 123,
#'           ReplayWindowSize = 123,
#'           DpdTimeoutSeconds = 123,
#'           DpdTimeoutAction = "string",
#'           Phase1EncryptionAlgorithms = list(
#'             list(
#'               Value = "string"
#'             )
#'           ),
#'           Phase2EncryptionAlgorithms = list(
#'             list(
#'               Value = "string"
#'             )
#'           ),
#'           Phase1IntegrityAlgorithms = list(
#'             list(
#'               Value = "string"
#'             )
#'           ),
#'           Phase2IntegrityAlgorithms = list(
#'             list(
#'               Value = "string"
#'             )
#'           ),
#'           Phase1DHGroupNumbers = list(
#'             list(
#'               Value = 123
#'             )
#'           ),
#'           Phase2DHGroupNumbers = list(
#'             list(
#'               Value = 123
#'             )
#'           ),
#'           IkeVersions = list(
#'             list(
#'               Value = "string"
#'             )
#'           ),
#'           StartupAction = "string"
#'         )
#'       )
#'     ),
#'     Routes = list(
#'       list(
#'         DestinationCidrBlock = "string",
#'         Source = "Static",
#'         State = "pending"|"available"|"deleting"|"deleted"
#'       )
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     VgwTelemetry = list(
#'       list(
#'         AcceptedRouteCount = 123,
#'         LastStatusChange = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         OutsideIpAddress = "string",
#'         Status = "UP"|"DOWN",
#'         StatusMessage = "string",
#'         CertificateArn = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_vpn_connection(
#'   CustomerGatewayId = "string",
#'   Type = "string",
#'   VpnGatewayId = "string",
#'   TransitGatewayId = "string",
#'   DryRun = TRUE|FALSE,
#'   Options = list(
#'     EnableAcceleration = TRUE|FALSE,
#'     StaticRoutesOnly = TRUE|FALSE,
#'     TunnelInsideIpVersion = "ipv4"|"ipv6",
#'     TunnelOptions = list(
#'       list(
#'         TunnelInsideCidr = "string",
#'         TunnelInsideIpv6Cidr = "string",
#'         PreSharedKey = "string",
#'         Phase1LifetimeSeconds = 123,
#'         Phase2LifetimeSeconds = 123,
#'         RekeyMarginTimeSeconds = 123,
#'         RekeyFuzzPercentage = 123,
#'         ReplayWindowSize = 123,
#'         DPDTimeoutSeconds = 123,
#'         DPDTimeoutAction = "string",
#'         Phase1EncryptionAlgorithms = list(
#'           list(
#'             Value = "string"
#'           )
#'         ),
#'         Phase2EncryptionAlgorithms = list(
#'           list(
#'             Value = "string"
#'           )
#'         ),
#'         Phase1IntegrityAlgorithms = list(
#'           list(
#'             Value = "string"
#'           )
#'         ),
#'         Phase2IntegrityAlgorithms = list(
#'           list(
#'             Value = "string"
#'           )
#'         ),
#'         Phase1DHGroupNumbers = list(
#'           list(
#'             Value = 123
#'           )
#'         ),
#'         Phase2DHGroupNumbers = list(
#'           list(
#'             Value = 123
#'           )
#'         ),
#'         IKEVersions = list(
#'           list(
#'             Value = "string"
#'           )
#'         ),
#'         StartupAction = "string"
#'       )
#'     ),
#'     LocalIpv4NetworkCidr = "string",
#'     RemoteIpv4NetworkCidr = "string",
#'     LocalIpv6NetworkCidr = "string",
#'     RemoteIpv6NetworkCidr = "string"
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpn_connection
ec2_create_vpn_connection <- function(CustomerGatewayId, Type, VpnGatewayId = NULL, TransitGatewayId = NULL, DryRun = NULL, Options = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateVpnConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpn_connection_input(CustomerGatewayId = CustomerGatewayId, Type = Type, VpnGatewayId = VpnGatewayId, TransitGatewayId = TransitGatewayId, DryRun = DryRun, Options = Options, TagSpecifications = TagSpecifications)
  output <- .ec2$create_vpn_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpn_connection <- ec2_create_vpn_connection

#' Creates a static route associated with a VPN connection between an
#' existing virtual private gateway and a VPN customer gateway
#'
#' @description
#' Creates a static route associated with a VPN connection between an
#' existing virtual private gateway and a VPN customer gateway. The static
#' route allows traffic to be routed from the virtual private gateway to
#' the VPN customer gateway.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_create_vpn_connection_route(DestinationCidrBlock, VpnConnectionId)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR block associated with the local subnet of the customer network.
#' @param VpnConnectionId &#91;required&#93; The ID of the VPN connection.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_vpn_connection_route(
#'   DestinationCidrBlock = "string",
#'   VpnConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpn_connection_route
ec2_create_vpn_connection_route <- function(DestinationCidrBlock, VpnConnectionId) {
  op <- new_operation(
    name = "CreateVpnConnectionRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpn_connection_route_input(DestinationCidrBlock = DestinationCidrBlock, VpnConnectionId = VpnConnectionId)
  output <- .ec2$create_vpn_connection_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpn_connection_route <- ec2_create_vpn_connection_route

#' Creates a virtual private gateway
#'
#' @description
#' Creates a virtual private gateway. A virtual private gateway is the
#' endpoint on the VPC side of your VPN connection. You can create a
#' virtual private gateway before creating the VPC itself.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_create_vpn_gateway(AvailabilityZone, Type, TagSpecifications,
#'   AmazonSideAsn, DryRun)
#'
#' @param AvailabilityZone The Availability Zone for the virtual private gateway.
#' @param Type &#91;required&#93; The type of VPN connection this virtual private gateway supports.
#' @param TagSpecifications The tags to apply to the virtual private gateway.
#' @param AmazonSideAsn A private Autonomous System Number (ASN) for the Amazon side of a BGP
#' session. If you're using a 16-bit ASN, it must be in the 64512 to 65534
#' range. If you're using a 32-bit ASN, it must be in the 4200000000 to
#' 4294967294 range.
#' 
#' Default: 64512
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   VpnGateway = list(
#'     AvailabilityZone = "string",
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     Type = "ipsec.1",
#'     VpcAttachments = list(
#'       list(
#'         State = "attaching"|"attached"|"detaching"|"detached",
#'         VpcId = "string"
#'       )
#'     ),
#'     VpnGatewayId = "string",
#'     AmazonSideAsn = 123,
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_vpn_gateway(
#'   AvailabilityZone = "string",
#'   Type = "ipsec.1",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   AmazonSideAsn = 123,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpn_gateway
ec2_create_vpn_gateway <- function(AvailabilityZone = NULL, Type, TagSpecifications = NULL, AmazonSideAsn = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateVpnGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpn_gateway_input(AvailabilityZone = AvailabilityZone, Type = Type, TagSpecifications = TagSpecifications, AmazonSideAsn = AmazonSideAsn, DryRun = DryRun)
  output <- .ec2$create_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpn_gateway <- ec2_create_vpn_gateway

#' Deletes a carrier gateway
#'
#' @description
#' Deletes a carrier gateway.
#' 
#' If you do not delete the route that contains the carrier gateway as the
#' Target, the route is a blackhole route. For information about how to
#' delete a route, see [`delete_route`][ec2_delete_route].
#'
#' @usage
#' ec2_delete_carrier_gateway(CarrierGatewayId, DryRun)
#'
#' @param CarrierGatewayId &#91;required&#93; The ID of the carrier gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CarrierGateway = list(
#'     CarrierGatewayId = "string",
#'     VpcId = "string",
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     OwnerId = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_carrier_gateway(
#'   CarrierGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_carrier_gateway
ec2_delete_carrier_gateway <- function(CarrierGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteCarrierGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_carrier_gateway_input(CarrierGatewayId = CarrierGatewayId, DryRun = DryRun)
  output <- .ec2$delete_carrier_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_carrier_gateway <- ec2_delete_carrier_gateway

#' Deletes the specified Client VPN endpoint
#'
#' @description
#' Deletes the specified Client VPN endpoint. You must disassociate all
#' target networks before you can delete a Client VPN endpoint.
#'
#' @usage
#' ec2_delete_client_vpn_endpoint(ClientVpnEndpointId, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN to be deleted.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Status = list(
#'     Code = "pending-associate"|"available"|"deleting"|"deleted",
#'     Message = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_client_vpn_endpoint(
#'   ClientVpnEndpointId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_client_vpn_endpoint
ec2_delete_client_vpn_endpoint <- function(ClientVpnEndpointId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteClientVpnEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_client_vpn_endpoint_input(ClientVpnEndpointId = ClientVpnEndpointId, DryRun = DryRun)
  output <- .ec2$delete_client_vpn_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_client_vpn_endpoint <- ec2_delete_client_vpn_endpoint

#' Deletes a route from a Client VPN endpoint
#'
#' @description
#' Deletes a route from a Client VPN endpoint. You can only delete routes
#' that you manually added using the **CreateClientVpnRoute** action. You
#' cannot delete routes that were automatically added when associating a
#' subnet. To remove routes that have been automatically added,
#' disassociate the target subnet from the Client VPN endpoint.
#'
#' @usage
#' ec2_delete_client_vpn_route(ClientVpnEndpointId, TargetVpcSubnetId,
#'   DestinationCidrBlock, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint from which the route is to be deleted.
#' @param TargetVpcSubnetId The ID of the target subnet used by the route.
#' @param DestinationCidrBlock &#91;required&#93; The IPv4 address range, in CIDR notation, of the route to be deleted.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Status = list(
#'     Code = "creating"|"active"|"failed"|"deleting",
#'     Message = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_client_vpn_route(
#'   ClientVpnEndpointId = "string",
#'   TargetVpcSubnetId = "string",
#'   DestinationCidrBlock = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_client_vpn_route
ec2_delete_client_vpn_route <- function(ClientVpnEndpointId, TargetVpcSubnetId = NULL, DestinationCidrBlock, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteClientVpnRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_client_vpn_route_input(ClientVpnEndpointId = ClientVpnEndpointId, TargetVpcSubnetId = TargetVpcSubnetId, DestinationCidrBlock = DestinationCidrBlock, DryRun = DryRun)
  output <- .ec2$delete_client_vpn_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_client_vpn_route <- ec2_delete_client_vpn_route

#' Deletes the specified customer gateway
#'
#' @description
#' Deletes the specified customer gateway. You must delete the VPN
#' connection before you can delete the customer gateway.
#'
#' @usage
#' ec2_delete_customer_gateway(CustomerGatewayId, DryRun)
#'
#' @param CustomerGatewayId &#91;required&#93; The ID of the customer gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_customer_gateway(
#'   CustomerGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified customer gateway.
#' svc$delete_customer_gateway(
#'   CustomerGatewayId = "cgw-0e11f167"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_customer_gateway
ec2_delete_customer_gateway <- function(CustomerGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteCustomerGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_customer_gateway_input(CustomerGatewayId = CustomerGatewayId, DryRun = DryRun)
  output <- .ec2$delete_customer_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_customer_gateway <- ec2_delete_customer_gateway

#' Deletes the specified set of DHCP options
#'
#' @description
#' Deletes the specified set of DHCP options. You must disassociate the set
#' of DHCP options before you can delete it. You can disassociate the set
#' of DHCP options by associating either a new set of options or the
#' default set of options with the VPC.
#'
#' @usage
#' ec2_delete_dhcp_options(DhcpOptionsId, DryRun)
#'
#' @param DhcpOptionsId &#91;required&#93; The ID of the DHCP options set.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dhcp_options(
#'   DhcpOptionsId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified DHCP options set.
#' svc$delete_dhcp_options(
#'   DhcpOptionsId = "dopt-d9070ebb"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_dhcp_options
ec2_delete_dhcp_options <- function(DhcpOptionsId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteDhcpOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_dhcp_options_input(DhcpOptionsId = DhcpOptionsId, DryRun = DryRun)
  output <- .ec2$delete_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_dhcp_options <- ec2_delete_dhcp_options

#' Deletes an egress-only internet gateway
#'
#' @description
#' Deletes an egress-only internet gateway.
#'
#' @usage
#' ec2_delete_egress_only_internet_gateway(DryRun,
#'   EgressOnlyInternetGatewayId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EgressOnlyInternetGatewayId &#91;required&#93; The ID of the egress-only internet gateway.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ReturnCode = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_egress_only_internet_gateway(
#'   DryRun = TRUE|FALSE,
#'   EgressOnlyInternetGatewayId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_egress_only_internet_gateway
ec2_delete_egress_only_internet_gateway <- function(DryRun = NULL, EgressOnlyInternetGatewayId) {
  op <- new_operation(
    name = "DeleteEgressOnlyInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_egress_only_internet_gateway_input(DryRun = DryRun, EgressOnlyInternetGatewayId = EgressOnlyInternetGatewayId)
  output <- .ec2$delete_egress_only_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_egress_only_internet_gateway <- ec2_delete_egress_only_internet_gateway

#' Deletes the specified EC2 Fleet
#'
#' @description
#' Deletes the specified EC2 Fleet.
#' 
#' After you delete an EC2 Fleet, it launches no new instances.
#' 
#' You must specify whether a deleted EC2 Fleet should also terminate its
#' instances. If you choose to terminate the instances, the EC2 Fleet
#' enters the `deleted_terminating` state. Otherwise, the EC2 Fleet enters
#' the `deleted_running` state, and the instances continue to run until
#' they are interrupted or you terminate them manually.
#' 
#' For `instant` fleets, EC2 Fleet must terminate the instances when the
#' fleet is deleted. A deleted `instant` fleet with running instances is
#' not supported.
#' 
#' **Restrictions**
#' 
#' -   You can delete up to 25 `instant` fleets in a single request. If you
#'     exceed this number, no `instant` fleets are deleted and an error is
#'     returned. There is no restriction on the number of fleets of type
#'     `maintain` or `request` that can be deleted in a single request.
#' 
#' -   Up to 1000 instances can be terminated in a single request to delete
#'     `instant` fleets.
#' 
#' For more information, see [Deleting an EC2
#' Fleet](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_delete_fleets(DryRun, FleetIds, TerminateInstances)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FleetIds &#91;required&#93; The IDs of the EC2 Fleets.
#' @param TerminateInstances &#91;required&#93; Indicates whether to terminate the instances when the EC2 Fleet is
#' deleted. The default is to terminate the instances.
#' 
#' To let the instances continue to run after the EC2 Fleet is deleted,
#' specify `NoTerminateInstances`. Supported only for fleets of type
#' `maintain` and `request`.
#' 
#' For `instant` fleets, you cannot specify `NoTerminateInstances`. A
#' deleted `instant` fleet with running instances is not supported.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SuccessfulFleetDeletions = list(
#'     list(
#'       CurrentFleetState = "submitted"|"active"|"deleted"|"failed"|"deleted_running"|"deleted_terminating"|"modifying",
#'       PreviousFleetState = "submitted"|"active"|"deleted"|"failed"|"deleted_running"|"deleted_terminating"|"modifying",
#'       FleetId = "string"
#'     )
#'   ),
#'   UnsuccessfulFleetDeletions = list(
#'     list(
#'       Error = list(
#'         Code = "fleetIdDoesNotExist"|"fleetIdMalformed"|"fleetNotInDeletableState"|"unexpectedError",
#'         Message = "string"
#'       ),
#'       FleetId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_fleets(
#'   DryRun = TRUE|FALSE,
#'   FleetIds = list(
#'     "string"
#'   ),
#'   TerminateInstances = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_fleets
ec2_delete_fleets <- function(DryRun = NULL, FleetIds, TerminateInstances) {
  op <- new_operation(
    name = "DeleteFleets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_fleets_input(DryRun = DryRun, FleetIds = FleetIds, TerminateInstances = TerminateInstances)
  output <- .ec2$delete_fleets_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_fleets <- ec2_delete_fleets

#' Deletes one or more flow logs
#'
#' @description
#' Deletes one or more flow logs.
#'
#' @usage
#' ec2_delete_flow_logs(DryRun, FlowLogIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FlowLogIds &#91;required&#93; One or more flow log IDs.
#' 
#' Constraint: Maximum of 1000 flow log IDs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Unsuccessful = list(
#'     list(
#'       Error = list(
#'         Code = "string",
#'         Message = "string"
#'       ),
#'       ResourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_flow_logs(
#'   DryRun = TRUE|FALSE,
#'   FlowLogIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_flow_logs
ec2_delete_flow_logs <- function(DryRun = NULL, FlowLogIds) {
  op <- new_operation(
    name = "DeleteFlowLogs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_flow_logs_input(DryRun = DryRun, FlowLogIds = FlowLogIds)
  output <- .ec2$delete_flow_logs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_flow_logs <- ec2_delete_flow_logs

#' Deletes the specified Amazon FPGA Image (AFI)
#'
#' @description
#' Deletes the specified Amazon FPGA Image (AFI).
#'
#' @usage
#' ec2_delete_fpga_image(DryRun, FpgaImageId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageId &#91;required&#93; The ID of the AFI.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Return = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_fpga_image(
#'   DryRun = TRUE|FALSE,
#'   FpgaImageId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_fpga_image
ec2_delete_fpga_image <- function(DryRun = NULL, FpgaImageId) {
  op <- new_operation(
    name = "DeleteFpgaImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_fpga_image_input(DryRun = DryRun, FpgaImageId = FpgaImageId)
  output <- .ec2$delete_fpga_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_fpga_image <- ec2_delete_fpga_image

#' Deletes the specified internet gateway
#'
#' @description
#' Deletes the specified internet gateway. You must detach the internet
#' gateway from the VPC before you can delete it.
#'
#' @usage
#' ec2_delete_internet_gateway(DryRun, InternetGatewayId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayId &#91;required&#93; The ID of the internet gateway.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_internet_gateway(
#'   DryRun = TRUE|FALSE,
#'   InternetGatewayId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified Internet gateway.
#' svc$delete_internet_gateway(
#'   InternetGatewayId = "igw-c0a643a9"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_internet_gateway
ec2_delete_internet_gateway <- function(DryRun = NULL, InternetGatewayId) {
  op <- new_operation(
    name = "DeleteInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_internet_gateway_input(DryRun = DryRun, InternetGatewayId = InternetGatewayId)
  output <- .ec2$delete_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_internet_gateway <- ec2_delete_internet_gateway

#' Deletes the specified key pair, by removing the public key from Amazon
#' EC2
#'
#' @description
#' Deletes the specified key pair, by removing the public key from Amazon
#' EC2.
#'
#' @usage
#' ec2_delete_key_pair(KeyName, KeyPairId, DryRun)
#'
#' @param KeyName The name of the key pair.
#' @param KeyPairId The ID of the key pair.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_key_pair(
#'   KeyName = "string",
#'   KeyPairId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified key pair.
#' svc$delete_key_pair(
#'   KeyName = "my-key-pair"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_key_pair
ec2_delete_key_pair <- function(KeyName = NULL, KeyPairId = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_key_pair_input(KeyName = KeyName, KeyPairId = KeyPairId, DryRun = DryRun)
  output <- .ec2$delete_key_pair_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_key_pair <- ec2_delete_key_pair

#' Deletes a launch template
#'
#' @description
#' Deletes a launch template. Deleting a launch template deletes all of its
#' versions.
#'
#' @usage
#' ec2_delete_launch_template(DryRun, LaunchTemplateId, LaunchTemplateName)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateId The ID of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param LaunchTemplateName The name of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LaunchTemplate = list(
#'     LaunchTemplateId = "string",
#'     LaunchTemplateName = "string",
#'     CreateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CreatedBy = "string",
#'     DefaultVersionNumber = 123,
#'     LatestVersionNumber = 123,
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_launch_template(
#'   DryRun = TRUE|FALSE,
#'   LaunchTemplateId = "string",
#'   LaunchTemplateName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified launch template.
#' svc$delete_launch_template(
#'   LaunchTemplateId = "lt-0abcd290751193123"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_launch_template
ec2_delete_launch_template <- function(DryRun = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL) {
  op <- new_operation(
    name = "DeleteLaunchTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_launch_template_input(DryRun = DryRun, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName)
  output <- .ec2$delete_launch_template_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_launch_template <- ec2_delete_launch_template

#' Deletes one or more versions of a launch template
#'
#' @description
#' Deletes one or more versions of a launch template. You cannot delete the
#' default version of a launch template; you must first assign a different
#' version as the default. If the default version is the only version for
#' the launch template, you must delete the entire launch template using
#' [`delete_launch_template`][ec2_delete_launch_template].
#'
#' @usage
#' ec2_delete_launch_template_versions(DryRun, LaunchTemplateId,
#'   LaunchTemplateName, Versions)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateId The ID of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param LaunchTemplateName The name of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param Versions &#91;required&#93; The version numbers of one or more launch template versions to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SuccessfullyDeletedLaunchTemplateVersions = list(
#'     list(
#'       LaunchTemplateId = "string",
#'       LaunchTemplateName = "string",
#'       VersionNumber = 123
#'     )
#'   ),
#'   UnsuccessfullyDeletedLaunchTemplateVersions = list(
#'     list(
#'       LaunchTemplateId = "string",
#'       LaunchTemplateName = "string",
#'       VersionNumber = 123,
#'       ResponseError = list(
#'         Code = "launchTemplateIdDoesNotExist"|"launchTemplateIdMalformed"|"launchTemplateNameDoesNotExist"|"launchTemplateNameMalformed"|"launchTemplateVersionDoesNotExist"|"unexpectedError",
#'         Message = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_launch_template_versions(
#'   DryRun = TRUE|FALSE,
#'   LaunchTemplateId = "string",
#'   LaunchTemplateName = "string",
#'   Versions = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified launch template version.
#' svc$delete_launch_template_versions(
#'   LaunchTemplateId = "lt-0abcd290751193123",
#'   Versions = list(
#'     "1"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_launch_template_versions
ec2_delete_launch_template_versions <- function(DryRun = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, Versions) {
  op <- new_operation(
    name = "DeleteLaunchTemplateVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_launch_template_versions_input(DryRun = DryRun, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, Versions = Versions)
  output <- .ec2$delete_launch_template_versions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_launch_template_versions <- ec2_delete_launch_template_versions

#' Deletes the specified route from the specified local gateway route table
#'
#' @description
#' Deletes the specified route from the specified local gateway route
#' table.
#'
#' @usage
#' ec2_delete_local_gateway_route(DestinationCidrBlock,
#'   LocalGatewayRouteTableId, DryRun)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range for the route. This must match the CIDR for the route
#' exactly.
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Route = list(
#'     DestinationCidrBlock = "string",
#'     LocalGatewayVirtualInterfaceGroupId = "string",
#'     Type = "static"|"propagated",
#'     State = "pending"|"active"|"blackhole"|"deleting"|"deleted",
#'     LocalGatewayRouteTableId = "string",
#'     LocalGatewayRouteTableArn = "string",
#'     OwnerId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_local_gateway_route(
#'   DestinationCidrBlock = "string",
#'   LocalGatewayRouteTableId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_local_gateway_route
ec2_delete_local_gateway_route <- function(DestinationCidrBlock, LocalGatewayRouteTableId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteLocalGatewayRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_local_gateway_route_input(DestinationCidrBlock = DestinationCidrBlock, LocalGatewayRouteTableId = LocalGatewayRouteTableId, DryRun = DryRun)
  output <- .ec2$delete_local_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_local_gateway_route <- ec2_delete_local_gateway_route

#' Deletes the specified association between a VPC and local gateway route
#' table
#'
#' @description
#' Deletes the specified association between a VPC and local gateway route
#' table.
#'
#' @usage
#' ec2_delete_local_gateway_route_table_vpc_association(
#'   LocalGatewayRouteTableVpcAssociationId, DryRun)
#'
#' @param LocalGatewayRouteTableVpcAssociationId &#91;required&#93; The ID of the association.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LocalGatewayRouteTableVpcAssociation = list(
#'     LocalGatewayRouteTableVpcAssociationId = "string",
#'     LocalGatewayRouteTableId = "string",
#'     LocalGatewayRouteTableArn = "string",
#'     LocalGatewayId = "string",
#'     VpcId = "string",
#'     OwnerId = "string",
#'     State = "string",
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_local_gateway_route_table_vpc_association(
#'   LocalGatewayRouteTableVpcAssociationId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_local_gateway_route_table_vpc_association
ec2_delete_local_gateway_route_table_vpc_association <- function(LocalGatewayRouteTableVpcAssociationId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteLocalGatewayRouteTableVpcAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_local_gateway_route_table_vpc_association_input(LocalGatewayRouteTableVpcAssociationId = LocalGatewayRouteTableVpcAssociationId, DryRun = DryRun)
  output <- .ec2$delete_local_gateway_route_table_vpc_association_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_local_gateway_route_table_vpc_association <- ec2_delete_local_gateway_route_table_vpc_association

#' Deletes the specified managed prefix list
#'
#' @description
#' Deletes the specified managed prefix list. You must first remove all
#' references to the prefix list in your resources.
#'
#' @usage
#' ec2_delete_managed_prefix_list(DryRun, PrefixListId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param PrefixListId &#91;required&#93; The ID of the prefix list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PrefixList = list(
#'     PrefixListId = "string",
#'     AddressFamily = "string",
#'     State = "create-in-progress"|"create-complete"|"create-failed"|"modify-in-progress"|"modify-complete"|"modify-failed"|"restore-in-progress"|"restore-complete"|"restore-failed"|"delete-in-progress"|"delete-complete"|"delete-failed",
#'     StateMessage = "string",
#'     PrefixListArn = "string",
#'     PrefixListName = "string",
#'     MaxEntries = 123,
#'     Version = 123,
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     OwnerId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_managed_prefix_list(
#'   DryRun = TRUE|FALSE,
#'   PrefixListId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_managed_prefix_list
ec2_delete_managed_prefix_list <- function(DryRun = NULL, PrefixListId) {
  op <- new_operation(
    name = "DeleteManagedPrefixList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_managed_prefix_list_input(DryRun = DryRun, PrefixListId = PrefixListId)
  output <- .ec2$delete_managed_prefix_list_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_managed_prefix_list <- ec2_delete_managed_prefix_list

#' Deletes the specified NAT gateway
#'
#' @description
#' Deletes the specified NAT gateway. Deleting a NAT gateway disassociates
#' its Elastic IP address, but does not release the address from your
#' account. Deleting a NAT gateway does not delete any NAT gateway routes
#' in your route tables.
#'
#' @usage
#' ec2_delete_nat_gateway(DryRun, NatGatewayId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NatGatewayId &#91;required&#93; The ID of the NAT gateway.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NatGatewayId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_nat_gateway(
#'   DryRun = TRUE|FALSE,
#'   NatGatewayId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified NAT gateway.
#' svc$delete_nat_gateway(
#'   NatGatewayId = "nat-04ae55e711cec5680"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_nat_gateway
ec2_delete_nat_gateway <- function(DryRun = NULL, NatGatewayId) {
  op <- new_operation(
    name = "DeleteNatGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_nat_gateway_input(DryRun = DryRun, NatGatewayId = NatGatewayId)
  output <- .ec2$delete_nat_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_nat_gateway <- ec2_delete_nat_gateway

#' Deletes the specified network ACL
#'
#' @description
#' Deletes the specified network ACL. You can't delete the ACL if it's
#' associated with any subnets. You can't delete the default network ACL.
#'
#' @usage
#' ec2_delete_network_acl(DryRun, NetworkAclId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkAclId &#91;required&#93; The ID of the network ACL.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_acl(
#'   DryRun = TRUE|FALSE,
#'   NetworkAclId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified network ACL.
#' svc$delete_network_acl(
#'   NetworkAclId = "acl-5fb85d36"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_acl
ec2_delete_network_acl <- function(DryRun = NULL, NetworkAclId) {
  op <- new_operation(
    name = "DeleteNetworkAcl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_acl_input(DryRun = DryRun, NetworkAclId = NetworkAclId)
  output <- .ec2$delete_network_acl_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_acl <- ec2_delete_network_acl

#' Deletes the specified ingress or egress entry (rule) from the specified
#' network ACL
#'
#' @description
#' Deletes the specified ingress or egress entry (rule) from the specified
#' network ACL.
#'
#' @usage
#' ec2_delete_network_acl_entry(DryRun, Egress, NetworkAclId, RuleNumber)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Egress &#91;required&#93; Indicates whether the rule is an egress rule.
#' @param NetworkAclId &#91;required&#93; The ID of the network ACL.
#' @param RuleNumber &#91;required&#93; The rule number of the entry to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_acl_entry(
#'   DryRun = TRUE|FALSE,
#'   Egress = TRUE|FALSE,
#'   NetworkAclId = "string",
#'   RuleNumber = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes ingress rule number 100 from the specified network
#' # ACL.
#' svc$delete_network_acl_entry(
#'   Egress = TRUE,
#'   NetworkAclId = "acl-5fb85d36",
#'   RuleNumber = 100L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_acl_entry
ec2_delete_network_acl_entry <- function(DryRun = NULL, Egress, NetworkAclId, RuleNumber) {
  op <- new_operation(
    name = "DeleteNetworkAclEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_acl_entry_input(DryRun = DryRun, Egress = Egress, NetworkAclId = NetworkAclId, RuleNumber = RuleNumber)
  output <- .ec2$delete_network_acl_entry_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_acl_entry <- ec2_delete_network_acl_entry

#' Deletes the specified network insights analysis
#'
#' @description
#' Deletes the specified network insights analysis.
#'
#' @usage
#' ec2_delete_network_insights_analysis(DryRun, NetworkInsightsAnalysisId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInsightsAnalysisId &#91;required&#93; The ID of the network insights analysis.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkInsightsAnalysisId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_insights_analysis(
#'   DryRun = TRUE|FALSE,
#'   NetworkInsightsAnalysisId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_insights_analysis
ec2_delete_network_insights_analysis <- function(DryRun = NULL, NetworkInsightsAnalysisId) {
  op <- new_operation(
    name = "DeleteNetworkInsightsAnalysis",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_insights_analysis_input(DryRun = DryRun, NetworkInsightsAnalysisId = NetworkInsightsAnalysisId)
  output <- .ec2$delete_network_insights_analysis_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_insights_analysis <- ec2_delete_network_insights_analysis

#' Deletes the specified path
#'
#' @description
#' Deletes the specified path.
#'
#' @usage
#' ec2_delete_network_insights_path(DryRun, NetworkInsightsPathId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInsightsPathId &#91;required&#93; The ID of the path.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkInsightsPathId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_insights_path(
#'   DryRun = TRUE|FALSE,
#'   NetworkInsightsPathId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_insights_path
ec2_delete_network_insights_path <- function(DryRun = NULL, NetworkInsightsPathId) {
  op <- new_operation(
    name = "DeleteNetworkInsightsPath",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_insights_path_input(DryRun = DryRun, NetworkInsightsPathId = NetworkInsightsPathId)
  output <- .ec2$delete_network_insights_path_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_insights_path <- ec2_delete_network_insights_path

#' Deletes the specified network interface
#'
#' @description
#' Deletes the specified network interface. You must detach the network
#' interface before you can delete it.
#'
#' @usage
#' ec2_delete_network_interface(DryRun, NetworkInterfaceId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_interface(
#'   DryRun = TRUE|FALSE,
#'   NetworkInterfaceId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified network interface.
#' svc$delete_network_interface(
#'   NetworkInterfaceId = "eni-e5aa89a3"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_interface
ec2_delete_network_interface <- function(DryRun = NULL, NetworkInterfaceId) {
  op <- new_operation(
    name = "DeleteNetworkInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_interface_input(DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId)
  output <- .ec2$delete_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_interface <- ec2_delete_network_interface

#' Deletes a permission for a network interface
#'
#' @description
#' Deletes a permission for a network interface. By default, you cannot
#' delete the permission if the account for which you're removing the
#' permission has attached the network interface to an instance. However,
#' you can force delete the permission, regardless of any attachment.
#'
#' @usage
#' ec2_delete_network_interface_permission(NetworkInterfacePermissionId,
#'   Force, DryRun)
#'
#' @param NetworkInterfacePermissionId &#91;required&#93; The ID of the network interface permission.
#' @param Force Specify `true` to remove the permission even if the network interface is
#' attached to an instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Return = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_interface_permission(
#'   NetworkInterfacePermissionId = "string",
#'   Force = TRUE|FALSE,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_interface_permission
ec2_delete_network_interface_permission <- function(NetworkInterfacePermissionId, Force = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteNetworkInterfacePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_interface_permission_input(NetworkInterfacePermissionId = NetworkInterfacePermissionId, Force = Force, DryRun = DryRun)
  output <- .ec2$delete_network_interface_permission_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_interface_permission <- ec2_delete_network_interface_permission

#' Deletes the specified placement group
#'
#' @description
#' Deletes the specified placement group. You must terminate all instances
#' in the placement group before you can delete the placement group. For
#' more information, see [Placement
#' groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_delete_placement_group(DryRun, GroupName)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupName &#91;required&#93; The name of the placement group.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_placement_group(
#'   DryRun = TRUE|FALSE,
#'   GroupName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified placement group.
#' # 
#' svc$delete_placement_group(
#'   GroupName = "my-cluster"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_placement_group
ec2_delete_placement_group <- function(DryRun = NULL, GroupName) {
  op <- new_operation(
    name = "DeletePlacementGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_placement_group_input(DryRun = DryRun, GroupName = GroupName)
  output <- .ec2$delete_placement_group_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_placement_group <- ec2_delete_placement_group

#' Deletes the queued purchases for the specified Reserved Instances
#'
#' @description
#' Deletes the queued purchases for the specified Reserved Instances.
#'
#' @usage
#' ec2_delete_queued_reserved_instances(DryRun, ReservedInstancesIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReservedInstancesIds &#91;required&#93; The IDs of the Reserved Instances.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SuccessfulQueuedPurchaseDeletions = list(
#'     list(
#'       ReservedInstancesId = "string"
#'     )
#'   ),
#'   FailedQueuedPurchaseDeletions = list(
#'     list(
#'       Error = list(
#'         Code = "reserved-instances-id-invalid"|"reserved-instances-not-in-queued-state"|"unexpected-error",
#'         Message = "string"
#'       ),
#'       ReservedInstancesId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_queued_reserved_instances(
#'   DryRun = TRUE|FALSE,
#'   ReservedInstancesIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_queued_reserved_instances
ec2_delete_queued_reserved_instances <- function(DryRun = NULL, ReservedInstancesIds) {
  op <- new_operation(
    name = "DeleteQueuedReservedInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_queued_reserved_instances_input(DryRun = DryRun, ReservedInstancesIds = ReservedInstancesIds)
  output <- .ec2$delete_queued_reserved_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_queued_reserved_instances <- ec2_delete_queued_reserved_instances

#' Deletes the specified route from the specified route table
#'
#' @description
#' Deletes the specified route from the specified route table.
#'
#' @usage
#' ec2_delete_route(DestinationCidrBlock, DestinationIpv6CidrBlock,
#'   DestinationPrefixListId, DryRun, RouteTableId)
#'
#' @param DestinationCidrBlock The IPv4 CIDR range for the route. The value you specify must match the
#' CIDR for the route exactly.
#' @param DestinationIpv6CidrBlock The IPv6 CIDR range for the route. The value you specify must match the
#' CIDR for the route exactly.
#' @param DestinationPrefixListId The ID of the prefix list for the route.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_route(
#'   DestinationCidrBlock = "string",
#'   DestinationIpv6CidrBlock = "string",
#'   DestinationPrefixListId = "string",
#'   DryRun = TRUE|FALSE,
#'   RouteTableId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified route from the specified route table.
#' svc$delete_route(
#'   DestinationCidrBlock = "0.0.0.0/0",
#'   RouteTableId = "rtb-22574640"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_route
ec2_delete_route <- function(DestinationCidrBlock = NULL, DestinationIpv6CidrBlock = NULL, DestinationPrefixListId = NULL, DryRun = NULL, RouteTableId) {
  op <- new_operation(
    name = "DeleteRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_route_input(DestinationCidrBlock = DestinationCidrBlock, DestinationIpv6CidrBlock = DestinationIpv6CidrBlock, DestinationPrefixListId = DestinationPrefixListId, DryRun = DryRun, RouteTableId = RouteTableId)
  output <- .ec2$delete_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_route <- ec2_delete_route

#' Deletes the specified route table
#'
#' @description
#' Deletes the specified route table. You must disassociate the route table
#' from any subnets before you can delete it. You can't delete the main
#' route table.
#'
#' @usage
#' ec2_delete_route_table(DryRun, RouteTableId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_route_table(
#'   DryRun = TRUE|FALSE,
#'   RouteTableId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified route table.
#' svc$delete_route_table(
#'   RouteTableId = "rtb-22574640"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_route_table
ec2_delete_route_table <- function(DryRun = NULL, RouteTableId) {
  op <- new_operation(
    name = "DeleteRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_route_table_input(DryRun = DryRun, RouteTableId = RouteTableId)
  output <- .ec2$delete_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_route_table <- ec2_delete_route_table

#' Deletes a security group
#'
#' @description
#' Deletes a security group.
#' 
#' If you attempt to delete a security group that is associated with an
#' instance, or is referenced by another security group, the operation
#' fails with `InvalidGroup.InUse` in EC2-Classic or `DependencyViolation`
#' in EC2-VPC.
#'
#' @usage
#' ec2_delete_security_group(GroupId, GroupName, DryRun)
#'
#' @param GroupId The ID of the security group. Required for a nondefault VPC.
#' @param GroupName \[EC2-Classic, default VPC\] The name of the security group. You can
#' specify either the security group name or the security group ID.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_security_group(
#'   GroupId = "string",
#'   GroupName = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified security group.
#' svc$delete_security_group(
#'   GroupId = "sg-903004f8"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_security_group
ec2_delete_security_group <- function(GroupId = NULL, GroupName = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_security_group_input(GroupId = GroupId, GroupName = GroupName, DryRun = DryRun)
  output <- .ec2$delete_security_group_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_security_group <- ec2_delete_security_group

#' Deletes the specified snapshot
#'
#' @description
#' Deletes the specified snapshot.
#' 
#' When you make periodic snapshots of a volume, the snapshots are
#' incremental, and only the blocks on the device that have changed since
#' your last snapshot are saved in the new snapshot. When you delete a
#' snapshot, only the data not needed for any other snapshot is removed. So
#' regardless of which prior snapshots have been deleted, all active
#' snapshots will have access to all the information needed to restore the
#' volume.
#' 
#' You cannot delete a snapshot of the root device of an EBS volume used by
#' a registered AMI. You must first de-register the AMI before you can
#' delete the snapshot.
#' 
#' For more information, see [Deleting an Amazon EBS
#' snapshot](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_delete_snapshot(SnapshotId, DryRun)
#'
#' @param SnapshotId &#91;required&#93; The ID of the EBS snapshot.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_snapshot(
#'   SnapshotId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes a snapshot with the snapshot ID of
#' # `snap-1234567890abcdef0`. If the command succeeds, no output is
#' # returned.
#' svc$delete_snapshot(
#'   SnapshotId = "snap-1234567890abcdef0"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_snapshot
ec2_delete_snapshot <- function(SnapshotId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_snapshot_input(SnapshotId = SnapshotId, DryRun = DryRun)
  output <- .ec2$delete_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_snapshot <- ec2_delete_snapshot

#' Deletes the data feed for Spot Instances
#'
#' @description
#' Deletes the data feed for Spot Instances.
#'
#' @usage
#' ec2_delete_spot_datafeed_subscription(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_spot_datafeed_subscription(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes a Spot data feed subscription for the account.
#' svc$delete_spot_datafeed_subscription()
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_spot_datafeed_subscription
ec2_delete_spot_datafeed_subscription <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSpotDatafeedSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_spot_datafeed_subscription_input(DryRun = DryRun)
  output <- .ec2$delete_spot_datafeed_subscription_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_spot_datafeed_subscription <- ec2_delete_spot_datafeed_subscription

#' Deletes the specified subnet
#'
#' @description
#' Deletes the specified subnet. You must terminate all running instances
#' in the subnet before you can delete the subnet.
#'
#' @usage
#' ec2_delete_subnet(SubnetId, DryRun)
#'
#' @param SubnetId &#91;required&#93; The ID of the subnet.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_subnet(
#'   SubnetId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified subnet.
#' svc$delete_subnet(
#'   SubnetId = "subnet-9d4a7b6c"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_subnet
ec2_delete_subnet <- function(SubnetId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSubnet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_subnet_input(SubnetId = SubnetId, DryRun = DryRun)
  output <- .ec2$delete_subnet_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_subnet <- ec2_delete_subnet

#' Deletes the specified set of tags from the specified set of resources
#'
#' @description
#' Deletes the specified set of tags from the specified set of resources.
#' 
#' To list the current tags, use [`describe_tags`][ec2_describe_tags]. For
#' more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_delete_tags(DryRun, Resources, Tags)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Resources &#91;required&#93; The IDs of the resources, separated by spaces.
#' 
#' Constraints: Up to 1000 resource IDs. We recommend breaking up this
#' request into smaller batches.
#' @param Tags The tags to delete. Specify a tag key and an optional tag value to
#' delete specific tags. If you specify a tag key without a tag value, we
#' delete any tag with this key regardless of its value. If you specify a
#' tag key with an empty string as the tag value, we delete the tag only if
#' its value is an empty string.
#' 
#' If you omit this parameter, we delete all user-defined tags for the
#' specified resources. We do not delete AWS-generated tags (tags that have
#' the `aws:` prefix).
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags(
#'   DryRun = TRUE|FALSE,
#'   Resources = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the tag Stack=test from the specified image.
#' svc$delete_tags(
#'   Resources = list(
#'     "ami-78a54011"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "Stack",
#'       Value = "test"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_tags
ec2_delete_tags <- function(DryRun = NULL, Resources, Tags = NULL) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_tags_input(DryRun = DryRun, Resources = Resources, Tags = Tags)
  output <- .ec2$delete_tags_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_tags <- ec2_delete_tags

#' Deletes the specified Traffic Mirror filter
#'
#' @description
#' Deletes the specified Traffic Mirror filter.
#' 
#' You cannot delete a Traffic Mirror filter that is in use by a Traffic
#' Mirror session.
#'
#' @usage
#' ec2_delete_traffic_mirror_filter(TrafficMirrorFilterId, DryRun)
#'
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the Traffic Mirror filter.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrafficMirrorFilterId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_mirror_filter(
#'   TrafficMirrorFilterId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_filter
ec2_delete_traffic_mirror_filter <- function(TrafficMirrorFilterId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_traffic_mirror_filter_input(TrafficMirrorFilterId = TrafficMirrorFilterId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_filter_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_filter <- ec2_delete_traffic_mirror_filter

#' Deletes the specified Traffic Mirror rule
#'
#' @description
#' Deletes the specified Traffic Mirror rule.
#'
#' @usage
#' ec2_delete_traffic_mirror_filter_rule(TrafficMirrorFilterRuleId, DryRun)
#'
#' @param TrafficMirrorFilterRuleId &#91;required&#93; The ID of the Traffic Mirror rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrafficMirrorFilterRuleId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_mirror_filter_rule(
#'   TrafficMirrorFilterRuleId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_filter_rule
ec2_delete_traffic_mirror_filter_rule <- function(TrafficMirrorFilterRuleId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorFilterRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_traffic_mirror_filter_rule_input(TrafficMirrorFilterRuleId = TrafficMirrorFilterRuleId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_filter_rule_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_filter_rule <- ec2_delete_traffic_mirror_filter_rule

#' Deletes the specified Traffic Mirror session
#'
#' @description
#' Deletes the specified Traffic Mirror session.
#'
#' @usage
#' ec2_delete_traffic_mirror_session(TrafficMirrorSessionId, DryRun)
#'
#' @param TrafficMirrorSessionId &#91;required&#93; The ID of the Traffic Mirror session.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrafficMirrorSessionId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_mirror_session(
#'   TrafficMirrorSessionId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_session
ec2_delete_traffic_mirror_session <- function(TrafficMirrorSessionId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_traffic_mirror_session_input(TrafficMirrorSessionId = TrafficMirrorSessionId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_session_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_session <- ec2_delete_traffic_mirror_session

#' Deletes the specified Traffic Mirror target
#'
#' @description
#' Deletes the specified Traffic Mirror target.
#' 
#' You cannot delete a Traffic Mirror target that is in use by a Traffic
#' Mirror session.
#'
#' @usage
#' ec2_delete_traffic_mirror_target(TrafficMirrorTargetId, DryRun)
#'
#' @param TrafficMirrorTargetId &#91;required&#93; The ID of the Traffic Mirror target.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TrafficMirrorTargetId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_mirror_target(
#'   TrafficMirrorTargetId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_target
ec2_delete_traffic_mirror_target <- function(TrafficMirrorTargetId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_traffic_mirror_target_input(TrafficMirrorTargetId = TrafficMirrorTargetId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_target_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_target <- ec2_delete_traffic_mirror_target

#' Deletes the specified transit gateway
#'
#' @description
#' Deletes the specified transit gateway.
#'
#' @usage
#' ec2_delete_transit_gateway(TransitGatewayId, DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGateway = list(
#'     TransitGatewayId = "string",
#'     TransitGatewayArn = "string",
#'     State = "pending"|"available"|"modifying"|"deleting"|"deleted",
#'     OwnerId = "string",
#'     Description = "string",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Options = list(
#'       AmazonSideAsn = 123,
#'       TransitGatewayCidrBlocks = list(
#'         "string"
#'       ),
#'       AutoAcceptSharedAttachments = "enable"|"disable",
#'       DefaultRouteTableAssociation = "enable"|"disable",
#'       AssociationDefaultRouteTableId = "string",
#'       DefaultRouteTablePropagation = "enable"|"disable",
#'       PropagationDefaultRouteTableId = "string",
#'       VpnEcmpSupport = "enable"|"disable",
#'       DnsSupport = "enable"|"disable",
#'       MulticastSupport = "enable"|"disable"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway(
#'   TransitGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway
ec2_delete_transit_gateway <- function(TransitGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_input(TransitGatewayId = TransitGatewayId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway <- ec2_delete_transit_gateway

#' Deletes the specified Connect attachment
#'
#' @description
#' Deletes the specified Connect attachment. You must first delete any
#' Connect peers for the attachment.
#'
#' @usage
#' ec2_delete_transit_gateway_connect(TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the Connect attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayConnect = list(
#'     TransitGatewayAttachmentId = "string",
#'     TransportTransitGatewayAttachmentId = "string",
#'     TransitGatewayId = "string",
#'     State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Options = list(
#'       Protocol = "gre"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_connect(
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_connect
ec2_delete_transit_gateway_connect <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayConnect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_connect_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_connect_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_connect <- ec2_delete_transit_gateway_connect

#' Deletes the specified Connect peer
#'
#' @description
#' Deletes the specified Connect peer.
#'
#' @usage
#' ec2_delete_transit_gateway_connect_peer(TransitGatewayConnectPeerId,
#'   DryRun)
#'
#' @param TransitGatewayConnectPeerId &#91;required&#93; The ID of the Connect peer.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayConnectPeer = list(
#'     TransitGatewayAttachmentId = "string",
#'     TransitGatewayConnectPeerId = "string",
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ConnectPeerConfiguration = list(
#'       TransitGatewayAddress = "string",
#'       PeerAddress = "string",
#'       InsideCidrBlocks = list(
#'         "string"
#'       ),
#'       Protocol = "gre",
#'       BgpConfigurations = list(
#'         list(
#'           TransitGatewayAsn = 123,
#'           PeerAsn = 123,
#'           TransitGatewayAddress = "string",
#'           PeerAddress = "string",
#'           BgpStatus = "up"|"down"
#'         )
#'       )
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_connect_peer(
#'   TransitGatewayConnectPeerId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_connect_peer
ec2_delete_transit_gateway_connect_peer <- function(TransitGatewayConnectPeerId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayConnectPeer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_connect_peer_input(TransitGatewayConnectPeerId = TransitGatewayConnectPeerId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_connect_peer_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_connect_peer <- ec2_delete_transit_gateway_connect_peer

#' Deletes the specified transit gateway multicast domain
#'
#' @description
#' Deletes the specified transit gateway multicast domain.
#'
#' @usage
#' ec2_delete_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId, DryRun)
#'
#' @param TransitGatewayMulticastDomainId &#91;required&#93; The ID of the transit gateway multicast domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayMulticastDomain = list(
#'     TransitGatewayMulticastDomainId = "string",
#'     TransitGatewayId = "string",
#'     TransitGatewayMulticastDomainArn = "string",
#'     OwnerId = "string",
#'     Options = list(
#'       Igmpv2Support = "enable"|"disable",
#'       StaticSourcesSupport = "enable"|"disable",
#'       AutoAcceptSharedAssociations = "enable"|"disable"
#'     ),
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_multicast_domain
ec2_delete_transit_gateway_multicast_domain <- function(TransitGatewayMulticastDomainId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_multicast_domain_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_multicast_domain <- ec2_delete_transit_gateway_multicast_domain

#' Deletes a transit gateway peering attachment
#'
#' @description
#' Deletes a transit gateway peering attachment.
#'
#' @usage
#' ec2_delete_transit_gateway_peering_attachment(
#'   TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway peering attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayPeeringAttachment = list(
#'     TransitGatewayAttachmentId = "string",
#'     RequesterTgwInfo = list(
#'       TransitGatewayId = "string",
#'       OwnerId = "string",
#'       Region = "string"
#'     ),
#'     AccepterTgwInfo = list(
#'       TransitGatewayId = "string",
#'       OwnerId = "string",
#'       Region = "string"
#'     ),
#'     Status = list(
#'       Code = "string",
#'       Message = "string"
#'     ),
#'     State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_peering_attachment(
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_peering_attachment
ec2_delete_transit_gateway_peering_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayPeeringAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_peering_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_peering_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_peering_attachment <- ec2_delete_transit_gateway_peering_attachment

#' Deletes a reference (route) to a prefix list in a specified transit
#' gateway route table
#'
#' @description
#' Deletes a reference (route) to a prefix list in a specified transit
#' gateway route table.
#'
#' @usage
#' ec2_delete_transit_gateway_prefix_list_reference(
#'   TransitGatewayRouteTableId, PrefixListId, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the route table.
#' @param PrefixListId &#91;required&#93; The ID of the prefix list.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayPrefixListReference = list(
#'     TransitGatewayRouteTableId = "string",
#'     PrefixListId = "string",
#'     PrefixListOwnerId = "string",
#'     State = "pending"|"available"|"modifying"|"deleting",
#'     Blackhole = TRUE|FALSE,
#'     TransitGatewayAttachment = list(
#'       TransitGatewayAttachmentId = "string",
#'       ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering",
#'       ResourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_prefix_list_reference(
#'   TransitGatewayRouteTableId = "string",
#'   PrefixListId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_prefix_list_reference
ec2_delete_transit_gateway_prefix_list_reference <- function(TransitGatewayRouteTableId, PrefixListId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayPrefixListReference",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_prefix_list_reference_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, PrefixListId = PrefixListId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_prefix_list_reference_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_prefix_list_reference <- ec2_delete_transit_gateway_prefix_list_reference

#' Deletes the specified route from the specified transit gateway route
#' table
#'
#' @description
#' Deletes the specified route from the specified transit gateway route
#' table.
#'
#' @usage
#' ec2_delete_transit_gateway_route(TransitGatewayRouteTableId,
#'   DestinationCidrBlock, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range for the route. This must match the CIDR for the route
#' exactly.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Route = list(
#'     DestinationCidrBlock = "string",
#'     PrefixListId = "string",
#'     TransitGatewayAttachments = list(
#'       list(
#'         ResourceId = "string",
#'         TransitGatewayAttachmentId = "string",
#'         ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering"
#'       )
#'     ),
#'     Type = "static"|"propagated",
#'     State = "pending"|"active"|"blackhole"|"deleting"|"deleted"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_route(
#'   TransitGatewayRouteTableId = "string",
#'   DestinationCidrBlock = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_route
ec2_delete_transit_gateway_route <- function(TransitGatewayRouteTableId, DestinationCidrBlock, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_route_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, DestinationCidrBlock = DestinationCidrBlock, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_route <- ec2_delete_transit_gateway_route

#' Deletes the specified transit gateway route table
#'
#' @description
#' Deletes the specified transit gateway route table. You must disassociate
#' the route table from any transit gateway route tables before you can
#' delete it.
#'
#' @usage
#' ec2_delete_transit_gateway_route_table(TransitGatewayRouteTableId,
#'   DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayRouteTable = list(
#'     TransitGatewayRouteTableId = "string",
#'     TransitGatewayId = "string",
#'     State = "pending"|"available"|"deleting"|"deleted",
#'     DefaultAssociationRouteTable = TRUE|FALSE,
#'     DefaultPropagationRouteTable = TRUE|FALSE,
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_route_table(
#'   TransitGatewayRouteTableId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_route_table
ec2_delete_transit_gateway_route_table <- function(TransitGatewayRouteTableId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_route_table_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_route_table <- ec2_delete_transit_gateway_route_table

#' Deletes the specified VPC attachment
#'
#' @description
#' Deletes the specified VPC attachment.
#'
#' @usage
#' ec2_delete_transit_gateway_vpc_attachment(TransitGatewayAttachmentId,
#'   DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransitGatewayVpcAttachment = list(
#'     TransitGatewayAttachmentId = "string",
#'     TransitGatewayId = "string",
#'     VpcId = "string",
#'     VpcOwnerId = "string",
#'     State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Options = list(
#'       DnsSupport = "enable"|"disable",
#'       Ipv6Support = "enable"|"disable",
#'       ApplianceModeSupport = "enable"|"disable"
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_vpc_attachment(
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_vpc_attachment
ec2_delete_transit_gateway_vpc_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_vpc_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_vpc_attachment <- ec2_delete_transit_gateway_vpc_attachment

#' Deletes the specified EBS volume
#'
#' @description
#' Deletes the specified EBS volume. The volume must be in the `available`
#' state (not attached to an instance).
#' 
#' The volume can remain in the `deleting` state for several minutes.
#' 
#' For more information, see [Deleting an Amazon EBS
#' volume](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_delete_volume(VolumeId, DryRun)
#'
#' @param VolumeId &#91;required&#93; The ID of the volume.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_volume(
#'   VolumeId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes an available volume with the volume ID of
#' # `vol-049df61146c4d7901`. If the command succeeds, no output is
#' # returned.
#' svc$delete_volume(
#'   VolumeId = "vol-049df61146c4d7901"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_volume
ec2_delete_volume <- function(VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_volume_input(VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$delete_volume_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_volume <- ec2_delete_volume

#' Deletes the specified VPC
#'
#' @description
#' Deletes the specified VPC. You must detach or delete all gateways and
#' resources that are associated with the VPC before you can delete it. For
#' example, you must terminate all instances running in the VPC, delete all
#' security groups associated with the VPC (except the default one), delete
#' all route tables associated with the VPC (except the default one), and
#' so on.
#'
#' @usage
#' ec2_delete_vpc(VpcId, DryRun)
#'
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc(
#'   VpcId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified VPC.
#' svc$delete_vpc(
#'   VpcId = "vpc-a01106c2"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc
ec2_delete_vpc <- function(VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_input(VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$delete_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc <- ec2_delete_vpc

#' Deletes one or more VPC endpoint connection notifications
#'
#' @description
#' Deletes one or more VPC endpoint connection notifications.
#'
#' @usage
#' ec2_delete_vpc_endpoint_connection_notifications(DryRun,
#'   ConnectionNotificationIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ConnectionNotificationIds &#91;required&#93; One or more notification IDs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Unsuccessful = list(
#'     list(
#'       Error = list(
#'         Code = "string",
#'         Message = "string"
#'       ),
#'       ResourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc_endpoint_connection_notifications(
#'   DryRun = TRUE|FALSE,
#'   ConnectionNotificationIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_endpoint_connection_notifications
ec2_delete_vpc_endpoint_connection_notifications <- function(DryRun = NULL, ConnectionNotificationIds) {
  op <- new_operation(
    name = "DeleteVpcEndpointConnectionNotifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_endpoint_connection_notifications_input(DryRun = DryRun, ConnectionNotificationIds = ConnectionNotificationIds)
  output <- .ec2$delete_vpc_endpoint_connection_notifications_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_endpoint_connection_notifications <- ec2_delete_vpc_endpoint_connection_notifications

#' Deletes one or more VPC endpoint service configurations in your account
#'
#' @description
#' Deletes one or more VPC endpoint service configurations in your account.
#' Before you delete the endpoint service configuration, you must reject
#' any `Available` or `PendingAcceptance` interface endpoint connections
#' that are attached to the service.
#'
#' @usage
#' ec2_delete_vpc_endpoint_service_configurations(DryRun, ServiceIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceIds &#91;required&#93; The IDs of one or more services.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Unsuccessful = list(
#'     list(
#'       Error = list(
#'         Code = "string",
#'         Message = "string"
#'       ),
#'       ResourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc_endpoint_service_configurations(
#'   DryRun = TRUE|FALSE,
#'   ServiceIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_endpoint_service_configurations
ec2_delete_vpc_endpoint_service_configurations <- function(DryRun = NULL, ServiceIds) {
  op <- new_operation(
    name = "DeleteVpcEndpointServiceConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_endpoint_service_configurations_input(DryRun = DryRun, ServiceIds = ServiceIds)
  output <- .ec2$delete_vpc_endpoint_service_configurations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_endpoint_service_configurations <- ec2_delete_vpc_endpoint_service_configurations

#' Deletes one or more specified VPC endpoints
#'
#' @description
#' Deletes one or more specified VPC endpoints. Deleting a gateway endpoint
#' also deletes the endpoint routes in the route tables that were
#' associated with the endpoint. Deleting an interface endpoint or a
#' Gateway Load Balancer endpoint deletes the endpoint network interfaces.
#' Gateway Load Balancer endpoints can only be deleted if the routes that
#' are associated with the endpoint are deleted.
#'
#' @usage
#' ec2_delete_vpc_endpoints(DryRun, VpcEndpointIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointIds &#91;required&#93; One or more VPC endpoint IDs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Unsuccessful = list(
#'     list(
#'       Error = list(
#'         Code = "string",
#'         Message = "string"
#'       ),
#'       ResourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc_endpoints(
#'   DryRun = TRUE|FALSE,
#'   VpcEndpointIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_endpoints
ec2_delete_vpc_endpoints <- function(DryRun = NULL, VpcEndpointIds) {
  op <- new_operation(
    name = "DeleteVpcEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_endpoints_input(DryRun = DryRun, VpcEndpointIds = VpcEndpointIds)
  output <- .ec2$delete_vpc_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_endpoints <- ec2_delete_vpc_endpoints

#' Deletes a VPC peering connection
#'
#' @description
#' Deletes a VPC peering connection. Either the owner of the requester VPC
#' or the owner of the accepter VPC can delete the VPC peering connection
#' if it's in the `active` state. The owner of the requester VPC can delete
#' a VPC peering connection in the `pending-acceptance` state. You cannot
#' delete a VPC peering connection that's in the `failed` state.
#'
#' @usage
#' ec2_delete_vpc_peering_connection(DryRun, VpcPeeringConnectionId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcPeeringConnectionId &#91;required&#93; The ID of the VPC peering connection.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Return = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc_peering_connection(
#'   DryRun = TRUE|FALSE,
#'   VpcPeeringConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_peering_connection
ec2_delete_vpc_peering_connection <- function(DryRun = NULL, VpcPeeringConnectionId) {
  op <- new_operation(
    name = "DeleteVpcPeeringConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_peering_connection_input(DryRun = DryRun, VpcPeeringConnectionId = VpcPeeringConnectionId)
  output <- .ec2$delete_vpc_peering_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_peering_connection <- ec2_delete_vpc_peering_connection

#' Deletes the specified VPN connection
#'
#' @description
#' Deletes the specified VPN connection.
#' 
#' If you're deleting the VPC and its associated components, we recommend
#' that you detach the virtual private gateway from the VPC and delete the
#' VPC before deleting the VPN connection. If you believe that the tunnel
#' credentials for your VPN connection have been compromised, you can
#' delete the VPN connection and create a new one that has new keys,
#' without needing to delete the VPC or virtual private gateway. If you
#' create a new VPN connection, you must reconfigure the customer gateway
#' device using the new configuration information returned with the new VPN
#' connection ID.
#' 
#' For certificate-based authentication, delete all AWS Certificate Manager
#' (ACM) private certificates used for the AWS-side tunnel endpoints for
#' the VPN connection before deleting the VPN connection.
#'
#' @usage
#' ec2_delete_vpn_connection(VpnConnectionId, DryRun)
#'
#' @param VpnConnectionId &#91;required&#93; The ID of the VPN connection.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpn_connection(
#'   VpnConnectionId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpn_connection
ec2_delete_vpn_connection <- function(VpnConnectionId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVpnConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpn_connection_input(VpnConnectionId = VpnConnectionId, DryRun = DryRun)
  output <- .ec2$delete_vpn_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpn_connection <- ec2_delete_vpn_connection

#' Deletes the specified static route associated with a VPN connection
#' between an existing virtual private gateway and a VPN customer gateway
#'
#' @description
#' Deletes the specified static route associated with a VPN connection
#' between an existing virtual private gateway and a VPN customer gateway.
#' The static route allows traffic to be routed from the virtual private
#' gateway to the VPN customer gateway.
#'
#' @usage
#' ec2_delete_vpn_connection_route(DestinationCidrBlock, VpnConnectionId)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR block associated with the local subnet of the customer network.
#' @param VpnConnectionId &#91;required&#93; The ID of the VPN connection.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpn_connection_route(
#'   DestinationCidrBlock = "string",
#'   VpnConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpn_connection_route
ec2_delete_vpn_connection_route <- function(DestinationCidrBlock, VpnConnectionId) {
  op <- new_operation(
    name = "DeleteVpnConnectionRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpn_connection_route_input(DestinationCidrBlock = DestinationCidrBlock, VpnConnectionId = VpnConnectionId)
  output <- .ec2$delete_vpn_connection_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpn_connection_route <- ec2_delete_vpn_connection_route

#' Deletes the specified virtual private gateway
#'
#' @description
#' Deletes the specified virtual private gateway. You must first detach the
#' virtual private gateway from the VPC. Note that you don't need to delete
#' the virtual private gateway if you plan to delete and recreate the VPN
#' connection between your VPC and your network.
#'
#' @usage
#' ec2_delete_vpn_gateway(VpnGatewayId, DryRun)
#'
#' @param VpnGatewayId &#91;required&#93; The ID of the virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpn_gateway(
#'   VpnGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpn_gateway
ec2_delete_vpn_gateway <- function(VpnGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVpnGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpn_gateway_input(VpnGatewayId = VpnGatewayId, DryRun = DryRun)
  output <- .ec2$delete_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpn_gateway <- ec2_delete_vpn_gateway

#' Releases the specified address range that you provisioned for use with
#' your AWS resources through bring your own IP addresses (BYOIP) and
#' deletes the corresponding address pool
#'
#' @description
#' Releases the specified address range that you provisioned for use with
#' your AWS resources through bring your own IP addresses (BYOIP) and
#' deletes the corresponding address pool.
#' 
#' Before you can release an address range, you must stop advertising it
#' using [`withdraw_byoip_cidr`][ec2_withdraw_byoip_cidr] and you must not
#' have any IP addresses allocated from its address range.
#'
#' @usage
#' ec2_deprovision_byoip_cidr(Cidr, DryRun)
#'
#' @param Cidr &#91;required&#93; The address range, in CIDR notation. The prefix must be the same prefix
#' that you specified when you provisioned the address range.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ByoipCidr = list(
#'     Cidr = "string",
#'     Description = "string",
#'     StatusMessage = "string",
#'     State = "advertised"|"deprovisioned"|"failed-deprovision"|"failed-provision"|"pending-deprovision"|"pending-provision"|"provisioned"|"provisioned-not-publicly-advertisable"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$deprovision_byoip_cidr(
#'   Cidr = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_deprovision_byoip_cidr
ec2_deprovision_byoip_cidr <- function(Cidr, DryRun = NULL) {
  op <- new_operation(
    name = "DeprovisionByoipCidr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$deprovision_byoip_cidr_input(Cidr = Cidr, DryRun = DryRun)
  output <- .ec2$deprovision_byoip_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deprovision_byoip_cidr <- ec2_deprovision_byoip_cidr

#' Deregisters the specified AMI
#'
#' @description
#' Deregisters the specified AMI. After you deregister an AMI, it can't be
#' used to launch new instances; however, it doesn't affect any instances
#' that you've already launched from the AMI. You'll continue to incur
#' usage costs for those instances until you terminate them.
#' 
#' When you deregister an Amazon EBS-backed AMI, it doesn't affect the
#' snapshot that was created for the root volume of the instance during the
#' AMI creation process. When you deregister an instance store-backed AMI,
#' it doesn't affect the files that you uploaded to Amazon S3 when you
#' created the AMI.
#'
#' @usage
#' ec2_deregister_image(ImageId, DryRun)
#'
#' @param ImageId &#91;required&#93; The ID of the AMI.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_image(
#'   ImageId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_image
ec2_deregister_image <- function(ImageId, DryRun = NULL) {
  op <- new_operation(
    name = "DeregisterImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$deregister_image_input(ImageId = ImageId, DryRun = DryRun)
  output <- .ec2$deregister_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_image <- ec2_deregister_image

#' Deregisters tag keys to prevent tags that have the specified tag keys
#' from being included in scheduled event notifications for resources in
#' the Region
#'
#' @description
#' Deregisters tag keys to prevent tags that have the specified tag keys
#' from being included in scheduled event notifications for resources in
#' the Region.
#'
#' @usage
#' ec2_deregister_instance_event_notification_attributes(DryRun,
#'   InstanceTagAttribute)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTagAttribute Information about the tag keys to deregister.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InstanceTagAttribute = list(
#'     InstanceTagKeys = list(
#'       "string"
#'     ),
#'     IncludeAllTagsOfInstance = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$deregister_instance_event_notification_attributes(
#'   DryRun = TRUE|FALSE,
#'   InstanceTagAttribute = list(
#'     IncludeAllTagsOfInstance = TRUE|FALSE,
#'     InstanceTagKeys = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_instance_event_notification_attributes
ec2_deregister_instance_event_notification_attributes <- function(DryRun = NULL, InstanceTagAttribute = NULL) {
  op <- new_operation(
    name = "DeregisterInstanceEventNotificationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$deregister_instance_event_notification_attributes_input(DryRun = DryRun, InstanceTagAttribute = InstanceTagAttribute)
  output <- .ec2$deregister_instance_event_notification_attributes_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_instance_event_notification_attributes <- ec2_deregister_instance_event_notification_attributes

#' Deregisters the specified members (network interfaces) from the transit
#' gateway multicast group
#'
#' @description
#' Deregisters the specified members (network interfaces) from the transit
#' gateway multicast group.
#'
#' @usage
#' ec2_deregister_transit_gateway_multicast_group_members(
#'   TransitGatewayMulticastDomainId, GroupIpAddress, NetworkInterfaceIds,
#'   DryRun)
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param GroupIpAddress The IP address assigned to the transit gateway multicast group.
#' @param NetworkInterfaceIds The IDs of the group members' network interfaces.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DeregisteredMulticastGroupMembers = list(
#'     TransitGatewayMulticastDomainId = "string",
#'     DeregisteredNetworkInterfaceIds = list(
#'       "string"
#'     ),
#'     GroupIpAddress = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$deregister_transit_gateway_multicast_group_members(
#'   TransitGatewayMulticastDomainId = "string",
#'   GroupIpAddress = "string",
#'   NetworkInterfaceIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_transit_gateway_multicast_group_members
ec2_deregister_transit_gateway_multicast_group_members <- function(TransitGatewayMulticastDomainId = NULL, GroupIpAddress = NULL, NetworkInterfaceIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeregisterTransitGatewayMulticastGroupMembers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$deregister_transit_gateway_multicast_group_members_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, GroupIpAddress = GroupIpAddress, NetworkInterfaceIds = NetworkInterfaceIds, DryRun = DryRun)
  output <- .ec2$deregister_transit_gateway_multicast_group_members_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_transit_gateway_multicast_group_members <- ec2_deregister_transit_gateway_multicast_group_members

#' Deregisters the specified sources (network interfaces) from the transit
#' gateway multicast group
#'
#' @description
#' Deregisters the specified sources (network interfaces) from the transit
#' gateway multicast group.
#'
#' @usage
#' ec2_deregister_transit_gateway_multicast_group_sources(
#'   TransitGatewayMulticastDomainId, GroupIpAddress, NetworkInterfaceIds,
#'   DryRun)
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param GroupIpAddress The IP address assigned to the transit gateway multicast group.
#' @param NetworkInterfaceIds The IDs of the group sources' network interfaces.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DeregisteredMulticastGroupSources = list(
#'     TransitGatewayMulticastDomainId = "string",
#'     DeregisteredNetworkInterfaceIds = list(
#'       "string"
#'     ),
#'     GroupIpAddress = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$deregister_transit_gateway_multicast_group_sources(
#'   TransitGatewayMulticastDomainId = "string",
#'   GroupIpAddress = "string",
#'   NetworkInterfaceIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_transit_gateway_multicast_group_sources
ec2_deregister_transit_gateway_multicast_group_sources <- function(TransitGatewayMulticastDomainId = NULL, GroupIpAddress = NULL, NetworkInterfaceIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeregisterTransitGatewayMulticastGroupSources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$deregister_transit_gateway_multicast_group_sources_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, GroupIpAddress = GroupIpAddress, NetworkInterfaceIds = NetworkInterfaceIds, DryRun = DryRun)
  output <- .ec2$deregister_transit_gateway_multicast_group_sources_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_transit_gateway_multicast_group_sources <- ec2_deregister_transit_gateway_multicast_group_sources

#' Describes attributes of your AWS account
#'
#' @description
#' Describes attributes of your AWS account. The following are the
#' supported account attributes:
#' 
#' -   `supported-platforms`: Indicates whether your account can launch
#'     instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.
#' 
#' -   `default-vpc`: The ID of the default VPC for your account, or
#'     `none`.
#' 
#' -   `max-instances`: This attribute is no longer supported. The returned
#'     value does not reflect your actual vCPU limit for running On-Demand
#'     Instances. For more information, see [On-Demand Instance
#'     Limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits)
#'     in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' -   `vpc-max-security-groups-per-interface`: The maximum number of
#'     security groups that you can assign to a network interface.
#' 
#' -   `max-elastic-ips`: The maximum number of Elastic IP addresses that
#'     you can allocate for use with EC2-Classic.
#' 
#' -   `vpc-max-elastic-ips`: The maximum number of Elastic IP addresses
#'     that you can allocate for use with EC2-VPC.
#'
#' @usage
#' ec2_describe_account_attributes(AttributeNames, DryRun)
#'
#' @param AttributeNames The account attribute names.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AccountAttributes = list(
#'     list(
#'       AttributeName = "string",
#'       AttributeValues = list(
#'         list(
#'           AttributeValue = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_account_attributes(
#'   AttributeNames = list(
#'     "supported-platforms"|"default-vpc"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the supported-platforms attribute for your AWS
#' # account.
#' svc$describe_account_attributes(
#'   AttributeNames = list(
#'     "supported-platforms"
#'   )
#' )
#' 
#' # This example describes the attributes for your AWS account.
#' svc$describe_account_attributes()
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_account_attributes
ec2_describe_account_attributes <- function(AttributeNames = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_account_attributes_input(AttributeNames = AttributeNames, DryRun = DryRun)
  output <- .ec2$describe_account_attributes_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_account_attributes <- ec2_describe_account_attributes

#' Describes the specified Elastic IP addresses or all of your Elastic IP
#' addresses
#'
#' @description
#' Describes the specified Elastic IP addresses or all of your Elastic IP
#' addresses.
#' 
#' An Elastic IP address is for use in either the EC2-Classic platform or
#' in a VPC. For more information, see [Elastic IP
#' Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_addresses(Filters, PublicIps, AllocationIds, DryRun)
#'
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `allocation-id` - \[EC2-VPC\] The allocation ID for the address.
#' 
#' -   `association-id` - \[EC2-VPC\] The association ID for the address.
#' 
#' -   `domain` - Indicates whether the address is for use in EC2-Classic
#'     (`standard`) or in a VPC (`vpc`).
#' 
#' -   `instance-id` - The ID of the instance the address is associated
#'     with, if any.
#' 
#' -   `network-border-group` - A unique set of Availability Zones, Local
#'     Zones, or Wavelength Zones from where AWS advertises IP addresses.
#' 
#' -   `network-interface-id` - \[EC2-VPC\] The ID of the network interface
#'     that the address is associated with, if any.
#' 
#' -   `network-interface-owner-id` - The AWS account ID of the owner.
#' 
#' -   `private-ip-address` - \[EC2-VPC\] The private IP address associated
#'     with the Elastic IP address.
#' 
#' -   `public-ip` - The Elastic IP address, or the carrier IP address.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param PublicIps One or more Elastic IP addresses.
#' 
#' Default: Describes all your Elastic IP addresses.
#' @param AllocationIds \[EC2-VPC\] Information about the allocation IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Addresses = list(
#'     list(
#'       InstanceId = "string",
#'       PublicIp = "string",
#'       AllocationId = "string",
#'       AssociationId = "string",
#'       Domain = "vpc"|"standard",
#'       NetworkInterfaceId = "string",
#'       NetworkInterfaceOwnerId = "string",
#'       PrivateIpAddress = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       PublicIpv4Pool = "string",
#'       NetworkBorderGroup = "string",
#'       CustomerOwnedIp = "string",
#'       CustomerOwnedIpv4Pool = "string",
#'       CarrierIp = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_addresses(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   PublicIps = list(
#'     "string"
#'   ),
#'   AllocationIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes your Elastic IP addresses.
#' svc$describe_addresses()
#' 
#' # This example describes your Elastic IP addresses for use with instances
#' # in a VPC.
#' svc$describe_addresses(
#'   Filters = list(
#'     list(
#'       Name = "domain",
#'       Values = list(
#'         "vpc"
#'       )
#'     )
#'   )
#' )
#' 
#' # This example describes your Elastic IP addresses for use with instances
#' # in EC2-Classic.
#' svc$describe_addresses(
#'   Filters = list(
#'     list(
#'       Name = "domain",
#'       Values = list(
#'         "standard"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_addresses
ec2_describe_addresses <- function(Filters = NULL, PublicIps = NULL, AllocationIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAddresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_addresses_input(Filters = Filters, PublicIps = PublicIps, AllocationIds = AllocationIds, DryRun = DryRun)
  output <- .ec2$describe_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_addresses <- ec2_describe_addresses

#' Describes the longer ID format settings for all resource types in a
#' specific Region
#'
#' @description
#' Describes the longer ID format settings for all resource types in a
#' specific Region. This request is useful for performing a quick audit to
#' determine whether a specific Region is fully opted in for longer IDs
#' (17-character IDs).
#' 
#' This request only returns information about resource types that support
#' longer IDs.
#' 
#' The following resource types support longer IDs: `bundle` |
#' `conversion-task` | `customer-gateway` | `dhcp-options` |
#' `elastic-ip-allocation` | `elastic-ip-association` | `export-task` |
#' `flow-log` | `image` | `import-task` | `instance` | `internet-gateway` |
#' `network-acl` | `network-acl-association` | `network-interface` |
#' `network-interface-attachment` | `prefix-list` | `reservation` |
#' `route-table` | `route-table-association` | `security-group` |
#' `snapshot` | `subnet` | `subnet-cidr-block-association` | `volume` |
#' `vpc` | `vpc-cidr-block-association` | `vpc-endpoint` |
#' `vpc-peering-connection` | `vpn-connection` | `vpn-gateway`.
#'
#' @usage
#' ec2_describe_aggregate_id_format(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   UseLongIdsAggregated = TRUE|FALSE,
#'   Statuses = list(
#'     list(
#'       Deadline = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Resource = "string",
#'       UseLongIds = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_aggregate_id_format(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_aggregate_id_format
ec2_describe_aggregate_id_format <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAggregateIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_aggregate_id_format_input(DryRun = DryRun)
  output <- .ec2$describe_aggregate_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_aggregate_id_format <- ec2_describe_aggregate_id_format

#' Describes the Availability Zones, Local Zones, and Wavelength Zones that
#' are available to you
#'
#' @description
#' Describes the Availability Zones, Local Zones, and Wavelength Zones that
#' are available to you. If there is an event impacting a zone, you can use
#' this request to view the state and any provided messages for that zone.
#' 
#' For more information about Availability Zones, Local Zones, and
#' Wavelength Zones, see [Regions, Zones and
#' Outposts](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_availability_zones(Filters, ZoneNames, ZoneIds,
#'   AllAvailabilityZones, DryRun)
#'
#' @param Filters The filters.
#' 
#' -   `group-name` - For Availability Zones, use the Region name. For
#'     Local Zones, use the name of the group associated with the Local
#'     Zone (for example, `us-west-2-lax-1`) For Wavelength Zones, use the
#'     name of the group associated with the Wavelength Zone (for example,
#'     `us-east-1-wl1-bos-wlz-1`).
#' 
#' -   `message` - The Zone message.
#' 
#' -   `opt-in-status` - The opt-in status (`opted-in`, and `not-opted-in`
#'     | `opt-in-not-required`).
#' 
#' -   `parent-zoneID` - The ID of the zone that handles some of the Local
#'     Zone and Wavelength Zone control plane operations, such as API
#'     calls.
#' 
#' -   `parent-zoneName` - The ID of the zone that handles some of the
#'     Local Zone and Wavelength Zone control plane operations, such as API
#'     calls.
#' 
#' -   `region-name` - The name of the Region for the Zone (for example,
#'     `us-east-1`).
#' 
#' -   `state` - The state of the Availability Zone, the Local Zone, or the
#'     Wavelength Zone (`available` | `information` | `impaired` |
#'     `unavailable`).
#' 
#' -   `zone-id` - The ID of the Availability Zone (for example,
#'     `use1-az1`), the Local Zone (for example, `usw2-lax1-az1`), or the
#'     Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
#' 
#' -   `zone-type` - The type of zone, for example, `local-zone`.
#' 
#' -   `zone-name` - The name of the Availability Zone (for example,
#'     `us-east-1a`), the Local Zone (for example, `us-west-2-lax-1a`), or
#'     the Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
#' 
#' -   `zone-type` - The type of zone, for example, `local-zone`.
#' @param ZoneNames The names of the Availability Zones, Local Zones, and Wavelength Zones.
#' @param ZoneIds The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
#' @param AllAvailabilityZones Include all Availability Zones, Local Zones, and Wavelength Zones
#' regardless of your opt-in status.
#' 
#' If you do not use this parameter, the results include only the zones for
#' the Regions where you have chosen the option to opt in.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AvailabilityZones = list(
#'     list(
#'       State = "available"|"information"|"impaired"|"unavailable",
#'       OptInStatus = "opt-in-not-required"|"opted-in"|"not-opted-in",
#'       Messages = list(
#'         list(
#'           Message = "string"
#'         )
#'       ),
#'       RegionName = "string",
#'       ZoneName = "string",
#'       ZoneId = "string",
#'       GroupName = "string",
#'       NetworkBorderGroup = "string",
#'       ZoneType = "string",
#'       ParentZoneName = "string",
#'       ParentZoneId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_availability_zones(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ZoneNames = list(
#'     "string"
#'   ),
#'   ZoneIds = list(
#'     "string"
#'   ),
#'   AllAvailabilityZones = TRUE|FALSE,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the Availability Zones that are available to you.
#' # The response includes Availability Zones only for the current region.
#' svc$describe_availability_zones()
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_availability_zones
ec2_describe_availability_zones <- function(Filters = NULL, ZoneNames = NULL, ZoneIds = NULL, AllAvailabilityZones = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAvailabilityZones",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_availability_zones_input(Filters = Filters, ZoneNames = ZoneNames, ZoneIds = ZoneIds, AllAvailabilityZones = AllAvailabilityZones, DryRun = DryRun)
  output <- .ec2$describe_availability_zones_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_availability_zones <- ec2_describe_availability_zones

#' Describes the specified bundle tasks or all of your bundle tasks
#'
#' @description
#' Describes the specified bundle tasks or all of your bundle tasks.
#' 
#' Completed bundle tasks are listed for only a limited time. If your
#' bundle task is no longer in the list, you can still register an AMI from
#' it. Just use [`register_image`][ec2_register_image] with the Amazon S3
#' bucket name and image manifest name you provided to the bundle task.
#'
#' @usage
#' ec2_describe_bundle_tasks(BundleIds, Filters, DryRun)
#'
#' @param BundleIds The bundle task IDs.
#' 
#' Default: Describes all your bundle tasks.
#' @param Filters The filters.
#' 
#' -   `bundle-id` - The ID of the bundle task.
#' 
#' -   `error-code` - If the task failed, the error code returned.
#' 
#' -   `error-message` - If the task failed, the error message returned.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `progress` - The level of task completion, as a percentage (for
#'     example, 20%).
#' 
#' -   `s3-bucket` - The Amazon S3 bucket to store the AMI.
#' 
#' -   `s3-prefix` - The beginning of the AMI name.
#' 
#' -   `start-time` - The time the task started (for example,
#'     2013-09-15T17:15:20.000Z).
#' 
#' -   `state` - The state of the task (`pending` | `waiting-for-shutdown`
#'     | `bundling` | `storing` | `cancelling` | `complete` | `failed`).
#' 
#' -   `update-time` - The time of the most recent update for the task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   BundleTasks = list(
#'     list(
#'       BundleId = "string",
#'       BundleTaskError = list(
#'         Code = "string",
#'         Message = "string"
#'       ),
#'       InstanceId = "string",
#'       Progress = "string",
#'       StartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       State = "pending"|"waiting-for-shutdown"|"bundling"|"storing"|"cancelling"|"complete"|"failed",
#'       Storage = list(
#'         S3 = list(
#'           AWSAccessKeyId = "string",
#'           Bucket = "string",
#'           Prefix = "string",
#'           UploadPolicy = raw,
#'           UploadPolicySignature = "string"
#'         )
#'       ),
#'       UpdateTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_bundle_tasks(
#'   BundleIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_bundle_tasks
ec2_describe_bundle_tasks <- function(BundleIds = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeBundleTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_bundle_tasks_input(BundleIds = BundleIds, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_bundle_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_bundle_tasks <- ec2_describe_bundle_tasks

#' Describes the IP address ranges that were specified in calls to
#' ProvisionByoipCidr
#'
#' @description
#' Describes the IP address ranges that were specified in calls to
#' [`provision_byoip_cidr`][ec2_provision_byoip_cidr].
#' 
#' To describe the address pools that were created when you provisioned the
#' address ranges, use
#' [`describe_public_ipv_4_pools`][ec2_describe_public_ipv_4_pools] or
#' [`describe_ipv_6_pools`][ec2_describe_ipv_6_pools].
#'
#' @usage
#' ec2_describe_byoip_cidrs(DryRun, MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults &#91;required&#93; The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ByoipCidrs = list(
#'     list(
#'       Cidr = "string",
#'       Description = "string",
#'       StatusMessage = "string",
#'       State = "advertised"|"deprovisioned"|"failed-deprovision"|"failed-provision"|"pending-deprovision"|"pending-provision"|"provisioned"|"provisioned-not-publicly-advertisable"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_byoip_cidrs(
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_byoip_cidrs
ec2_describe_byoip_cidrs <- function(DryRun = NULL, MaxResults, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeByoipCidrs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_byoip_cidrs_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_byoip_cidrs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_byoip_cidrs <- ec2_describe_byoip_cidrs

#' Describes one or more of your Capacity Reservations
#'
#' @description
#' Describes one or more of your Capacity Reservations. The results
#' describe only the Capacity Reservations in the AWS Region that you're
#' currently using.
#'
#' @usage
#' ec2_describe_capacity_reservations(CapacityReservationIds, NextToken,
#'   MaxResults, Filters, DryRun)
#'
#' @param CapacityReservationIds The ID of the Capacity Reservation.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' @param Filters One or more filters.
#' 
#' -   `instance-type` - The type of instance for which the Capacity
#'     Reservation reserves capacity.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the Capacity
#'     Reservation.
#' 
#' -   `availability-zone-id` - The Availability Zone ID of the Capacity
#'     Reservation.
#' 
#' -   `instance-platform` - The type of operating system for which the
#'     Capacity Reservation reserves capacity.
#' 
#' -   `availability-zone` - The Availability Zone ID of the Capacity
#'     Reservation.
#' 
#' -   `tenancy` - Indicates the tenancy of the Capacity Reservation. A
#'     Capacity Reservation can have one of the following tenancy settings:
#' 
#'     -   `default` - The Capacity Reservation is created on hardware that
#'         is shared with other AWS accounts.
#' 
#'     -   `dedicated` - The Capacity Reservation is created on
#'         single-tenant hardware that is dedicated to a single AWS
#'         account.
#' 
#' -   `state` - The current state of the Capacity Reservation. A Capacity
#'     Reservation can be in one of the following states:
#' 
#'     -   `active`- The Capacity Reservation is active and the capacity is
#'         available for your use.
#' 
#'     -   `expired` - The Capacity Reservation expired automatically at
#'         the date and time specified in your request. The reserved
#'         capacity is no longer available for your use.
#' 
#'     -   `cancelled` - The Capacity Reservation was manually cancelled.
#'         The reserved capacity is no longer available for your use.
#' 
#'     -   `pending` - The Capacity Reservation request was successful but
#'         the capacity provisioning is still pending.
#' 
#'     -   `failed` - The Capacity Reservation request has failed. A
#'         request might fail due to invalid request parameters, capacity
#'         constraints, or instance limit constraints. Failed requests are
#'         retained for 60 minutes.
#' 
#' -   `end-date` - The date and time at which the Capacity Reservation
#'     expires. When a Capacity Reservation expires, the reserved capacity
#'     is released and you can no longer launch instances into it. The
#'     Capacity Reservation's state changes to expired when it reaches its
#'     end date and time.
#' 
#' -   `end-date-type` - Indicates the way in which the Capacity
#'     Reservation ends. A Capacity Reservation can have one of the
#'     following end types:
#' 
#'     -   `unlimited` - The Capacity Reservation remains active until you
#'         explicitly cancel it.
#' 
#'     -   `limited` - The Capacity Reservation expires automatically at a
#'         specified date and time.
#' 
#' -   `instance-match-criteria` - Indicates the type of instance launches
#'     that the Capacity Reservation accepts. The options include:
#' 
#'     -   `open` - The Capacity Reservation accepts all instances that
#'         have matching attributes (instance type, platform, and
#'         Availability Zone). Instances that have matching attributes
#'         launch into the Capacity Reservation automatically without
#'         specifying any additional parameters.
#' 
#'     -   `targeted` - The Capacity Reservation only accepts instances
#'         that have matching attributes (instance type, platform, and
#'         Availability Zone), and explicitly target the Capacity
#'         Reservation. This ensures that only permitted instances can use
#'         the reserved capacity.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   CapacityReservations = list(
#'     list(
#'       CapacityReservationId = "string",
#'       OwnerId = "string",
#'       CapacityReservationArn = "string",
#'       AvailabilityZoneId = "string",
#'       InstanceType = "string",
#'       InstancePlatform = "Linux/UNIX"|"Red Hat Enterprise Linux"|"SUSE Linux"|"Windows"|"Windows with SQL Server"|"Windows with SQL Server Enterprise"|"Windows with SQL Server Standard"|"Windows with SQL Server Web"|"Linux with SQL Server Standard"|"Linux with SQL Server Web"|"Linux with SQL Server Enterprise",
#'       AvailabilityZone = "string",
#'       Tenancy = "default"|"dedicated",
#'       TotalInstanceCount = 123,
#'       AvailableInstanceCount = 123,
#'       EbsOptimized = TRUE|FALSE,
#'       EphemeralStorage = TRUE|FALSE,
#'       State = "active"|"expired"|"cancelled"|"pending"|"failed",
#'       EndDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EndDateType = "unlimited"|"limited",
#'       InstanceMatchCriteria = "open"|"targeted",
#'       CreateDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_capacity_reservations(
#'   CapacityReservationIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_capacity_reservations
ec2_describe_capacity_reservations <- function(CapacityReservationIds = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCapacityReservations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_capacity_reservations_input(CapacityReservationIds = CapacityReservationIds, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_capacity_reservations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_capacity_reservations <- ec2_describe_capacity_reservations

#' Describes one or more of your carrier gateways
#'
#' @description
#' Describes one or more of your carrier gateways.
#'
#' @usage
#' ec2_describe_carrier_gateways(CarrierGatewayIds, Filters, MaxResults,
#'   NextToken, DryRun)
#'
#' @param CarrierGatewayIds One or more carrier gateway IDs.
#' @param Filters One or more filters.
#' 
#' -   `carrier-gateway-id` - The ID of the carrier gateway.
#' 
#' -   `state` - The state of the carrier gateway (`pending` | `failed` |
#'     `available` | `deleting` | `deleted`).
#' 
#' -   `owner-id` - The AWS account ID of the owner of the carrier gateway.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC associated with the carrier gateway.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CarrierGateways = list(
#'     list(
#'       CarrierGatewayId = "string",
#'       VpcId = "string",
#'       State = "pending"|"available"|"deleting"|"deleted",
#'       OwnerId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_carrier_gateways(
#'   CarrierGatewayIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_carrier_gateways
ec2_describe_carrier_gateways <- function(CarrierGatewayIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCarrierGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_carrier_gateways_input(CarrierGatewayIds = CarrierGatewayIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_carrier_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_carrier_gateways <- ec2_describe_carrier_gateways

#' Describes one or more of your linked EC2-Classic instances
#'
#' @description
#' Describes one or more of your linked EC2-Classic instances. This request
#' only returns information about EC2-Classic instances linked to a VPC
#' through ClassicLink. You cannot use this request to return information
#' about other instances.
#'
#' @usage
#' ec2_describe_classic_link_instances(Filters, DryRun, InstanceIds,
#'   MaxResults, NextToken)
#'
#' @param Filters One or more filters.
#' 
#' -   `group-id` - The ID of a VPC security group that's associated with
#'     the instance.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC to which the instance is linked.
#' 
#'     `vpc-id` - The ID of the VPC that the instance is linked to.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceIds One or more instance IDs. Must be instances linked to a VPC through
#' ClassicLink.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' Constraint: If the value is greater than 1000, we return only 1000
#' items.
#' @param NextToken The token for the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Instances = list(
#'     list(
#'       Groups = list(
#'         list(
#'           GroupName = "string",
#'           GroupId = "string"
#'         )
#'       ),
#'       InstanceId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       VpcId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_classic_link_instances(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_classic_link_instances
ec2_describe_classic_link_instances <- function(Filters = NULL, DryRun = NULL, InstanceIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeClassicLinkInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_classic_link_instances_input(Filters = Filters, DryRun = DryRun, InstanceIds = InstanceIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_classic_link_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_classic_link_instances <- ec2_describe_classic_link_instances

#' Describes the authorization rules for a specified Client VPN endpoint
#'
#' @description
#' Describes the authorization rules for a specified Client VPN endpoint.
#'
#' @usage
#' ec2_describe_client_vpn_authorization_rules(ClientVpnEndpointId, DryRun,
#'   NextToken, Filters, MaxResults)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `description` - The description of the authorization rule.
#' 
#' -   `destination-cidr` - The CIDR of the network to which the
#'     authorization rule applies.
#' 
#' -   `group-id` - The ID of the Active Directory group to which the
#'     authorization rule grants access.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AuthorizationRules = list(
#'     list(
#'       ClientVpnEndpointId = "string",
#'       Description = "string",
#'       GroupId = "string",
#'       AccessAll = TRUE|FALSE,
#'       DestinationCidr = "string",
#'       Status = list(
#'         Code = "authorizing"|"active"|"failed"|"revoking",
#'         Message = "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_authorization_rules(
#'   ClientVpnEndpointId = "string",
#'   DryRun = TRUE|FALSE,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_authorization_rules
ec2_describe_client_vpn_authorization_rules <- function(ClientVpnEndpointId, DryRun = NULL, NextToken = NULL, Filters = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnAuthorizationRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_authorization_rules_input(ClientVpnEndpointId = ClientVpnEndpointId, DryRun = DryRun, NextToken = NextToken, Filters = Filters, MaxResults = MaxResults)
  output <- .ec2$describe_client_vpn_authorization_rules_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_authorization_rules <- ec2_describe_client_vpn_authorization_rules

#' Describes active client connections and connections that have been
#' terminated within the last 60 minutes for the specified Client VPN
#' endpoint
#'
#' @description
#' Describes active client connections and connections that have been
#' terminated within the last 60 minutes for the specified Client VPN
#' endpoint.
#'
#' @usage
#' ec2_describe_client_vpn_connections(ClientVpnEndpointId, Filters,
#'   NextToken, MaxResults, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `connection-id` - The ID of the connection.
#' 
#' -   `username` - For Active Directory client authentication, the user
#'     name of the client who established the client connection.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Connections = list(
#'     list(
#'       ClientVpnEndpointId = "string",
#'       Timestamp = "string",
#'       ConnectionId = "string",
#'       Username = "string",
#'       ConnectionEstablishedTime = "string",
#'       IngressBytes = "string",
#'       EgressBytes = "string",
#'       IngressPackets = "string",
#'       EgressPackets = "string",
#'       ClientIp = "string",
#'       CommonName = "string",
#'       Status = list(
#'         Code = "active"|"failed-to-terminate"|"terminating"|"terminated",
#'         Message = "string"
#'       ),
#'       ConnectionEndTime = "string",
#'       PostureComplianceStatuses = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_connections(
#'   ClientVpnEndpointId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_connections
ec2_describe_client_vpn_connections <- function(ClientVpnEndpointId, Filters = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_connections_input(ClientVpnEndpointId = ClientVpnEndpointId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_connections_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_connections <- ec2_describe_client_vpn_connections

#' Describes one or more Client VPN endpoints in the account
#'
#' @description
#' Describes one or more Client VPN endpoints in the account.
#'
#' @usage
#' ec2_describe_client_vpn_endpoints(ClientVpnEndpointIds, MaxResults,
#'   NextToken, Filters, DryRun)
#'
#' @param ClientVpnEndpointIds The ID of the Client VPN endpoint.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `endpoint-id` - The ID of the Client VPN endpoint.
#' 
#' -   `transport-protocol` - The transport protocol (`tcp` | `udp`).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ClientVpnEndpoints = list(
#'     list(
#'       ClientVpnEndpointId = "string",
#'       Description = "string",
#'       Status = list(
#'         Code = "pending-associate"|"available"|"deleting"|"deleted",
#'         Message = "string"
#'       ),
#'       CreationTime = "string",
#'       DeletionTime = "string",
#'       DnsName = "string",
#'       ClientCidrBlock = "string",
#'       DnsServers = list(
#'         "string"
#'       ),
#'       SplitTunnel = TRUE|FALSE,
#'       VpnProtocol = "openvpn",
#'       TransportProtocol = "tcp"|"udp",
#'       VpnPort = 123,
#'       AssociatedTargetNetworks = list(
#'         list(
#'           NetworkId = "string",
#'           NetworkType = "vpc"
#'         )
#'       ),
#'       ServerCertificateArn = "string",
#'       AuthenticationOptions = list(
#'         list(
#'           Type = "certificate-authentication"|"directory-service-authentication"|"federated-authentication",
#'           ActiveDirectory = list(
#'             DirectoryId = "string"
#'           ),
#'           MutualAuthentication = list(
#'             ClientRootCertificateChain = "string"
#'           ),
#'           FederatedAuthentication = list(
#'             SamlProviderArn = "string",
#'             SelfServiceSamlProviderArn = "string"
#'           )
#'         )
#'       ),
#'       ConnectionLogOptions = list(
#'         Enabled = TRUE|FALSE,
#'         CloudwatchLogGroup = "string",
#'         CloudwatchLogStream = "string"
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       SecurityGroupIds = list(
#'         "string"
#'       ),
#'       VpcId = "string",
#'       SelfServicePortalUrl = "string",
#'       ClientConnectOptions = list(
#'         Enabled = TRUE|FALSE,
#'         LambdaFunctionArn = "string",
#'         Status = list(
#'           Code = "applying"|"applied",
#'           Message = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_endpoints(
#'   ClientVpnEndpointIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_endpoints
ec2_describe_client_vpn_endpoints <- function(ClientVpnEndpointIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_endpoints_input(ClientVpnEndpointIds = ClientVpnEndpointIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_endpoints <- ec2_describe_client_vpn_endpoints

#' Describes the routes for the specified Client VPN endpoint
#'
#' @description
#' Describes the routes for the specified Client VPN endpoint.
#'
#' @usage
#' ec2_describe_client_vpn_routes(ClientVpnEndpointId, Filters, MaxResults,
#'   NextToken, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `destination-cidr` - The CIDR of the route destination.
#' 
#' -   `origin` - How the route was associated with the Client VPN endpoint
#'     (`associate` | `add-route`).
#' 
#' -   `target-subnet` - The ID of the subnet through which traffic is
#'     routed.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param NextToken The token to retrieve the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Routes = list(
#'     list(
#'       ClientVpnEndpointId = "string",
#'       DestinationCidr = "string",
#'       TargetSubnet = "string",
#'       Type = "string",
#'       Origin = "string",
#'       Status = list(
#'         Code = "creating"|"active"|"failed"|"deleting",
#'         Message = "string"
#'       ),
#'       Description = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_routes(
#'   ClientVpnEndpointId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_routes
ec2_describe_client_vpn_routes <- function(ClientVpnEndpointId, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnRoutes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_routes_input(ClientVpnEndpointId = ClientVpnEndpointId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_routes_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_routes <- ec2_describe_client_vpn_routes

#' Describes the target networks associated with the specified Client VPN
#' endpoint
#'
#' @description
#' Describes the target networks associated with the specified Client VPN
#' endpoint.
#'
#' @usage
#' ec2_describe_client_vpn_target_networks(ClientVpnEndpointId,
#'   AssociationIds, MaxResults, NextToken, Filters, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param AssociationIds The IDs of the target network associations.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `association-id` - The ID of the association.
#' 
#' -   `target-network-id` - The ID of the subnet specified as the target
#'     network.
#' 
#' -   `vpc-id` - The ID of the VPC in which the target network is located.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ClientVpnTargetNetworks = list(
#'     list(
#'       AssociationId = "string",
#'       VpcId = "string",
#'       TargetNetworkId = "string",
#'       ClientVpnEndpointId = "string",
#'       Status = list(
#'         Code = "associating"|"associated"|"association-failed"|"disassociating"|"disassociated",
#'         Message = "string"
#'       ),
#'       SecurityGroups = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_target_networks(
#'   ClientVpnEndpointId = "string",
#'   AssociationIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_target_networks
ec2_describe_client_vpn_target_networks <- function(ClientVpnEndpointId, AssociationIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnTargetNetworks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_target_networks_input(ClientVpnEndpointId = ClientVpnEndpointId, AssociationIds = AssociationIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_target_networks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_target_networks <- ec2_describe_client_vpn_target_networks

#' Describes the specified customer-owned address pools or all of your
#' customer-owned address pools
#'
#' @description
#' Describes the specified customer-owned address pools or all of your
#' customer-owned address pools.
#'
#' @usage
#' ec2_describe_coip_pools(PoolIds, Filters, MaxResults, NextToken, DryRun)
#'
#' @param PoolIds The IDs of the address pools.
#' @param Filters The filters. The following are the possible values:
#' 
#' -   `coip-pool.pool-id`
#' 
#' 
#' -   `coip-pool.local-gateway-route-table-id`
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CoipPools = list(
#'     list(
#'       PoolId = "string",
#'       PoolCidrs = list(
#'         "string"
#'       ),
#'       LocalGatewayRouteTableId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       PoolArn = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_coip_pools(
#'   PoolIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_coip_pools
ec2_describe_coip_pools <- function(PoolIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCoipPools",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_coip_pools_input(PoolIds = PoolIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_coip_pools_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_coip_pools <- ec2_describe_coip_pools

#' Describes the specified conversion tasks or all your conversion tasks
#'
#' @description
#' Describes the specified conversion tasks or all your conversion tasks.
#' For more information, see the [VM Import/Export User
#' Guide](https://docs.aws.amazon.com/vm-import/latest/userguide/).
#' 
#' For information about the import manifest referenced by this API action,
#' see [VM Import
#' Manifest](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
#'
#' @usage
#' ec2_describe_conversion_tasks(ConversionTaskIds, DryRun)
#'
#' @param ConversionTaskIds The conversion task IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConversionTasks = list(
#'     list(
#'       ConversionTaskId = "string",
#'       ExpirationTime = "string",
#'       ImportInstance = list(
#'         Description = "string",
#'         InstanceId = "string",
#'         Platform = "Windows",
#'         Volumes = list(
#'           list(
#'             AvailabilityZone = "string",
#'             BytesConverted = 123,
#'             Description = "string",
#'             Image = list(
#'               Checksum = "string",
#'               Format = "VMDK"|"RAW"|"VHD",
#'               ImportManifestUrl = "string",
#'               Size = 123
#'             ),
#'             Status = "string",
#'             StatusMessage = "string",
#'             Volume = list(
#'               Id = "string",
#'               Size = 123
#'             )
#'           )
#'         )
#'       ),
#'       ImportVolume = list(
#'         AvailabilityZone = "string",
#'         BytesConverted = 123,
#'         Description = "string",
#'         Image = list(
#'           Checksum = "string",
#'           Format = "VMDK"|"RAW"|"VHD",
#'           ImportManifestUrl = "string",
#'           Size = 123
#'         ),
#'         Volume = list(
#'           Id = "string",
#'           Size = 123
#'         )
#'       ),
#'       State = "active"|"cancelling"|"cancelled"|"completed",
#'       StatusMessage = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_conversion_tasks(
#'   ConversionTaskIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_conversion_tasks
ec2_describe_conversion_tasks <- function(ConversionTaskIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeConversionTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_conversion_tasks_input(ConversionTaskIds = ConversionTaskIds, DryRun = DryRun)
  output <- .ec2$describe_conversion_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_conversion_tasks <- ec2_describe_conversion_tasks

#' Describes one or more of your VPN customer gateways
#'
#' @description
#' Describes one or more of your VPN customer gateways.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_describe_customer_gateways(CustomerGatewayIds, Filters, DryRun)
#'
#' @param CustomerGatewayIds One or more customer gateway IDs.
#' 
#' Default: Describes all your customer gateways.
#' @param Filters One or more filters.
#' 
#' -   `bgp-asn` - The customer gateway's Border Gateway Protocol (BGP)
#'     Autonomous System Number (ASN).
#' 
#' -   `customer-gateway-id` - The ID of the customer gateway.
#' 
#' -   `ip-address` - The IP address of the customer gateway's
#'     Internet-routable external interface.
#' 
#' -   `state` - The state of the customer gateway (`pending` | `available`
#'     | `deleting` | `deleted`).
#' 
#' -   `type` - The type of customer gateway. Currently, the only supported
#'     type is `ipsec.1`.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CustomerGateways = list(
#'     list(
#'       BgpAsn = "string",
#'       CustomerGatewayId = "string",
#'       IpAddress = "string",
#'       CertificateArn = "string",
#'       State = "string",
#'       Type = "string",
#'       DeviceName = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_customer_gateways(
#'   CustomerGatewayIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified customer gateway.
#' svc$describe_customer_gateways(
#'   CustomerGatewayIds = list(
#'     "cgw-0e11f167"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_customer_gateways
ec2_describe_customer_gateways <- function(CustomerGatewayIds = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCustomerGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_customer_gateways_input(CustomerGatewayIds = CustomerGatewayIds, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_customer_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_customer_gateways <- ec2_describe_customer_gateways

#' Describes one or more of your DHCP options sets
#'
#' @description
#' Describes one or more of your DHCP options sets.
#' 
#' For more information, see [DHCP Options
#' Sets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_describe_dhcp_options(DhcpOptionsIds, Filters, DryRun, NextToken,
#'   MaxResults)
#'
#' @param DhcpOptionsIds The IDs of one or more DHCP options sets.
#' 
#' Default: Describes all your DHCP options sets.
#' @param Filters One or more filters.
#' 
#' -   `dhcp-options-id` - The ID of a DHCP options set.
#' 
#' -   `key` - The key for one of the options (for example, `domain-name`).
#' 
#' -   `value` - The value for one of the options.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the DHCP options
#'     set.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DhcpOptions = list(
#'     list(
#'       DhcpConfigurations = list(
#'         list(
#'           Key = "string",
#'           Values = list(
#'             list(
#'               Value = "string"
#'             )
#'           )
#'         )
#'       ),
#'       DhcpOptionsId = "string",
#'       OwnerId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_dhcp_options(
#'   DhcpOptionsIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified DHCP options set.
#' svc$describe_dhcp_options(
#'   DhcpOptionsIds = list(
#'     "dopt-d9070ebb"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_dhcp_options
ec2_describe_dhcp_options <- function(DhcpOptionsIds = NULL, Filters = NULL, DryRun = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeDhcpOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_dhcp_options_input(DhcpOptionsIds = DhcpOptionsIds, Filters = Filters, DryRun = DryRun, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_dhcp_options <- ec2_describe_dhcp_options

#' Describes one or more of your egress-only internet gateways
#'
#' @description
#' Describes one or more of your egress-only internet gateways.
#'
#' @usage
#' ec2_describe_egress_only_internet_gateways(DryRun,
#'   EgressOnlyInternetGatewayIds, MaxResults, NextToken, Filters)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EgressOnlyInternetGatewayIds One or more egress-only internet gateway IDs.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param Filters One or more filters.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EgressOnlyInternetGateways = list(
#'     list(
#'       Attachments = list(
#'         list(
#'           State = "attaching"|"attached"|"detaching"|"detached",
#'           VpcId = "string"
#'         )
#'       ),
#'       EgressOnlyInternetGatewayId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_egress_only_internet_gateways(
#'   DryRun = TRUE|FALSE,
#'   EgressOnlyInternetGatewayIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_egress_only_internet_gateways
ec2_describe_egress_only_internet_gateways <- function(DryRun = NULL, EgressOnlyInternetGatewayIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeEgressOnlyInternetGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_egress_only_internet_gateways_input(DryRun = DryRun, EgressOnlyInternetGatewayIds = EgressOnlyInternetGatewayIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .ec2$describe_egress_only_internet_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_egress_only_internet_gateways <- ec2_describe_egress_only_internet_gateways

#' Describes the Elastic Graphics accelerator associated with your
#' instances
#'
#' @description
#' Describes the Elastic Graphics accelerator associated with your
#' instances. For more information about Elastic Graphics, see [Amazon
#' Elastic
#' Graphics](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html).
#'
#' @usage
#' ec2_describe_elastic_gpus(ElasticGpuIds, DryRun, Filters, MaxResults,
#'   NextToken)
#'
#' @param ElasticGpuIds The Elastic Graphics accelerator IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone in which the Elastic
#'     Graphics accelerator resides.
#' 
#' -   `elastic-gpu-health` - The status of the Elastic Graphics
#'     accelerator (`OK` | `IMPAIRED`).
#' 
#' -   `elastic-gpu-state` - The state of the Elastic Graphics accelerator
#'     (`ATTACHED`).
#' 
#' -   `elastic-gpu-type` - The type of Elastic Graphics accelerator; for
#'     example, `eg1.medium`.
#' 
#' -   `instance-id` - The ID of the instance to which the Elastic Graphics
#'     accelerator is associated.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 5 and 1000.
#' @param NextToken The token to request the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ElasticGpuSet = list(
#'     list(
#'       ElasticGpuId = "string",
#'       AvailabilityZone = "string",
#'       ElasticGpuType = "string",
#'       ElasticGpuHealth = list(
#'         Status = "OK"|"IMPAIRED"
#'       ),
#'       ElasticGpuState = "ATTACHED",
#'       InstanceId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_elastic_gpus(
#'   ElasticGpuIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_elastic_gpus
ec2_describe_elastic_gpus <- function(ElasticGpuIds = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeElasticGpus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_elastic_gpus_input(ElasticGpuIds = ElasticGpuIds, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_elastic_gpus_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_elastic_gpus <- ec2_describe_elastic_gpus

#' Describes the specified export image tasks or all of your export image
#' tasks
#'
#' @description
#' Describes the specified export image tasks or all of your export image
#' tasks.
#'
#' @usage
#' ec2_describe_export_image_tasks(DryRun, Filters, ExportImageTaskIds,
#'   MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters Filter tasks using the `task-state` filter and one of the following
#' values: `active`, `completed`, `deleting`, or `deleted`.
#' @param ExportImageTaskIds The IDs of the export image tasks.
#' @param MaxResults The maximum number of results to return in a single call.
#' @param NextToken A token that indicates the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ExportImageTasks = list(
#'     list(
#'       Description = "string",
#'       ExportImageTaskId = "string",
#'       ImageId = "string",
#'       Progress = "string",
#'       S3ExportLocation = list(
#'         S3Bucket = "string",
#'         S3Prefix = "string"
#'       ),
#'       Status = "string",
#'       StatusMessage = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_export_image_tasks(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ExportImageTaskIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_export_image_tasks
ec2_describe_export_image_tasks <- function(DryRun = NULL, Filters = NULL, ExportImageTaskIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeExportImageTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_export_image_tasks_input(DryRun = DryRun, Filters = Filters, ExportImageTaskIds = ExportImageTaskIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_export_image_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_export_image_tasks <- ec2_describe_export_image_tasks

#' Describes the specified export instance tasks or all of your export
#' instance tasks
#'
#' @description
#' Describes the specified export instance tasks or all of your export
#' instance tasks.
#'
#' @usage
#' ec2_describe_export_tasks(ExportTaskIds, Filters)
#'
#' @param ExportTaskIds The export task IDs.
#' @param Filters the filters for the export tasks.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ExportTasks = list(
#'     list(
#'       Description = "string",
#'       ExportTaskId = "string",
#'       ExportToS3Task = list(
#'         ContainerFormat = "ova",
#'         DiskImageFormat = "VMDK"|"RAW"|"VHD",
#'         S3Bucket = "string",
#'         S3Key = "string"
#'       ),
#'       InstanceExportDetails = list(
#'         InstanceId = "string",
#'         TargetEnvironment = "citrix"|"vmware"|"microsoft"
#'       ),
#'       State = "active"|"cancelling"|"cancelled"|"completed",
#'       StatusMessage = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_export_tasks(
#'   ExportTaskIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_export_tasks
ec2_describe_export_tasks <- function(ExportTaskIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeExportTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_export_tasks_input(ExportTaskIds = ExportTaskIds, Filters = Filters)
  output <- .ec2$describe_export_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_export_tasks <- ec2_describe_export_tasks

#' Describes the state of fast snapshot restores for your snapshots
#'
#' @description
#' Describes the state of fast snapshot restores for your snapshots.
#'
#' @usage
#' ec2_describe_fast_snapshot_restores(Filters, MaxResults, NextToken,
#'   DryRun)
#'
#' @param Filters The filters. The possible values are:
#' 
#' -   `availability-zone`: The Availability Zone of the snapshot.
#' 
#' -   `owner-id`: The ID of the AWS account that enabled fast snapshot
#'     restore on the snapshot.
#' 
#' -   `snapshot-id`: The ID of the snapshot.
#' 
#' -   `state`: The state of fast snapshot restores for the snapshot
#'     (`enabling` | `optimizing` | `enabled` | `disabling` | `disabled`).
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FastSnapshotRestores = list(
#'     list(
#'       SnapshotId = "string",
#'       AvailabilityZone = "string",
#'       State = "enabling"|"optimizing"|"enabled"|"disabling"|"disabled",
#'       StateTransitionReason = "string",
#'       OwnerId = "string",
#'       OwnerAlias = "string",
#'       EnablingTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       OptimizingTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EnabledTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DisablingTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DisabledTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_fast_snapshot_restores(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fast_snapshot_restores
ec2_describe_fast_snapshot_restores <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeFastSnapshotRestores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fast_snapshot_restores_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_fast_snapshot_restores_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fast_snapshot_restores <- ec2_describe_fast_snapshot_restores

#' Describes the events for the specified EC2 Fleet during the specified
#' time
#'
#' @description
#' Describes the events for the specified EC2 Fleet during the specified
#' time.
#' 
#' EC2 Fleet events are delayed by up to 30 seconds before they can be
#' described. This ensures that you can query by the last evaluated time
#' and not miss a recorded event. EC2 Fleet events are available for 48
#' hours.
#'
#' @usage
#' ec2_describe_fleet_history(DryRun, EventType, MaxResults, NextToken,
#'   FleetId, StartTime)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EventType The type of events to describe. By default, all events are described.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param FleetId &#91;required&#93; The ID of the EC2 Fleet.
#' @param StartTime &#91;required&#93; The start date and time for the events, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   HistoryRecords = list(
#'     list(
#'       EventInformation = list(
#'         EventDescription = "string",
#'         EventSubType = "string",
#'         InstanceId = "string"
#'       ),
#'       EventType = "instance-change"|"fleet-change"|"service-error",
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   LastEvaluatedTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NextToken = "string",
#'   FleetId = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_fleet_history(
#'   DryRun = TRUE|FALSE,
#'   EventType = "instance-change"|"fleet-change"|"service-error",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   FleetId = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fleet_history
ec2_describe_fleet_history <- function(DryRun = NULL, EventType = NULL, MaxResults = NULL, NextToken = NULL, FleetId, StartTime) {
  op <- new_operation(
    name = "DescribeFleetHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fleet_history_input(DryRun = DryRun, EventType = EventType, MaxResults = MaxResults, NextToken = NextToken, FleetId = FleetId, StartTime = StartTime)
  output <- .ec2$describe_fleet_history_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fleet_history <- ec2_describe_fleet_history

#' Describes the running instances for the specified EC2 Fleet
#'
#' @description
#' Describes the running instances for the specified EC2 Fleet.
#'
#' @usage
#' ec2_describe_fleet_instances(DryRun, MaxResults, NextToken, FleetId,
#'   Filters)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param FleetId &#91;required&#93; The ID of the EC2 Fleet.
#' @param Filters The filters.
#' 
#' -   `instance-type` - The instance type.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ActiveInstances = list(
#'     list(
#'       InstanceId = "string",
#'       InstanceType = "string",
#'       SpotInstanceRequestId = "string",
#'       InstanceHealth = "healthy"|"unhealthy"
#'     )
#'   ),
#'   NextToken = "string",
#'   FleetId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_fleet_instances(
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string",
#'   FleetId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fleet_instances
ec2_describe_fleet_instances <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, FleetId, Filters = NULL) {
  op <- new_operation(
    name = "DescribeFleetInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fleet_instances_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, FleetId = FleetId, Filters = Filters)
  output <- .ec2$describe_fleet_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fleet_instances <- ec2_describe_fleet_instances

#' Describes the specified EC2 Fleets or all of your EC2 Fleets
#'
#' @description
#' Describes the specified EC2 Fleets or all of your EC2 Fleets.
#'
#' @usage
#' ec2_describe_fleets(DryRun, MaxResults, NextToken, FleetIds, Filters)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param FleetIds The ID of the EC2 Fleets.
#' @param Filters The filters.
#' 
#' -   `activity-status` - The progress of the EC2 Fleet ( `error` |
#'     `pending-fulfillment` | `pending-termination` | `fulfilled`).
#' 
#' -   `excess-capacity-termination-policy` - Indicates whether to
#'     terminate running instances if the target capacity is decreased
#'     below the current EC2 Fleet size (`true` | `false`).
#' 
#' -   `fleet-state` - The state of the EC2 Fleet (`submitted` | `active` |
#'     `deleted` | `failed` | `deleted-running` | `deleted-terminating` |
#'     `modifying`).
#' 
#' -   `replace-unhealthy-instances` - Indicates whether EC2 Fleet should
#'     replace unhealthy instances (`true` | `false`).
#' 
#' -   `type` - The type of request (`instant` | `request` | `maintain`).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   Fleets = list(
#'     list(
#'       ActivityStatus = "error"|"pending_fulfillment"|"pending_termination"|"fulfilled",
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       FleetId = "string",
#'       FleetState = "submitted"|"active"|"deleted"|"failed"|"deleted_running"|"deleted_terminating"|"modifying",
#'       ClientToken = "string",
#'       ExcessCapacityTerminationPolicy = "no-termination"|"termination",
#'       FulfilledCapacity = 123.0,
#'       FulfilledOnDemandCapacity = 123.0,
#'       LaunchTemplateConfigs = list(
#'         list(
#'           LaunchTemplateSpecification = list(
#'             LaunchTemplateId = "string",
#'             LaunchTemplateName = "string",
#'             Version = "string"
#'           ),
#'           Overrides = list(
#'             list(
#'               InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'               MaxPrice = "string",
#'               SubnetId = "string",
#'               AvailabilityZone = "string",
#'               WeightedCapacity = 123.0,
#'               Priority = 123.0,
#'               Placement = list(
#'                 GroupName = "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       TargetCapacitySpecification = list(
#'         TotalTargetCapacity = 123,
#'         OnDemandTargetCapacity = 123,
#'         SpotTargetCapacity = 123,
#'         DefaultTargetCapacityType = "spot"|"on-demand"
#'       ),
#'       TerminateInstancesWithExpiration = TRUE|FALSE,
#'       Type = "request"|"maintain"|"instant",
#'       ValidFrom = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ValidUntil = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ReplaceUnhealthyInstances = TRUE|FALSE,
#'       SpotOptions = list(
#'         AllocationStrategy = "lowest-price"|"diversified"|"capacity-optimized",
#'         MaintenanceStrategies = list(
#'           CapacityRebalance = list(
#'             ReplacementStrategy = "launch"
#'           )
#'         ),
#'         InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate",
#'         InstancePoolsToUseCount = 123,
#'         SingleInstanceType = TRUE|FALSE,
#'         SingleAvailabilityZone = TRUE|FALSE,
#'         MinTargetCapacity = 123,
#'         MaxTotalPrice = "string"
#'       ),
#'       OnDemandOptions = list(
#'         AllocationStrategy = "lowest-price"|"prioritized",
#'         CapacityReservationOptions = list(
#'           UsageStrategy = "use-capacity-reservations-first"
#'         ),
#'         SingleInstanceType = TRUE|FALSE,
#'         SingleAvailabilityZone = TRUE|FALSE,
#'         MinTargetCapacity = 123,
#'         MaxTotalPrice = "string"
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       Errors = list(
#'         list(
#'           LaunchTemplateAndOverrides = list(
#'             LaunchTemplateSpecification = list(
#'               LaunchTemplateId = "string",
#'               LaunchTemplateName = "string",
#'               Version = "string"
#'             ),
#'             Overrides = list(
#'               InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'               MaxPrice = "string",
#'               SubnetId = "string",
#'               AvailabilityZone = "string",
#'               WeightedCapacity = 123.0,
#'               Priority = 123.0,
#'               Placement = list(
#'                 GroupName = "string"
#'               )
#'             )
#'           ),
#'           Lifecycle = "spot"|"on-demand",
#'           ErrorCode = "string",
#'           ErrorMessage = "string"
#'         )
#'       ),
#'       Instances = list(
#'         list(
#'           LaunchTemplateAndOverrides = list(
#'             LaunchTemplateSpecification = list(
#'               LaunchTemplateId = "string",
#'               LaunchTemplateName = "string",
#'               Version = "string"
#'             ),
#'             Overrides = list(
#'               InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'               MaxPrice = "string",
#'               SubnetId = "string",
#'               AvailabilityZone = "string",
#'               WeightedCapacity = 123.0,
#'               Priority = 123.0,
#'               Placement = list(
#'                 GroupName = "string"
#'               )
#'             )
#'           ),
#'           Lifecycle = "spot"|"on-demand",
#'           InstanceIds = list(
#'             "string"
#'           ),
#'           InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'           Platform = "Windows"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_fleets(
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string",
#'   FleetIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fleets
ec2_describe_fleets <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, FleetIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeFleets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fleets_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, FleetIds = FleetIds, Filters = Filters)
  output <- .ec2$describe_fleets_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fleets <- ec2_describe_fleets

#' Describes one or more flow logs
#'
#' @description
#' Describes one or more flow logs. To view the information in your flow
#' logs (the log streams for the network interfaces), you must use the
#' CloudWatch Logs console or the CloudWatch Logs API.
#'
#' @usage
#' ec2_describe_flow_logs(DryRun, Filter, FlowLogIds, MaxResults,
#'   NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filter One or more filters.
#' 
#' -   `deliver-log-status` - The status of the logs delivery (`SUCCESS` |
#'     `FAILED`).
#' 
#' -   `log-destination-type` - The type of destination to which the flow
#'     log publishes data. Possible destination types include
#'     `cloud-watch-logs` and `s3`.
#' 
#' -   `flow-log-id` - The ID of the flow log.
#' 
#' -   `log-group-name` - The name of the log group.
#' 
#' -   `resource-id` - The ID of the VPC, subnet, or network interface.
#' 
#' -   `traffic-type` - The type of traffic (`ACCEPT` | `REJECT` | `ALL`).
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param FlowLogIds One or more flow log IDs.
#' 
#' Constraint: Maximum of 1000 flow log IDs.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FlowLogs = list(
#'     list(
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DeliverLogsErrorMessage = "string",
#'       DeliverLogsPermissionArn = "string",
#'       DeliverLogsStatus = "string",
#'       FlowLogId = "string",
#'       FlowLogStatus = "string",
#'       LogGroupName = "string",
#'       ResourceId = "string",
#'       TrafficType = "ACCEPT"|"REJECT"|"ALL",
#'       LogDestinationType = "cloud-watch-logs"|"s3",
#'       LogDestination = "string",
#'       LogFormat = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       MaxAggregationInterval = 123
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_flow_logs(
#'   DryRun = TRUE|FALSE,
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   FlowLogIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_flow_logs
ec2_describe_flow_logs <- function(DryRun = NULL, Filter = NULL, FlowLogIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeFlowLogs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_flow_logs_input(DryRun = DryRun, Filter = Filter, FlowLogIds = FlowLogIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_flow_logs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_flow_logs <- ec2_describe_flow_logs

#' Describes the specified attribute of the specified Amazon FPGA Image
#' (AFI)
#'
#' @description
#' Describes the specified attribute of the specified Amazon FPGA Image
#' (AFI).
#'
#' @usage
#' ec2_describe_fpga_image_attribute(DryRun, FpgaImageId, Attribute)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageId &#91;required&#93; The ID of the AFI.
#' @param Attribute &#91;required&#93; The AFI attribute.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FpgaImageAttribute = list(
#'     FpgaImageId = "string",
#'     Name = "string",
#'     Description = "string",
#'     LoadPermissions = list(
#'       list(
#'         UserId = "string",
#'         Group = "all"
#'       )
#'     ),
#'     ProductCodes = list(
#'       list(
#'         ProductCodeId = "string",
#'         ProductCodeType = "devpay"|"marketplace"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_fpga_image_attribute(
#'   DryRun = TRUE|FALSE,
#'   FpgaImageId = "string",
#'   Attribute = "description"|"name"|"loadPermission"|"productCodes"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fpga_image_attribute
ec2_describe_fpga_image_attribute <- function(DryRun = NULL, FpgaImageId, Attribute) {
  op <- new_operation(
    name = "DescribeFpgaImageAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fpga_image_attribute_input(DryRun = DryRun, FpgaImageId = FpgaImageId, Attribute = Attribute)
  output <- .ec2$describe_fpga_image_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fpga_image_attribute <- ec2_describe_fpga_image_attribute

#' Describes the Amazon FPGA Images (AFIs) available to you
#'
#' @description
#' Describes the Amazon FPGA Images (AFIs) available to you. These include
#' public AFIs, private AFIs that you own, and AFIs owned by other AWS
#' accounts for which you have load permissions.
#'
#' @usage
#' ec2_describe_fpga_images(DryRun, FpgaImageIds, Owners, Filters,
#'   NextToken, MaxResults)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageIds The AFI IDs.
#' @param Owners Filters the AFI by owner. Specify an AWS account ID, `self` (owner is
#' the sender of the request), or an AWS owner alias (valid values are
#' `amazon` | `aws-marketplace`).
#' @param Filters The filters.
#' 
#' -   `create-time` - The creation time of the AFI.
#' 
#' -   `fpga-image-id` - The FPGA image identifier (AFI ID).
#' 
#' -   `fpga-image-global-id` - The global FPGA image identifier (AGFI ID).
#' 
#' -   `name` - The name of the AFI.
#' 
#' -   `owner-id` - The AWS account ID of the AFI owner.
#' 
#' -   `product-code` - The product code.
#' 
#' -   `shell-version` - The version of the AWS Shell that was used to
#'     create the bitstream.
#' 
#' -   `state` - The state of the AFI (`pending` | `failed` | `available` |
#'     `unavailable`).
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `update-time` - The time of the most recent update.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FpgaImages = list(
#'     list(
#'       FpgaImageId = "string",
#'       FpgaImageGlobalId = "string",
#'       Name = "string",
#'       Description = "string",
#'       ShellVersion = "string",
#'       PciId = list(
#'         DeviceId = "string",
#'         VendorId = "string",
#'         SubsystemId = "string",
#'         SubsystemVendorId = "string"
#'       ),
#'       State = list(
#'         Code = "pending"|"failed"|"available"|"unavailable",
#'         Message = "string"
#'       ),
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       UpdateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       OwnerId = "string",
#'       OwnerAlias = "string",
#'       ProductCodes = list(
#'         list(
#'           ProductCodeId = "string",
#'           ProductCodeType = "devpay"|"marketplace"
#'         )
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       Public = TRUE|FALSE,
#'       DataRetentionSupport = TRUE|FALSE
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_fpga_images(
#'   DryRun = TRUE|FALSE,
#'   FpgaImageIds = list(
#'     "string"
#'   ),
#'   Owners = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fpga_images
ec2_describe_fpga_images <- function(DryRun = NULL, FpgaImageIds = NULL, Owners = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeFpgaImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fpga_images_input(DryRun = DryRun, FpgaImageIds = FpgaImageIds, Owners = Owners, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_fpga_images_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fpga_images <- ec2_describe_fpga_images

#' Describes the Dedicated Host reservations that are available to purchase
#'
#' @description
#' Describes the Dedicated Host reservations that are available to
#' purchase.
#' 
#' The results describe all of the Dedicated Host reservation offerings,
#' including offerings that might not match the instance family and Region
#' of your Dedicated Hosts. When purchasing an offering, ensure that the
#' instance family and Region of the offering matches that of the Dedicated
#' Hosts with which it is to be associated. For more information about
#' supported instance types, see [Dedicated Hosts
#' Overview](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_host_reservation_offerings(Filter, MaxDuration, MaxResults,
#'   MinDuration, NextToken, OfferingId)
#'
#' @param Filter The filters.
#' 
#' -   `instance-family` - The instance family of the offering (for
#'     example, `m4`).
#' 
#' -   `payment-option` - The payment option (`NoUpfront` |
#'     `PartialUpfront` | `AllUpfront`).
#' @param MaxDuration This is the maximum duration of the reservation to purchase, specified
#' in seconds. Reservations are available in one-year and three-year terms.
#' The number of seconds specified must be the number of seconds in a year
#' (365x24x60x60) times one of the supported durations (1 or 3). For
#' example, specify 94608000 for three years.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' @param MinDuration This is the minimum duration of the reservation you'd like to purchase,
#' specified in seconds. Reservations are available in one-year and
#' three-year terms. The number of seconds specified must be the number of
#' seconds in a year (365x24x60x60) times one of the supported durations (1
#' or 3). For example, specify 31536000 for one year.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param OfferingId The ID of the reservation offering.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   OfferingSet = list(
#'     list(
#'       CurrencyCode = "USD",
#'       Duration = 123,
#'       HourlyPrice = "string",
#'       InstanceFamily = "string",
#'       OfferingId = "string",
#'       PaymentOption = "AllUpfront"|"PartialUpfront"|"NoUpfront",
#'       UpfrontPrice = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_host_reservation_offerings(
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxDuration = 123,
#'   MaxResults = 123,
#'   MinDuration = 123,
#'   NextToken = "string",
#'   OfferingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_host_reservation_offerings
ec2_describe_host_reservation_offerings <- function(Filter = NULL, MaxDuration = NULL, MaxResults = NULL, MinDuration = NULL, NextToken = NULL, OfferingId = NULL) {
  op <- new_operation(
    name = "DescribeHostReservationOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_host_reservation_offerings_input(Filter = Filter, MaxDuration = MaxDuration, MaxResults = MaxResults, MinDuration = MinDuration, NextToken = NextToken, OfferingId = OfferingId)
  output <- .ec2$describe_host_reservation_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_host_reservation_offerings <- ec2_describe_host_reservation_offerings

#' Describes reservations that are associated with Dedicated Hosts in your
#' account
#'
#' @description
#' Describes reservations that are associated with Dedicated Hosts in your
#' account.
#'
#' @usage
#' ec2_describe_host_reservations(Filter, HostReservationIdSet, MaxResults,
#'   NextToken)
#'
#' @param Filter The filters.
#' 
#' -   `instance-family` - The instance family (for example, `m4`).
#' 
#' -   `payment-option` - The payment option (`NoUpfront` |
#'     `PartialUpfront` | `AllUpfront`).
#' 
#' -   `state` - The state of the reservation (`payment-pending` |
#'     `payment-failed` | `active` | `retired`).
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param HostReservationIdSet The host reservation IDs.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' @param NextToken The token to use to retrieve the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   HostReservationSet = list(
#'     list(
#'       Count = 123,
#'       CurrencyCode = "USD",
#'       Duration = 123,
#'       End = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       HostIdSet = list(
#'         "string"
#'       ),
#'       HostReservationId = "string",
#'       HourlyPrice = "string",
#'       InstanceFamily = "string",
#'       OfferingId = "string",
#'       PaymentOption = "AllUpfront"|"PartialUpfront"|"NoUpfront",
#'       Start = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       State = "payment-pending"|"payment-failed"|"active"|"retired",
#'       UpfrontPrice = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_host_reservations(
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   HostReservationIdSet = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_host_reservations
ec2_describe_host_reservations <- function(Filter = NULL, HostReservationIdSet = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeHostReservations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_host_reservations_input(Filter = Filter, HostReservationIdSet = HostReservationIdSet, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_host_reservations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_host_reservations <- ec2_describe_host_reservations

#' Describes the specified Dedicated Hosts or all your Dedicated Hosts
#'
#' @description
#' Describes the specified Dedicated Hosts or all your Dedicated Hosts.
#' 
#' The results describe only the Dedicated Hosts in the Region you're
#' currently using. All listed instances consume capacity on your Dedicated
#' Host. Dedicated Hosts that have recently been released are listed with
#' the state `released`.
#'
#' @usage
#' ec2_describe_hosts(Filter, HostIds, MaxResults, NextToken)
#'
#' @param Filter The filters.
#' 
#' -   `auto-placement` - Whether auto-placement is enabled or disabled
#'     (`on` | `off`).
#' 
#' -   `availability-zone` - The Availability Zone of the host.
#' 
#' -   `client-token` - The idempotency token that you provided when you
#'     allocated the host.
#' 
#' -   `host-reservation-id` - The ID of the reservation assigned to this
#'     host.
#' 
#' -   `instance-type` - The instance type size that the Dedicated Host is
#'     configured to support.
#' 
#' -   `state` - The allocation state of the Dedicated Host (`available` |
#'     `under-assessment` | `permanent-failure` | `released` |
#'     `released-permanent-failure`).
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param HostIds The IDs of the Dedicated Hosts. The IDs are used for targeted instance
#' launches.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' 
#' You cannot specify this parameter and the host IDs parameter in the same
#' request.
#' @param NextToken The token to use to retrieve the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Hosts = list(
#'     list(
#'       AutoPlacement = "on"|"off",
#'       AvailabilityZone = "string",
#'       AvailableCapacity = list(
#'         AvailableInstanceCapacity = list(
#'           list(
#'             AvailableCapacity = 123,
#'             InstanceType = "string",
#'             TotalCapacity = 123
#'           )
#'         ),
#'         AvailableVCpus = 123
#'       ),
#'       ClientToken = "string",
#'       HostId = "string",
#'       HostProperties = list(
#'         Cores = 123,
#'         InstanceType = "string",
#'         InstanceFamily = "string",
#'         Sockets = 123,
#'         TotalVCpus = 123
#'       ),
#'       HostReservationId = "string",
#'       Instances = list(
#'         list(
#'           InstanceId = "string",
#'           InstanceType = "string",
#'           OwnerId = "string"
#'         )
#'       ),
#'       State = "available"|"under-assessment"|"permanent-failure"|"released"|"released-permanent-failure"|"pending",
#'       AllocationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ReleaseTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       HostRecovery = "on"|"off",
#'       AllowsMultipleInstanceTypes = "on"|"off",
#'       OwnerId = "string",
#'       AvailabilityZoneId = "string",
#'       MemberOfServiceLinkedResourceGroup = TRUE|FALSE
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_hosts(
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   HostIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_hosts
ec2_describe_hosts <- function(Filter = NULL, HostIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeHosts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_hosts_input(Filter = Filter, HostIds = HostIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_hosts_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_hosts <- ec2_describe_hosts

#' Describes your IAM instance profile associations
#'
#' @description
#' Describes your IAM instance profile associations.
#'
#' @usage
#' ec2_describe_iam_instance_profile_associations(AssociationIds, Filters,
#'   MaxResults, NextToken)
#'
#' @param AssociationIds The IAM instance profile associations.
#' @param Filters The filters.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `state` - The state of the association (`associating` | `associated`
#'     | `disassociating`).
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IamInstanceProfileAssociations = list(
#'     list(
#'       AssociationId = "string",
#'       InstanceId = "string",
#'       IamInstanceProfile = list(
#'         Arn = "string",
#'         Id = "string"
#'       ),
#'       State = "associating"|"associated"|"disassociating"|"disassociated",
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_iam_instance_profile_associations(
#'   AssociationIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified IAM instance profile association.
#' svc$describe_iam_instance_profile_associations(
#'   AssociationIds = list(
#'     "iip-assoc-0db249b1f25fa24b8"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_iam_instance_profile_associations
ec2_describe_iam_instance_profile_associations <- function(AssociationIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeIamInstanceProfileAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_iam_instance_profile_associations_input(AssociationIds = AssociationIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_iam_instance_profile_associations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_iam_instance_profile_associations <- ec2_describe_iam_instance_profile_associations

#' Describes the ID format settings for your resources on a per-Region
#' basis, for example, to view which resource types are enabled for longer
#' IDs
#'
#' @description
#' Describes the ID format settings for your resources on a per-Region
#' basis, for example, to view which resource types are enabled for longer
#' IDs. This request only returns information about resource types whose ID
#' formats can be modified; it does not return information about other
#' resource types.
#' 
#' The following resource types support longer IDs: `bundle` |
#' `conversion-task` | `customer-gateway` | `dhcp-options` |
#' `elastic-ip-allocation` | `elastic-ip-association` | `export-task` |
#' `flow-log` | `image` | `import-task` | `instance` | `internet-gateway` |
#' `network-acl` | `network-acl-association` | `network-interface` |
#' `network-interface-attachment` | `prefix-list` | `reservation` |
#' `route-table` | `route-table-association` | `security-group` |
#' `snapshot` | `subnet` | `subnet-cidr-block-association` | `volume` |
#' `vpc` | `vpc-cidr-block-association` | `vpc-endpoint` |
#' `vpc-peering-connection` | `vpn-connection` | `vpn-gateway`.
#' 
#' These settings apply to the IAM user who makes the request; they do not
#' apply to the entire AWS account. By default, an IAM user defaults to the
#' same settings as the root user, unless they explicitly override the
#' settings by running the [`modify_id_format`][ec2_modify_id_format]
#' command. Resources created with longer IDs are visible to all IAM users,
#' regardless of these settings and provided that they have permission to
#' use the relevant `Describe` command for the resource type.
#'
#' @usage
#' ec2_describe_id_format(Resource)
#'
#' @param Resource The type of resource: `bundle` | `conversion-task` | `customer-gateway`
#' | `dhcp-options` | `elastic-ip-allocation` | `elastic-ip-association` |
#' `export-task` | `flow-log` | `image` | `import-task` | `instance` |
#' `internet-gateway` | `network-acl` | `network-acl-association` |
#' `network-interface` | `network-interface-attachment` | `prefix-list` |
#' `reservation` | `route-table` | `route-table-association` |
#' `security-group` | `snapshot` | `subnet` |
#' `subnet-cidr-block-association` | `volume` | `vpc` |
#' `vpc-cidr-block-association` | `vpc-endpoint` | `vpc-peering-connection`
#' | `vpn-connection` | `vpn-gateway`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Statuses = list(
#'     list(
#'       Deadline = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Resource = "string",
#'       UseLongIds = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_id_format(
#'   Resource = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_id_format
ec2_describe_id_format <- function(Resource = NULL) {
  op <- new_operation(
    name = "DescribeIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_id_format_input(Resource = Resource)
  output <- .ec2$describe_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_id_format <- ec2_describe_id_format

#' Describes the ID format settings for resources for the specified IAM
#' user, IAM role, or root user
#'
#' @description
#' Describes the ID format settings for resources for the specified IAM
#' user, IAM role, or root user. For example, you can view the resource
#' types that are enabled for longer IDs. This request only returns
#' information about resource types whose ID formats can be modified; it
#' does not return information about other resource types. For more
#' information, see [Resource
#' IDs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' The following resource types support longer IDs: `bundle` |
#' `conversion-task` | `customer-gateway` | `dhcp-options` |
#' `elastic-ip-allocation` | `elastic-ip-association` | `export-task` |
#' `flow-log` | `image` | `import-task` | `instance` | `internet-gateway` |
#' `network-acl` | `network-acl-association` | `network-interface` |
#' `network-interface-attachment` | `prefix-list` | `reservation` |
#' `route-table` | `route-table-association` | `security-group` |
#' `snapshot` | `subnet` | `subnet-cidr-block-association` | `volume` |
#' `vpc` | `vpc-cidr-block-association` | `vpc-endpoint` |
#' `vpc-peering-connection` | `vpn-connection` | `vpn-gateway`.
#' 
#' These settings apply to the principal specified in the request. They do
#' not apply to the principal that makes the request.
#'
#' @usage
#' ec2_describe_identity_id_format(PrincipalArn, Resource)
#'
#' @param PrincipalArn &#91;required&#93; The ARN of the principal, which can be an IAM role, IAM user, or the
#' root user.
#' @param Resource The type of resource: `bundle` | `conversion-task` | `customer-gateway`
#' | `dhcp-options` | `elastic-ip-allocation` | `elastic-ip-association` |
#' `export-task` | `flow-log` | `image` | `import-task` | `instance` |
#' `internet-gateway` | `network-acl` | `network-acl-association` |
#' `network-interface` | `network-interface-attachment` | `prefix-list` |
#' `reservation` | `route-table` | `route-table-association` |
#' `security-group` | `snapshot` | `subnet` |
#' `subnet-cidr-block-association` | `volume` | `vpc` |
#' `vpc-cidr-block-association` | `vpc-endpoint` | `vpc-peering-connection`
#' | `vpn-connection` | `vpn-gateway`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Statuses = list(
#'     list(
#'       Deadline = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Resource = "string",
#'       UseLongIds = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_identity_id_format(
#'   PrincipalArn = "string",
#'   Resource = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_identity_id_format
ec2_describe_identity_id_format <- function(PrincipalArn, Resource = NULL) {
  op <- new_operation(
    name = "DescribeIdentityIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_identity_id_format_input(PrincipalArn = PrincipalArn, Resource = Resource)
  output <- .ec2$describe_identity_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_identity_id_format <- ec2_describe_identity_id_format

#' Describes the specified attribute of the specified AMI
#'
#' @description
#' Describes the specified attribute of the specified AMI. You can specify
#' only one attribute at a time.
#'
#' @usage
#' ec2_describe_image_attribute(Attribute, ImageId, DryRun)
#'
#' @param Attribute &#91;required&#93; The AMI attribute.
#' 
#' **Note**: Depending on your account privileges, the `blockDeviceMapping`
#' attribute may return a `Client.AuthFailure` error. If this happens, use
#' [`describe_images`][ec2_describe_images] to get information about the
#' block device mapping for the AMI.
#' @param ImageId &#91;required&#93; The ID of the AMI.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   BlockDeviceMappings = list(
#'     list(
#'       DeviceName = "string",
#'       VirtualName = "string",
#'       Ebs = list(
#'         DeleteOnTermination = TRUE|FALSE,
#'         Iops = 123,
#'         SnapshotId = "string",
#'         VolumeSize = 123,
#'         VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
#'         KmsKeyId = "string",
#'         Throughput = 123,
#'         Encrypted = TRUE|FALSE
#'       ),
#'       NoDevice = "string"
#'     )
#'   ),
#'   ImageId = "string",
#'   LaunchPermissions = list(
#'     list(
#'       Group = "all",
#'       UserId = "string"
#'     )
#'   ),
#'   ProductCodes = list(
#'     list(
#'       ProductCodeId = "string",
#'       ProductCodeType = "devpay"|"marketplace"
#'     )
#'   ),
#'   Description = list(
#'     Value = "string"
#'   ),
#'   KernelId = list(
#'     Value = "string"
#'   ),
#'   RamdiskId = list(
#'     Value = "string"
#'   ),
#'   SriovNetSupport = list(
#'     Value = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_image_attribute(
#'   Attribute = "description"|"kernel"|"ramdisk"|"launchPermission"|"productCodes"|"blockDeviceMapping"|"sriovNetSupport",
#'   ImageId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the launch permissions for the specified AMI.
#' svc$describe_image_attribute(
#'   Attribute = "launchPermission",
#'   ImageId = "ami-5731123e"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_image_attribute
ec2_describe_image_attribute <- function(Attribute, ImageId, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeImageAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_image_attribute_input(Attribute = Attribute, ImageId = ImageId, DryRun = DryRun)
  output <- .ec2$describe_image_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_image_attribute <- ec2_describe_image_attribute

#' Describes the specified images (AMIs, AKIs, and ARIs) available to you
#' or all of the images available to you
#'
#' @description
#' Describes the specified images (AMIs, AKIs, and ARIs) available to you
#' or all of the images available to you.
#' 
#' The images available to you include public images, private images that
#' you own, and private images owned by other AWS accounts for which you
#' have explicit launch permissions.
#' 
#' Recently deregistered images appear in the returned results for a short
#' interval and then return empty results. After all instances that
#' reference a deregistered AMI are terminated, specifying the ID of the
#' image results in an error indicating that the AMI ID cannot be found.
#'
#' @usage
#' ec2_describe_images(ExecutableUsers, Filters, ImageIds, Owners, DryRun)
#'
#' @param ExecutableUsers Scopes the images by users with explicit launch permissions. Specify an
#' AWS account ID, `self` (the sender of the request), or `all` (public
#' AMIs).
#' @param Filters The filters.
#' 
#' -   `architecture` - The image architecture (`i386` | `x86_64` |
#'     `arm64`).
#' 
#' -   `block-device-mapping.delete-on-termination` - A Boolean value that
#'     indicates whether the Amazon EBS volume is deleted on instance
#'     termination.
#' 
#' -   `block-device-mapping.device-name` - The device name specified in
#'     the block device mapping (for example, `/dev/sdh` or `xvdh`).
#' 
#' -   `block-device-mapping.snapshot-id` - The ID of the snapshot used for
#'     the EBS volume.
#' 
#' -   `block-device-mapping.volume-size` - The volume size of the EBS
#'     volume, in GiB.
#' 
#' -   `block-device-mapping.volume-type` - The volume type of the EBS
#'     volume (`gp2` | `io1` | `io2` | `st1 `| `sc1` | `standard`).
#' 
#' -   `block-device-mapping.encrypted` - A Boolean that indicates whether
#'     the EBS volume is encrypted.
#' 
#' -   `description` - The description of the image (provided during image
#'     creation).
#' 
#' -   `ena-support` - A Boolean that indicates whether enhanced networking
#'     with ENA is enabled.
#' 
#' -   `hypervisor` - The hypervisor type (`ovm` | `xen`).
#' 
#' -   `image-id` - The ID of the image.
#' 
#' -   `image-type` - The image type (`machine` | `kernel` | `ramdisk`).
#' 
#' -   `is-public` - A Boolean that indicates whether the image is public.
#' 
#' -   `kernel-id` - The kernel ID.
#' 
#' -   `manifest-location` - The location of the image manifest.
#' 
#' -   `name` - The name of the AMI (provided during image creation).
#' 
#' -   `owner-alias` - The owner alias, from an Amazon-maintained list
#'     (`amazon` | `aws-marketplace`). This is not the user-configured AWS
#'     account alias set using the IAM console. We recommend that you use
#'     the related parameter instead of this filter.
#' 
#' -   `owner-id` - The AWS account ID of the owner. We recommend that you
#'     use the related parameter instead of this filter.
#' 
#' -   `platform` - The platform. To only list Windows-based AMIs, use
#'     `windows`.
#' 
#' -   `product-code` - The product code.
#' 
#' -   `product-code.type` - The type of the product code (`devpay` |
#'     `marketplace`).
#' 
#' -   `ramdisk-id` - The RAM disk ID.
#' 
#' -   `root-device-name` - The device name of the root device volume (for
#'     example, `/dev/sda1`).
#' 
#' -   `root-device-type` - The type of the root device volume (`ebs` |
#'     `instance-store`).
#' 
#' -   `state` - The state of the image (`available` | `pending` |
#'     `failed`).
#' 
#' -   `state-reason-code` - The reason code for the state change.
#' 
#' -   `state-reason-message` - The message for the state change.
#' 
#' -   `sriov-net-support` - A value of `simple` indicates that enhanced
#'     networking with the Intel 82599 VF interface is enabled.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `virtualization-type` - The virtualization type (`paravirtual` |
#'     `hvm`).
#' @param ImageIds The image IDs.
#' 
#' Default: Describes all images available to you.
#' @param Owners Scopes the results to images with the specified owners. You can specify
#' a combination of AWS account IDs, `self`, `amazon`, and
#' `aws-marketplace`. If you omit this parameter, the results include all
#' images for which you have launch permissions, regardless of ownership.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Images = list(
#'     list(
#'       Architecture = "i386"|"x86_64"|"arm64",
#'       CreationDate = "string",
#'       ImageId = "string",
#'       ImageLocation = "string",
#'       ImageType = "machine"|"kernel"|"ramdisk",
#'       Public = TRUE|FALSE,
#'       KernelId = "string",
#'       OwnerId = "string",
#'       Platform = "Windows",
#'       PlatformDetails = "string",
#'       UsageOperation = "string",
#'       ProductCodes = list(
#'         list(
#'           ProductCodeId = "string",
#'           ProductCodeType = "devpay"|"marketplace"
#'         )
#'       ),
#'       RamdiskId = "string",
#'       State = "pending"|"available"|"invalid"|"deregistered"|"transient"|"failed"|"error",
#'       BlockDeviceMappings = list(
#'         list(
#'           DeviceName = "string",
#'           VirtualName = "string",
#'           Ebs = list(
#'             DeleteOnTermination = TRUE|FALSE,
#'             Iops = 123,
#'             SnapshotId = "string",
#'             VolumeSize = 123,
#'             VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
#'             KmsKeyId = "string",
#'             Throughput = 123,
#'             Encrypted = TRUE|FALSE
#'           ),
#'           NoDevice = "string"
#'         )
#'       ),
#'       Description = "string",
#'       EnaSupport = TRUE|FALSE,
#'       Hypervisor = "ovm"|"xen",
#'       ImageOwnerAlias = "string",
#'       Name = "string",
#'       RootDeviceName = "string",
#'       RootDeviceType = "ebs"|"instance-store",
#'       SriovNetSupport = "string",
#'       StateReason = list(
#'         Code = "string",
#'         Message = "string"
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       VirtualizationType = "hvm"|"paravirtual"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_images(
#'   ExecutableUsers = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ImageIds = list(
#'     "string"
#'   ),
#'   Owners = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified AMI.
#' svc$describe_images(
#'   ImageIds = list(
#'     "ami-5731123e"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_images
ec2_describe_images <- function(ExecutableUsers = NULL, Filters = NULL, ImageIds = NULL, Owners = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_images_input(ExecutableUsers = ExecutableUsers, Filters = Filters, ImageIds = ImageIds, Owners = Owners, DryRun = DryRun)
  output <- .ec2$describe_images_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_images <- ec2_describe_images

#' Displays details about an import virtual machine or import snapshot
#' tasks that are already created
#'
#' @description
#' Displays details about an import virtual machine or import snapshot
#' tasks that are already created.
#'
#' @usage
#' ec2_describe_import_image_tasks(DryRun, Filters, ImportTaskIds,
#'   MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters Filter tasks using the `task-state` filter and one of the following
#' values: `active`, `completed`, `deleting`, or `deleted`.
#' @param ImportTaskIds The IDs of the import image tasks.
#' @param MaxResults The maximum number of results to return in a single call.
#' @param NextToken A token that indicates the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImportImageTasks = list(
#'     list(
#'       Architecture = "string",
#'       Description = "string",
#'       Encrypted = TRUE|FALSE,
#'       Hypervisor = "string",
#'       ImageId = "string",
#'       ImportTaskId = "string",
#'       KmsKeyId = "string",
#'       LicenseType = "string",
#'       Platform = "string",
#'       Progress = "string",
#'       SnapshotDetails = list(
#'         list(
#'           Description = "string",
#'           DeviceName = "string",
#'           DiskImageSize = 123.0,
#'           Format = "string",
#'           Progress = "string",
#'           SnapshotId = "string",
#'           Status = "string",
#'           StatusMessage = "string",
#'           Url = "string",
#'           UserBucket = list(
#'             S3Bucket = "string",
#'             S3Key = "string"
#'           )
#'         )
#'       ),
#'       Status = "string",
#'       StatusMessage = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       LicenseSpecifications = list(
#'         list(
#'           LicenseConfigurationArn = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_import_image_tasks(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ImportTaskIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_import_image_tasks
ec2_describe_import_image_tasks <- function(DryRun = NULL, Filters = NULL, ImportTaskIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImportImageTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_import_image_tasks_input(DryRun = DryRun, Filters = Filters, ImportTaskIds = ImportTaskIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_import_image_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_import_image_tasks <- ec2_describe_import_image_tasks

#' Describes your import snapshot tasks
#'
#' @description
#' Describes your import snapshot tasks.
#'
#' @usage
#' ec2_describe_import_snapshot_tasks(DryRun, Filters, ImportTaskIds,
#'   MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' @param ImportTaskIds A list of import snapshot task IDs.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken A token that indicates the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImportSnapshotTasks = list(
#'     list(
#'       Description = "string",
#'       ImportTaskId = "string",
#'       SnapshotTaskDetail = list(
#'         Description = "string",
#'         DiskImageSize = 123.0,
#'         Encrypted = TRUE|FALSE,
#'         Format = "string",
#'         KmsKeyId = "string",
#'         Progress = "string",
#'         SnapshotId = "string",
#'         Status = "string",
#'         StatusMessage = "string",
#'         Url = "string",
#'         UserBucket = list(
#'           S3Bucket = "string",
#'           S3Key = "string"
#'         )
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_import_snapshot_tasks(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ImportTaskIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_import_snapshot_tasks
ec2_describe_import_snapshot_tasks <- function(DryRun = NULL, Filters = NULL, ImportTaskIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImportSnapshotTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_import_snapshot_tasks_input(DryRun = DryRun, Filters = Filters, ImportTaskIds = ImportTaskIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_import_snapshot_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_import_snapshot_tasks <- ec2_describe_import_snapshot_tasks

#' Describes the specified attribute of the specified instance
#'
#' @description
#' Describes the specified attribute of the specified instance. You can
#' specify only one attribute at a time. Valid attribute values are:
#' `instanceType` | `kernel` | `ramdisk` | `userData` |
#' `disableApiTermination` | `instanceInitiatedShutdownBehavior` |
#' `rootDeviceName` | `blockDeviceMapping` | `productCodes` |
#' `sourceDestCheck` | `groupSet` | `ebsOptimized` | `sriovNetSupport`
#'
#' @usage
#' ec2_describe_instance_attribute(Attribute, DryRun, InstanceId)
#'
#' @param Attribute &#91;required&#93; The instance attribute.
#' 
#' Note: The `enaSupport` attribute is not supported at this time.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Groups = list(
#'     list(
#'       GroupName = "string",
#'       GroupId = "string"
#'     )
#'   ),
#'   BlockDeviceMappings = list(
#'     list(
#'       DeviceName = "string",
#'       Ebs = list(
#'         AttachTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         DeleteOnTermination = TRUE|FALSE,
#'         Status = "attaching"|"attached"|"detaching"|"detached",
#'         VolumeId = "string"
#'       )
#'     )
#'   ),
#'   DisableApiTermination = list(
#'     Value = TRUE|FALSE
#'   ),
#'   EnaSupport = list(
#'     Value = TRUE|FALSE
#'   ),
#'   EnclaveOptions = list(
#'     Enabled = TRUE|FALSE
#'   ),
#'   EbsOptimized = list(
#'     Value = TRUE|FALSE
#'   ),
#'   InstanceId = "string",
#'   InstanceInitiatedShutdownBehavior = list(
#'     Value = "string"
#'   ),
#'   InstanceType = list(
#'     Value = "string"
#'   ),
#'   KernelId = list(
#'     Value = "string"
#'   ),
#'   ProductCodes = list(
#'     list(
#'       ProductCodeId = "string",
#'       ProductCodeType = "devpay"|"marketplace"
#'     )
#'   ),
#'   RamdiskId = list(
#'     Value = "string"
#'   ),
#'   RootDeviceName = list(
#'     Value = "string"
#'   ),
#'   SourceDestCheck = list(
#'     Value = TRUE|FALSE
#'   ),
#'   SriovNetSupport = list(
#'     Value = "string"
#'   ),
#'   UserData = list(
#'     Value = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_attribute(
#'   Attribute = "instanceType"|"kernel"|"ramdisk"|"userData"|"disableApiTermination"|"instanceInitiatedShutdownBehavior"|"rootDeviceName"|"blockDeviceMapping"|"productCodes"|"sourceDestCheck"|"groupSet"|"ebsOptimized"|"sriovNetSupport"|"enaSupport"|"enclaveOptions",
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the instance type of the specified instance.
#' # 
#' svc$describe_instance_attribute(
#'   Attribute = "instanceType",
#'   InstanceId = "i-1234567890abcdef0"
#' )
#' 
#' # This example describes the `disableApiTermination` attribute of the
#' # specified instance.
#' # 
#' svc$describe_instance_attribute(
#'   Attribute = "disableApiTermination",
#'   InstanceId = "i-1234567890abcdef0"
#' )
#' 
#' # This example describes the `blockDeviceMapping` attribute of the
#' # specified instance.
#' # 
#' svc$describe_instance_attribute(
#'   Attribute = "blockDeviceMapping",
#'   InstanceId = "i-1234567890abcdef0"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_attribute
ec2_describe_instance_attribute <- function(Attribute, DryRun = NULL, InstanceId) {
  op <- new_operation(
    name = "DescribeInstanceAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_attribute_input(Attribute = Attribute, DryRun = DryRun, InstanceId = InstanceId)
  output <- .ec2$describe_instance_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_attribute <- ec2_describe_instance_attribute

#' Describes the credit option for CPU usage of the specified burstable
#' performance instances
#'
#' @description
#' Describes the credit option for CPU usage of the specified burstable
#' performance instances. The credit options are `standard` and
#' `unlimited`.
#' 
#' If you do not specify an instance ID, Amazon EC2 returns burstable
#' performance instances with the `unlimited` credit option, as well as
#' instances that were previously configured as T2, T3, and T3a with the
#' `unlimited` credit option. For example, if you resize a T2 instance,
#' while it is configured as `unlimited`, to an M4 instance, Amazon EC2
#' returns the M4 instance.
#' 
#' If you specify one or more instance IDs, Amazon EC2 returns the credit
#' option (`standard` or `unlimited`) of those instances. If you specify an
#' instance ID that is not valid, such as an instance that is not a
#' burstable performance instance, an error is returned.
#' 
#' Recently terminated instances might appear in the returned results. This
#' interval is usually less than one hour.
#' 
#' If an Availability Zone is experiencing a service disruption and you
#' specify instance IDs in the affected zone, or do not specify any
#' instance IDs at all, the call fails. If you specify only instance IDs in
#' an unaffected zone, the call works normally.
#' 
#' For more information, see [Burstable performance
#' instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_instance_credit_specifications(DryRun, Filters,
#'   InstanceIds, MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `instance-id` - The ID of the instance.
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' 
#' Constraints: Maximum 1000 explicitly specified instance IDs.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 5 and 1000. You cannot specify this
#' parameter and the instance IDs parameter in the same call.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InstanceCreditSpecifications = list(
#'     list(
#'       InstanceId = "string",
#'       CpuCredits = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_credit_specifications(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_credit_specifications
ec2_describe_instance_credit_specifications <- function(DryRun = NULL, Filters = NULL, InstanceIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceCreditSpecifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_credit_specifications_input(DryRun = DryRun, Filters = Filters, InstanceIds = InstanceIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_credit_specifications_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_credit_specifications <- ec2_describe_instance_credit_specifications

#' Describes the tag keys that are registered to appear in scheduled event
#' notifications for resources in the current Region
#'
#' @description
#' Describes the tag keys that are registered to appear in scheduled event
#' notifications for resources in the current Region.
#'
#' @usage
#' ec2_describe_instance_event_notification_attributes(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InstanceTagAttribute = list(
#'     InstanceTagKeys = list(
#'       "string"
#'     ),
#'     IncludeAllTagsOfInstance = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_event_notification_attributes(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_event_notification_attributes
ec2_describe_instance_event_notification_attributes <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DescribeInstanceEventNotificationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_event_notification_attributes_input(DryRun = DryRun)
  output <- .ec2$describe_instance_event_notification_attributes_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_event_notification_attributes <- ec2_describe_instance_event_notification_attributes

#' Describes the status of the specified instances or all of your instances
#'
#' @description
#' Describes the status of the specified instances or all of your
#' instances. By default, only running instances are described, unless you
#' specifically indicate to return the status of all instances.
#' 
#' Instance status includes the following components:
#' 
#' -   **Status checks** - Amazon EC2 performs status checks on running EC2
#'     instances to identify hardware and software issues. For more
#'     information, see [Status checks for your
#'     instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html)
#'     and [Troubleshooting instances with failed status
#'     checks](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html)
#'     in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' -   **Scheduled events** - Amazon EC2 can schedule events (such as
#'     reboot, stop, or terminate) for your instances related to hardware
#'     issues, software updates, or system maintenance. For more
#'     information, see [Scheduled events for your
#'     instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html)
#'     in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' -   **Instance state** - You can manage your instances from the moment
#'     you launch them through their termination. For more information, see
#'     [Instance
#'     lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html)
#'     in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_instance_status(Filters, InstanceIds, MaxResults,
#'   NextToken, DryRun, IncludeAllInstances)
#'
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone of the instance.
#' 
#' -   `event.code` - The code for the scheduled event (`instance-reboot` |
#'     `system-reboot` | `system-maintenance` | `instance-retirement` |
#'     `instance-stop`).
#' 
#' -   `event.description` - A description of the event.
#' 
#' -   `event.instance-event-id` - The ID of the event whose date and time
#'     you are modifying.
#' 
#' -   `event.not-after` - The latest end time for the scheduled event (for
#'     example, `2014-09-15T17:15:20.000Z`).
#' 
#' -   `event.not-before` - The earliest start time for the scheduled event
#'     (for example, `2014-09-15T17:15:20.000Z`).
#' 
#' -   `event.not-before-deadline` - The deadline for starting the event
#'     (for example, `2014-09-15T17:15:20.000Z`).
#' 
#' -   `instance-state-code` - The code for the instance state, as a 16-bit
#'     unsigned integer. The high byte is used for internal purposes and
#'     should be ignored. The low byte is set based on the state
#'     represented. The valid values are 0 (pending), 16 (running), 32
#'     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
#' 
#' -   `instance-state-name` - The state of the instance (`pending` |
#'     `running` | `shutting-down` | `terminated` | `stopping` |
#'     `stopped`).
#' 
#' -   `instance-status.reachability` - Filters on instance status where
#'     the name is `reachability` (`passed` | `failed` | `initializing` |
#'     `insufficient-data`).
#' 
#' -   `instance-status.status` - The status of the instance (`ok` |
#'     `impaired` | `initializing` | `insufficient-data` |
#'     `not-applicable`).
#' 
#' -   `system-status.reachability` - Filters on system status where the
#'     name is `reachability` (`passed` | `failed` | `initializing` |
#'     `insufficient-data`).
#' 
#' -   `system-status.status` - The system status of the instance (`ok` |
#'     `impaired` | `initializing` | `insufficient-data` |
#'     `not-applicable`).
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' 
#' Constraints: Maximum 100 explicitly specified instance IDs.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 5 and 1000. You cannot specify this
#' parameter and the instance IDs parameter in the same call.
#' @param NextToken The token to retrieve the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param IncludeAllInstances When `true`, includes the health status for all instances. When `false`,
#' includes the health status for running instances only.
#' 
#' Default: `false`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InstanceStatuses = list(
#'     list(
#'       AvailabilityZone = "string",
#'       OutpostArn = "string",
#'       Events = list(
#'         list(
#'           InstanceEventId = "string",
#'           Code = "instance-reboot"|"system-reboot"|"system-maintenance"|"instance-retirement"|"instance-stop",
#'           Description = "string",
#'           NotAfter = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           NotBefore = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           NotBeforeDeadline = as.POSIXct(
#'             "2015-01-01"
#'           )
#'         )
#'       ),
#'       InstanceId = "string",
#'       InstanceState = list(
#'         Code = 123,
#'         Name = "pending"|"running"|"shutting-down"|"terminated"|"stopping"|"stopped"
#'       ),
#'       InstanceStatus = list(
#'         Details = list(
#'           list(
#'             ImpairedSince = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             Name = "reachability",
#'             Status = "passed"|"failed"|"insufficient-data"|"initializing"
#'           )
#'         ),
#'         Status = "ok"|"impaired"|"insufficient-data"|"not-applicable"|"initializing"
#'       ),
#'       SystemStatus = list(
#'         Details = list(
#'           list(
#'             ImpairedSince = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             Name = "reachability",
#'             Status = "passed"|"failed"|"insufficient-data"|"initializing"
#'           )
#'         ),
#'         Status = "ok"|"impaired"|"insufficient-data"|"not-applicable"|"initializing"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_status(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE,
#'   IncludeAllInstances = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the current status of the specified instance.
#' svc$describe_instance_status(
#'   InstanceIds = list(
#'     "i-1234567890abcdef0"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_status
ec2_describe_instance_status <- function(Filters = NULL, InstanceIds = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL, IncludeAllInstances = NULL) {
  op <- new_operation(
    name = "DescribeInstanceStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_status_input(Filters = Filters, InstanceIds = InstanceIds, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun, IncludeAllInstances = IncludeAllInstances)
  output <- .ec2$describe_instance_status_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_status <- ec2_describe_instance_status

#' Returns a list of all instance types offered
#'
#' @description
#' Returns a list of all instance types offered. The results can be
#' filtered by location (Region or Availability Zone). If no location is
#' specified, the instance types offered in the current Region are
#' returned.
#'
#' @usage
#' ec2_describe_instance_type_offerings(DryRun, LocationType, Filters,
#'   MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LocationType The location type.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `location` - This depends on the location type. For example, if the
#'     location type is `region` (default), the location is the Region code
#'     (for example, `us-east-2`.)
#' 
#' -   `instance-type` - The instance type. For example, `c5.2xlarge`.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the next token value.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InstanceTypeOfferings = list(
#'     list(
#'       InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'       LocationType = "region"|"availability-zone"|"availability-zone-id",
#'       Location = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_type_offerings(
#'   DryRun = TRUE|FALSE,
#'   LocationType = "region"|"availability-zone"|"availability-zone-id",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_type_offerings
ec2_describe_instance_type_offerings <- function(DryRun = NULL, LocationType = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceTypeOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_type_offerings_input(DryRun = DryRun, LocationType = LocationType, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_type_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_type_offerings <- ec2_describe_instance_type_offerings

#' Describes the details of the instance types that are offered in a
#' location
#'
#' @description
#' Describes the details of the instance types that are offered in a
#' location. The results can be filtered by the attributes of the instance
#' types.
#'
#' @usage
#' ec2_describe_instance_types(DryRun, InstanceTypes, Filters, MaxResults,
#'   NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTypes The instance types. For more information, see [Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `auto-recovery-supported` - Indicates whether auto recovery is
#'     supported (`true` | `false`).
#' 
#' -   `bare-metal` - Indicates whether it is a bare metal instance type
#'     (`true` | `false`).
#' 
#' -   `burstable-performance-supported` - Indicates whether it is a
#'     burstable performance instance type (`true` | `false`).
#' 
#' -   `current-generation` - Indicates whether this instance type is the
#'     latest generation instance type of an instance family (`true` |
#'     `false`).
#' 
#' -   `ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps` - The
#'     baseline bandwidth performance for an EBS-optimized instance type,
#'     in Mbps.
#' 
#' -   `ebs-info.ebs-optimized-info.baseline-iops` - The baseline
#'     input/output storage operations per second for an EBS-optimized
#'     instance type.
#' 
#' -   `ebs-info.ebs-optimized-info.baseline-throughput-in-mbps` - The
#'     baseline throughput performance for an EBS-optimized instance type,
#'     in MB/s.
#' 
#' -   `ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps` - The
#'     maximum bandwidth performance for an EBS-optimized instance type, in
#'     Mbps.
#' 
#' -   `ebs-info.ebs-optimized-info.maximum-iops` - The maximum
#'     input/output storage operations per second for an EBS-optimized
#'     instance type.
#' 
#' -   `ebs-info.ebs-optimized-info.maximum-throughput-in-mbps` - The
#'     maximum throughput performance for an EBS-optimized instance type,
#'     in MB/s.
#' 
#' -   `ebs-info.ebs-optimized-support` - Indicates whether the instance
#'     type is EBS-optimized (`supported` | `unsupported` | `default`).
#' 
#' -   `ebs-info.encryption-support` - Indicates whether EBS encryption is
#'     supported (`supported` | `unsupported`).
#' 
#' -   `ebs-info.nvme-support` - Indicates whether non-volatile memory
#'     express (NVMe) is supported for EBS volumes (`required` |
#'     `supported` | `unsupported`).
#' 
#' -   `free-tier-eligible` - Indicates whether the instance type is
#'     eligible to use in the free tier (`true` | `false`).
#' 
#' -   `hibernation-supported` - Indicates whether On-Demand hibernation is
#'     supported (`true` | `false`).
#' 
#' -   `hypervisor` - The hypervisor (`nitro` | `xen`).
#' 
#' -   `instance-storage-info.disk.count` - The number of local disks.
#' 
#' -   `instance-storage-info.disk.size-in-gb` - The storage size of each
#'     instance storage disk, in GB.
#' 
#' -   `instance-storage-info.disk.type` - The storage technology for the
#'     local instance storage disks (`hdd` | `ssd`).
#' 
#' -   `instance-storage-info.nvme-support` - Indicates whether
#'     non-volatile memory express (NVMe) is supported for instance store
#'     (`required` | `supported`) | `unsupported`).
#' 
#' -   `instance-storage-info.total-size-in-gb` - The total amount of
#'     storage available from all local instance storage, in GB.
#' 
#' -   `instance-storage-supported` - Indicates whether the instance type
#'     has local instance storage (`true` | `false`).
#' 
#' -   `instance-type` - The instance type (for example `c5.2xlarge` or
#'     c5*).
#' 
#' -   `memory-info.size-in-mib` - The memory size.
#' 
#' -   `network-info.efa-supported` - Indicates whether the instance type
#'     supports Elastic Fabric Adapter (EFA) (`true` | `false`).
#' 
#' -   `network-info.ena-support` - Indicates whether Elastic Network
#'     Adapter (ENA) is supported or required (`required` | `supported` |
#'     `unsupported`).
#' 
#' -   `network-info.ipv4-addresses-per-interface` - The maximum number of
#'     private IPv4 addresses per network interface.
#' 
#' -   `network-info.ipv6-addresses-per-interface` - The maximum number of
#'     private IPv6 addresses per network interface.
#' 
#' -   `network-info.ipv6-supported` - Indicates whether the instance type
#'     supports IPv6 (`true` | `false`).
#' 
#' -   `network-info.maximum-network-interfaces` - The maximum number of
#'     network interfaces per instance.
#' 
#' -   `network-info.network-performance` - The network performance (for
#'     example, "25 Gigabit").
#' 
#' -   `processor-info.supported-architecture` - The CPU architecture
#'     (`arm64` | `i386` | `x86_64`).
#' 
#' -   `processor-info.sustained-clock-speed-in-ghz` - The CPU clock speed,
#'     in GHz.
#' 
#' -   `supported-root-device-type` - The root device type (`ebs` |
#'     `instance-store`).
#' 
#' -   `supported-usage-class` - The usage class (`on-demand` | `spot`).
#' 
#' -   `supported-virtualization-type` - The virtualization type (`hvm` |
#'     `paravirtual`).
#' 
#' -   `vcpu-info.default-cores` - The default number of cores for the
#'     instance type.
#' 
#' -   `vcpu-info.default-threads-per-core` - The default number of threads
#'     per core for the instance type.
#' 
#' -   `vcpu-info.default-vcpus` - The default number of vCPUs for the
#'     instance type.
#' 
#' -   `vcpu-info.valid-cores` - The number of cores that can be configured
#'     for the instance type.
#' 
#' -   `vcpu-info.valid-threads-per-core` - The number of threads per core
#'     that can be configured for the instance type. For example, "1" or
#'     "1,2".
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the next token value.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InstanceTypes = list(
#'     list(
#'       InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'       CurrentGeneration = TRUE|FALSE,
#'       FreeTierEligible = TRUE|FALSE,
#'       SupportedUsageClasses = list(
#'         "spot"|"on-demand"
#'       ),
#'       SupportedRootDeviceTypes = list(
#'         "ebs"|"instance-store"
#'       ),
#'       SupportedVirtualizationTypes = list(
#'         "hvm"|"paravirtual"
#'       ),
#'       BareMetal = TRUE|FALSE,
#'       Hypervisor = "nitro"|"xen",
#'       ProcessorInfo = list(
#'         SupportedArchitectures = list(
#'           "i386"|"x86_64"|"arm64"
#'         ),
#'         SustainedClockSpeedInGhz = 123.0
#'       ),
#'       VCpuInfo = list(
#'         DefaultVCpus = 123,
#'         DefaultCores = 123,
#'         DefaultThreadsPerCore = 123,
#'         ValidCores = list(
#'           123
#'         ),
#'         ValidThreadsPerCore = list(
#'           123
#'         )
#'       ),
#'       MemoryInfo = list(
#'         SizeInMiB = 123
#'       ),
#'       InstanceStorageSupported = TRUE|FALSE,
#'       InstanceStorageInfo = list(
#'         TotalSizeInGB = 123,
#'         Disks = list(
#'           list(
#'             SizeInGB = 123,
#'             Count = 123,
#'             Type = "hdd"|"ssd"
#'           )
#'         ),
#'         NvmeSupport = "unsupported"|"supported"|"required"
#'       ),
#'       EbsInfo = list(
#'         EbsOptimizedSupport = "unsupported"|"supported"|"default",
#'         EncryptionSupport = "unsupported"|"supported",
#'         EbsOptimizedInfo = list(
#'           BaselineBandwidthInMbps = 123,
#'           BaselineThroughputInMBps = 123.0,
#'           BaselineIops = 123,
#'           MaximumBandwidthInMbps = 123,
#'           MaximumThroughputInMBps = 123.0,
#'           MaximumIops = 123
#'         ),
#'         NvmeSupport = "unsupported"|"supported"|"required"
#'       ),
#'       NetworkInfo = list(
#'         NetworkPerformance = "string",
#'         MaximumNetworkInterfaces = 123,
#'         MaximumNetworkCards = 123,
#'         DefaultNetworkCardIndex = 123,
#'         NetworkCards = list(
#'           list(
#'             NetworkCardIndex = 123,
#'             NetworkPerformance = "string",
#'             MaximumNetworkInterfaces = 123
#'           )
#'         ),
#'         Ipv4AddressesPerInterface = 123,
#'         Ipv6AddressesPerInterface = 123,
#'         Ipv6Supported = TRUE|FALSE,
#'         EnaSupport = "unsupported"|"supported"|"required",
#'         EfaSupported = TRUE|FALSE
#'       ),
#'       GpuInfo = list(
#'         Gpus = list(
#'           list(
#'             Name = "string",
#'             Manufacturer = "string",
#'             Count = 123,
#'             MemoryInfo = list(
#'               SizeInMiB = 123
#'             )
#'           )
#'         ),
#'         TotalGpuMemoryInMiB = 123
#'       ),
#'       FpgaInfo = list(
#'         Fpgas = list(
#'           list(
#'             Name = "string",
#'             Manufacturer = "string",
#'             Count = 123,
#'             MemoryInfo = list(
#'               SizeInMiB = 123
#'             )
#'           )
#'         ),
#'         TotalFpgaMemoryInMiB = 123
#'       ),
#'       PlacementGroupInfo = list(
#'         SupportedStrategies = list(
#'           "cluster"|"partition"|"spread"
#'         )
#'       ),
#'       InferenceAcceleratorInfo = list(
#'         Accelerators = list(
#'           list(
#'             Count = 123,
#'             Name = "string",
#'             Manufacturer = "string"
#'           )
#'         )
#'       ),
#'       HibernationSupported = TRUE|FALSE,
#'       BurstablePerformanceSupported = TRUE|FALSE,
#'       DedicatedHostsSupported = TRUE|FALSE,
#'       AutoRecoverySupported = TRUE|FALSE
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_types(
#'   DryRun = TRUE|FALSE,
#'   InstanceTypes = list(
#'     "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_types
ec2_describe_instance_types <- function(DryRun = NULL, InstanceTypes = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_types_input(DryRun = DryRun, InstanceTypes = InstanceTypes, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_types_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_types <- ec2_describe_instance_types

#' Describes the specified instances or all instances
#'
#' @description
#' Describes the specified instances or all instances.
#' 
#' If you specify instance IDs, the output includes information for only
#' the specified instances. If you specify filters, the output includes
#' information for only those instances that meet the filter criteria. If
#' you do not specify instance IDs or filters, the output includes
#' information for all instances, which can affect performance. We
#' recommend that you use pagination to ensure that the operation returns
#' quickly and successfully.
#' 
#' If you specify an instance ID that is not valid, an error is returned.
#' If you specify an instance that you do not own, it is not included in
#' the output.
#' 
#' Recently terminated instances might appear in the returned results. This
#' interval is usually less than one hour.
#' 
#' If you describe instances in the rare case where an Availability Zone is
#' experiencing a service disruption and you specify instance IDs that are
#' in the affected zone, or do not specify any instance IDs at all, the
#' call fails. If you describe instances and specify only instance IDs that
#' are in an unaffected zone, the call works normally.
#'
#' @usage
#' ec2_describe_instances(Filters, InstanceIds, DryRun, MaxResults,
#'   NextToken)
#'
#' @param Filters The filters.
#' 
#' -   `affinity` - The affinity setting for an instance running on a
#'     Dedicated Host (`default` | `host`).
#' 
#' -   `architecture` - The instance architecture (`i386` | `x86_64` |
#'     `arm64`).
#' 
#' -   `availability-zone` - The Availability Zone of the instance.
#' 
#' -   `block-device-mapping.attach-time` - The attach time for an EBS
#'     volume mapped to the instance, for example,
#'     `2010-09-15T17:15:20.000Z`.
#' 
#' -   `block-device-mapping.delete-on-termination` - A Boolean that
#'     indicates whether the EBS volume is deleted on instance termination.
#' 
#' -   `block-device-mapping.device-name` - The device name specified in
#'     the block device mapping (for example, `/dev/sdh` or `xvdh`).
#' 
#' -   `block-device-mapping.status` - The status for the EBS volume
#'     (`attaching` | `attached` | `detaching` | `detached`).
#' 
#' -   `block-device-mapping.volume-id` - The volume ID of the EBS volume.
#' 
#' -   `client-token` - The idempotency token you provided when you
#'     launched the instance.
#' 
#' -   `dns-name` - The public DNS name of the instance.
#' 
#' -   `group-id` - The ID of the security group for the instance.
#'     EC2-Classic only.
#' 
#' -   `group-name` - The name of the security group for the instance.
#'     EC2-Classic only.
#' 
#' -   `hibernation-options.configured` - A Boolean that indicates whether
#'     the instance is enabled for hibernation. A value of `true` means
#'     that the instance is enabled for hibernation.
#' 
#' -   `host-id` - The ID of the Dedicated Host on which the instance is
#'     running, if applicable.
#' 
#' -   `hypervisor` - The hypervisor type of the instance (`ovm` | `xen`).
#'     The value `xen` is used for both Xen and Nitro hypervisors.
#' 
#' -   `iam-instance-profile.arn` - The instance profile associated with
#'     the instance. Specified as an ARN.
#' 
#' -   `image-id` - The ID of the image used to launch the instance.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `instance-lifecycle` - Indicates whether this is a Spot Instance or
#'     a Scheduled Instance (`spot` | `scheduled`).
#' 
#' -   `instance-state-code` - The state of the instance, as a 16-bit
#'     unsigned integer. The high byte is used for internal purposes and
#'     should be ignored. The low byte is set based on the state
#'     represented. The valid values are: 0 (pending), 16 (running), 32
#'     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
#' 
#' -   `instance-state-name` - The state of the instance (`pending` |
#'     `running` | `shutting-down` | `terminated` | `stopping` |
#'     `stopped`).
#' 
#' -   `instance-type` - The type of instance (for example, `t2.micro`).
#' 
#' -   `instance.group-id` - The ID of the security group for the instance.
#' 
#' -   `instance.group-name` - The name of the security group for the
#'     instance.
#' 
#' -   `ip-address` - The public IPv4 address of the instance.
#' 
#' -   `kernel-id` - The kernel ID.
#' 
#' -   `key-name` - The name of the key pair used when the instance was
#'     launched.
#' 
#' -   `launch-index` - When launching multiple instances, this is the
#'     index for the instance in the launch group (for example, 0, 1, 2,
#'     and so on).
#' 
#' -   `launch-time` - The time when the instance was launched.
#' 
#' -   `metadata-options.http-tokens` - The metadata request authorization
#'     state (`optional` | `required`)
#' 
#' -   `metadata-options.http-put-response-hop-limit` - The http metadata
#'     request put response hop limit (integer, possible values `1` to
#'     `64`)
#' 
#' -   `metadata-options.http-endpoint` - Enable or disable metadata access
#'     on http endpoint (`enabled` | `disabled`)
#' 
#' -   `monitoring-state` - Indicates whether detailed monitoring is
#'     enabled (`disabled` | `enabled`).
#' 
#' -   `network-interface.addresses.private-ip-address` - The private IPv4
#'     address associated with the network interface.
#' 
#' -   `network-interface.addresses.primary` - Specifies whether the IPv4
#'     address of the network interface is the primary private IPv4
#'     address.
#' 
#' -   `network-interface.addresses.association.public-ip` - The ID of the
#'     association of an Elastic IP address (IPv4) with a network
#'     interface.
#' 
#' -   `network-interface.addresses.association.ip-owner-id` - The owner ID
#'     of the private IPv4 address associated with the network interface.
#' 
#' -   `network-interface.association.public-ip` - The address of the
#'     Elastic IP address (IPv4) bound to the network interface.
#' 
#' -   `network-interface.association.ip-owner-id` - The owner of the
#'     Elastic IP address (IPv4) associated with the network interface.
#' 
#' -   `network-interface.association.allocation-id` - The allocation ID
#'     returned when you allocated the Elastic IP address (IPv4) for your
#'     network interface.
#' 
#' -   `network-interface.association.association-id` - The association ID
#'     returned when the network interface was associated with an IPv4
#'     address.
#' 
#' -   `network-interface.attachment.attachment-id` - The ID of the
#'     interface attachment.
#' 
#' -   `network-interface.attachment.instance-id` - The ID of the instance
#'     to which the network interface is attached.
#' 
#' -   `network-interface.attachment.instance-owner-id` - The owner ID of
#'     the instance to which the network interface is attached.
#' 
#' -   `network-interface.attachment.device-index` - The device index to
#'     which the network interface is attached.
#' 
#' -   `network-interface.attachment.status` - The status of the attachment
#'     (`attaching` | `attached` | `detaching` | `detached`).
#' 
#' -   `network-interface.attachment.attach-time` - The time that the
#'     network interface was attached to an instance.
#' 
#' -   `network-interface.attachment.delete-on-termination` - Specifies
#'     whether the attachment is deleted when an instance is terminated.
#' 
#' -   `network-interface.availability-zone` - The Availability Zone for
#'     the network interface.
#' 
#' -   `network-interface.description` - The description of the network
#'     interface.
#' 
#' -   `network-interface.group-id` - The ID of a security group associated
#'     with the network interface.
#' 
#' -   `network-interface.group-name` - The name of a security group
#'     associated with the network interface.
#' 
#' -   `network-interface.ipv6-addresses.ipv6-address` - The IPv6 address
#'     associated with the network interface.
#' 
#' -   `network-interface.mac-address` - The MAC address of the network
#'     interface.
#' 
#' -   `network-interface.network-interface-id` - The ID of the network
#'     interface.
#' 
#' -   `network-interface.owner-id` - The ID of the owner of the network
#'     interface.
#' 
#' -   `network-interface.private-dns-name` - The private DNS name of the
#'     network interface.
#' 
#' -   `network-interface.requester-id` - The requester ID for the network
#'     interface.
#' 
#' -   `network-interface.requester-managed` - Indicates whether the
#'     network interface is being managed by AWS.
#' 
#' -   `network-interface.status` - The status of the network interface
#'     (`available`) | `in-use`).
#' 
#' -   `network-interface.source-dest-check` - Whether the network
#'     interface performs source/destination checking. A value of `true`
#'     means that checking is enabled, and `false` means that checking is
#'     disabled. The value must be `false` for the network interface to
#'     perform network address translation (NAT) in your VPC.
#' 
#' -   `network-interface.subnet-id` - The ID of the subnet for the network
#'     interface.
#' 
#' -   `network-interface.vpc-id` - The ID of the VPC for the network
#'     interface.
#' 
#' -   `owner-id` - The AWS account ID of the instance owner.
#' 
#' -   `placement-group-name` - The name of the placement group for the
#'     instance.
#' 
#' -   `placement-partition-number` - The partition in which the instance
#'     is located.
#' 
#' -   `platform` - The platform. To list only Windows instances, use
#'     `windows`.
#' 
#' -   `private-dns-name` - The private IPv4 DNS name of the instance.
#' 
#' -   `private-ip-address` - The private IPv4 address of the instance.
#' 
#' -   `product-code` - The product code associated with the AMI used to
#'     launch the instance.
#' 
#' -   `product-code.type` - The type of product code (`devpay` |
#'     `marketplace`).
#' 
#' -   `ramdisk-id` - The RAM disk ID.
#' 
#' -   `reason` - The reason for the current state of the instance (for
#'     example, shows "User Initiated \[date\]" when you stop or terminate
#'     the instance). Similar to the state-reason-code filter.
#' 
#' -   `requester-id` - The ID of the entity that launched the instance on
#'     your behalf (for example, AWS Management Console, Auto Scaling, and
#'     so on).
#' 
#' -   `reservation-id` - The ID of the instance's reservation. A
#'     reservation ID is created any time you launch an instance. A
#'     reservation ID has a one-to-one relationship with an instance launch
#'     request, but can be associated with more than one instance if you
#'     launch multiple instances using the same launch request. For
#'     example, if you launch one instance, you get one reservation ID. If
#'     you launch ten instances using the same launch request, you also get
#'     one reservation ID.
#' 
#' -   `root-device-name` - The device name of the root device volume (for
#'     example, `/dev/sda1`).
#' 
#' -   `root-device-type` - The type of the root device volume (`ebs` |
#'     `instance-store`).
#' 
#' -   `source-dest-check` - Indicates whether the instance performs
#'     source/destination checking. A value of `true` means that checking
#'     is enabled, and `false` means that checking is disabled. The value
#'     must be `false` for the instance to perform network address
#'     translation (NAT) in your VPC.
#' 
#' -   `spot-instance-request-id` - The ID of the Spot Instance request.
#' 
#' -   `state-reason-code` - The reason code for the state change.
#' 
#' -   `state-reason-message` - A message that describes the state change.
#' 
#' -   `subnet-id` - The ID of the subnet for the instance.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources that have a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `tenancy` - The tenancy of an instance (`dedicated` | `default` |
#'     `host`).
#' 
#' -   `virtualization-type` - The virtualization type of the instance
#'     (`paravirtual` | `hvm`).
#' 
#' -   `vpc-id` - The ID of the VPC that the instance is running in.
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 5 and 1000. You cannot specify this
#' parameter and the instance IDs parameter in the same call.
#' @param NextToken The token to request the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Reservations = list(
#'     list(
#'       Groups = list(
#'         list(
#'           GroupName = "string",
#'           GroupId = "string"
#'         )
#'       ),
#'       Instances = list(
#'         list(
#'           AmiLaunchIndex = 123,
#'           ImageId = "string",
#'           InstanceId = "string",
#'           InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'           KernelId = "string",
#'           KeyName = "string",
#'           LaunchTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           Monitoring = list(
#'             State = "disabled"|"disabling"|"enabled"|"pending"
#'           ),
#'           Placement = list(
#'             AvailabilityZone = "string",
#'             Affinity = "string",
#'             GroupName = "string",
#'             PartitionNumber = 123,
#'             HostId = "string",
#'             Tenancy = "default"|"dedicated"|"host",
#'             SpreadDomain = "string",
#'             HostResourceGroupArn = "string"
#'           ),
#'           Platform = "Windows",
#'           PrivateDnsName = "string",
#'           PrivateIpAddress = "string",
#'           ProductCodes = list(
#'             list(
#'               ProductCodeId = "string",
#'               ProductCodeType = "devpay"|"marketplace"
#'             )
#'           ),
#'           PublicDnsName = "string",
#'           PublicIpAddress = "string",
#'           RamdiskId = "string",
#'           State = list(
#'             Code = 123,
#'             Name = "pending"|"running"|"shutting-down"|"terminated"|"stopping"|"stopped"
#'           ),
#'           StateTransitionReason = "string",
#'           SubnetId = "string",
#'           VpcId = "string",
#'           Architecture = "i386"|"x86_64"|"arm64",
#'           BlockDeviceMappings = list(
#'             list(
#'               DeviceName = "string",
#'               Ebs = list(
#'                 AttachTime = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 DeleteOnTermination = TRUE|FALSE,
#'                 Status = "attaching"|"attached"|"detaching"|"detached",
#'                 VolumeId = "string"
#'               )
#'             )
#'           ),
#'           ClientToken = "string",
#'           EbsOptimized = TRUE|FALSE,
#'           EnaSupport = TRUE|FALSE,
#'           Hypervisor = "ovm"|"xen",
#'           IamInstanceProfile = list(
#'             Arn = "string",
#'             Id = "string"
#'           ),
#'           InstanceLifecycle = "spot"|"scheduled",
#'           ElasticGpuAssociations = list(
#'             list(
#'               ElasticGpuId = "string",
#'               ElasticGpuAssociationId = "string",
#'               ElasticGpuAssociationState = "string",
#'               ElasticGpuAssociationTime = "string"
#'             )
#'           ),
#'           ElasticInferenceAcceleratorAssociations = list(
#'             list(
#'               ElasticInferenceAcceleratorArn = "string",
#'               ElasticInferenceAcceleratorAssociationId = "string",
#'               ElasticInferenceAcceleratorAssociationState = "string",
#'               ElasticInferenceAcceleratorAssociationTime = as.POSIXct(
#'                 "2015-01-01"
#'               )
#'             )
#'           ),
#'           NetworkInterfaces = list(
#'             list(
#'               Association = list(
#'                 CarrierIp = "string",
#'                 IpOwnerId = "string",
#'                 PublicDnsName = "string",
#'                 PublicIp = "string"
#'               ),
#'               Attachment = list(
#'                 AttachTime = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 AttachmentId = "string",
#'                 DeleteOnTermination = TRUE|FALSE,
#'                 DeviceIndex = 123,
#'                 Status = "attaching"|"attached"|"detaching"|"detached",
#'                 NetworkCardIndex = 123
#'               ),
#'               Description = "string",
#'               Groups = list(
#'                 list(
#'                   GroupName = "string",
#'                   GroupId = "string"
#'                 )
#'               ),
#'               Ipv6Addresses = list(
#'                 list(
#'                   Ipv6Address = "string"
#'                 )
#'               ),
#'               MacAddress = "string",
#'               NetworkInterfaceId = "string",
#'               OwnerId = "string",
#'               PrivateDnsName = "string",
#'               PrivateIpAddress = "string",
#'               PrivateIpAddresses = list(
#'                 list(
#'                   Association = list(
#'                     CarrierIp = "string",
#'                     IpOwnerId = "string",
#'                     PublicDnsName = "string",
#'                     PublicIp = "string"
#'                   ),
#'                   Primary = TRUE|FALSE,
#'                   PrivateDnsName = "string",
#'                   PrivateIpAddress = "string"
#'                 )
#'               ),
#'               SourceDestCheck = TRUE|FALSE,
#'               Status = "available"|"associated"|"attaching"|"in-use"|"detaching",
#'               SubnetId = "string",
#'               VpcId = "string",
#'               InterfaceType = "string"
#'             )
#'           ),
#'           OutpostArn = "string",
#'           RootDeviceName = "string",
#'           RootDeviceType = "ebs"|"instance-store",
#'           SecurityGroups = list(
#'             list(
#'               GroupName = "string",
#'               GroupId = "string"
#'             )
#'           ),
#'           SourceDestCheck = TRUE|FALSE,
#'           SpotInstanceRequestId = "string",
#'           SriovNetSupport = "string",
#'           StateReason = list(
#'             Code = "string",
#'             Message = "string"
#'           ),
#'           Tags = list(
#'             list(
#'               Key = "string",
#'               Value = "string"
#'             )
#'           ),
#'           VirtualizationType = "hvm"|"paravirtual",
#'           CpuOptions = list(
#'             CoreCount = 123,
#'             ThreadsPerCore = 123
#'           ),
#'           CapacityReservationId = "string",
#'           CapacityReservationSpecification = list(
#'             CapacityReservationPreference = "open"|"none",
#'             CapacityReservationTarget = list(
#'               CapacityReservationId = "string",
#'               CapacityReservationResourceGroupArn = "string"
#'             )
#'           ),
#'           HibernationOptions = list(
#'             Configured = TRUE|FALSE
#'           ),
#'           Licenses = list(
#'             list(
#'               LicenseConfigurationArn = "string"
#'             )
#'           ),
#'           MetadataOptions = list(
#'             State = "pending"|"applied",
#'             HttpTokens = "optional"|"required",
#'             HttpPutResponseHopLimit = 123,
#'             HttpEndpoint = "disabled"|"enabled"
#'           ),
#'           EnclaveOptions = list(
#'             Enabled = TRUE|FALSE
#'           )
#'         )
#'       ),
#'       OwnerId = "string",
#'       RequesterId = "string",
#'       ReservationId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_instances(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified instance.
#' svc$describe_instances(
#'   InstanceIds = list(
#'     "i-1234567890abcdef0"
#'   )
#' )
#' 
#' # This example describes the instances with the t2.micro instance type.
#' svc$describe_instances(
#'   Filters = list(
#'     list(
#'       Name = "instance-type",
#'       Values = list(
#'         "t2.micro"
#'       )
#'     )
#'   )
#' )
#' 
#' # This example describes the instances with the Purpose=test tag.
#' svc$describe_instances(
#'   Filters = list(
#'     list(
#'       Name = "tag:Purpose",
#'       Values = list(
#'         "test"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instances
ec2_describe_instances <- function(Filters = NULL, InstanceIds = NULL, DryRun = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instances_input(Filters = Filters, InstanceIds = InstanceIds, DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instances <- ec2_describe_instances

#' Describes one or more of your internet gateways
#'
#' @description
#' Describes one or more of your internet gateways.
#'
#' @usage
#' ec2_describe_internet_gateways(Filters, DryRun, InternetGatewayIds,
#'   NextToken, MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `attachment.state` - The current state of the attachment between the
#'     gateway and the VPC (`available`). Present only if a VPC is
#'     attached.
#' 
#' -   `attachment.vpc-id` - The ID of an attached VPC.
#' 
#' -   `internet-gateway-id` - The ID of the Internet gateway.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the internet
#'     gateway.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayIds One or more internet gateway IDs.
#' 
#' Default: Describes all your internet gateways.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InternetGateways = list(
#'     list(
#'       Attachments = list(
#'         list(
#'           State = "attaching"|"attached"|"detaching"|"detached",
#'           VpcId = "string"
#'         )
#'       ),
#'       InternetGatewayId = "string",
#'       OwnerId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_internet_gateways(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   InternetGatewayIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the Internet gateway for the specified VPC.
#' svc$describe_internet_gateways(
#'   Filters = list(
#'     list(
#'       Name = "attachment.vpc-id",
#'       Values = list(
#'         "vpc-a01106c2"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_internet_gateways
ec2_describe_internet_gateways <- function(Filters = NULL, DryRun = NULL, InternetGatewayIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInternetGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_internet_gateways_input(Filters = Filters, DryRun = DryRun, InternetGatewayIds = InternetGatewayIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_internet_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_internet_gateways <- ec2_describe_internet_gateways

#' Describes your IPv6 address pools
#'
#' @description
#' Describes your IPv6 address pools.
#'
#' @usage
#' ec2_describe_ipv_6_pools(PoolIds, NextToken, MaxResults, DryRun,
#'   Filters)
#'
#' @param PoolIds The IDs of the IPv6 address pools.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Ipv6Pools = list(
#'     list(
#'       PoolId = "string",
#'       Description = "string",
#'       PoolCidrBlocks = list(
#'         list(
#'           Cidr = "string"
#'         )
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_ipv_6_pools(
#'   PoolIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123,
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_ipv_6_pools
ec2_describe_ipv_6_pools <- function(PoolIds = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeIpv6Pools",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_ipv_6_pools_input(PoolIds = PoolIds, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_ipv_6_pools_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_ipv_6_pools <- ec2_describe_ipv_6_pools

#' Describes the specified key pairs or all of your key pairs
#'
#' @description
#' Describes the specified key pairs or all of your key pairs.
#' 
#' For more information about key pairs, see [Key
#' Pairs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_key_pairs(Filters, KeyNames, KeyPairIds, DryRun)
#'
#' @param Filters The filters.
#' 
#' -   `key-pair-id` - The ID of the key pair.
#' 
#' -   `fingerprint` - The fingerprint of the key pair.
#' 
#' -   `key-name` - The name of the key pair.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' @param KeyNames The key pair names.
#' 
#' Default: Describes all your key pairs.
#' @param KeyPairIds The IDs of the key pairs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   KeyPairs = list(
#'     list(
#'       KeyPairId = "string",
#'       KeyFingerprint = "string",
#'       KeyName = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_key_pairs(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   KeyNames = list(
#'     "string"
#'   ),
#'   KeyPairIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example displays the fingerprint for the specified key.
#' svc$describe_key_pairs(
#'   KeyNames = list(
#'     "my-key-pair"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_key_pairs
ec2_describe_key_pairs <- function(Filters = NULL, KeyNames = NULL, KeyPairIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeKeyPairs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_key_pairs_input(Filters = Filters, KeyNames = KeyNames, KeyPairIds = KeyPairIds, DryRun = DryRun)
  output <- .ec2$describe_key_pairs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_key_pairs <- ec2_describe_key_pairs

#' Describes one or more versions of a specified launch template
#'
#' @description
#' Describes one or more versions of a specified launch template. You can
#' describe all versions, individual versions, or a range of versions. You
#' can also describe all the latest versions or all the default versions of
#' all the launch templates in your account.
#'
#' @usage
#' ec2_describe_launch_template_versions(DryRun, LaunchTemplateId,
#'   LaunchTemplateName, Versions, MinVersion, MaxVersion, NextToken,
#'   MaxResults, Filters)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateId The ID of the launch template. To describe one or more versions of a
#' specified launch template, you must specify either the launch template
#' ID or the launch template name in the request. To describe all the
#' latest or default launch template versions in your account, you must
#' omit this parameter.
#' @param LaunchTemplateName The name of the launch template. To describe one or more versions of a
#' specified launch template, you must specify either the launch template
#' ID or the launch template name in the request. To describe all the
#' latest or default launch template versions in your account, you must
#' omit this parameter.
#' @param Versions One or more versions of the launch template. Valid values depend on
#' whether you are describing a specified launch template (by ID or name)
#' or all launch templates in your account.
#' 
#' To describe one or more versions of a specified launch template, valid
#' values are `$Latest`, `$Default`, and numbers.
#' 
#' To describe all launch templates in your account that are defined as the
#' latest version, the valid value is `$Latest`. To describe all launch
#' templates in your account that are defined as the default version, the
#' valid value is `$Default`. You can specify `$Latest` and `$Default` in
#' the same call. You cannot specify numbers.
#' @param MinVersion The version number after which to describe launch template versions.
#' @param MaxVersion The version number up to which to describe launch template versions.
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 1 and 200.
#' @param Filters One or more filters.
#' 
#' -   `create-time` - The time the launch template version was created.
#' 
#' -   `ebs-optimized` - A boolean that indicates whether the instance is
#'     optimized for Amazon EBS I/O.
#' 
#' -   `iam-instance-profile` - The ARN of the IAM instance profile.
#' 
#' -   `image-id` - The ID of the AMI.
#' 
#' -   `instance-type` - The instance type.
#' 
#' -   `is-default-version` - A boolean that indicates whether the launch
#'     template version is the default version.
#' 
#' -   `kernel-id` - The kernel ID.
#' 
#' -   `ram-disk-id` - The RAM disk ID.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LaunchTemplateVersions = list(
#'     list(
#'       LaunchTemplateId = "string",
#'       LaunchTemplateName = "string",
#'       VersionNumber = 123,
#'       VersionDescription = "string",
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CreatedBy = "string",
#'       DefaultVersion = TRUE|FALSE,
#'       LaunchTemplateData = list(
#'         KernelId = "string",
#'         EbsOptimized = TRUE|FALSE,
#'         IamInstanceProfile = list(
#'           Arn = "string",
#'           Name = "string"
#'         ),
#'         BlockDeviceMappings = list(
#'           list(
#'             DeviceName = "string",
#'             VirtualName = "string",
#'             Ebs = list(
#'               Encrypted = TRUE|FALSE,
#'               DeleteOnTermination = TRUE|FALSE,
#'               Iops = 123,
#'               KmsKeyId = "string",
#'               SnapshotId = "string",
#'               VolumeSize = 123,
#'               VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
#'               Throughput = 123
#'             ),
#'             NoDevice = "string"
#'           )
#'         ),
#'         NetworkInterfaces = list(
#'           list(
#'             AssociateCarrierIpAddress = TRUE|FALSE,
#'             AssociatePublicIpAddress = TRUE|FALSE,
#'             DeleteOnTermination = TRUE|FALSE,
#'             Description = "string",
#'             DeviceIndex = 123,
#'             Groups = list(
#'               "string"
#'             ),
#'             InterfaceType = "string",
#'             Ipv6AddressCount = 123,
#'             Ipv6Addresses = list(
#'               list(
#'                 Ipv6Address = "string"
#'               )
#'             ),
#'             NetworkInterfaceId = "string",
#'             PrivateIpAddress = "string",
#'             PrivateIpAddresses = list(
#'               list(
#'                 Primary = TRUE|FALSE,
#'                 PrivateIpAddress = "string"
#'               )
#'             ),
#'             SecondaryPrivateIpAddressCount = 123,
#'             SubnetId = "string",
#'             NetworkCardIndex = 123
#'           )
#'         ),
#'         ImageId = "string",
#'         InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'         KeyName = "string",
#'         Monitoring = list(
#'           Enabled = TRUE|FALSE
#'         ),
#'         Placement = list(
#'           AvailabilityZone = "string",
#'           Affinity = "string",
#'           GroupName = "string",
#'           HostId = "string",
#'           Tenancy = "default"|"dedicated"|"host",
#'           SpreadDomain = "string",
#'           HostResourceGroupArn = "string",
#'           PartitionNumber = 123
#'         ),
#'         RamDiskId = "string",
#'         DisableApiTermination = TRUE|FALSE,
#'         InstanceInitiatedShutdownBehavior = "stop"|"terminate",
#'         UserData = "string",
#'         TagSpecifications = list(
#'           list(
#'             ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
#'             Tags = list(
#'               list(
#'                 Key = "string",
#'                 Value = "string"
#'               )
#'             )
#'           )
#'         ),
#'         ElasticGpuSpecifications = list(
#'           list(
#'             Type = "string"
#'           )
#'         ),
#'         ElasticInferenceAccelerators = list(
#'           list(
#'             Type = "string",
#'             Count = 123
#'           )
#'         ),
#'         SecurityGroupIds = list(
#'           "string"
#'         ),
#'         SecurityGroups = list(
#'           "string"
#'         ),
#'         InstanceMarketOptions = list(
#'           MarketType = "spot",
#'           SpotOptions = list(
#'             MaxPrice = "string",
#'             SpotInstanceType = "one-time"|"persistent",
#'             BlockDurationMinutes = 123,
#'             ValidUntil = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate"
#'           )
#'         ),
#'         CreditSpecification = list(
#'           CpuCredits = "string"
#'         ),
#'         CpuOptions = list(
#'           CoreCount = 123,
#'           ThreadsPerCore = 123
#'         ),
#'         CapacityReservationSpecification = list(
#'           CapacityReservationPreference = "open"|"none",
#'           CapacityReservationTarget = list(
#'             CapacityReservationId = "string",
#'             CapacityReservationResourceGroupArn = "string"
#'           )
#'         ),
#'         LicenseSpecifications = list(
#'           list(
#'             LicenseConfigurationArn = "string"
#'           )
#'         ),
#'         HibernationOptions = list(
#'           Configured = TRUE|FALSE
#'         ),
#'         MetadataOptions = list(
#'           State = "pending"|"applied",
#'           HttpTokens = "optional"|"required",
#'           HttpPutResponseHopLimit = 123,
#'           HttpEndpoint = "disabled"|"enabled"
#'         ),
#'         EnclaveOptions = list(
#'           Enabled = TRUE|FALSE
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_launch_template_versions(
#'   DryRun = TRUE|FALSE,
#'   LaunchTemplateId = "string",
#'   LaunchTemplateName = "string",
#'   Versions = list(
#'     "string"
#'   ),
#'   MinVersion = "string",
#'   MaxVersion = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the versions for the specified launch template.
#' svc$describe_launch_template_versions(
#'   LaunchTemplateId = "068f72b72934aff71"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_launch_template_versions
ec2_describe_launch_template_versions <- function(DryRun = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, Versions = NULL, MinVersion = NULL, MaxVersion = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeLaunchTemplateVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_launch_template_versions_input(DryRun = DryRun, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, Versions = Versions, MinVersion = MinVersion, MaxVersion = MaxVersion, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .ec2$describe_launch_template_versions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_launch_template_versions <- ec2_describe_launch_template_versions

#' Describes one or more launch templates
#'
#' @description
#' Describes one or more launch templates.
#'
#' @usage
#' ec2_describe_launch_templates(DryRun, LaunchTemplateIds,
#'   LaunchTemplateNames, Filters, NextToken, MaxResults)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateIds One or more launch template IDs.
#' @param LaunchTemplateNames One or more launch template names.
#' @param Filters One or more filters.
#' 
#' -   `create-time` - The time the launch template was created.
#' 
#' -   `launch-template-name` - The name of the launch template.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 1 and 200.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LaunchTemplates = list(
#'     list(
#'       LaunchTemplateId = "string",
#'       LaunchTemplateName = "string",
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CreatedBy = "string",
#'       DefaultVersionNumber = 123,
#'       LatestVersionNumber = 123,
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_launch_templates(
#'   DryRun = TRUE|FALSE,
#'   LaunchTemplateIds = list(
#'     "string"
#'   ),
#'   LaunchTemplateNames = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified launch template.
#' svc$describe_launch_templates(
#'   LaunchTemplateIds = list(
#'     "lt-01238c059e3466abc"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_launch_templates
ec2_describe_launch_templates <- function(DryRun = NULL, LaunchTemplateIds = NULL, LaunchTemplateNames = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeLaunchTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_launch_templates_input(DryRun = DryRun, LaunchTemplateIds = LaunchTemplateIds, LaunchTemplateNames = LaunchTemplateNames, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_launch_templates_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_launch_templates <- ec2_describe_launch_templates

#' Describes the associations between virtual interface groups and local
#' gateway route tables
#'
#' @description
#' Describes the associations between virtual interface groups and local
#' gateway route tables.
#'
#' @usage
#' ec2_describe_local_gateway_route_table_virtual_interface_group_associations(
#'   LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds, Filters,
#'   MaxResults, NextToken, DryRun)
#'
#' @param LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds The IDs of the associations.
#' @param Filters One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `local-gateway-route-table-id` - The ID of the local gateway route
#'     table.
#' 
#' -   `local-gateway-route-table-virtual-interface-group-association-id` -
#'     The ID of the association.
#' 
#' -   `local-gateway-route-table-virtual-interface-group-id` - The ID of
#'     the virtual interface group.
#' 
#' -   `state` - The state of the association.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LocalGatewayRouteTableVirtualInterfaceGroupAssociations = list(
#'     list(
#'       LocalGatewayRouteTableVirtualInterfaceGroupAssociationId = "string",
#'       LocalGatewayVirtualInterfaceGroupId = "string",
#'       LocalGatewayId = "string",
#'       LocalGatewayRouteTableId = "string",
#'       LocalGatewayRouteTableArn = "string",
#'       OwnerId = "string",
#'       State = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_route_table_virtual_interface_group_associations(
#'   LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_route_table_virtual_interface_group_associations
ec2_describe_local_gateway_route_table_virtual_interface_group_associations <- function(LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_route_table_virtual_interface_group_associations_input(LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds = LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_route_table_virtual_interface_group_associations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_route_table_virtual_interface_group_associations <- ec2_describe_local_gateway_route_table_virtual_interface_group_associations

#' Describes the specified associations between VPCs and local gateway
#' route tables
#'
#' @description
#' Describes the specified associations between VPCs and local gateway
#' route tables.
#'
#' @usage
#' ec2_describe_local_gateway_route_table_vpc_associations(
#'   LocalGatewayRouteTableVpcAssociationIds, Filters, MaxResults, NextToken,
#'   DryRun)
#'
#' @param LocalGatewayRouteTableVpcAssociationIds The IDs of the associations.
#' @param Filters One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `local-gateway-route-table-id` - The ID of the local gateway route
#'     table.
#' 
#' -   `local-gateway-route-table-vpc-association-id` - The ID of the
#'     association.
#' 
#' -   `state` - The state of the association.
#' 
#' -   `vpc-id` - The ID of the VPC.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LocalGatewayRouteTableVpcAssociations = list(
#'     list(
#'       LocalGatewayRouteTableVpcAssociationId = "string",
#'       LocalGatewayRouteTableId = "string",
#'       LocalGatewayRouteTableArn = "string",
#'       LocalGatewayId = "string",
#'       VpcId = "string",
#'       OwnerId = "string",
#'       State = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_route_table_vpc_associations(
#'   LocalGatewayRouteTableVpcAssociationIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_route_table_vpc_associations
ec2_describe_local_gateway_route_table_vpc_associations <- function(LocalGatewayRouteTableVpcAssociationIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayRouteTableVpcAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_route_table_vpc_associations_input(LocalGatewayRouteTableVpcAssociationIds = LocalGatewayRouteTableVpcAssociationIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_route_table_vpc_associations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_route_table_vpc_associations <- ec2_describe_local_gateway_route_table_vpc_associations

#' Describes one or more local gateway route tables
#'
#' @description
#' Describes one or more local gateway route tables. By default, all local
#' gateway route tables are described. Alternatively, you can filter the
#' results.
#'
#' @usage
#' ec2_describe_local_gateway_route_tables(LocalGatewayRouteTableIds,
#'   Filters, MaxResults, NextToken, DryRun)
#'
#' @param LocalGatewayRouteTableIds The IDs of the local gateway route tables.
#' @param Filters One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `local-gateway-route-table-id` - The ID of a local gateway route
#'     table.
#' 
#' -   `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
#' 
#' -   `state` - The state of the local gateway route table.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LocalGatewayRouteTables = list(
#'     list(
#'       LocalGatewayRouteTableId = "string",
#'       LocalGatewayRouteTableArn = "string",
#'       LocalGatewayId = "string",
#'       OutpostArn = "string",
#'       OwnerId = "string",
#'       State = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_route_tables(
#'   LocalGatewayRouteTableIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_route_tables
ec2_describe_local_gateway_route_tables <- function(LocalGatewayRouteTableIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayRouteTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_route_tables_input(LocalGatewayRouteTableIds = LocalGatewayRouteTableIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_route_tables_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_route_tables <- ec2_describe_local_gateway_route_tables

#' Describes the specified local gateway virtual interface groups
#'
#' @description
#' Describes the specified local gateway virtual interface groups.
#'
#' @usage
#' ec2_describe_local_gateway_virtual_interface_groups(
#'   LocalGatewayVirtualInterfaceGroupIds, Filters, MaxResults, NextToken,
#'   DryRun)
#'
#' @param LocalGatewayVirtualInterfaceGroupIds The IDs of the virtual interface groups.
#' @param Filters One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `local-gateway-virtual-interface-id` - The ID of the virtual
#'     interface.
#' 
#' -   `local-gateway-virtual-interface-group-id` - The ID of the virtual
#'     interface group.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LocalGatewayVirtualInterfaceGroups = list(
#'     list(
#'       LocalGatewayVirtualInterfaceGroupId = "string",
#'       LocalGatewayVirtualInterfaceIds = list(
#'         "string"
#'       ),
#'       LocalGatewayId = "string",
#'       OwnerId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_virtual_interface_groups(
#'   LocalGatewayVirtualInterfaceGroupIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_virtual_interface_groups
ec2_describe_local_gateway_virtual_interface_groups <- function(LocalGatewayVirtualInterfaceGroupIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayVirtualInterfaceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_virtual_interface_groups_input(LocalGatewayVirtualInterfaceGroupIds = LocalGatewayVirtualInterfaceGroupIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_virtual_interface_groups_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_virtual_interface_groups <- ec2_describe_local_gateway_virtual_interface_groups

#' Describes the specified local gateway virtual interfaces
#'
#' @description
#' Describes the specified local gateway virtual interfaces.
#'
#' @usage
#' ec2_describe_local_gateway_virtual_interfaces(
#'   LocalGatewayVirtualInterfaceIds, Filters, MaxResults, NextToken, DryRun)
#'
#' @param LocalGatewayVirtualInterfaceIds The IDs of the virtual interfaces.
#' @param Filters One or more filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LocalGatewayVirtualInterfaces = list(
#'     list(
#'       LocalGatewayVirtualInterfaceId = "string",
#'       LocalGatewayId = "string",
#'       Vlan = 123,
#'       LocalAddress = "string",
#'       PeerAddress = "string",
#'       LocalBgpAsn = 123,
#'       PeerBgpAsn = 123,
#'       OwnerId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_virtual_interfaces(
#'   LocalGatewayVirtualInterfaceIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_virtual_interfaces
ec2_describe_local_gateway_virtual_interfaces <- function(LocalGatewayVirtualInterfaceIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayVirtualInterfaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_virtual_interfaces_input(LocalGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_virtual_interfaces_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_virtual_interfaces <- ec2_describe_local_gateway_virtual_interfaces

#' Describes one or more local gateways
#'
#' @description
#' Describes one or more local gateways. By default, all local gateways are
#' described. Alternatively, you can filter the results.
#'
#' @usage
#' ec2_describe_local_gateways(LocalGatewayIds, Filters, MaxResults,
#'   NextToken, DryRun)
#'
#' @param LocalGatewayIds One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `local-gateway-route-table-id` - The ID of the local gateway route
#'     table.
#' 
#' -   `local-gateway-route-table-virtual-interface-group-association-id` -
#'     The ID of the association.
#' 
#' -   `local-gateway-route-table-virtual-interface-group-id` - The ID of
#'     the virtual interface group.
#' 
#' -   `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
#' 
#' -   `state` - The state of the association.
#' @param Filters One or more filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LocalGateways = list(
#'     list(
#'       LocalGatewayId = "string",
#'       OutpostArn = "string",
#'       OwnerId = "string",
#'       State = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateways(
#'   LocalGatewayIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateways
ec2_describe_local_gateways <- function(LocalGatewayIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateways_input(LocalGatewayIds = LocalGatewayIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateways <- ec2_describe_local_gateways

#' Describes your managed prefix lists and any AWS-managed prefix lists
#'
#' @description
#' Describes your managed prefix lists and any AWS-managed prefix lists.
#' 
#' To view the entries for your prefix list, use
#' [`get_managed_prefix_list_entries`][ec2_get_managed_prefix_list_entries].
#'
#' @usage
#' ec2_describe_managed_prefix_lists(DryRun, Filters, MaxResults,
#'   NextToken, PrefixListIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `owner-id` - The ID of the prefix list owner.
#' 
#' -   `prefix-list-id` - The ID of the prefix list.
#' 
#' -   `prefix-list-name` - The name of the prefix list.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param PrefixListIds One or more prefix list IDs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   PrefixLists = list(
#'     list(
#'       PrefixListId = "string",
#'       AddressFamily = "string",
#'       State = "create-in-progress"|"create-complete"|"create-failed"|"modify-in-progress"|"modify-complete"|"modify-failed"|"restore-in-progress"|"restore-complete"|"restore-failed"|"delete-in-progress"|"delete-complete"|"delete-failed",
#'       StateMessage = "string",
#'       PrefixListArn = "string",
#'       PrefixListName = "string",
#'       MaxEntries = 123,
#'       Version = 123,
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       OwnerId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_managed_prefix_lists(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   PrefixListIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_managed_prefix_lists
ec2_describe_managed_prefix_lists <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, PrefixListIds = NULL) {
  op <- new_operation(
    name = "DescribeManagedPrefixLists",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_managed_prefix_lists_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, PrefixListIds = PrefixListIds)
  output <- .ec2$describe_managed_prefix_lists_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_managed_prefix_lists <- ec2_describe_managed_prefix_lists

#' Describes your Elastic IP addresses that are being moved to the EC2-VPC
#' platform, or that are being restored to the EC2-Classic platform
#'
#' @description
#' Describes your Elastic IP addresses that are being moved to the EC2-VPC
#' platform, or that are being restored to the EC2-Classic platform. This
#' request does not return information about any other Elastic IP addresses
#' in your account.
#'
#' @usage
#' ec2_describe_moving_addresses(Filters, DryRun, MaxResults, NextToken,
#'   PublicIps)
#'
#' @param Filters One or more filters.
#' 
#' -   `moving-status` - The status of the Elastic IP address
#'     (`MovingToVpc` | `RestoringToClassic`).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. This value
#' can be between 5 and 1000; if `MaxResults` is given a value outside of
#' this range, an error is returned.
#' 
#' Default: If no value is provided, the default is 1000.
#' @param NextToken The token for the next page of results.
#' @param PublicIps One or more Elastic IP addresses.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   MovingAddressStatuses = list(
#'     list(
#'       MoveStatus = "movingToVpc"|"restoringToClassic",
#'       PublicIp = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_moving_addresses(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string",
#'   PublicIps = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes all of your moving Elastic IP addresses.
#' svc$describe_moving_addresses()
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_moving_addresses
ec2_describe_moving_addresses <- function(Filters = NULL, DryRun = NULL, MaxResults = NULL, NextToken = NULL, PublicIps = NULL) {
  op <- new_operation(
    name = "DescribeMovingAddresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_moving_addresses_input(Filters = Filters, DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, PublicIps = PublicIps)
  output <- .ec2$describe_moving_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_moving_addresses <- ec2_describe_moving_addresses

#' Describes one or more of your NAT gateways
#'
#' @description
#' Describes one or more of your NAT gateways.
#'
#' @usage
#' ec2_describe_nat_gateways(DryRun, Filter, MaxResults, NatGatewayIds,
#'   NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filter One or more filters.
#' 
#' -   `nat-gateway-id` - The ID of the NAT gateway.
#' 
#' -   `state` - The state of the NAT gateway (`pending` | `failed` |
#'     `available` | `deleting` | `deleted`).
#' 
#' -   `subnet-id` - The ID of the subnet in which the NAT gateway resides.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC in which the NAT gateway resides.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NatGatewayIds One or more NAT gateway IDs.
#' @param NextToken The token for the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NatGateways = list(
#'     list(
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DeleteTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       FailureCode = "string",
#'       FailureMessage = "string",
#'       NatGatewayAddresses = list(
#'         list(
#'           AllocationId = "string",
#'           NetworkInterfaceId = "string",
#'           PrivateIp = "string",
#'           PublicIp = "string"
#'         )
#'       ),
#'       NatGatewayId = "string",
#'       ProvisionedBandwidth = list(
#'         ProvisionTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Provisioned = "string",
#'         RequestTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Requested = "string",
#'         Status = "string"
#'       ),
#'       State = "pending"|"failed"|"available"|"deleting"|"deleted",
#'       SubnetId = "string",
#'       VpcId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_nat_gateways(
#'   DryRun = TRUE|FALSE,
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NatGatewayIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the NAT gateway for the specified VPC.
#' svc$describe_nat_gateways(
#'   Filter = list(
#'     list(
#'       Name = "vpc-id",
#'       Values = list(
#'         "vpc-1a2b3c4d"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_nat_gateways
ec2_describe_nat_gateways <- function(DryRun = NULL, Filter = NULL, MaxResults = NULL, NatGatewayIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNatGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_nat_gateways_input(DryRun = DryRun, Filter = Filter, MaxResults = MaxResults, NatGatewayIds = NatGatewayIds, NextToken = NextToken)
  output <- .ec2$describe_nat_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_nat_gateways <- ec2_describe_nat_gateways

#' Describes one or more of your network ACLs
#'
#' @description
#' Describes one or more of your network ACLs.
#' 
#' For more information, see [Network
#' ACLs](https://docs.aws.amazon.com/vpc/latest/userguide/) in the *Amazon
#' Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_describe_network_acls(Filters, DryRun, NetworkAclIds, NextToken,
#'   MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `association.association-id` - The ID of an association ID for the
#'     ACL.
#' 
#' -   `association.network-acl-id` - The ID of the network ACL involved in
#'     the association.
#' 
#' -   `association.subnet-id` - The ID of the subnet involved in the
#'     association.
#' 
#' -   `default` - Indicates whether the ACL is the default network ACL for
#'     the VPC.
#' 
#' -   `entry.cidr` - The IPv4 CIDR range specified in the entry.
#' 
#' -   `entry.icmp.code` - The ICMP code specified in the entry, if any.
#' 
#' -   `entry.icmp.type` - The ICMP type specified in the entry, if any.
#' 
#' -   `entry.ipv6-cidr` - The IPv6 CIDR range specified in the entry.
#' 
#' -   `entry.port-range.from` - The start of the port range specified in
#'     the entry.
#' 
#' -   `entry.port-range.to` - The end of the port range specified in the
#'     entry.
#' 
#' -   `entry.protocol` - The protocol specified in the entry (`tcp` |
#'     `udp` | `icmp` or a protocol number).
#' 
#' -   `entry.rule-action` - Allows or denies the matching traffic (`allow`
#'     | `deny`).
#' 
#' -   `entry.rule-number` - The number of an entry (in other words, rule)
#'     in the set of ACL entries.
#' 
#' -   `network-acl-id` - The ID of the network ACL.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the network ACL.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC for the network ACL.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkAclIds One or more network ACL IDs.
#' 
#' Default: Describes all your network ACLs.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkAcls = list(
#'     list(
#'       Associations = list(
#'         list(
#'           NetworkAclAssociationId = "string",
#'           NetworkAclId = "string",
#'           SubnetId = "string"
#'         )
#'       ),
#'       Entries = list(
#'         list(
#'           CidrBlock = "string",
#'           Egress = TRUE|FALSE,
#'           IcmpTypeCode = list(
#'             Code = 123,
#'             Type = 123
#'           ),
#'           Ipv6CidrBlock = "string",
#'           PortRange = list(
#'             From = 123,
#'             To = 123
#'           ),
#'           Protocol = "string",
#'           RuleAction = "allow"|"deny",
#'           RuleNumber = 123
#'         )
#'       ),
#'       IsDefault = TRUE|FALSE,
#'       NetworkAclId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       VpcId = "string",
#'       OwnerId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_acls(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NetworkAclIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified network ACL.
#' svc$describe_network_acls(
#'   NetworkAclIds = list(
#'     "acl-5fb85d36"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_acls
ec2_describe_network_acls <- function(Filters = NULL, DryRun = NULL, NetworkAclIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeNetworkAcls",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_acls_input(Filters = Filters, DryRun = DryRun, NetworkAclIds = NetworkAclIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_network_acls_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_acls <- ec2_describe_network_acls

#' Describes one or more of your network insights analyses
#'
#' @description
#' Describes one or more of your network insights analyses.
#'
#' @usage
#' ec2_describe_network_insights_analyses(NetworkInsightsAnalysisIds,
#'   NetworkInsightsPathId, AnalysisStartTime, AnalysisEndTime, Filters,
#'   MaxResults, DryRun, NextToken)
#'
#' @param NetworkInsightsAnalysisIds The ID of the network insights analyses. You must specify either
#' analysis IDs or a path ID.
#' @param NetworkInsightsPathId The ID of the path. You must specify either a path ID or analysis IDs.
#' @param AnalysisStartTime The time when the network insights analyses started.
#' @param AnalysisEndTime The time when the network insights analyses ended.
#' @param Filters The filters. The following are possible values:
#' 
#' -   PathFound - A Boolean value that indicates whether a feasible path
#'     is found.
#' 
#' -   Status - The status of the analysis (running | succeeded | failed).
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkInsightsAnalyses = list(
#'     list(
#'       NetworkInsightsAnalysisId = "string",
#'       NetworkInsightsAnalysisArn = "string",
#'       NetworkInsightsPathId = "string",
#'       FilterInArns = list(
#'         "string"
#'       ),
#'       StartDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Status = "running"|"succeeded"|"failed",
#'       StatusMessage = "string",
#'       NetworkPathFound = TRUE|FALSE,
#'       ForwardPathComponents = list(
#'         list(
#'           SequenceNumber = 123,
#'           AclRule = list(
#'             Cidr = "string",
#'             Egress = TRUE|FALSE,
#'             PortRange = list(
#'               From = 123,
#'               To = 123
#'             ),
#'             Protocol = "string",
#'             RuleAction = "string",
#'             RuleNumber = 123
#'           ),
#'           Component = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           DestinationVpc = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           OutboundHeader = list(
#'             DestinationAddresses = list(
#'               "string"
#'             ),
#'             DestinationPortRanges = list(
#'               list(
#'                 From = 123,
#'                 To = 123
#'               )
#'             ),
#'             Protocol = "string",
#'             SourceAddresses = list(
#'               "string"
#'             ),
#'             SourcePortRanges = list(
#'               list(
#'                 From = 123,
#'                 To = 123
#'               )
#'             )
#'           ),
#'           InboundHeader = list(
#'             DestinationAddresses = list(
#'               "string"
#'             ),
#'             DestinationPortRanges = list(
#'               list(
#'                 From = 123,
#'                 To = 123
#'               )
#'             ),
#'             Protocol = "string",
#'             SourceAddresses = list(
#'               "string"
#'             ),
#'             SourcePortRanges = list(
#'               list(
#'                 From = 123,
#'                 To = 123
#'               )
#'             )
#'           ),
#'           RouteTableRoute = list(
#'             DestinationCidr = "string",
#'             DestinationPrefixListId = "string",
#'             EgressOnlyInternetGatewayId = "string",
#'             GatewayId = "string",
#'             InstanceId = "string",
#'             NatGatewayId = "string",
#'             NetworkInterfaceId = "string",
#'             Origin = "string",
#'             TransitGatewayId = "string",
#'             VpcPeeringConnectionId = "string"
#'           ),
#'           SecurityGroupRule = list(
#'             Cidr = "string",
#'             Direction = "string",
#'             SecurityGroupId = "string",
#'             PortRange = list(
#'               From = 123,
#'               To = 123
#'             ),
#'             PrefixListId = "string",
#'             Protocol = "string"
#'           ),
#'           SourceVpc = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           Subnet = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           Vpc = list(
#'             Id = "string",
#'             Arn = "string"
#'           )
#'         )
#'       ),
#'       ReturnPathComponents = list(
#'         list(
#'           SequenceNumber = 123,
#'           AclRule = list(
#'             Cidr = "string",
#'             Egress = TRUE|FALSE,
#'             PortRange = list(
#'               From = 123,
#'               To = 123
#'             ),
#'             Protocol = "string",
#'             RuleAction = "string",
#'             RuleNumber = 123
#'           ),
#'           Component = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           DestinationVpc = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           OutboundHeader = list(
#'             DestinationAddresses = list(
#'               "string"
#'             ),
#'             DestinationPortRanges = list(
#'               list(
#'                 From = 123,
#'                 To = 123
#'               )
#'             ),
#'             Protocol = "string",
#'             SourceAddresses = list(
#'               "string"
#'             ),
#'             SourcePortRanges = list(
#'               list(
#'                 From = 123,
#'                 To = 123
#'               )
#'             )
#'           ),
#'           InboundHeader = list(
#'             DestinationAddresses = list(
#'               "string"
#'             ),
#'             DestinationPortRanges = list(
#'               list(
#'                 From = 123,
#'                 To = 123
#'               )
#'             ),
#'             Protocol = "string",
#'             SourceAddresses = list(
#'               "string"
#'             ),
#'             SourcePortRanges = list(
#'               list(
#'                 From = 123,
#'                 To = 123
#'               )
#'             )
#'           ),
#'           RouteTableRoute = list(
#'             DestinationCidr = "string",
#'             DestinationPrefixListId = "string",
#'             EgressOnlyInternetGatewayId = "string",
#'             GatewayId = "string",
#'             InstanceId = "string",
#'             NatGatewayId = "string",
#'             NetworkInterfaceId = "string",
#'             Origin = "string",
#'             TransitGatewayId = "string",
#'             VpcPeeringConnectionId = "string"
#'           ),
#'           SecurityGroupRule = list(
#'             Cidr = "string",
#'             Direction = "string",
#'             SecurityGroupId = "string",
#'             PortRange = list(
#'               From = 123,
#'               To = 123
#'             ),
#'             PrefixListId = "string",
#'             Protocol = "string"
#'           ),
#'           SourceVpc = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           Subnet = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           Vpc = list(
#'             Id = "string",
#'             Arn = "string"
#'           )
#'         )
#'       ),
#'       Explanations = list(
#'         list(
#'           Acl = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           AclRule = list(
#'             Cidr = "string",
#'             Egress = TRUE|FALSE,
#'             PortRange = list(
#'               From = 123,
#'               To = 123
#'             ),
#'             Protocol = "string",
#'             RuleAction = "string",
#'             RuleNumber = 123
#'           ),
#'           Address = "string",
#'           Addresses = list(
#'             "string"
#'           ),
#'           AttachedTo = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           AvailabilityZones = list(
#'             "string"
#'           ),
#'           Cidrs = list(
#'             "string"
#'           ),
#'           Component = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           CustomerGateway = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           Destination = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           DestinationVpc = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           Direction = "string",
#'           ExplanationCode = "string",
#'           IngressRouteTable = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           InternetGateway = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           LoadBalancerArn = "string",
#'           ClassicLoadBalancerListener = list(
#'             LoadBalancerPort = 123,
#'             InstancePort = 123
#'           ),
#'           LoadBalancerListenerPort = 123,
#'           LoadBalancerTarget = list(
#'             Address = "string",
#'             AvailabilityZone = "string",
#'             Instance = list(
#'               Id = "string",
#'               Arn = "string"
#'             ),
#'             Port = 123
#'           ),
#'           LoadBalancerTargetGroup = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           LoadBalancerTargetGroups = list(
#'             list(
#'               Id = "string",
#'               Arn = "string"
#'             )
#'           ),
#'           LoadBalancerTargetPort = 123,
#'           ElasticLoadBalancerListener = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           MissingComponent = "string",
#'           NatGateway = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           NetworkInterface = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           PacketField = "string",
#'           VpcPeeringConnection = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           Port = 123,
#'           PortRanges = list(
#'             list(
#'               From = 123,
#'               To = 123
#'             )
#'           ),
#'           PrefixList = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           Protocols = list(
#'             "string"
#'           ),
#'           RouteTableRoute = list(
#'             DestinationCidr = "string",
#'             DestinationPrefixListId = "string",
#'             EgressOnlyInternetGatewayId = "string",
#'             GatewayId = "string",
#'             InstanceId = "string",
#'             NatGatewayId = "string",
#'             NetworkInterfaceId = "string",
#'             Origin = "string",
#'             TransitGatewayId = "string",
#'             VpcPeeringConnectionId = "string"
#'           ),
#'           RouteTable = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           SecurityGroup = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           SecurityGroupRule = list(
#'             Cidr = "string",
#'             Direction = "string",
#'             SecurityGroupId = "string",
#'             PortRange = list(
#'               From = 123,
#'               To = 123
#'             ),
#'             PrefixListId = "string",
#'             Protocol = "string"
#'           ),
#'           SecurityGroups = list(
#'             list(
#'               Id = "string",
#'               Arn = "string"
#'             )
#'           ),
#'           SourceVpc = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           State = "string",
#'           Subnet = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           SubnetRouteTable = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           Vpc = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           VpcEndpoint = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           VpnConnection = list(
#'             Id = "string",
#'             Arn = "string"
#'           ),
#'           VpnGateway = list(
#'             Id = "string",
#'             Arn = "string"
#'           )
#'         )
#'       ),
#'       AlternatePathHints = list(
#'         list(
#'           ComponentId = "string",
#'           ComponentArn = "string"
#'         )
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_insights_analyses(
#'   NetworkInsightsAnalysisIds = list(
#'     "string"
#'   ),
#'   NetworkInsightsPathId = "string",
#'   AnalysisStartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   AnalysisEndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   DryRun = TRUE|FALSE,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_insights_analyses
ec2_describe_network_insights_analyses <- function(NetworkInsightsAnalysisIds = NULL, NetworkInsightsPathId = NULL, AnalysisStartTime = NULL, AnalysisEndTime = NULL, Filters = NULL, MaxResults = NULL, DryRun = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInsightsAnalyses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_insights_analyses_input(NetworkInsightsAnalysisIds = NetworkInsightsAnalysisIds, NetworkInsightsPathId = NetworkInsightsPathId, AnalysisStartTime = AnalysisStartTime, AnalysisEndTime = AnalysisEndTime, Filters = Filters, MaxResults = MaxResults, DryRun = DryRun, NextToken = NextToken)
  output <- .ec2$describe_network_insights_analyses_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_insights_analyses <- ec2_describe_network_insights_analyses

#' Describes one or more of your paths
#'
#' @description
#' Describes one or more of your paths.
#'
#' @usage
#' ec2_describe_network_insights_paths(NetworkInsightsPathIds, Filters,
#'   MaxResults, DryRun, NextToken)
#'
#' @param NetworkInsightsPathIds The IDs of the paths.
#' @param Filters The filters. The following are possible values:
#' 
#' -   Destination - The ID of the resource.
#' 
#' -   DestinationPort - The destination port.
#' 
#' -   Name - The path name.
#' 
#' -   Protocol - The protocol.
#' 
#' -   Source - The ID of the resource.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkInsightsPaths = list(
#'     list(
#'       NetworkInsightsPathId = "string",
#'       NetworkInsightsPathArn = "string",
#'       CreatedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Source = "string",
#'       Destination = "string",
#'       SourceIp = "string",
#'       DestinationIp = "string",
#'       Protocol = "tcp"|"udp",
#'       DestinationPort = 123,
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_insights_paths(
#'   NetworkInsightsPathIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   DryRun = TRUE|FALSE,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_insights_paths
ec2_describe_network_insights_paths <- function(NetworkInsightsPathIds = NULL, Filters = NULL, MaxResults = NULL, DryRun = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInsightsPaths",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_insights_paths_input(NetworkInsightsPathIds = NetworkInsightsPathIds, Filters = Filters, MaxResults = MaxResults, DryRun = DryRun, NextToken = NextToken)
  output <- .ec2$describe_network_insights_paths_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_insights_paths <- ec2_describe_network_insights_paths

#' Describes a network interface attribute
#'
#' @description
#' Describes a network interface attribute. You can specify only one
#' attribute at a time.
#'
#' @usage
#' ec2_describe_network_interface_attribute(Attribute, DryRun,
#'   NetworkInterfaceId)
#'
#' @param Attribute The attribute of the network interface. This parameter is required.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Attachment = list(
#'     AttachTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     AttachmentId = "string",
#'     DeleteOnTermination = TRUE|FALSE,
#'     DeviceIndex = 123,
#'     NetworkCardIndex = 123,
#'     InstanceId = "string",
#'     InstanceOwnerId = "string",
#'     Status = "attaching"|"attached"|"detaching"|"detached"
#'   ),
#'   Description = list(
#'     Value = "string"
#'   ),
#'   Groups = list(
#'     list(
#'       GroupName = "string",
#'       GroupId = "string"
#'     )
#'   ),
#'   NetworkInterfaceId = "string",
#'   SourceDestCheck = list(
#'     Value = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_interface_attribute(
#'   Attribute = "description"|"groupSet"|"sourceDestCheck"|"attachment",
#'   DryRun = TRUE|FALSE,
#'   NetworkInterfaceId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the attachment attribute of the specified network
#' # interface.
#' svc$describe_network_interface_attribute(
#'   Attribute = "attachment",
#'   NetworkInterfaceId = "eni-686ea200"
#' )
#' 
#' # This example describes the description attribute of the specified
#' # network interface.
#' svc$describe_network_interface_attribute(
#'   Attribute = "description",
#'   NetworkInterfaceId = "eni-686ea200"
#' )
#' 
#' # This example describes the groupSet attribute of the specified network
#' # interface.
#' svc$describe_network_interface_attribute(
#'   Attribute = "groupSet",
#'   NetworkInterfaceId = "eni-686ea200"
#' )
#' 
#' # This example describes the sourceDestCheck attribute of the specified
#' # network interface.
#' svc$describe_network_interface_attribute(
#'   Attribute = "sourceDestCheck",
#'   NetworkInterfaceId = "eni-686ea200"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_interface_attribute
ec2_describe_network_interface_attribute <- function(Attribute = NULL, DryRun = NULL, NetworkInterfaceId) {
  op <- new_operation(
    name = "DescribeNetworkInterfaceAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_interface_attribute_input(Attribute = Attribute, DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId)
  output <- .ec2$describe_network_interface_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_interface_attribute <- ec2_describe_network_interface_attribute

#' Describes the permissions for your network interfaces
#'
#' @description
#' Describes the permissions for your network interfaces.
#'
#' @usage
#' ec2_describe_network_interface_permissions(
#'   NetworkInterfacePermissionIds, Filters, NextToken, MaxResults)
#'
#' @param NetworkInterfacePermissionIds One or more network interface permission IDs.
#' @param Filters One or more filters.
#' 
#' -   `network-interface-permission.network-interface-permission-id` - The
#'     ID of the permission.
#' 
#' -   `network-interface-permission.network-interface-id` - The ID of the
#'     network interface.
#' 
#' -   `network-interface-permission.aws-account-id` - The AWS account ID.
#' 
#' -   `network-interface-permission.aws-service` - The AWS service.
#' 
#' -   `network-interface-permission.permission` - The type of permission
#'     (`INSTANCE-ATTACH` | `EIP-ASSOCIATE`).
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. If this parameter is not specified, up to 50 results are returned
#' by default.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkInterfacePermissions = list(
#'     list(
#'       NetworkInterfacePermissionId = "string",
#'       NetworkInterfaceId = "string",
#'       AwsAccountId = "string",
#'       AwsService = "string",
#'       Permission = "INSTANCE-ATTACH"|"EIP-ASSOCIATE",
#'       PermissionState = list(
#'         State = "pending"|"granted"|"revoking"|"revoked",
#'         StatusMessage = "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_interface_permissions(
#'   NetworkInterfacePermissionIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_interface_permissions
ec2_describe_network_interface_permissions <- function(NetworkInterfacePermissionIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInterfacePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_interface_permissions_input(NetworkInterfacePermissionIds = NetworkInterfacePermissionIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_network_interface_permissions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_interface_permissions <- ec2_describe_network_interface_permissions

#' Describes one or more of your network interfaces
#'
#' @description
#' Describes one or more of your network interfaces.
#'
#' @usage
#' ec2_describe_network_interfaces(Filters, DryRun, NetworkInterfaceIds,
#'   NextToken, MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `addresses.private-ip-address` - The private IPv4 addresses
#'     associated with the network interface.
#' 
#' -   `addresses.primary` - Whether the private IPv4 address is the
#'     primary IP address associated with the network interface.
#' 
#' -   `addresses.association.public-ip` - The association ID returned when
#'     the network interface was associated with the Elastic IP address
#'     (IPv4).
#' 
#' -   `addresses.association.owner-id` - The owner ID of the addresses
#'     associated with the network interface.
#' 
#' -   `association.association-id` - The association ID returned when the
#'     network interface was associated with an IPv4 address.
#' 
#' -   `association.allocation-id` - The allocation ID returned when you
#'     allocated the Elastic IP address (IPv4) for your network interface.
#' 
#' -   `association.ip-owner-id` - The owner of the Elastic IP address
#'     (IPv4) associated with the network interface.
#' 
#' -   `association.public-ip` - The address of the Elastic IP address
#'     (IPv4) bound to the network interface.
#' 
#' -   `association.public-dns-name` - The public DNS name for the network
#'     interface (IPv4).
#' 
#' -   `attachment.attachment-id` - The ID of the interface attachment.
#' 
#' -   `attachment.attach-time` - The time that the network interface was
#'     attached to an instance.
#' 
#' -   `attachment.delete-on-termination` - Indicates whether the
#'     attachment is deleted when an instance is terminated.
#' 
#' -   `attachment.device-index` - The device index to which the network
#'     interface is attached.
#' 
#' -   `attachment.instance-id` - The ID of the instance to which the
#'     network interface is attached.
#' 
#' -   `attachment.instance-owner-id` - The owner ID of the instance to
#'     which the network interface is attached.
#' 
#' -   `attachment.status` - The status of the attachment (`attaching` |
#'     `attached` | `detaching` | `detached`).
#' 
#' -   `availability-zone` - The Availability Zone of the network
#'     interface.
#' 
#' -   `description` - The description of the network interface.
#' 
#' -   `group-id` - The ID of a security group associated with the network
#'     interface.
#' 
#' -   `group-name` - The name of a security group associated with the
#'     network interface.
#' 
#' -   `ipv6-addresses.ipv6-address` - An IPv6 address associated with the
#'     network interface.
#' 
#' -   `mac-address` - The MAC address of the network interface.
#' 
#' -   `network-interface-id` - The ID of the network interface.
#' 
#' -   `owner-id` - The AWS account ID of the network interface owner.
#' 
#' -   `private-ip-address` - The private IPv4 address or addresses of the
#'     network interface.
#' 
#' -   `private-dns-name` - The private DNS name of the network interface
#'     (IPv4).
#' 
#' -   `requester-id` - The ID of the entity that launched the instance on
#'     your behalf (for example, AWS Management Console, Auto Scaling, and
#'     so on).
#' 
#' -   `requester-managed` - Indicates whether the network interface is
#'     being managed by an AWS service (for example, AWS Management
#'     Console, Auto Scaling, and so on).
#' 
#' -   `source-dest-check` - Indicates whether the network interface
#'     performs source/destination checking. A value of `true` means
#'     checking is enabled, and `false` means checking is disabled. The
#'     value must be `false` for the network interface to perform network
#'     address translation (NAT) in your VPC.
#' 
#' -   `status` - The status of the network interface. If the network
#'     interface is not attached to an instance, the status is `available`;
#'     if a network interface is attached to an instance the status is
#'     `in-use`.
#' 
#' -   `subnet-id` - The ID of the subnet for the network interface.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC for the network interface.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceIds One or more network interface IDs.
#' 
#' Default: Describes all your network interfaces.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of items to return for this request. The request
#' returns a token that you can specify in a subsequent call to get the
#' next set of results. You cannot specify this parameter and the network
#' interface IDs parameter in the same request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NetworkInterfaces = list(
#'     list(
#'       Association = list(
#'         AllocationId = "string",
#'         AssociationId = "string",
#'         IpOwnerId = "string",
#'         PublicDnsName = "string",
#'         PublicIp = "string",
#'         CustomerOwnedIp = "string",
#'         CarrierIp = "string"
#'       ),
#'       Attachment = list(
#'         AttachTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         AttachmentId = "string",
#'         DeleteOnTermination = TRUE|FALSE,
#'         DeviceIndex = 123,
#'         NetworkCardIndex = 123,
#'         InstanceId = "string",
#'         InstanceOwnerId = "string",
#'         Status = "attaching"|"attached"|"detaching"|"detached"
#'       ),
#'       AvailabilityZone = "string",
#'       Description = "string",
#'       Groups = list(
#'         list(
#'           GroupName = "string",
#'           GroupId = "string"
#'         )
#'       ),
#'       InterfaceType = "interface"|"natGateway"|"efa",
#'       Ipv6Addresses = list(
#'         list(
#'           Ipv6Address = "string"
#'         )
#'       ),
#'       MacAddress = "string",
#'       NetworkInterfaceId = "string",
#'       OutpostArn = "string",
#'       OwnerId = "string",
#'       PrivateDnsName = "string",
#'       PrivateIpAddress = "string",
#'       PrivateIpAddresses = list(
#'         list(
#'           Association = list(
#'             AllocationId = "string",
#'             AssociationId = "string",
#'             IpOwnerId = "string",
#'             PublicDnsName = "string",
#'             PublicIp = "string",
#'             CustomerOwnedIp = "string",
#'             CarrierIp = "string"
#'           ),
#'           Primary = TRUE|FALSE,
#'           PrivateDnsName = "string",
#'           PrivateIpAddress = "string"
#'         )
#'       ),
#'       RequesterId = "string",
#'       RequesterManaged = TRUE|FALSE,
#'       SourceDestCheck = TRUE|FALSE,
#'       Status = "available"|"associated"|"attaching"|"in-use"|"detaching",
#'       SubnetId = "string",
#'       TagSet = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       VpcId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_interfaces(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NetworkInterfaceIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$describe_network_interfaces(
#'   NetworkInterfaceIds = list(
#'     "eni-e5aa89a3"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_interfaces
ec2_describe_network_interfaces <- function(Filters = NULL, DryRun = NULL, NetworkInterfaceIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInterfaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_interfaces_input(Filters = Filters, DryRun = DryRun, NetworkInterfaceIds = NetworkInterfaceIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_network_interfaces_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_interfaces <- ec2_describe_network_interfaces

#' Describes the specified placement groups or all of your placement groups
#'
#' @description
#' Describes the specified placement groups or all of your placement
#' groups. For more information, see [Placement
#' groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_placement_groups(Filters, DryRun, GroupNames, GroupIds)
#'
#' @param Filters The filters.
#' 
#' -   `group-name` - The name of the placement group.
#' 
#' -   `state` - The state of the placement group (`pending` | `available`
#'     | `deleting` | `deleted`).
#' 
#' -   `strategy` - The strategy of the placement group (`cluster` |
#'     `spread` | `partition`).
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources that have a tag with a specific key,
#'     regardless of the tag value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupNames The names of the placement groups.
#' 
#' Default: Describes all your placement groups, or only those otherwise
#' specified.
#' @param GroupIds The IDs of the placement groups.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PlacementGroups = list(
#'     list(
#'       GroupName = "string",
#'       State = "pending"|"available"|"deleting"|"deleted",
#'       Strategy = "cluster"|"spread"|"partition",
#'       PartitionCount = 123,
#'       GroupId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_placement_groups(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   GroupNames = list(
#'     "string"
#'   ),
#'   GroupIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_placement_groups
ec2_describe_placement_groups <- function(Filters = NULL, DryRun = NULL, GroupNames = NULL, GroupIds = NULL) {
  op <- new_operation(
    name = "DescribePlacementGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_placement_groups_input(Filters = Filters, DryRun = DryRun, GroupNames = GroupNames, GroupIds = GroupIds)
  output <- .ec2$describe_placement_groups_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_placement_groups <- ec2_describe_placement_groups

#' Describes available AWS services in a prefix list format, which includes
#' the prefix list name and prefix list ID of the service and the IP
#' address range for the service
#'
#' @description
#' Describes available AWS services in a prefix list format, which includes
#' the prefix list name and prefix list ID of the service and the IP
#' address range for the service.
#' 
#' We recommend that you use
#' [`describe_managed_prefix_lists`][ec2_describe_managed_prefix_lists]
#' instead.
#'
#' @usage
#' ec2_describe_prefix_lists(DryRun, Filters, MaxResults, NextToken,
#'   PrefixListIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `prefix-list-id`: The ID of a prefix list.
#' 
#' -   `prefix-list-name`: The name of a prefix list.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param PrefixListIds One or more prefix list IDs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   PrefixLists = list(
#'     list(
#'       Cidrs = list(
#'         "string"
#'       ),
#'       PrefixListId = "string",
#'       PrefixListName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_prefix_lists(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   PrefixListIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_prefix_lists
ec2_describe_prefix_lists <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, PrefixListIds = NULL) {
  op <- new_operation(
    name = "DescribePrefixLists",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_prefix_lists_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, PrefixListIds = PrefixListIds)
  output <- .ec2$describe_prefix_lists_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_prefix_lists <- ec2_describe_prefix_lists

#' Describes the ID format settings for the root user and all IAM roles and
#' IAM users that have explicitly specified a longer ID (17-character ID)
#' preference
#'
#' @description
#' Describes the ID format settings for the root user and all IAM roles and
#' IAM users that have explicitly specified a longer ID (17-character ID)
#' preference.
#' 
#' By default, all IAM roles and IAM users default to the same ID settings
#' as the root user, unless they explicitly override the settings. This
#' request is useful for identifying those IAM users and IAM roles that
#' have overridden the default ID settings.
#' 
#' The following resource types support longer IDs: `bundle` |
#' `conversion-task` | `customer-gateway` | `dhcp-options` |
#' `elastic-ip-allocation` | `elastic-ip-association` | `export-task` |
#' `flow-log` | `image` | `import-task` | `instance` | `internet-gateway` |
#' `network-acl` | `network-acl-association` | `network-interface` |
#' `network-interface-attachment` | `prefix-list` | `reservation` |
#' `route-table` | `route-table-association` | `security-group` |
#' `snapshot` | `subnet` | `subnet-cidr-block-association` | `volume` |
#' `vpc` | `vpc-cidr-block-association` | `vpc-endpoint` |
#' `vpc-peering-connection` | `vpn-connection` | `vpn-gateway`.
#'
#' @usage
#' ec2_describe_principal_id_format(DryRun, Resources, MaxResults,
#'   NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Resources The type of resource: `bundle` | `conversion-task` | `customer-gateway`
#' | `dhcp-options` | `elastic-ip-allocation` | `elastic-ip-association` |
#' `export-task` | `flow-log` | `image` | `import-task` | `instance` |
#' `internet-gateway` | `network-acl` | `network-acl-association` |
#' `network-interface` | `network-interface-attachment` | `prefix-list` |
#' `reservation` | `route-table` | `route-table-association` |
#' `security-group` | `snapshot` | `subnet` |
#' `subnet-cidr-block-association` | `volume` | `vpc` |
#' `vpc-cidr-block-association` | `vpc-endpoint` | `vpc-peering-connection`
#' | `vpn-connection` | `vpn-gateway`
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned NextToken
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Principals = list(
#'     list(
#'       Arn = "string",
#'       Statuses = list(
#'         list(
#'           Deadline = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           Resource = "string",
#'           UseLongIds = TRUE|FALSE
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_principal_id_format(
#'   DryRun = TRUE|FALSE,
#'   Resources = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_principal_id_format
ec2_describe_principal_id_format <- function(DryRun = NULL, Resources = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePrincipalIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_principal_id_format_input(DryRun = DryRun, Resources = Resources, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_principal_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_principal_id_format <- ec2_describe_principal_id_format

#' Describes the specified IPv4 address pools
#'
#' @description
#' Describes the specified IPv4 address pools.
#'
#' @usage
#' ec2_describe_public_ipv_4_pools(PoolIds, NextToken, MaxResults, Filters)
#'
#' @param PoolIds The IDs of the address pools.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param Filters One or more filters.
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PublicIpv4Pools = list(
#'     list(
#'       PoolId = "string",
#'       Description = "string",
#'       PoolAddressRanges = list(
#'         list(
#'           FirstAddress = "string",
#'           LastAddress = "string",
#'           AddressCount = 123,
#'           AvailableAddressCount = 123
#'         )
#'       ),
#'       TotalAddressCount = 123,
#'       TotalAvailableAddressCount = 123,
#'       NetworkBorderGroup = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_public_ipv_4_pools(
#'   PoolIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_public_ipv_4_pools
ec2_describe_public_ipv_4_pools <- function(PoolIds = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribePublicIpv4Pools",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_public_ipv_4_pools_input(PoolIds = PoolIds, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .ec2$describe_public_ipv_4_pools_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_public_ipv_4_pools <- ec2_describe_public_ipv_4_pools

#' Describes the Regions that are enabled for your account, or all Regions
#'
#' @description
#' Describes the Regions that are enabled for your account, or all Regions.
#' 
#' For a list of the Regions supported by Amazon EC2, see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region).
#' 
#' For information about enabling and disabling Regions for your account,
#' see [Managing AWS
#' Regions](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html)
#' in the *AWS General Reference*.
#'
#' @usage
#' ec2_describe_regions(Filters, RegionNames, DryRun, AllRegions)
#'
#' @param Filters The filters.
#' 
#' -   `endpoint` - The endpoint of the Region (for example,
#'     `ec2.us-east-1.amazonaws.com`).
#' 
#' -   `opt-in-status` - The opt-in status of the Region
#'     (`opt-in-not-required` | `opted-in` | `not-opted-in`).
#' 
#' -   `region-name` - The name of the Region (for example, `us-east-1`).
#' @param RegionNames The names of the Regions. You can specify any Regions, whether they are
#' enabled and disabled for your account.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param AllRegions Indicates whether to display all Regions, including Regions that are
#' disabled for your account.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Regions = list(
#'     list(
#'       Endpoint = "string",
#'       RegionName = "string",
#'       OptInStatus = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_regions(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   RegionNames = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   AllRegions = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes all the regions that are available to you.
#' svc$describe_regions()
#' }
#'
#' @keywords internal
#'
#' @rdname ec2_describe_regions
ec2_describe_regions <- function(Filters = NULL, RegionNames = NULL, DryRun = NULL, AllRegions = NULL) {
  op <- new_operation(
    name = "DescribeRegions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_regions_input(Filters = Filters, RegionNames = RegionNames, DryRun = DryRun, AllRegions = AllRegions)
  output <- .ec2$describe_regions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_regions <- ec2_describe_regions

#' Describes one or more of the Reserved Instances that you purchased
#'
#' @description
#' Describes one or more of the Reserved Instances that you purchased.
#' 
#' For more information about Reserved Instances, see [Reserved
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-reserved-instances.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_reserved_instances(Filters, OfferingClass,
#'   ReservedInstancesIds, DryRun, OfferingType)
#'
#' @param Filters One or more filters.
#' 
#' -   `availability-zone` - The Availability Zone where the Reserved
#'     Instance can be used.
#' 
#' -   `duration` - The duration of the Reserved Instance (one year or
#'     three years), in seconds (`31536000` | `94608000`).
#' 
#' -   `end` - The time when the Reserved Instance expires (for example,
#'     2015-08-07T11:54:42.000Z).
#' 
#' -   `fixed-price` - The purchase price of the Reserved Instance (for
#'     example, 9800.0).
#' 
#' -   `instance-type` - The instance type that is covered by the
#'     reservation.
#' 
#' -   `scope` - The scope of the Reserved Instance (`Region` or
#'     `Availability Zone`).
#' 
#' -   `product-description` - The Reserved Instance product platform
#'     description. Instances that include `(Amazon VPC)` in the product
#'     platform description will only be displayed to EC2-Classic account
#'     holders and are for use with Amazon VPC (`Linux/UNIX` |
#'     `Linux/UNIX (Amazon VPC)` | `SUSE Linux` | `SUSE Linux (Amazon VPC)`
#'     | `Red Hat Enterprise Linux` |
#'     `Red Hat Enterprise Linux (Amazon VPC)` | `Windows` |
#'     `Windows (Amazon VPC)` | `Windows with SQL Server Standard` |
#'     `Windows with SQL Server Standard (Amazon VPC)` |
#'     `Windows with SQL Server Web` |
#'     `Windows with SQL Server Web (Amazon VPC)` |
#'     `Windows with SQL Server Enterprise` |
#'     `Windows with SQL Server Enterprise (Amazon VPC)`).
#' 
#' -   `reserved-instances-id` - The ID of the Reserved Instance.
#' 
#' -   `start` - The time at which the Reserved Instance purchase request
#'     was placed (for example, 2014-08-07T11:54:42.000Z).
#' 
#' -   `state` - The state of the Reserved Instance (`payment-pending` |
#'     `active` | `payment-failed` | `retired`).
#' 
#' -   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to
#'     the resource. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
#'     for the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `usage-price` - The usage price of the Reserved Instance, per hour
#'     (for example, 0.84).
#' @param OfferingClass Describes whether the Reserved Instance is Standard or Convertible.
#' @param ReservedInstancesIds One or more Reserved Instance IDs.
#' 
#' Default: Describes all your Reserved Instances, or only those otherwise
#' specified.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param OfferingType The Reserved Instance offering type. If you are using tools that predate
#' the 2011-11-01 API version, you only have access to the
#' `Medium Utilization` Reserved Instance offering type.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ReservedInstances = list(
#'     list(
#'       AvailabilityZone = "string",
#'       Duration = 123,
#'       End = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       FixedPrice = 123.0,
#'       InstanceCount = 123,
#'       InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'       ProductDescription = "Linux/UNIX"|"Linux/UNIX (Amazon VPC)"|"Windows"|"Windows (Amazon VPC)",
#'       ReservedInstancesId = "string",
#'       Start = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       State = "payment-pending"|"active"|"payment-failed"|"retired"|"queued"|"queued-deleted",
#'       UsagePrice = 123.0,
#'       CurrencyCode = "USD",
#'       InstanceTenancy = "default"|"dedicated"|"host",
#'       OfferingClass = "standard"|"convertible",
#'       OfferingType = "Heavy Utilization"|"Medium Utilization"|"Light Utilization"|"No Upfront"|"Partial Upfront"|"All Upfront",
#'       RecurringCharges = list(
#'         list(
#'           Amount = 123.0,
#'           Frequency = "Hourly"
#'         )
#'       ),
#'       Scope = "Availability Zone"|"Region",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_instances(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   OfferingClass = "standard"|"convertible",
#'   ReservedInstancesIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   OfferingType = "Heavy Utilization"|"Medium Utilization"|"Light Utilization"|"No Upfront"|"Partial Upfront"|"All Upfront"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances
ec2_describe_reserved_instances <- function(Filters = NULL, OfferingClass = NULL, ReservedInstancesIds = NULL, DryRun = NULL, OfferingType = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_reserved_instances_input(Filters = Filters, OfferingClass = OfferingClass, ReservedInstancesIds = ReservedInstancesIds, DryRun = DryRun, OfferingType = OfferingType)
  output <- .ec2$describe_reserved_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances <- ec2_describe_reserved_instances

#' Describes your account's Reserved Instance listings in the Reserved
#' Instance Marketplace
#'
#' @description
#' Describes your account's Reserved Instance listings in the Reserved
#' Instance Marketplace.
#' 
#' The Reserved Instance Marketplace matches sellers who want to resell
#' Reserved Instance capacity that they no longer need with buyers who want
#' to purchase additional capacity. Reserved Instances bought and sold
#' through the Reserved Instance Marketplace work like any other Reserved
#' Instances.
#' 
#' As a seller, you choose to list some or all of your Reserved Instances,
#' and you specify the upfront price to receive for them. Your Reserved
#' Instances are then listed in the Reserved Instance Marketplace and are
#' available for purchase.
#' 
#' As a buyer, you specify the configuration of the Reserved Instance to
#' purchase, and the Marketplace matches what you're searching for with
#' what's available. The Marketplace first sells the lowest priced Reserved
#' Instances to you, and continues to sell available Reserved Instance
#' listings to you until your demand is met. You are charged based on the
#' total price of all of the listings that you purchase.
#' 
#' For more information, see [Reserved Instance
#' Marketplace](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_reserved_instances_listings(Filters, ReservedInstancesId,
#'   ReservedInstancesListingId)
#'
#' @param Filters One or more filters.
#' 
#' -   `reserved-instances-id` - The ID of the Reserved Instances.
#' 
#' -   `reserved-instances-listing-id` - The ID of the Reserved Instances
#'     listing.
#' 
#' -   `status` - The status of the Reserved Instance listing (`pending` |
#'     `active` | `cancelled` | `closed`).
#' 
#' -   `status-message` - The reason for the status.
#' @param ReservedInstancesId One or more Reserved Instance IDs.
#' @param ReservedInstancesListingId One or more Reserved Instance listing IDs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ReservedInstancesListings = list(
#'     list(
#'       ClientToken = "string",
#'       CreateDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       InstanceCounts = list(
#'         list(
#'           InstanceCount = 123,
#'           State = "available"|"sold"|"cancelled"|"pending"
#'         )
#'       ),
#'       PriceSchedules = list(
#'         list(
#'           Active = TRUE|FALSE,
#'           CurrencyCode = "USD",
#'           Price = 123.0,
#'           Term = 123
#'         )
#'       ),
#'       ReservedInstancesId = "string",
#'       ReservedInstancesListingId = "string",
#'       Status = "active"|"pending"|"cancelled"|"closed",
#'       StatusMessage = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       UpdateDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_instances_listings(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ReservedInstancesId = "string",
#'   ReservedInstancesListingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances_listings
ec2_describe_reserved_instances_listings <- function(Filters = NULL, ReservedInstancesId = NULL, ReservedInstancesListingId = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstancesListings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_reserved_instances_listings_input(Filters = Filters, ReservedInstancesId = ReservedInstancesId, ReservedInstancesListingId = ReservedInstancesListingId)
  output <- .ec2$describe_reserved_instances_listings_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances_listings <- ec2_describe_reserved_instances_listings

#' Describes the modifications made to your Reserved Instances
#'
#' @description
#' Describes the modifications made to your Reserved Instances. If no
#' parameter is specified, information about all your Reserved Instances
#' modification requests is returned. If a modification ID is specified,
#' only information about the specific modification is returned.
#' 
#' For more information, see [Modifying Reserved
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
#' in the Amazon Elastic Compute Cloud User Guide.
#'
#' @usage
#' ec2_describe_reserved_instances_modifications(Filters,
#'   ReservedInstancesModificationIds, NextToken)
#'
#' @param Filters One or more filters.
#' 
#' -   `client-token` - The idempotency token for the modification request.
#' 
#' -   `create-date` - The time when the modification request was created.
#' 
#' -   `effective-date` - The time when the modification becomes effective.
#' 
#' -   `modification-result.reserved-instances-id` - The ID for the
#'     Reserved Instances created as part of the modification request. This
#'     ID is only available when the status of the modification is
#'     `fulfilled`.
#' 
#' -   `modification-result.target-configuration.availability-zone` - The
#'     Availability Zone for the new Reserved Instances.
#' 
#' -   `modification-result.target-configuration.instance-count ` - The
#'     number of new Reserved Instances.
#' 
#' -   `modification-result.target-configuration.instance-type` - The
#'     instance type of the new Reserved Instances.
#' 
#' -   `modification-result.target-configuration.platform` - The network
#'     platform of the new Reserved Instances (`EC2-Classic` | `EC2-VPC`).
#' 
#' -   `reserved-instances-id` - The ID of the Reserved Instances modified.
#' 
#' -   `reserved-instances-modification-id` - The ID of the modification
#'     request.
#' 
#' -   `status` - The status of the Reserved Instances modification request
#'     (`processing` | `fulfilled` | `failed`).
#' 
#' -   `status-message` - The reason for the status.
#' 
#' -   `update-date` - The time when the modification request was last
#'     updated.
#' @param ReservedInstancesModificationIds IDs for the submitted modification request.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   ReservedInstancesModifications = list(
#'     list(
#'       ClientToken = "string",
#'       CreateDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EffectiveDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ModificationResults = list(
#'         list(
#'           ReservedInstancesId = "string",
#'           TargetConfiguration = list(
#'             AvailabilityZone = "string",
#'             InstanceCount = 123,
#'             InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'             Platform = "string",
#'             Scope = "Availability Zone"|"Region"
#'           )
#'         )
#'       ),
#'       ReservedInstancesIds = list(
#'         list(
#'           ReservedInstancesId = "string"
#'         )
#'       ),
#'       ReservedInstancesModificationId = "string",
#'       Status = "string",
#'       StatusMessage = "string",
#'       UpdateDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_instances_modifications(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ReservedInstancesModificationIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances_modifications
ec2_describe_reserved_instances_modifications <- function(Filters = NULL, ReservedInstancesModificationIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstancesModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_reserved_instances_modifications_input(Filters = Filters, ReservedInstancesModificationIds = ReservedInstancesModificationIds, NextToken = NextToken)
  output <- .ec2$describe_reserved_instances_modifications_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances_modifications <- ec2_describe_reserved_instances_modifications

#' Describes Reserved Instance offerings that are available for purchase
#'
#' @description
#' Describes Reserved Instance offerings that are available for purchase.
#' With Reserved Instances, you purchase the right to launch instances for
#' a period of time. During that time period, you do not receive
#' insufficient capacity errors, and you pay a lower usage rate than the
#' rate charged for On-Demand instances for the actual time used.
#' 
#' If you have listed your own Reserved Instances for sale in the Reserved
#' Instance Marketplace, they will be excluded from these results. This is
#' to ensure that you do not purchase your own Reserved Instances.
#' 
#' For more information, see [Reserved Instance
#' Marketplace](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_reserved_instances_offerings(AvailabilityZone, Filters,
#'   IncludeMarketplace, InstanceType, MaxDuration, MaxInstanceCount,
#'   MinDuration, OfferingClass, ProductDescription,
#'   ReservedInstancesOfferingIds, DryRun, InstanceTenancy, MaxResults,
#'   NextToken, OfferingType)
#'
#' @param AvailabilityZone The Availability Zone in which the Reserved Instance can be used.
#' @param Filters One or more filters.
#' 
#' -   `availability-zone` - The Availability Zone where the Reserved
#'     Instance can be used.
#' 
#' -   `duration` - The duration of the Reserved Instance (for example, one
#'     year or three years), in seconds (`31536000` | `94608000`).
#' 
#' -   `fixed-price` - The purchase price of the Reserved Instance (for
#'     example, 9800.0).
#' 
#' -   `instance-type` - The instance type that is covered by the
#'     reservation.
#' 
#' -   `marketplace` - Set to `true` to show only Reserved Instance
#'     Marketplace offerings. When this filter is not used, which is the
#'     default behavior, all offerings from both AWS and the Reserved
#'     Instance Marketplace are listed.
#' 
#' -   `product-description` - The Reserved Instance product platform
#'     description. Instances that include `(Amazon VPC)` in the product
#'     platform description will only be displayed to EC2-Classic account
#'     holders and are for use with Amazon VPC. (`Linux/UNIX` |
#'     `Linux/UNIX (Amazon VPC)` | `SUSE Linux` | `SUSE Linux (Amazon VPC)`
#'     | `Red Hat Enterprise Linux` |
#'     `Red Hat Enterprise Linux (Amazon VPC)` | `Windows` |
#'     `Windows (Amazon VPC)` | `Windows with SQL Server Standard` |
#'     `Windows with SQL Server Standard (Amazon VPC)` |
#'     `Windows with SQL Server Web` |
#'     ` Windows with SQL Server Web (Amazon VPC)` |
#'     `Windows with SQL Server Enterprise` |
#'     `Windows with SQL Server Enterprise (Amazon VPC)`)
#' 
#' -   `reserved-instances-offering-id` - The Reserved Instances offering
#'     ID.
#' 
#' -   `scope` - The scope of the Reserved Instance (`Availability Zone` or
#'     `Region`).
#' 
#' -   `usage-price` - The usage price of the Reserved Instance, per hour
#'     (for example, 0.84).
#' @param IncludeMarketplace Include Reserved Instance Marketplace offerings in the response.
#' @param InstanceType The instance type that the reservation will cover (for example,
#' `m1.small`). For more information, see [Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param MaxDuration The maximum duration (in seconds) to filter when searching for
#' offerings.
#' 
#' Default: 94608000 (3 years)
#' @param MaxInstanceCount The maximum number of instances to filter when searching for offerings.
#' 
#' Default: 20
#' @param MinDuration The minimum duration (in seconds) to filter when searching for
#' offerings.
#' 
#' Default: 2592000 (1 month)
#' @param OfferingClass The offering class of the Reserved Instance. Can be `standard` or
#' `convertible`.
#' @param ProductDescription The Reserved Instance product platform description. Instances that
#' include `(Amazon VPC)` in the description are for use with Amazon VPC.
#' @param ReservedInstancesOfferingIds One or more Reserved Instances offering IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTenancy The tenancy of the instances covered by the reservation. A Reserved
#' Instance with a tenancy of `dedicated` is applied to instances that run
#' in a VPC on single-tenant hardware (i.e., Dedicated Instances).
#' 
#' **Important:** The `host` value cannot be used with this parameter. Use
#' the `default` or `dedicated` values only.
#' 
#' Default: `default`
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. The maximum
#' is 100.
#' 
#' Default: 100
#' @param NextToken The token to retrieve the next page of results.
#' @param OfferingType The Reserved Instance offering type. If you are using tools that predate
#' the 2011-11-01 API version, you only have access to the
#' `Medium Utilization` Reserved Instance offering type.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ReservedInstancesOfferings = list(
#'     list(
#'       AvailabilityZone = "string",
#'       Duration = 123,
#'       FixedPrice = 123.0,
#'       InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
#'       ProductDescription = "Linux/UNIX"|"Linux/UNIX (Amazon VPC)"|"Windows"|"Windows (Amazon VPC)",
#'       ReservedInstancesOfferingId = "string",
#'       UsagePrice = 123.0,
#'       CurrencyCode = "USD",
#'       InstanceTenancy = "default"|"dedicated"|"host",
#'       Marketplace = TRUE|FALSE,
#'       OfferingClass = "standard"|"convertible",
#'       OfferingType = "Heavy Utilization"|"Medium Utilization"|"Light Utilization"|"No Upfront"|"Partial Upfront"|"All Upfront",
#'       PricingDetails = list(
#'         list(
#'           Count = 123,
#'           Price = 123.0
#'         )
#'       ),
#'       RecurringCharges = list(
#'         list(
#'           Amount = 123.0,
#'           Frequency = "Hourly"
#'         )
#'       ),
#'       Scope = "Availability Zone"|"Region"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_instances_offerings(
#'   AvailabilityZone = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   IncludeMarketplace = TRUE|FALSE,
#'   InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|