% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_submit_job}
\alias{batch_submit_job}
\title{Submits an AWS Batch job from a job definition}
\usage{
batch_submit_job(jobName, jobQueue, arrayProperties, dependsOn,
  jobDefinition, parameters, containerOverrides, nodeOverrides,
  retryStrategy, propagateTags, timeout, tags)
}
\arguments{
\item{jobName}{[required] The name of the job. The first character must be alphanumeric, and up to
128 letters (uppercase and lowercase), numbers, hyphens, and underscores
are allowed.}

\item{jobQueue}{[required] The job queue into which the job is submitted. You can specify either
the name or the Amazon Resource Name (ARN) of the queue.}

\item{arrayProperties}{The array properties for the submitted job, such as the size of the
array. The array size can be between 2 and 10,000. If you specify array
properties for a job, it becomes an array job. For more information, see
\href{https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html}{Array Jobs}
in the \emph{AWS Batch User Guide}.}

\item{dependsOn}{A list of dependencies for the job. A job can depend upon a maximum of
20 jobs. You can specify a \code{SEQUENTIAL} type dependency without
specifying a job ID for array jobs so that each child array job
completes sequentially, starting at index 0. You can also specify an
\code{N_TO_N} type dependency with a job ID for array jobs. In that case,
each index child of this job must wait for the corresponding index child
of each dependency to complete before it can begin.}

\item{jobDefinition}{[required] The job definition used by this job. This value can be one of \code{name},
\code{name:revision}, or the Amazon Resource Name (ARN) for the job
definition. If \code{name} is specified without a revision then the latest
active revision is used.}

\item{parameters}{Additional parameters passed to the job that replace parameter
substitution placeholders that are set in the job definition. Parameters
are specified as a key and value pair mapping. Parameters in a
\code{\link[=batch_submit_job]{submit_job}} request override any corresponding
parameter defaults from the job definition.}

\item{containerOverrides}{A list of container overrides in JSON format that specify the name of a
container in the specified job definition and the overrides it should
receive. You can override the default command for a container (that's
specified in the job definition or the Docker image) with a \code{command}
override. You can also override existing environment variables (that are
specified in the job definition or Docker image) on a container or add
new environment variables to it with an \code{environment} override.}

\item{nodeOverrides}{A list of node overrides in JSON format that specify the node range to
target and the container overrides for that node range.

This parameter isn't applicable to jobs running on Fargate resources;
use \code{containerOverrides} instead.}

\item{retryStrategy}{The retry strategy to use for failed jobs from this
\code{\link[=batch_submit_job]{submit_job}} operation. When a retry strategy is
specified here, it overrides the retry strategy defined in the job
definition.}

\item{propagateTags}{Specifies whether to propagate the tags from the job or job definition
to the corresponding Amazon ECS task. If no value is specified, the tags
aren't propagated. Tags can only be propagated to the tasks during task
creation. For tags with the same name, job tags are given priority over
job definitions tags. If the total number of combined tags from the job
and job definition is over 50, the job is moved to the \code{FAILED} state.
When specified, this overrides the tag propagation setting in the job
definition.}

\item{timeout}{The timeout configuration for this \code{\link[=batch_submit_job]{submit_job}}
operation. You can specify a timeout duration after which AWS Batch
terminates your jobs if they haven't finished. If a job is terminated
due to a timeout, it isn't retried. The minimum value for the timeout is
60 seconds. This configuration overrides any timeout configuration
specified in the job definition. For array jobs, child jobs have the
same timeout configuration as the parent job. For more information, see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/}{Job Timeouts}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{tags}{The tags that you apply to the job request to help you categorize and
organize your resources. Each tag consists of a key and an optional
value. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging AWS Resources}
in \emph{AWS General Reference}.}
}
\value{
A list with the following syntax:\preformatted{list(
  jobArn = "string",
  jobName = "string",
  jobId = "string"
)
}
}
\description{
Submits an AWS Batch job from a job definition. Parameters specified
during \code{\link[=batch_submit_job]{submit_job}} override parameters defined in
the job definition.

Jobs run on Fargate resources don't run for more than 14 days. After 14
days, the Fargate resources might no longer be available and the job is
terminated.
}
\section{Request syntax}{
\preformatted{svc$submit_job(
  jobName = "string",
  jobQueue = "string",
  arrayProperties = list(
    size = 123
  ),
  dependsOn = list(
    list(
      jobId = "string",
      type = "N_TO_N"|"SEQUENTIAL"
    )
  ),
  jobDefinition = "string",
  parameters = list(
    "string"
  ),
  containerOverrides = list(
    vcpus = 123,
    memory = 123,
    command = list(
      "string"
    ),
    instanceType = "string",
    environment = list(
      list(
        name = "string",
        value = "string"
      )
    ),
    resourceRequirements = list(
      list(
        value = "string",
        type = "GPU"|"VCPU"|"MEMORY"
      )
    )
  ),
  nodeOverrides = list(
    numNodes = 123,
    nodePropertyOverrides = list(
      list(
        targetNodes = "string",
        containerOverrides = list(
          vcpus = 123,
          memory = 123,
          command = list(
            "string"
          ),
          instanceType = "string",
          environment = list(
            list(
              name = "string",
              value = "string"
            )
          ),
          resourceRequirements = list(
            list(
              value = "string",
              type = "GPU"|"VCPU"|"MEMORY"
            )
          )
        )
      )
    )
  ),
  retryStrategy = list(
    attempts = 123,
    evaluateOnExit = list(
      list(
        onStatusReason = "string",
        onReason = "string",
        onExitCode = "string",
        action = "RETRY"|"EXIT"
      )
    )
  ),
  propagateTags = TRUE|FALSE,
  timeout = list(
    attemptDurationSeconds = 123
  ),
  tags = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example submits a simple container job called example to the
# HighPriority job queue.
svc$submit_job(
  jobDefinition = "sleep60",
  jobName = "example",
  jobQueue = "HighPriority"
)
}

}
\keyword{internal}
