% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_assign_private_ip_addresses}
\alias{ec2_assign_private_ip_addresses}
\title{Assigns one or more secondary private IP addresses to the specified
network interface}
\usage{
ec2_assign_private_ip_addresses(AllowReassignment, NetworkInterfaceId,
  PrivateIpAddresses, SecondaryPrivateIpAddressCount)
}
\arguments{
\item{AllowReassignment}{Indicates whether to allow an IP address that is already assigned to
another network interface or instance to be reassigned to the specified
network interface.}

\item{NetworkInterfaceId}{[required] The ID of the network interface.}

\item{PrivateIpAddresses}{One or more IP addresses to be assigned as a secondary private IP
address to the network interface. You can't specify this parameter when
also specifying a number of secondary IP addresses.

If you don't specify an IP address, Amazon EC2 automatically selects an
IP address within the subnet range.}

\item{SecondaryPrivateIpAddressCount}{The number of secondary IP addresses to assign to the network interface.
You can't specify this parameter when also specifying private IP
addresses.}
}
\value{
A list with the following syntax:\preformatted{list(
  NetworkInterfaceId = "string",
  AssignedPrivateIpAddresses = list(
    list(
      PrivateIpAddress = "string"
    )
  )
)
}
}
\description{
Assigns one or more secondary private IP addresses to the specified
network interface.

You can specify one or more specific secondary IP addresses, or you can
specify the number of secondary IP addresses to be automatically
assigned within the subnet's CIDR block range. The number of secondary
IP addresses that you can assign to an instance varies by instance type.
For information about instance types, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance Types}
in the \emph{Amazon Elastic Compute Cloud User Guide}. For more information
about Elastic IP addresses, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html}{Elastic IP Addresses}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

When you move a secondary private IP address to another network
interface, any Elastic IP address that is associated with the IP address
is also moved.

Remapping an IP address is an asynchronous operation. When you move an
IP address from one network interface to another, check
\code{network/interfaces/macs/mac/local-ipv4s} in the instance metadata to
confirm that the remapping is complete.

You must specify either the IP addresses or the IP address count in the
request.
}
\section{Request syntax}{
\preformatted{svc$assign_private_ip_addresses(
  AllowReassignment = TRUE|FALSE,
  NetworkInterfaceId = "string",
  PrivateIpAddresses = list(
    "string"
  ),
  SecondaryPrivateIpAddressCount = 123
)
}
}

\examples{
\dontrun{
# This example assigns the specified secondary private IP address to the
# specified network interface.
svc$assign_private_ip_addresses(
  NetworkInterfaceId = "eni-e5aa89a3",
  PrivateIpAddresses = list(
    "10.0.0.82"
  )
)

# This example assigns two secondary private IP addresses to the specified
# network interface. Amazon EC2 automatically assigns these IP addresses
# from the available IP addresses in the CIDR block range of the subnet
# the network interface is associated with.
svc$assign_private_ip_addresses(
  NetworkInterfaceId = "eni-e5aa89a3",
  SecondaryPrivateIpAddressCount = 2L
)
}

}
\keyword{internal}
