% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disable_vgw_route_propagation}
\alias{ec2_disable_vgw_route_propagation}
\title{Disables a virtual private gateway (VGW) from propagating routes to a
specified route table of a VPC}
\usage{
ec2_disable_vgw_route_propagation(GatewayId, RouteTableId, DryRun)
}
\arguments{
\item{GatewayId}{[required] The ID of the virtual private gateway.}

\item{RouteTableId}{[required] The ID of the route table.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
An empty list.
}
\description{
Disables a virtual private gateway (VGW) from propagating routes to a
specified route table of a VPC.
}
\section{Request syntax}{
\preformatted{svc$disable_vgw_route_propagation(
  GatewayId = "string",
  RouteTableId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example disables the specified virtual private gateway from
# propagating static routes to the specified route table.
svc$disable_vgw_route_propagation(
  GatewayId = "vgw-9a4cacf3",
  RouteTableId = "rtb-22574640"
)
}

}
\keyword{internal}
