% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2instanceconnect_operations.R
\name{ec2instanceconnect_send_ssh_public_key}
\alias{ec2instanceconnect_send_ssh_public_key}
\title{Pushes an SSH public key to a particular OS user on a given EC2 instance
for 60 seconds}
\usage{
ec2instanceconnect_send_ssh_public_key(InstanceId, InstanceOSUser,
  SSHPublicKey, AvailabilityZone)
}
\arguments{
\item{InstanceId}{[required] The EC2 instance you wish to publish the SSH key to.}

\item{InstanceOSUser}{[required] The OS user on the EC2 instance whom the key may be used to authenticate
as.}

\item{SSHPublicKey}{[required] The public key to be published to the instance. To use it after
publication you must have the matching private key.}

\item{AvailabilityZone}{[required] The availability zone the EC2 instance was launched in.}
}
\value{
A list with the following syntax:\preformatted{list(
  RequestId = "string",
  Success = TRUE|FALSE
)
}
}
\description{
Pushes an SSH public key to a particular OS user on a given EC2 instance
for 60 seconds.
}
\section{Request syntax}{
\preformatted{svc$send_ssh_public_key(
  InstanceId = "string",
  InstanceOSUser = "string",
  SSHPublicKey = "string",
  AvailabilityZone = "string"
)
}
}

\examples{
\dontrun{
# The following example pushes a sample SSH public key to the EC2 instance
# i-abcd1234 in AZ us-west-2b for use by the instance OS user ec2-user.
svc$send_ssh_public_key(
  AvailabilityZone = "us-west-2a",
  InstanceId = "i-abcd1234",
  InstanceOSUser = "ec2-user",
  SSHPublicKey = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC3FlHqj2eqCdrGHuA6d..."
)
}

}
\keyword{internal}
