% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_batch_check_layer_availability}
\alias{ecr_batch_check_layer_availability}
\title{Checks the availability of one or more image layers in a repository}
\usage{
ecr_batch_check_layer_availability(registryId, repositoryName,
  layerDigests)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the image
layers to check. If you do not specify a registry, the default registry
is assumed.}

\item{repositoryName}{[required] The name of the repository that is associated with the image layers to
check.}

\item{layerDigests}{[required] The digests of the image layers to check.}
}
\value{
A list with the following syntax:\preformatted{list(
  layers = list(
    list(
      layerDigest = "string",
      layerAvailability = "AVAILABLE"|"UNAVAILABLE",
      layerSize = 123,
      mediaType = "string"
    )
  ),
  failures = list(
    list(
      layerDigest = "string",
      failureCode = "InvalidLayerDigest"|"MissingLayerDigest",
      failureReason = "string"
    )
  )
)
}
}
\description{
Checks the availability of one or more image layers in a repository.

When an image is pushed to a repository, each image layer is checked to
verify if it has been uploaded before. If it has been uploaded, then the
image layer is skipped.

This operation is used by the Amazon ECR proxy and is not generally used
by customers for pulling and pushing images. In most cases, you should
use the \code{docker} CLI to pull, tag, and push images.
}
\section{Request syntax}{
\preformatted{svc$batch_check_layer_availability(
  registryId = "string",
  repositoryName = "string",
  layerDigests = list(
    "string"
  )
)
}
}

\keyword{internal}
