% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_spot_fleet_instances}
\alias{ec2_describe_spot_fleet_instances}
\title{Describes the running instances for the specified Spot Fleet}
\usage{
ec2_describe_spot_fleet_instances(DryRun, MaxResults, NextToken,
  SpotFleetRequestId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 1 and 1000. The default value is 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next set of results.}

\item{SpotFleetRequestId}{[required] The ID of the Spot Fleet request.}
}
\description{
Describes the running instances for the specified Spot Fleet.
}
\section{Request syntax}{
\preformatted{svc$describe_spot_fleet_instances(
  DryRun = TRUE|FALSE,
  MaxResults = 123,
  NextToken = "string",
  SpotFleetRequestId = "string"
)
}
}

\examples{
# This example lists the Spot Instances associated with the specified Spot
# fleet.
\dontrun{svc$describe_spot_fleet_instances(
  SpotFleetRequestId = "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"
)}

}
\keyword{internal}
