% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disassociate_route_table}
\alias{ec2_disassociate_route_table}
\title{Disassociates a subnet from a route table}
\usage{
ec2_disassociate_route_table(AssociationId, DryRun)
}
\arguments{
\item{AssociationId}{[required] The association ID representing the current association between the
route table and subnet.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Disassociates a subnet from a route table.
}
\details{
After you perform this action, the subnet no longer uses the routes in
the route table. Instead, it uses the routes in the VPC\'s main route
table. For more information about route tables, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html}{Route Tables}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$disassociate_route_table(
  AssociationId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example disassociates the specified route table from its associated
# subnet.
\dontrun{svc$disassociate_route_table(
  AssociationId = "rtbassoc-781d0d1a"
)}

}
\keyword{internal}
