% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_fleets}
\alias{ec2_delete_fleets}
\title{Deletes the specified EC2 Fleet}
\usage{
ec2_delete_fleets(DryRun, FleetIds, TerminateInstances)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{FleetIds}{[required] The IDs of the EC2 Fleets.}

\item{TerminateInstances}{[required] Indicates whether to terminate instances for an EC2 Fleet if it is
deleted successfully.}
}
\description{
Deletes the specified EC2 Fleet.
}
\details{
After you delete an EC2 Fleet, it launches no new instances. You must
specify whether an EC2 Fleet should also terminate its instances. If you
terminate the instances, the EC2 Fleet enters the \code{deleted_terminating}
state. Otherwise, the EC2 Fleet enters the \code{deleted_running} state, and
the instances continue to run until they are interrupted or you
terminate them manually.
}
\section{Request syntax}{
\preformatted{svc$delete_fleets(
  DryRun = TRUE|FALSE,
  FleetIds = list(
    "string"
  ),
  TerminateInstances = TRUE|FALSE
)
}
}

\keyword{internal}
