% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_launch_template}
\alias{ec2_modify_launch_template}
\title{Modifies a launch template}
\usage{
ec2_modify_launch_template(DryRun, ClientToken, LaunchTemplateId,
  LaunchTemplateName, DefaultVersion)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.

Constraint: Maximum 128 ASCII characters.}

\item{LaunchTemplateId}{The ID of the launch template. You must specify either the launch
template ID or launch template name in the request.}

\item{LaunchTemplateName}{The name of the launch template. You must specify either the launch
template ID or launch template name in the request.}

\item{DefaultVersion}{The version number of the launch template to set as the default version.}
}
\description{
Modifies a launch template. You can specify which version of the launch
template to set as the default version. When launching an instance, the
default version applies when a launch template version is not specified.
}
\section{Request syntax}{
\preformatted{svc$modify_launch_template(
  DryRun = TRUE|FALSE,
  ClientToken = "string",
  LaunchTemplateId = "string",
  LaunchTemplateName = "string",
  DefaultVersion = "string"
)
}
}

\examples{
\dontrun{
# This example specifies version 2 as the default version of the specified
# launch template.
svc$modify_launch_template(
  DefaultVersion = "2",
  LaunchTemplateId = "lt-0abcd290751193123"
)
}

}
\keyword{internal}
