% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_put_lifecycle_policy}
\alias{ecr_put_lifecycle_policy}
\title{Creates or updates a lifecycle policy}
\usage{
ecr_put_lifecycle_policy(registryId, repositoryName,
  lifecyclePolicyText)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the
repository. If you doâ€¨ not specify a registry, the default registry is
assumed.}

\item{repositoryName}{[required] The name of the repository to receive the policy.}

\item{lifecyclePolicyText}{[required] The JSON repository policy text to apply to the repository.}
}
\description{
Creates or updates a lifecycle policy. For information about lifecycle
policy syntax, see \href{https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html}{Lifecycle Policy Template}.
}
\section{Request syntax}{
\preformatted{svc$put_lifecycle_policy(
  registryId = "string",
  repositoryName = "string",
  lifecyclePolicyText = "string"
)
}
}

\keyword{internal}
