% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_update_application_version}
\alias{elasticbeanstalk_update_application_version}
\title{Updates the specified application version to have the specified
properties}
\usage{
elasticbeanstalk_update_application_version(ApplicationName,
  VersionLabel, Description)
}
\arguments{
\item{ApplicationName}{[required] The name of the application associated with this version.

If no application is found with this name, \code{UpdateApplication} returns
an \code{InvalidParameterValue} error.}

\item{VersionLabel}{[required] The name of the version to update.

If no application version is found with this label, \code{UpdateApplication}
returns an \code{InvalidParameterValue} error.}

\item{Description}{A new description for this version.}
}
\description{
Updates the specified application version to have the specified
properties.
}
\details{
If a property (for example, \code{description}) is not provided, the value
remains unchanged. To clear properties, specify an empty string.
}
\section{Request syntax}{
\preformatted{svc$update_application_version(
  ApplicationName = "string",
  VersionLabel = "string",
  Description = "string"
)
}
}

\examples{
\dontrun{
# The following operation updates the description of an application
# version named 22a0-stage-150819_185942:
svc$update_application_version(
  ApplicationName = "my-app",
  Description = "new description",
  VersionLabel = "22a0-stage-150819_185942"
)
}

}
\keyword{internal}
