% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpcs}
\alias{ec2_describe_vpcs}
\title{Describes one or more of your VPCs}
\usage{
ec2_describe_vpcs(
  Filters = NULL,
  VpcIds = NULL,
  DryRun = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Filters}{The filters.
\itemize{
\item \code{cidr} - The primary IPv4 CIDR block of the VPC. The CIDR block you
specify must exactly match the VPC's CIDR block for information to
be returned for the VPC. Must contain the slash followed by one or
two digits (for example, \verb{/28}).
\item \code{cidr-block-association.cidr-block} - An IPv4 CIDR block associated
with the VPC.
\item \code{cidr-block-association.association-id} - The association ID for an
IPv4 CIDR block associated with the VPC.
\item \code{cidr-block-association.state} - The state of an IPv4 CIDR block
associated with the VPC.
\item \code{dhcp-options-id} - The ID of a set of DHCP options.
\item \code{ipv6-cidr-block-association.ipv6-cidr-block} - An IPv6 CIDR block
associated with the VPC.
\item \code{ipv6-cidr-block-association.ipv6-pool} - The ID of the IPv6 address
pool from which the IPv6 CIDR block is allocated.
\item \code{ipv6-cidr-block-association.association-id} - The association ID
for an IPv6 CIDR block associated with the VPC.
\item \code{ipv6-cidr-block-association.state} - The state of an IPv6 CIDR
block associated with the VPC.
\item \code{is-default} - Indicates whether the VPC is the default VPC.
\item \code{owner-id} - The ID of the Amazon Web Services account that owns the
VPC.
\item \code{state} - The state of the VPC (\code{pending} | \code{available}).
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC.
}}

\item{VpcIds}{The IDs of the VPCs.

Default: Describes all your VPCs.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describes one or more of your VPCs.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_vpcs/} for full documentation.
}
\keyword{internal}
