% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_carrier_gateway}
\alias{ec2_create_carrier_gateway}
\title{Creates a carrier gateway}
\usage{
ec2_create_carrier_gateway(
  VpcId,
  TagSpecifications = NULL,
  DryRun = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{VpcId}{[required] The ID of the VPC to associate with the carrier gateway.}

\item{TagSpecifications}{The tags to associate with the carrier gateway.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to ensure idempotency}.}
}
\description{
Creates a carrier gateway. For more information about carrier gateways, see \href{https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway}{Carrier gateways} in the \emph{Amazon Web Services Wavelength Developer Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_carrier_gateway/} for full documentation.
}
\keyword{internal}
