% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_put_function_code_signing_config}
\alias{lambda_put_function_code_signing_config}
\title{Update the code signing configuration for the function}
\usage{
lambda_put_function_code_signing_config(CodeSigningConfigArn, FunctionName)
}
\arguments{
\item{CodeSigningConfigArn}{[required] The The Amazon Resource Name (ARN) of the code signing configuration.}

\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}
}
\description{
Update the code signing configuration for the function. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.

See \url{https://www.paws-r-sdk.com/docs/lambda_put_function_code_signing_config/} for full documentation.
}
\keyword{internal}
