% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_capacity_reservation_attributes}
\alias{ec2_modify_instance_capacity_reservation_attributes}
\title{Modifies the Capacity Reservation settings for a stopped instance}
\usage{
ec2_modify_instance_capacity_reservation_attributes(
  InstanceId,
  CapacityReservationSpecification,
  DryRun = NULL
)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance to be modified.}

\item{CapacityReservationSpecification}{[required] Information about the Capacity Reservation targeting option.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies the Capacity Reservation settings for a stopped instance. Use this action to configure an instance to target a specific Capacity Reservation, run in any \code{open} Capacity Reservation with matching attributes, or run On-Demand Instance capacity.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_instance_capacity_reservation_attributes/} for full documentation.
}
\keyword{internal}
