% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpc_endpoint}
\alias{ec2_modify_vpc_endpoint}
\title{Modifies attributes of a specified VPC endpoint}
\usage{
ec2_modify_vpc_endpoint(
  DryRun = NULL,
  VpcEndpointId,
  ResetPolicy = NULL,
  PolicyDocument = NULL,
  AddRouteTableIds = NULL,
  RemoveRouteTableIds = NULL,
  AddSubnetIds = NULL,
  RemoveSubnetIds = NULL,
  AddSecurityGroupIds = NULL,
  RemoveSecurityGroupIds = NULL,
  IpAddressType = NULL,
  DnsOptions = NULL,
  PrivateDnsEnabled = NULL,
  SubnetConfigurations = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcEndpointId}{[required] The ID of the endpoint.}

\item{ResetPolicy}{(Gateway endpoint) Specify \code{true} to reset the policy document to the
default policy. The default policy allows full access to the service.}

\item{PolicyDocument}{(Interface and gateway endpoints) A policy to attach to the endpoint
that controls access to the service. The policy must be in valid JSON
format.}

\item{AddRouteTableIds}{(Gateway endpoint) The IDs of the route tables to associate with the
endpoint.}

\item{RemoveRouteTableIds}{(Gateway endpoint) The IDs of the route tables to disassociate from the
endpoint.}

\item{AddSubnetIds}{(Interface and Gateway Load Balancer endpoints) The IDs of the subnets
in which to serve the endpoint. For a Gateway Load Balancer endpoint,
you can specify only one subnet.}

\item{RemoveSubnetIds}{(Interface endpoint) The IDs of the subnets from which to remove the
endpoint.}

\item{AddSecurityGroupIds}{(Interface endpoint) The IDs of the security groups to associate with
the endpoint network interfaces.}

\item{RemoveSecurityGroupIds}{(Interface endpoint) The IDs of the security groups to disassociate from
the endpoint network interfaces.}

\item{IpAddressType}{The IP address type for the endpoint.}

\item{DnsOptions}{The DNS options for the endpoint.}

\item{PrivateDnsEnabled}{(Interface endpoint) Indicates whether a private hosted zone is
associated with the VPC.}

\item{SubnetConfigurations}{The subnet configurations for the endpoint.}
}
\description{
Modifies attributes of a specified VPC endpoint. The attributes that you can modify depend on the type of VPC endpoint (interface, gateway, or Gateway Load Balancer). For more information, see the \href{https://docs.aws.amazon.com/vpc/latest/privatelink/}{Amazon Web Services PrivateLink Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_vpc_endpoint/} for full documentation.
}
\keyword{internal}
