% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_network_performance_options}
\alias{ec2_modify_instance_network_performance_options}
\title{Change the configuration of the network performance options for an
existing instance}
\usage{
ec2_modify_instance_network_performance_options(
  InstanceId,
  BandwidthWeighting,
  DryRun = NULL
)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance to update.}

\item{BandwidthWeighting}{[required] Specify the bandwidth weighting option to boost the associated type of
baseline bandwidth, as follows:

\strong{default}

This option uses the standard bandwidth configuration for your instance
type.

\strong{vpc-1}

This option boosts your networking baseline bandwidth and reduces your
EBS baseline bandwidth.

\strong{ebs-1}

This option boosts your EBS baseline bandwidth and reduces your
networking baseline bandwidth.}

\item{DryRun}{Checks whether you have the required permissions for the operation,
without actually making the request, and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Change the configuration of the network performance options for an existing instance.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_instance_network_performance_options/} for full documentation.
}
\keyword{internal}
