% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographydataplane_operations.R
\name{paymentcryptographydataplane_verify_card_validation_data}
\alias{paymentcryptographydataplane_verify_card_validation_data}
\title{Verifies card-related validation data using algorithms such as Card
Verification Values (CVV/CVV2), Dynamic Card Verification Values
(dCVV/dCVV2) and Card Security Codes (CSC)}
\usage{
paymentcryptographydataplane_verify_card_validation_data(
  KeyIdentifier,
  PrimaryAccountNumber,
  ValidationData,
  VerificationAttributes
)
}
\arguments{
\item{KeyIdentifier}{[required] The \code{keyARN} of the CVK encryption key that Amazon Web Services Payment
Cryptography uses to verify card data.}

\item{PrimaryAccountNumber}{[required] The Primary Account Number (PAN), a unique identifier for a payment
credit or debit card that associates the card with a specific account
holder.}

\item{ValidationData}{[required] The CVV or CSC value for use for card data verification within Amazon
Web Services Payment Cryptography.}

\item{VerificationAttributes}{[required] The algorithm to use for verification of card data within Amazon Web
Services Payment Cryptography.}
}
\description{
Verifies card-related validation data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2) and Card Security Codes (CSC). For more information, see \href{https://docs.aws.amazon.com/payment-cryptography/latest/userguide/verify-card-data.html}{Verify card data} in the \emph{Amazon Web Services Payment Cryptography User Guide}.

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographydataplane_verify_card_validation_data/} for full documentation.
}
\keyword{internal}
