% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographydataplane_operations.R
\name{paymentcryptographydataplane_generate_card_validation_data}
\alias{paymentcryptographydataplane_generate_card_validation_data}
\title{Generates card-related validation data using algorithms such as Card
Verification Values (CVV/CVV2), Dynamic Card Verification Values
(dCVV/dCVV2), or Card Security Codes (CSC)}
\usage{
paymentcryptographydataplane_generate_card_validation_data(
  KeyIdentifier,
  PrimaryAccountNumber,
  GenerationAttributes,
  ValidationDataLength = NULL
)
}
\arguments{
\item{KeyIdentifier}{[required] The \code{keyARN} of the CVK encryption key that Amazon Web Services Payment
Cryptography uses to generate card data.}

\item{PrimaryAccountNumber}{[required] The Primary Account Number (PAN), a unique identifier for a payment
credit or debit card that associates the card with a specific account
holder.}

\item{GenerationAttributes}{[required] The algorithm for generating CVV or CSC values for the card within
Amazon Web Services Payment Cryptography.}

\item{ValidationDataLength}{The length of the CVV or CSC to be generated. The default value is 3.}
}
\description{
Generates card-related validation data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security Codes (CSC). For more information, see \href{https://docs.aws.amazon.com/payment-cryptography/latest/userguide/generate-card-data.html}{Generate card data} in the \emph{Amazon Web Services Payment Cryptography User Guide}.

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographydataplane_generate_card_validation_data/} for full documentation.
}
\keyword{internal}
