% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_reservation_utilization}
\alias{costexplorer_get_reservation_utilization}
\title{Retrieves the reservation utilization for your account}
\usage{
costexplorer_get_reservation_utilization(
  TimePeriod,
  GroupBy = NULL,
  Granularity = NULL,
  Filter = NULL,
  SortBy = NULL,
  NextPageToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{TimePeriod}{[required] Sets the start and end dates for retrieving Reserved Instance (RI)
utilization. The start date is inclusive, but the end date is exclusive.
For example, if \code{start} is \code{2017-01-01} and \code{end} is \code{2017-05-01}, then
the cost and usage data is retrieved from \code{2017-01-01} up to and
including \code{2017-04-30} but not including \code{2017-05-01}.}

\item{GroupBy}{Groups only by \code{SUBSCRIPTION_ID}. Metadata is included.}

\item{Granularity}{If \code{GroupBy} is set, \code{Granularity} can't be set. If \code{Granularity} isn't
set, the response object doesn't include \code{Granularity}, either \code{MONTHLY}
or \code{DAILY}. If both \code{GroupBy} and \code{Granularity} aren't set,
\code{\link[=costexplorer_get_reservation_utilization]{get_reservation_utilization}}
defaults to \code{DAILY}.

The
\code{\link[=costexplorer_get_reservation_utilization]{get_reservation_utilization}}
operation supports only \code{DAILY} and \code{MONTHLY} granularities.}

\item{Filter}{Filters utilization data by dimensions. You can filter by the following
dimensions:
\itemize{
\item AZ
\item CACHE_ENGINE
\item DEPLOYMENT_OPTION
\item INSTANCE_TYPE
\item LINKED_ACCOUNT
\item OPERATING_SYSTEM
\item PLATFORM
\item REGION
\item SERVICE
\item SCOPE
\item TENANCY
}

\code{\link[=costexplorer_get_reservation_utilization]{get_reservation_utilization}}
uses the same
\href{https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html}{Expression}
object as the other operations, but only \code{AND} is supported among each
dimension, and nesting is supported up to only one level deep. If there
are multiple values for a dimension, they are OR'd together.}

\item{SortBy}{The value that you want to sort the data by.

The following values are supported for \code{Key}:
\itemize{
\item \code{UtilizationPercentage}
\item \code{UtilizationPercentageInUnits}
\item \code{PurchasedHours}
\item \code{PurchasedUnits}
\item \code{TotalActualHours}
\item \code{TotalActualUnits}
\item \code{UnusedHours}
\item \code{UnusedUnits}
\item \code{OnDemandCostOfRIHoursUsed}
\item \code{NetRISavings}
\item \code{TotalPotentialRISavings}
\item \code{AmortizedUpfrontFee}
\item \code{AmortizedRecurringFee}
\item \code{TotalAmortizedFee}
\item \code{RICostForUnusedHours}
\item \code{RealizedSavings}
\item \code{UnrealizedSavings}
}

The supported values for \code{SortOrder} are \code{ASCENDING} and \code{DESCENDING}.}

\item{NextPageToken}{The token to retrieve the next set of results. Amazon Web Services
provides the token when the response from a previous call has more
results than the maximum page size.}

\item{MaxResults}{The maximum number of objects that you returned for this request. If
more objects are available, in the response, Amazon Web Services
provides a NextPageToken value that you can use in a subsequent call to
get the next batch of objects.}
}
\description{
Retrieves the reservation utilization for your account. Management account in an organization have access to member accounts. You can filter data by dimensions in a time period. You can use \code{\link[=costexplorer_get_dimension_values]{get_dimension_values}} to determine the possible dimension values. Currently, you can group only by \code{SUBSCRIPTION_ID}.

See \url{https://www.paws-r-sdk.com/docs/costexplorer_get_reservation_utilization/} for full documentation.
}
\keyword{internal}
