% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billing_operations.R
\name{billing_list_billing_views}
\alias{billing_list_billing_views}
\title{Lists the billing views available for a given time period}
\usage{
billing_list_billing_views(
  activeTimeRange = NULL,
  arns = NULL,
  billingViewTypes = NULL,
  ownerAccountId = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{activeTimeRange}{The time range for the billing views listed. \code{PRIMARY} billing view is
always listed. \code{BILLING_GROUP} billing views are listed for time ranges
when the associated billing group resource in Billing Conductor is
active. The time range must be within one calendar month.}

\item{arns}{The Amazon Resource Name (ARN) that can be used to uniquely identify the
billing view.}

\item{billingViewTypes}{The type of billing view.}

\item{ownerAccountId}{The list of owners of the billing view.}

\item{maxResults}{The maximum number of billing views to retrieve. Default is 100.}

\item{nextToken}{The pagination token that is used on subsequent calls to list billing
views.}
}
\description{
Lists the billing views available for a given time period.

See \url{https://www.paws-r-sdk.com/docs/billing_list_billing_views/} for full documentation.
}
\keyword{internal}
