% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_contact_recording}
\alias{connect_start_contact_recording}
\title{This API starts recording the contact when the agent joins the call}
\usage{
connect_start_contact_recording(InstanceId, ContactId, InitialContactId,
  VoiceRecordingConfiguration)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{ContactId}{[required] The identifier of the contact.}

\item{InitialContactId}{[required] The identifier of the contact. This is the identifier of the contact
associated with the first interaction with the contact center.}

\item{VoiceRecordingConfiguration}{[required] Who is being recorded.}
}
\value{
An empty list.
}
\description{
This API starts recording the contact when the agent joins the call.
StartContactRecording is a one-time action. For example, if you use
StopContactRecording to stop recording an ongoing call, you can't use
StartContactRecording to restart it. For scenarios where the recording
has started and you want to suspend and resume it, such as when
collecting sensitive information (for example, a credit card number),
use SuspendContactRecording and ResumeContactRecording.

You can use this API to override the recording behavior configured in
the \href{https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html}{Set recording behavior}
block.

Only voice recordings are supported at this time.
}
\section{Request syntax}{
\preformatted{svc$start_contact_recording(
  InstanceId = "string",
  ContactId = "string",
  InitialContactId = "string",
  VoiceRecordingConfiguration = list(
    VoiceRecordingTrack = "FROM_AGENT"|"TO_AGENT"|"ALL"
  )
)
}
}

\keyword{internal}
