% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_contact_flow_content}
\alias{connect_update_contact_flow_content}
\title{Updates the specified contact flow}
\usage{
connect_update_contact_flow_content(InstanceId, ContactFlowId, Content)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{ContactFlowId}{[required] The identifier of the contact flow.}

\item{Content}{[required] The JSON string that represents contact flow’s content. For an example,
see \href{https://docs.aws.amazon.com/connect/latest/adminguide/flow-language-example.html}{Example contact flow in Amazon Connect Flow language}
in the \emph{Amazon Connect Administrator Guide}.}
}
\value{
An empty list.
}
\description{
Updates the specified contact flow.

You can also create and update contact flows using the \href{https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html}{Amazon Connect Flow language}.
}
\section{Request syntax}{
\preformatted{svc$update_contact_flow_content(
  InstanceId = "string",
  ContactFlowId = "string",
  Content = "string"
)
}
}

\keyword{internal}
