% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_apps}
\alias{pinpoint_get_apps}
\title{Retrieves information about all the applications that are associated
with your Amazon Pinpoint account}
\usage{
pinpoint_get_apps(PageSize, Token)
}
\arguments{
\item{PageSize}{The maximum number of items to include in each page of a paginated
response. This parameter is not supported for application, campaign, and
journey metrics.}

\item{Token}{The NextToken string that specifies which page of results to return in a
paginated response.}
}
\value{
A list with the following syntax:\preformatted{list(
  ApplicationsResponse = list(
    Item = list(
      list(
        Arn = "string",
        Id = "string",
        Name = "string",
        tags = list(
          "string"
        )
      )
    ),
    NextToken = "string"
  )
)
}
}
\description{
Retrieves information about all the applications that are associated
with your Amazon Pinpoint account.
}
\section{Request syntax}{
\preformatted{svc$get_apps(
  PageSize = "string",
  Token = "string"
)
}
}

\keyword{internal}
