% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_clone_receipt_rule_set}
\alias{ses_clone_receipt_rule_set}
\title{Creates a receipt rule set by cloning an existing one}
\usage{
ses_clone_receipt_rule_set(RuleSetName, OriginalRuleSetName)
}
\arguments{
\item{RuleSetName}{[required] The name of the rule set to create. The name must:
\itemize{
\item This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
underscores (_), or dashes (-).
\item Start and end with a letter or number.
\item Contain less than 64 characters.
}}

\item{OriginalRuleSetName}{[required] The name of the rule set to clone.}
}
\value{
An empty list.
}
\description{
Creates a receipt rule set by cloning an existing one. All receipt rules
and configurations are copied to the new receipt rule set and are
completely independent of the source rule set.

For information about setting up rule sets, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$clone_receipt_rule_set(
  RuleSetName = "string",
  OriginalRuleSetName = "string"
)
}
}

\examples{
\dontrun{
# The following example creates a receipt rule set by cloning an existing
# one:
svc$clone_receipt_rule_set(
  OriginalRuleSetName = "RuleSetToClone",
  RuleSetName = "RuleSetToCreate"
)
}

}
\keyword{internal}
