% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointemail_operations.R
\name{pinpointemail_put_configuration_set_delivery_options}
\alias{pinpointemail_put_configuration_set_delivery_options}
\title{Associate a configuration set with a dedicated IP pool}
\usage{
pinpointemail_put_configuration_set_delivery_options(
  ConfigurationSetName, TlsPolicy, SendingPoolName)
}
\arguments{
\item{ConfigurationSetName}{[required] The name of the configuration set that you want to associate with a
dedicated IP pool.}

\item{TlsPolicy}{Whether Amazon Pinpoint should require that incoming email is delivered
over a connection encrypted with Transport Layer Security (TLS).}

\item{SendingPoolName}{The name of the dedicated IP pool that you want to associate with the
configuration set.}
}
\description{
Associate a configuration set with a dedicated IP pool. You can use
dedicated IP pools to create groups of dedicated IP addresses for
sending specific types of email.
}
\section{Request syntax}{
\preformatted{svc$put_configuration_set_delivery_options(
  ConfigurationSetName = "string",
  TlsPolicy = "REQUIRE"|"OPTIONAL",
  SendingPoolName = "string"
)
}
}

\keyword{internal}
