% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_contact_attributes}
\alias{connect_update_contact_attributes}
\title{The UpdateContactAttributes operation lets you programmatically create
new, or update existing, contact attributes associated with a contact}
\usage{
connect_update_contact_attributes(InitialContactId, InstanceId,
  Attributes)
}
\arguments{
\item{InitialContactId}{[required] The unique identifier of the contact for which to update attributes.
This is the identifier for the contact associated with the first
interaction with the contact center.}

\item{InstanceId}{[required] The identifier for your Amazon Connect instance. To find the ID of your
instance, open the AWS console and select Amazon Connect. Select the
alias of the instance in the Instance alias column. The instance ID is
displayed in the Overview section of your instance settings. For
example, the instance ID is the set of characters at the end of the
instance ARN, after instance/, such as
10a4c4eb-f57e-4d4c-b602-bf39176ced07.}

\item{Attributes}{[required] Specify a custom key-value pair using an attribute map. The attributes
are standard Amazon Connect attributes, and can be accessed in contact
flows just like any other contact attributes.

There can be up to 32,768 UTF-8 bytes across all key-value pairs per
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.}
}
\description{
The \code{UpdateContactAttributes} operation lets you programmatically create
new, or update existing, contact attributes associated with a contact.
You can use the operation to add or update attributes for both ongoing
and completed contacts. For example, you can update the customer's name
or the reason the customer called while the call is active, or add notes
about steps that the agent took during the call that are displayed to
the next agent that takes the call. You can also use the
\code{UpdateContactAttributes} operation to update attributes for a contact
using data from your CRM application and save the data with the contact
in Amazon Connect. You could also flag calls for additional analysis,
such as legal review or identifying abusive callers.
}
\details{
Contact attributes are available in Amazon Connect for 24 months, and
are then deleted.

\emph{Important:}

You cannot use the operation to update attributes for contacts that
occurred prior to the release of the API, September 12, 2018. You can
update attributes only for contacts that started after the release of
the API. If you attempt to update attributes for a contact that occurred
prior to the release of the API, a 400 error is returned. This applies
also to queued callbacks that were initiated prior to the release of the
API but are still active in your instance.
}
\section{Request syntax}{
\preformatted{svc$update_contact_attributes(
  InitialContactId = "string",
  InstanceId = "string",
  Attributes = list(
    "string"
  )
)
}
}

\keyword{internal}
