# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include pinpointsmsvoicev2_service.R
NULL

#' Associates the specified origination identity with a pool
#'
#' @description
#' Associates the specified origination identity with a pool.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/associate_origination_identity.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/associate_origination_identity.html) for full documentation.
#'
#' @param PoolId &#91;required&#93; The pool to update with the new Identity. This value can be either the
#' PoolId or PoolArn, and you can find these values using
#' [`describe_pools`][pinpointsmsvoicev2_describe_pools].
#' @param OriginationIdentity &#91;required&#93; The origination identity to use, such as PhoneNumberId, PhoneNumberArn,
#' SenderId, or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' find the values for PhoneNumberId and PhoneNumberArn, while
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] can be
#' used to get the values for SenderId and SenderIdArn.
#' @param IsoCountryCode &#91;required&#93; The new two-character code, in ISO 3166-1 alpha-2 format, for the
#' country or region of the origination identity.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_associate_origination_identity
pinpointsmsvoicev2_associate_origination_identity <- function(PoolId, OriginationIdentity, IsoCountryCode, ClientToken = NULL) {
  op <- new_operation(
    name = "AssociateOriginationIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$associate_origination_identity_input(PoolId = PoolId, OriginationIdentity = OriginationIdentity, IsoCountryCode = IsoCountryCode, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$associate_origination_identity_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$associate_origination_identity <- pinpointsmsvoicev2_associate_origination_identity

#' Creates a new configuration set
#'
#' @description
#' Creates a new configuration set. After you create the configuration set, you can add one or more event destinations to it.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/create_configuration_set.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/create_configuration_set.html) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name to use for the new configuration set.
#' @param Tags An array of key and value pair tags that's associated with the new
#' configuration set.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_configuration_set
pinpointsmsvoicev2_create_configuration_set <- function(ConfigurationSetName, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateConfigurationSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_configuration_set_input(ConfigurationSetName = ConfigurationSetName, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_configuration_set_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_configuration_set <- pinpointsmsvoicev2_create_configuration_set

#' Creates a new event destination in a configuration set
#'
#' @description
#' Creates a new event destination in a configuration set.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/create_event_destination.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/create_event_destination.html) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; Either the name of the configuration set or the configuration set ARN to
#' apply event logging to. The ConfigurateSetName and ConfigurationSetArn
#' can be found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#' @param EventDestinationName &#91;required&#93; The name that identifies the event destination.
#' @param MatchingEventTypes &#91;required&#93; An array of event types that determine which events to log. If "ALL" is
#' used, then Amazon Pinpoint logs every event type.
#' @param CloudWatchLogsDestination An object that contains information about an event destination for
#' logging to Amazon CloudWatch logs.
#' @param KinesisFirehoseDestination An object that contains information about an event destination for
#' logging to Amazon Kinesis Data Firehose.
#' @param SnsDestination An object that contains information about an event destination for
#' logging to Amazon SNS.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_event_destination
pinpointsmsvoicev2_create_event_destination <- function(ConfigurationSetName, EventDestinationName, MatchingEventTypes, CloudWatchLogsDestination = NULL, KinesisFirehoseDestination = NULL, SnsDestination = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateEventDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, MatchingEventTypes = MatchingEventTypes, CloudWatchLogsDestination = CloudWatchLogsDestination, KinesisFirehoseDestination = KinesisFirehoseDestination, SnsDestination = SnsDestination, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_event_destination_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_event_destination <- pinpointsmsvoicev2_create_event_destination

#' Creates a new opt-out list
#'
#' @description
#' Creates a new opt-out list.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/create_opt_out_list.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/create_opt_out_list.html) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The name of the new OptOutList.
#' @param Tags An array of tags (key and value pairs) to associate with the new
#' OptOutList.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_opt_out_list
pinpointsmsvoicev2_create_opt_out_list <- function(OptOutListName, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateOptOutList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_opt_out_list_input(OptOutListName = OptOutListName, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_opt_out_list_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_opt_out_list <- pinpointsmsvoicev2_create_opt_out_list

#' Creates a new pool and associates the specified origination identity to
#' the pool
#'
#' @description
#' Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/create_pool.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/create_pool.html) for full documentation.
#'
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' SenderId or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' find the values for PhoneNumberId and PhoneNumberArn while
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] can be
#' used to get the values for SenderId and SenderIdArn.
#' @param IsoCountryCode &#91;required&#93; The new two-character code, in ISO 3166-1 alpha-2 format, for the
#' country or region of the new pool.
#' @param MessageType &#91;required&#93; The type of message. Valid values are TRANSACTIONAL for messages that
#' are critical or time-sensitive and PROMOTIONAL for messages that aren't
#' critical or time-sensitive.
#' @param DeletionProtectionEnabled By default this is set to false. When set to true the pool can't be
#' deleted. You can change this value using the
#' [`update_pool`][pinpointsmsvoicev2_update_pool] action.
#' @param Tags An array of tags (key and value pairs) associated with the pool.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_create_pool
pinpointsmsvoicev2_create_pool <- function(OriginationIdentity, IsoCountryCode, MessageType, DeletionProtectionEnabled = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreatePool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$create_pool_input(OriginationIdentity = OriginationIdentity, IsoCountryCode = IsoCountryCode, MessageType = MessageType, DeletionProtectionEnabled = DeletionProtectionEnabled, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$create_pool_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$create_pool <- pinpointsmsvoicev2_create_pool

#' Deletes an existing configuration set
#'
#' @description
#' Deletes an existing configuration set.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_configuration_set.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_configuration_set.html) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set or the configuration set ARN that you
#' want to delete. The ConfigurationSetName and ConfigurationSetArn can be
#' found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_configuration_set
pinpointsmsvoicev2_delete_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoicev2$delete_configuration_set_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_configuration_set <- pinpointsmsvoicev2_delete_configuration_set

#' Deletes an existing default message type on a configuration set
#'
#' @description
#' Deletes an existing default message type on a configuration set.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_default_message_type.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_default_message_type.html) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set or the configuration set Amazon
#' Resource Name (ARN) to delete the default message type from. The
#' ConfigurationSetName and ConfigurationSetArn can be found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_default_message_type
pinpointsmsvoicev2_delete_default_message_type <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteDefaultMessageType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_default_message_type_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoicev2$delete_default_message_type_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_default_message_type <- pinpointsmsvoicev2_delete_default_message_type

#' Deletes an existing default sender ID on a configuration set
#'
#' @description
#' Deletes an existing default sender ID on a configuration set.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_default_sender_id.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_default_sender_id.html) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set or the configuration set Amazon
#' Resource Name (ARN) to delete the default sender ID from. The
#' ConfigurationSetName and ConfigurationSetArn can be found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_default_sender_id
pinpointsmsvoicev2_delete_default_sender_id <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteDefaultSenderId",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_default_sender_id_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoicev2$delete_default_sender_id_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_default_sender_id <- pinpointsmsvoicev2_delete_default_sender_id

#' Deletes an existing event destination
#'
#' @description
#' Deletes an existing event destination.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_event_destination.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_event_destination.html) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set or the configuration set's Amazon
#' Resource Name (ARN) to remove the event destination from. The
#' ConfigurateSetName and ConfigurationSetArn can be found using the
#' [`describe_configuration_sets`][pinpointsmsvoicev2_describe_configuration_sets]
#' action.
#' @param EventDestinationName &#91;required&#93; The name of the event destination to delete.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_event_destination
pinpointsmsvoicev2_delete_event_destination <- function(ConfigurationSetName, EventDestinationName) {
  op <- new_operation(
    name = "DeleteEventDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName)
  output <- .pinpointsmsvoicev2$delete_event_destination_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_event_destination <- pinpointsmsvoicev2_delete_event_destination

#' Deletes an existing keyword from an origination phone number or pool
#'
#' @description
#' Deletes an existing keyword from an origination phone number or pool.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_keyword.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_keyword.html) for full documentation.
#'
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' PoolId or PoolArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' find the values for PhoneNumberId and PhoneNumberArn and
#' [`describe_pools`][pinpointsmsvoicev2_describe_pools] to find the values
#' of PoolId and PoolArn.
#' @param Keyword &#91;required&#93; The keyword to delete.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_keyword
pinpointsmsvoicev2_delete_keyword <- function(OriginationIdentity, Keyword) {
  op <- new_operation(
    name = "DeleteKeyword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_keyword_input(OriginationIdentity = OriginationIdentity, Keyword = Keyword)
  output <- .pinpointsmsvoicev2$delete_keyword_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_keyword <- pinpointsmsvoicev2_delete_keyword

#' Deletes an existing opt-out list
#'
#' @description
#' Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_opt_out_list.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_opt_out_list.html) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The OptOutListName or OptOutListArn of the OptOutList to delete. You can
#' use
#' [`describe_opt_out_lists`][pinpointsmsvoicev2_describe_opt_out_lists] to
#' find the values for OptOutListName and OptOutListArn.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_opt_out_list
pinpointsmsvoicev2_delete_opt_out_list <- function(OptOutListName) {
  op <- new_operation(
    name = "DeleteOptOutList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_opt_out_list_input(OptOutListName = OptOutListName)
  output <- .pinpointsmsvoicev2$delete_opt_out_list_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_opt_out_list <- pinpointsmsvoicev2_delete_opt_out_list

#' Deletes an existing opted out destination phone number from the
#' specified opt-out list
#'
#' @description
#' Deletes an existing opted out destination phone number from the specified opt-out list.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_opted_out_number.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_opted_out_number.html) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The OptOutListName or OptOutListArn to remove the phone number from.
#' @param OptedOutNumber &#91;required&#93; The phone number, in E.164 format, to remove from the OptOutList.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_opted_out_number
pinpointsmsvoicev2_delete_opted_out_number <- function(OptOutListName, OptedOutNumber) {
  op <- new_operation(
    name = "DeleteOptedOutNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_opted_out_number_input(OptOutListName = OptOutListName, OptedOutNumber = OptedOutNumber)
  output <- .pinpointsmsvoicev2$delete_opted_out_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_opted_out_number <- pinpointsmsvoicev2_delete_opted_out_number

#' Deletes an existing pool
#'
#' @description
#' Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_pool.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_pool.html) for full documentation.
#'
#' @param PoolId &#91;required&#93; The PoolId or PoolArn of the pool to delete. You can use
#' [`describe_pools`][pinpointsmsvoicev2_describe_pools] to find the values
#' for PoolId and PoolArn .
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_pool
pinpointsmsvoicev2_delete_pool <- function(PoolId) {
  op <- new_operation(
    name = "DeletePool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_pool_input(PoolId = PoolId)
  output <- .pinpointsmsvoicev2$delete_pool_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_pool <- pinpointsmsvoicev2_delete_pool

#' Deletes an account-level monthly spending limit override for sending
#' text messages
#'
#' @description
#' Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit override will set the `EnforcedLimit` to equal the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see [Amazon Pinpoint quotas](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_text_message_spend_limit_override.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_text_message_spend_limit_override.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_text_message_spend_limit_override
pinpointsmsvoicev2_delete_text_message_spend_limit_override <- function() {
  op <- new_operation(
    name = "DeleteTextMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_text_message_spend_limit_override_input()
  output <- .pinpointsmsvoicev2$delete_text_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_text_message_spend_limit_override <- pinpointsmsvoicev2_delete_text_message_spend_limit_override

#' Deletes an account level monthly spend limit override for sending voice
#' messages
#'
#' @description
#' Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override sets the `EnforcedLimit` equal to the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spending limits (quotas) see [Amazon Pinpoint quotas](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_voice_message_spend_limit_override.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/delete_voice_message_spend_limit_override.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_delete_voice_message_spend_limit_override
pinpointsmsvoicev2_delete_voice_message_spend_limit_override <- function() {
  op <- new_operation(
    name = "DeleteVoiceMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$delete_voice_message_spend_limit_override_input()
  output <- .pinpointsmsvoicev2$delete_voice_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$delete_voice_message_spend_limit_override <- pinpointsmsvoicev2_delete_voice_message_spend_limit_override

#' Describes attributes of your Amazon Web Services account
#'
#' @description
#' Describes attributes of your Amazon Web Services account. The supported account attributes include account tier, which indicates whether your account is in the sandbox or production environment. When you're ready to move your account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_account_attributes.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_account_attributes.html) for full documentation.
#'
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_account_attributes
pinpointsmsvoicev2_describe_account_attributes <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_account_attributes_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_account_attributes_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_account_attributes <- pinpointsmsvoicev2_describe_account_attributes

#' Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for
#' your account
#'
#' @description
#' Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_account_limits.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_account_limits.html) for full documentation.
#'
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_account_limits
pinpointsmsvoicev2_describe_account_limits <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeAccountLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_account_limits_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_account_limits_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_account_limits <- pinpointsmsvoicev2_describe_account_limits

#' Describes the specified configuration sets or all in your account
#'
#' @description
#' Describes the specified configuration sets or all in your account.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_configuration_sets.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_configuration_sets.html) for full documentation.
#'
#' @param ConfigurationSetNames An array of strings. Each element can be either a ConfigurationSetName
#' or ConfigurationSetArn.
#' @param Filters An array of filters to apply to the results that are returned.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_configuration_sets
pinpointsmsvoicev2_describe_configuration_sets <- function(ConfigurationSetNames = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_configuration_sets_input(ConfigurationSetNames = ConfigurationSetNames, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_configuration_sets_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_configuration_sets <- pinpointsmsvoicev2_describe_configuration_sets

#' Describes the specified keywords or all keywords on your origination
#' phone number or pool
#'
#' @description
#' Describes the specified keywords or all keywords on your origination phone number or pool.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_keywords.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_keywords.html) for full documentation.
#'
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' SenderId or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' find the values for PhoneNumberId and PhoneNumberArn while
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] can be
#' used to get the values for SenderId and SenderIdArn.
#' @param Keywords An array of keywords to search for.
#' @param Filters An array of keyword filters to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_keywords
pinpointsmsvoicev2_describe_keywords <- function(OriginationIdentity, Keywords = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeKeywords",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_keywords_input(OriginationIdentity = OriginationIdentity, Keywords = Keywords, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_keywords_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_keywords <- pinpointsmsvoicev2_describe_keywords

#' Describes the specified opt-out list or all opt-out lists in your
#' account
#'
#' @description
#' Describes the specified opt-out list or all opt-out lists in your account.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_opt_out_lists.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_opt_out_lists.html) for full documentation.
#'
#' @param OptOutListNames The OptOutLists to show the details of. This is an array of strings that
#' can be either the OptOutListName or OptOutListArn.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_opt_out_lists
pinpointsmsvoicev2_describe_opt_out_lists <- function(OptOutListNames = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeOptOutLists",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_opt_out_lists_input(OptOutListNames = OptOutListNames, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_opt_out_lists_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_opt_out_lists <- pinpointsmsvoicev2_describe_opt_out_lists

#' Describes the specified opted out destination numbers or all opted out
#' destination numbers in an opt-out list
#'
#' @description
#' Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_opted_out_numbers.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_opted_out_numbers.html) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The OptOutListName or OptOutListArn of the OptOutList. You can use
#' [`describe_opt_out_lists`][pinpointsmsvoicev2_describe_opt_out_lists] to
#' find the values for OptOutListName and OptOutListArn.
#' @param OptedOutNumbers An array of phone numbers to search for in the OptOutList.
#' @param Filters An array of OptedOutFilter objects to filter the results on.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_opted_out_numbers
pinpointsmsvoicev2_describe_opted_out_numbers <- function(OptOutListName, OptedOutNumbers = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeOptedOutNumbers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_opted_out_numbers_input(OptOutListName = OptOutListName, OptedOutNumbers = OptedOutNumbers, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_opted_out_numbers_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_opted_out_numbers <- pinpointsmsvoicev2_describe_opted_out_numbers

#' Describes the specified origination phone number, or all the phone
#' numbers in your account
#'
#' @description
#' Describes the specified origination phone number, or all the phone numbers in your account.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_phone_numbers.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_phone_numbers.html) for full documentation.
#'
#' @param PhoneNumberIds The unique identifier of phone numbers to find information about. This
#' is an array of strings that can be either the PhoneNumberId or
#' PhoneNumberArn.
#' @param Filters An array of PhoneNumberFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_phone_numbers
pinpointsmsvoicev2_describe_phone_numbers <- function(PhoneNumberIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribePhoneNumbers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_phone_numbers_input(PhoneNumberIds = PhoneNumberIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_phone_numbers_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_phone_numbers <- pinpointsmsvoicev2_describe_phone_numbers

#' Retrieves the specified pools or all pools associated with your Amazon
#' Web Services account
#'
#' @description
#' Retrieves the specified pools or all pools associated with your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_pools.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_pools.html) for full documentation.
#'
#' @param PoolIds The unique identifier of pools to find. This is an array of strings that
#' can be either the PoolId or PoolArn.
#' @param Filters An array of PoolFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_pools
pinpointsmsvoicev2_describe_pools <- function(PoolIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribePools",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_pools_input(PoolIds = PoolIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_pools_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_pools <- pinpointsmsvoicev2_describe_pools

#' Describes the specified SenderIds or all SenderIds associated with your
#' Amazon Web Services account
#'
#' @description
#' Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_sender_ids.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_sender_ids.html) for full documentation.
#'
#' @param SenderIds An array of SenderIdAndCountry objects to search for.
#' @param Filters An array of SenderIdFilter objects to filter the results.
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_sender_ids
pinpointsmsvoicev2_describe_sender_ids <- function(SenderIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSenderIds",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_sender_ids_input(SenderIds = SenderIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_sender_ids_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_sender_ids <- pinpointsmsvoicev2_describe_sender_ids

#' Describes the current Amazon Pinpoint monthly spend limits for sending
#' voice and text messages
#'
#' @description
#' Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_spend_limits.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/describe_spend_limits.html) for full documentation.
#'
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_describe_spend_limits
pinpointsmsvoicev2_describe_spend_limits <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSpendLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$describe_spend_limits_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$describe_spend_limits_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$describe_spend_limits <- pinpointsmsvoicev2_describe_spend_limits

#' Removes the specified origination identity from an existing pool
#'
#' @description
#' Removes the specified origination identity from an existing pool.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/disassociate_origination_identity.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/disassociate_origination_identity.html) for full documentation.
#'
#' @param PoolId &#91;required&#93; The unique identifier for the pool to disassociate with the origination
#' identity. This value can be either the PoolId or PoolArn.
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' SenderId or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers]
#' find the values for PhoneNumberId and PhoneNumberArn, or use
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] to get
#' the values for SenderId and SenderIdArn.
#' @param IsoCountryCode &#91;required&#93; The two-character code, in ISO 3166-1 alpha-2 format, for the country or
#' region.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. If you don't specify a client token, a randomly
#' generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_disassociate_origination_identity
pinpointsmsvoicev2_disassociate_origination_identity <- function(PoolId, OriginationIdentity, IsoCountryCode, ClientToken = NULL) {
  op <- new_operation(
    name = "DisassociateOriginationIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$disassociate_origination_identity_input(PoolId = PoolId, OriginationIdentity = OriginationIdentity, IsoCountryCode = IsoCountryCode, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$disassociate_origination_identity_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$disassociate_origination_identity <- pinpointsmsvoicev2_disassociate_origination_identity

#' Lists all associated origination identities in your pool
#'
#' @description
#' Lists all associated origination identities in your pool.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/list_pool_origination_identities.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/list_pool_origination_identities.html) for full documentation.
#'
#' @param PoolId &#91;required&#93; The unique identifier for the pool. This value can be either the PoolId
#' or PoolArn.
#' @param Filters An array of PoolOriginationIdentitiesFilter objects to filter the
#' results..
#' @param NextToken The token to be used for the next set of paginated results. You don't
#' need to supply a value for this field in the initial request.
#' @param MaxResults The maximum number of results to return per each request.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_list_pool_origination_identities
pinpointsmsvoicev2_list_pool_origination_identities <- function(PoolId, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPoolOriginationIdentities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$list_pool_origination_identities_input(PoolId = PoolId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pinpointsmsvoicev2$list_pool_origination_identities_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$list_pool_origination_identities <- pinpointsmsvoicev2_list_pool_origination_identities

#' List all tags associated with a resource
#'
#' @description
#' List all tags associated with a resource.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/list_tags_for_resource.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to query for.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_list_tags_for_resource
pinpointsmsvoicev2_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .pinpointsmsvoicev2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$list_tags_for_resource <- pinpointsmsvoicev2_list_tags_for_resource

#' Creates or updates a keyword configuration on an origination phone
#' number or pool
#'
#' @description
#' Creates or updates a keyword configuration on an origination phone number or pool.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/put_keyword.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/put_keyword.html) for full documentation.
#'
#' @param OriginationIdentity &#91;required&#93; The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
#' SenderId or SenderIdArn. You can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers]
#' get the values for PhoneNumberId and PhoneNumberArn while
#' [`describe_sender_ids`][pinpointsmsvoicev2_describe_sender_ids] can be
#' used to get the values for SenderId and SenderIdArn.
#' @param Keyword &#91;required&#93; The new keyword to add.
#' @param KeywordMessage &#91;required&#93; The message associated with the keyword.
#' 
#' -   AUTOMATIC_RESPONSE: A message is sent to the recipient.
#' 
#' -   OPT_OUT: Keeps the recipient from receiving future messages.
#' 
#' -   OPT_IN: The recipient wants to receive future messages.
#' @param KeywordAction The action to perform for the new keyword when it is received.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_put_keyword
pinpointsmsvoicev2_put_keyword <- function(OriginationIdentity, Keyword, KeywordMessage, KeywordAction = NULL) {
  op <- new_operation(
    name = "PutKeyword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$put_keyword_input(OriginationIdentity = OriginationIdentity, Keyword = Keyword, KeywordMessage = KeywordMessage, KeywordAction = KeywordAction)
  output <- .pinpointsmsvoicev2$put_keyword_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$put_keyword <- pinpointsmsvoicev2_put_keyword

#' Creates an opted out destination phone number in the opt-out list
#'
#' @description
#' Creates an opted out destination phone number in the opt-out list.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/put_opted_out_number.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/put_opted_out_number.html) for full documentation.
#'
#' @param OptOutListName &#91;required&#93; The OptOutListName or OptOutListArn to add the phone number to.
#' @param OptedOutNumber &#91;required&#93; The phone number to add to the OptOutList in E.164 format.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_put_opted_out_number
pinpointsmsvoicev2_put_opted_out_number <- function(OptOutListName, OptedOutNumber) {
  op <- new_operation(
    name = "PutOptedOutNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$put_opted_out_number_input(OptOutListName = OptOutListName, OptedOutNumber = OptedOutNumber)
  output <- .pinpointsmsvoicev2$put_opted_out_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$put_opted_out_number <- pinpointsmsvoicev2_put_opted_out_number

#' Releases an existing origination phone number in your account
#'
#' @description
#' Releases an existing origination phone number in your account. Once released, a phone number is no longer available for sending messages.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/release_phone_number.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/release_phone_number.html) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; The PhoneNumberId or PhoneNumberArn of the phone number to release. You
#' can use
#' [`describe_phone_numbers`][pinpointsmsvoicev2_describe_phone_numbers] to
#' get the values for PhoneNumberId and PhoneNumberArn.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_release_phone_number
pinpointsmsvoicev2_release_phone_number <- function(PhoneNumberId) {
  op <- new_operation(
    name = "ReleasePhoneNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$release_phone_number_input(PhoneNumberId = PhoneNumberId)
  output <- .pinpointsmsvoicev2$release_phone_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$release_phone_number <- pinpointsmsvoicev2_release_phone_number

#' Request an origination phone number for use in your account
#'
#' @description
#' Request an origination phone number for use in your account. For more information on phone number request see [Requesting a number](https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html) in the *Amazon Pinpoint User Guide*.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/request_phone_number.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/request_phone_number.html) for full documentation.
#'
#' @param IsoCountryCode &#91;required&#93; The two-character code, in ISO 3166-1 alpha-2 format, for the country or
#' region.
#' @param MessageType &#91;required&#93; The type of message. Valid values are TRANSACTIONAL for messages that
#' are critical or time-sensitive and PROMOTIONAL for messages that aren't
#' critical or time-sensitive.
#' @param NumberCapabilities &#91;required&#93; Indicates if the phone number will be used for text messages, voice
#' messages, or both.
#' @param NumberType &#91;required&#93; The type of phone number to request.
#' @param OptOutListName The name of the OptOutList to associate with the phone number. You can
#' use the OutOutListName or OptPutListArn.
#' @param PoolId The pool to associated with the phone number. You can use the PoolId or
#' PoolArn.
#' @param RegistrationId Use this field to attach your phone number for an external registration
#' process.
#' @param DeletionProtectionEnabled By default this is set to false. When set to true the phone number can't
#' be deleted.
#' @param Tags An array of tags (key and value pairs) associate with the requested
#' phone number.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don't specify a client token, a
#' randomly generated token is used for the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_request_phone_number
pinpointsmsvoicev2_request_phone_number <- function(IsoCountryCode, MessageType, NumberCapabilities, NumberType, OptOutListName = NULL, PoolId = NULL, RegistrationId = NULL, DeletionProtectionEnabled = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "RequestPhoneNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$request_phone_number_input(IsoCountryCode = IsoCountryCode, MessageType = MessageType, NumberCapabilities = NumberCapabilities, NumberType = NumberType, OptOutListName = OptOutListName, PoolId = PoolId, RegistrationId = RegistrationId, DeletionProtectionEnabled = DeletionProtectionEnabled, Tags = Tags, ClientToken = ClientToken)
  output <- .pinpointsmsvoicev2$request_phone_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$request_phone_number <- pinpointsmsvoicev2_request_phone_number

#' Creates a new text message and sends it to a recipient's phone number
#'
#' @description
#' Creates a new text message and sends it to a recipient's phone number.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/send_text_message.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/send_text_message.html) for full documentation.
#'
#' @param DestinationPhoneNumber &#91;required&#93; The destination phone number in E.164 format.
#' @param OriginationIdentity The origination identity of the message. This can be either the
#' PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn,
#' PoolId, or PoolArn.
#' @param MessageBody The body of the text message.
#' @param MessageType The type of message. Valid values are TRANSACTIONAL for messages that
#' are critical or time-sensitive and PROMOTIONAL for messages that aren't
#' critical or time-sensitive.
#' @param Keyword When you register a short code in the US, you must specify a program
#' name. If you don’t have a US short code, omit this attribute.
#' @param ConfigurationSetName The name of the configuration set to use. This can be either the
#' ConfigurationSetName or ConfigurationSetArn.
#' @param MaxPrice The maximum amount that you want to spend, in US dollars, per each text
#' message part. A text message can contain multiple parts.
#' @param TimeToLive How long the text message is valid for. By default this is 72 hours.
#' @param Context You can specify custom data in this field. If you do, that data is
#' logged to the event destination.
#' @param DestinationCountryParameters This field is used for any country-specific registration requirements.
#' Currently, this setting is only used when you send messages to
#' recipients in India using a sender ID. For more information see [Special
#' requirements for sending SMS messages to recipients in
#' India](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html).
#' @param DryRun When set to true, the message is checked and validated, but isn't sent
#' to the end recipient.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_send_text_message
pinpointsmsvoicev2_send_text_message <- function(DestinationPhoneNumber, OriginationIdentity = NULL, MessageBody = NULL, MessageType = NULL, Keyword = NULL, ConfigurationSetName = NULL, MaxPrice = NULL, TimeToLive = NULL, Context = NULL, DestinationCountryParameters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "SendTextMessage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$send_text_message_input(DestinationPhoneNumber = DestinationPhoneNumber, OriginationIdentity = OriginationIdentity, MessageBody = MessageBody, MessageType = MessageType, Keyword = Keyword, ConfigurationSetName = ConfigurationSetName, MaxPrice = MaxPrice, TimeToLive = TimeToLive, Context = Context, DestinationCountryParameters = DestinationCountryParameters, DryRun = DryRun)
  output <- .pinpointsmsvoicev2$send_text_message_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$send_text_message <- pinpointsmsvoicev2_send_text_message

#' Allows you to send a request that sends a text message through Amazon
#' Pinpoint
#'
#' @description
#' Allows you to send a request that sends a text message through Amazon Pinpoint. This operation uses [Amazon Polly](https://aws.amazon.com/polly/) to convert a text script into a voice message.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/send_voice_message.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/send_voice_message.html) for full documentation.
#'
#' @param DestinationPhoneNumber &#91;required&#93; The destination phone number in E.164 format.
#' @param OriginationIdentity &#91;required&#93; The origination identity to use for the voice call. This can be the
#' PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.
#' @param MessageBody The text to convert to a voice message.
#' @param MessageBodyTextType Specifies if the MessageBody field contains text or [speech synthesis
#' markup language
#' (SSML)](https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
#' 
#' -   TEXT: This is the default value. When used the maximum character
#'     limit is 3000.
#' 
#' -   SSML: When used the maximum character limit is 6000 including SSML
#'     tagging.
#' @param VoiceId The voice for the [Amazon
#' Polly](https://docs.aws.amazon.com/polly/latest/dg/what-is.html) service
#' to use. By default this is set to "MATTHEW".
#' @param ConfigurationSetName The name of the configuration set to use. This can be either the
#' ConfigurationSetName or ConfigurationSetArn.
#' @param MaxPricePerMinute The maximum amount to spend per voice message, in US dollars.
#' @param TimeToLive How long the voice message is valid for. By default this is 72 hours.
#' @param Context You can specify custom data in this field. If you do, that data is
#' logged to the event destination.
#' @param DryRun When set to true, the message is checked and validated, but isn't sent
#' to the end recipient.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_send_voice_message
pinpointsmsvoicev2_send_voice_message <- function(DestinationPhoneNumber, OriginationIdentity, MessageBody = NULL, MessageBodyTextType = NULL, VoiceId = NULL, ConfigurationSetName = NULL, MaxPricePerMinute = NULL, TimeToLive = NULL, Context = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "SendVoiceMessage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$send_voice_message_input(DestinationPhoneNumber = DestinationPhoneNumber, OriginationIdentity = OriginationIdentity, MessageBody = MessageBody, MessageBodyTextType = MessageBodyTextType, VoiceId = VoiceId, ConfigurationSetName = ConfigurationSetName, MaxPricePerMinute = MaxPricePerMinute, TimeToLive = TimeToLive, Context = Context, DryRun = DryRun)
  output <- .pinpointsmsvoicev2$send_voice_message_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$send_voice_message <- pinpointsmsvoicev2_send_voice_message

#' Sets the default message type on a configuration set
#'
#' @description
#' Sets the default message type on a configuration set.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/set_default_message_type.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/set_default_message_type.html) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The configuration set to update with a new default message type. This
#' field can be the ConsigurationSetName or ConfigurationSetArn.
#' @param MessageType &#91;required&#93; The type of message. Valid values are TRANSACTIONAL for messages that
#' are critical or time-sensitive and PROMOTIONAL for messages that aren't
#' critical or time-sensitive.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_default_message_type
pinpointsmsvoicev2_set_default_message_type <- function(ConfigurationSetName, MessageType) {
  op <- new_operation(
    name = "SetDefaultMessageType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_default_message_type_input(ConfigurationSetName = ConfigurationSetName, MessageType = MessageType)
  output <- .pinpointsmsvoicev2$set_default_message_type_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_default_message_type <- pinpointsmsvoicev2_set_default_message_type

#' Sets default sender ID on a configuration set
#'
#' @description
#' Sets default sender ID on a configuration set.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/set_default_sender_id.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/set_default_sender_id.html) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The configuration set to updated with a new default SenderId. This field
#' can be the ConsigurationSetName or ConfigurationSetArn.
#' @param SenderId &#91;required&#93; The current sender ID for the configuration set. When sending a text
#' message to a destination country which supports SenderIds, the default
#' sender ID on the configuration set specified on
#' [`send_text_message`][pinpointsmsvoicev2_send_text_message] will be used
#' if no dedicated origination phone numbers or registered SenderIds are
#' available in your account, instead of a generic sender ID, such as
#' 'NOTICE'.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_default_sender_id
pinpointsmsvoicev2_set_default_sender_id <- function(ConfigurationSetName, SenderId) {
  op <- new_operation(
    name = "SetDefaultSenderId",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_default_sender_id_input(ConfigurationSetName = ConfigurationSetName, SenderId = SenderId)
  output <- .pinpointsmsvoicev2$set_default_sender_id_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_default_sender_id <- pinpointsmsvoicev2_set_default_sender_id

#' Sets an account level monthly spend limit override for sending text
#' messages
#'
#' @description
#' Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/set_text_message_spend_limit_override.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/set_text_message_spend_limit_override.html) for full documentation.
#'
#' @param MonthlyLimit &#91;required&#93; The new monthly limit to enforce on text messages.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_text_message_spend_limit_override
pinpointsmsvoicev2_set_text_message_spend_limit_override <- function(MonthlyLimit) {
  op <- new_operation(
    name = "SetTextMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_text_message_spend_limit_override_input(MonthlyLimit = MonthlyLimit)
  output <- .pinpointsmsvoicev2$set_text_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_text_message_spend_limit_override <- pinpointsmsvoicev2_set_text_message_spend_limit_override

#' Sets an account level monthly spend limit override for sending voice
#' messages
#'
#' @description
#' Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/set_voice_message_spend_limit_override.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/set_voice_message_spend_limit_override.html) for full documentation.
#'
#' @param MonthlyLimit &#91;required&#93; The new monthly limit to enforce on voice messages.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_set_voice_message_spend_limit_override
pinpointsmsvoicev2_set_voice_message_spend_limit_override <- function(MonthlyLimit) {
  op <- new_operation(
    name = "SetVoiceMessageSpendLimitOverride",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$set_voice_message_spend_limit_override_input(MonthlyLimit = MonthlyLimit)
  output <- .pinpointsmsvoicev2$set_voice_message_spend_limit_override_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$set_voice_message_spend_limit_override <- pinpointsmsvoicev2_set_voice_message_spend_limit_override

#' Adds or overwrites only the specified tags for the specified Amazon
#' Pinpoint SMS Voice, version 2 resource
#'
#' @description
#' Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see [Tagging Amazon Pinpoint resources](https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html) in the *Amazon Pinpoint Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/tag_resource.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param Tags &#91;required&#93; An array of key and value pair tags that are associated with the
#' resource.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_tag_resource
pinpointsmsvoicev2_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .pinpointsmsvoicev2$tag_resource_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$tag_resource <- pinpointsmsvoicev2_tag_resource

#' Removes the association of the specified tags from an Amazon Pinpoint
#' SMS Voice V2 resource
#'
#' @description
#' Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information on tags see [Tagging Amazon Pinpoint resources](https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html) in the *Amazon Pinpoint Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/untag_resource.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; An array of tag key values to unassociate with the resource.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_untag_resource
pinpointsmsvoicev2_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .pinpointsmsvoicev2$untag_resource_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$untag_resource <- pinpointsmsvoicev2_untag_resource

#' Updates an existing event destination in a configuration set
#'
#' @description
#' Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs and Kinesis Data Firehose. You can also enable or disable the event destination.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/update_event_destination.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/update_event_destination.html) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The configuration set to update with the new event destination. Valid
#' values for this can be the ConfigurationSetName or ConfigurationSetArn.
#' @param EventDestinationName &#91;required&#93; The name to use for the event destination.
#' @param Enabled When set to true logging is enabled.
#' @param MatchingEventTypes An array of event types that determine which events to log.
#' @param CloudWatchLogsDestination An object that contains information about an event destination that
#' sends data to CloudWatch Logs.
#' @param KinesisFirehoseDestination An object that contains information about an event destination for
#' logging to Kinesis Data Firehose.
#' @param SnsDestination An object that contains information about an event destination that
#' sends data to Amazon SNS.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_update_event_destination
pinpointsmsvoicev2_update_event_destination <- function(ConfigurationSetName, EventDestinationName, Enabled = NULL, MatchingEventTypes = NULL, CloudWatchLogsDestination = NULL, KinesisFirehoseDestination = NULL, SnsDestination = NULL) {
  op <- new_operation(
    name = "UpdateEventDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$update_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, Enabled = Enabled, MatchingEventTypes = MatchingEventTypes, CloudWatchLogsDestination = CloudWatchLogsDestination, KinesisFirehoseDestination = KinesisFirehoseDestination, SnsDestination = SnsDestination)
  output <- .pinpointsmsvoicev2$update_event_destination_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$update_event_destination <- pinpointsmsvoicev2_update_event_destination

#' Updates the configuration of an existing origination phone number
#'
#' @description
#' Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or disable deletion protection.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/update_phone_number.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/update_phone_number.html) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; The unique identifier of the phone number. Valid values for this field
#' can be either the PhoneNumberId or PhoneNumberArn.
#' @param TwoWayEnabled By default this is set to false. When set to true you can receive
#' incoming text messages from your end recipients.
#' @param TwoWayChannelArn The Amazon Resource Name (ARN) of the two way channel.
#' @param SelfManagedOptOutsEnabled By default this is set to false. When an end recipient sends a message
#' that begins with HELP or STOP to one of your dedicated numbers, Amazon
#' Pinpoint automatically replies with a customizable message and adds the
#' end recipient to the OptOutList. When set to true you're responsible for
#' responding to HELP and STOP requests. You're also responsible for
#' tracking and honoring opt-out requests.
#' @param OptOutListName The OptOutList to add the phone number to. Valid values for this field
#' can be either the OutOutListName or OutOutListArn.
#' @param DeletionProtectionEnabled By default this is set to false. When set to true the phone number can't
#' be deleted.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_update_phone_number
pinpointsmsvoicev2_update_phone_number <- function(PhoneNumberId, TwoWayEnabled = NULL, TwoWayChannelArn = NULL, SelfManagedOptOutsEnabled = NULL, OptOutListName = NULL, DeletionProtectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdatePhoneNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$update_phone_number_input(PhoneNumberId = PhoneNumberId, TwoWayEnabled = TwoWayEnabled, TwoWayChannelArn = TwoWayChannelArn, SelfManagedOptOutsEnabled = SelfManagedOptOutsEnabled, OptOutListName = OptOutListName, DeletionProtectionEnabled = DeletionProtectionEnabled)
  output <- .pinpointsmsvoicev2$update_phone_number_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$update_phone_number <- pinpointsmsvoicev2_update_phone_number

#' Updates the configuration of an existing pool
#'
#' @description
#' Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way messaging, change the `TwoWayChannelArn`, enable or disable self-managed opt-outs, enable or disable deletion protection, and enable or disable shared routes.
#'
#' See [https://paws-r.github.io/docs/pinpointsmsvoicev2/update_pool.html](https://paws-r.github.io/docs/pinpointsmsvoicev2/update_pool.html) for full documentation.
#'
#' @param PoolId &#91;required&#93; The unique identifier of the pool to update. Valid values are either the
#' PoolId or PoolArn.
#' @param TwoWayEnabled By default this is set to false. When set to true you can receive
#' incoming text messages from your end recipients.
#' @param TwoWayChannelArn The Amazon Resource Name (ARN) of the two way channel.
#' @param SelfManagedOptOutsEnabled By default this is set to false. When an end recipient sends a message
#' that begins with HELP or STOP to one of your dedicated numbers, Amazon
#' Pinpoint automatically replies with a customizable message and adds the
#' end recipient to the OptOutList. When set to true you're responsible for
#' responding to HELP and STOP requests. You're also responsible for
#' tracking and honoring opt-out requests.
#' @param OptOutListName The OptOutList to associate with the pool. Valid values are either
#' OptOutListName or OptOutListArn.
#' @param SharedRoutesEnabled Indicates whether shared routes are enabled for the pool.
#' @param DeletionProtectionEnabled When set to true the pool can't be deleted.
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoicev2_update_pool
pinpointsmsvoicev2_update_pool <- function(PoolId, TwoWayEnabled = NULL, TwoWayChannelArn = NULL, SelfManagedOptOutsEnabled = NULL, OptOutListName = NULL, SharedRoutesEnabled = NULL, DeletionProtectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdatePool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pinpointsmsvoicev2$update_pool_input(PoolId = PoolId, TwoWayEnabled = TwoWayEnabled, TwoWayChannelArn = TwoWayChannelArn, SelfManagedOptOutsEnabled = SelfManagedOptOutsEnabled, OptOutListName = OptOutListName, SharedRoutesEnabled = SharedRoutesEnabled, DeletionProtectionEnabled = DeletionProtectionEnabled)
  output <- .pinpointsmsvoicev2$update_pool_output()
  config <- get_config()
  svc <- .pinpointsmsvoicev2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoicev2$operations$update_pool <- pinpointsmsvoicev2_update_pool
