% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoicev2_operations.R
\name{pinpointsmsvoicev2_associate_origination_identity}
\alias{pinpointsmsvoicev2_associate_origination_identity}
\title{Associates the specified origination identity with a pool}
\usage{
pinpointsmsvoicev2_associate_origination_identity(
  PoolId,
  OriginationIdentity,
  IsoCountryCode,
  ClientToken = NULL
)
}
\arguments{
\item{PoolId}{[required] The pool to update with the new Identity. This value can be either the
PoolId or PoolArn, and you can find these values using
\code{\link[=pinpointsmsvoicev2_describe_pools]{describe_pools}}.}

\item{OriginationIdentity}{[required] The origination identity to use, such as PhoneNumberId, PhoneNumberArn,
SenderId, or SenderIdArn. You can use
\code{\link[=pinpointsmsvoicev2_describe_phone_numbers]{describe_phone_numbers}} to
find the values for PhoneNumberId and PhoneNumberArn, while
\code{\link[=pinpointsmsvoicev2_describe_sender_ids]{describe_sender_ids}} can be
used to get the values for SenderId and SenderIdArn.}

\item{IsoCountryCode}{[required] The new two-character code, in ISO 3166-1 alpha-2 format, for the
country or region of the origination identity.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you don't specify a client token, a
randomly generated token is used for the request to ensure idempotency.}
}
\description{
Associates the specified origination identity with a pool.

See \url{https://paws-r.github.io/docs/pinpointsmsvoicev2/associate_origination_identity.html} for full documentation.
}
\keyword{internal}
