# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ses_service.R
NULL

#' Creates a receipt rule set by cloning an existing one
#'
#' @description
#' Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new receipt rule set and are completely independent of the source rule set.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_clone_receipt_rule_set/](https://www.paws-r-sdk.com/docs/ses_clone_receipt_rule_set/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the rule set to create. The name must:
#' 
#' -   This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
#'     underscores (_), or dashes (-).
#' 
#' -   Start and end with a letter or number.
#' 
#' -   Contain less than 64 characters.
#' @param OriginalRuleSetName &#91;required&#93; The name of the rule set to clone.
#'
#' @keywords internal
#'
#' @rdname ses_clone_receipt_rule_set
ses_clone_receipt_rule_set <- function(RuleSetName, OriginalRuleSetName) {
  op <- new_operation(
    name = "CloneReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$clone_receipt_rule_set_input(RuleSetName = RuleSetName, OriginalRuleSetName = OriginalRuleSetName)
  output <- .ses$clone_receipt_rule_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$clone_receipt_rule_set <- ses_clone_receipt_rule_set

#' Creates a configuration set
#'
#' @description
#' Creates a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_create_configuration_set/](https://www.paws-r-sdk.com/docs/ses_create_configuration_set/) for full documentation.
#'
#' @param ConfigurationSet &#91;required&#93; A data structure that contains the name of the configuration set.
#'
#' @keywords internal
#'
#' @rdname ses_create_configuration_set
ses_create_configuration_set <- function(ConfigurationSet) {
  op <- new_operation(
    name = "CreateConfigurationSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_configuration_set_input(ConfigurationSet = ConfigurationSet)
  output <- .ses$create_configuration_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_configuration_set <- ses_create_configuration_set

#' Creates a configuration set event destination
#'
#' @description
#' Creates a configuration set event destination.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_create_configuration_set_event_destination/](https://www.paws-r-sdk.com/docs/ses_create_configuration_set_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that the event destination should be
#' associated with.
#' @param EventDestination &#91;required&#93; An object that describes the AWS service that email sending event
#' information will be published to.
#'
#' @keywords internal
#'
#' @rdname ses_create_configuration_set_event_destination
ses_create_configuration_set_event_destination <- function(ConfigurationSetName, EventDestination) {
  op <- new_operation(
    name = "CreateConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestination = EventDestination)
  output <- .ses$create_configuration_set_event_destination_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_configuration_set_event_destination <- ses_create_configuration_set_event_destination

#' Creates an association between a configuration set and a custom domain
#' for open and click event tracking
#'
#' @description
#' Creates an association between a configuration set and a custom domain for open and click event tracking.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_create_configuration_set_tracking_options/](https://www.paws-r-sdk.com/docs/ses_create_configuration_set_tracking_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that the tracking options should be
#' associated with.
#' @param TrackingOptions &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname ses_create_configuration_set_tracking_options
ses_create_configuration_set_tracking_options <- function(ConfigurationSetName, TrackingOptions) {
  op <- new_operation(
    name = "CreateConfigurationSetTrackingOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_configuration_set_tracking_options_input(ConfigurationSetName = ConfigurationSetName, TrackingOptions = TrackingOptions)
  output <- .ses$create_configuration_set_tracking_options_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_configuration_set_tracking_options <- ses_create_configuration_set_tracking_options

#' Creates a new custom verification email template
#'
#' @description
#' Creates a new custom verification email template.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_create_custom_verification_email_template/](https://www.paws-r-sdk.com/docs/ses_create_custom_verification_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template.
#' @param FromEmailAddress &#91;required&#93; The email address that the custom verification email is sent from.
#' @param TemplateSubject &#91;required&#93; The subject line of the custom verification email.
#' @param TemplateContent &#91;required&#93; The content of the custom verification email. The total size of the
#' email must be less than 10 MB. The message body may contain HTML, with
#' some limitations. For more information, see [Custom Verification Email
#' Frequently Asked
#' Questions](https://docs.aws.amazon.com/ses/latest/dg/Welcome.html#custom-verification-emails-faq)
#' in the *Amazon SES Developer Guide*.
#' @param SuccessRedirectionURL &#91;required&#93; The URL that the recipient of the verification email is sent to if his
#' or her address is successfully verified.
#' @param FailureRedirectionURL &#91;required&#93; The URL that the recipient of the verification email is sent to if his
#' or her address is not successfully verified.
#'
#' @keywords internal
#'
#' @rdname ses_create_custom_verification_email_template
ses_create_custom_verification_email_template <- function(TemplateName, FromEmailAddress, TemplateSubject, TemplateContent, SuccessRedirectionURL, FailureRedirectionURL) {
  op <- new_operation(
    name = "CreateCustomVerificationEmailTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_custom_verification_email_template_input(TemplateName = TemplateName, FromEmailAddress = FromEmailAddress, TemplateSubject = TemplateSubject, TemplateContent = TemplateContent, SuccessRedirectionURL = SuccessRedirectionURL, FailureRedirectionURL = FailureRedirectionURL)
  output <- .ses$create_custom_verification_email_template_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_custom_verification_email_template <- ses_create_custom_verification_email_template

#' Creates a new IP address filter
#'
#' @description
#' Creates a new IP address filter.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_create_receipt_filter/](https://www.paws-r-sdk.com/docs/ses_create_receipt_filter/) for full documentation.
#'
#' @param Filter &#91;required&#93; A data structure that describes the IP address filter to create, which
#' consists of a name, an IP address range, and whether to allow or block
#' mail from it.
#'
#' @keywords internal
#'
#' @rdname ses_create_receipt_filter
ses_create_receipt_filter <- function(Filter) {
  op <- new_operation(
    name = "CreateReceiptFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_receipt_filter_input(Filter = Filter)
  output <- .ses$create_receipt_filter_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_receipt_filter <- ses_create_receipt_filter

#' Creates a receipt rule
#'
#' @description
#' Creates a receipt rule.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_create_receipt_rule/](https://www.paws-r-sdk.com/docs/ses_create_receipt_rule/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the rule set that the receipt rule will be added to.
#' @param After The name of an existing rule after which the new rule will be placed. If
#' this parameter is null, the new rule will be inserted at the beginning
#' of the rule list.
#' @param Rule &#91;required&#93; A data structure that contains the specified rule's name, actions,
#' recipients, domains, enabled status, scan status, and TLS policy.
#'
#' @keywords internal
#'
#' @rdname ses_create_receipt_rule
ses_create_receipt_rule <- function(RuleSetName, After = NULL, Rule) {
  op <- new_operation(
    name = "CreateReceiptRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_receipt_rule_input(RuleSetName = RuleSetName, After = After, Rule = Rule)
  output <- .ses$create_receipt_rule_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_receipt_rule <- ses_create_receipt_rule

#' Creates an empty receipt rule set
#'
#' @description
#' Creates an empty receipt rule set.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_create_receipt_rule_set/](https://www.paws-r-sdk.com/docs/ses_create_receipt_rule_set/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the rule set to create. The name must:
#' 
#' -   This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
#'     underscores (_), or dashes (-).
#' 
#' -   Start and end with a letter or number.
#' 
#' -   Contain less than 64 characters.
#'
#' @keywords internal
#'
#' @rdname ses_create_receipt_rule_set
ses_create_receipt_rule_set <- function(RuleSetName) {
  op <- new_operation(
    name = "CreateReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_receipt_rule_set_input(RuleSetName = RuleSetName)
  output <- .ses$create_receipt_rule_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_receipt_rule_set <- ses_create_receipt_rule_set

#' Creates an email template
#'
#' @description
#' Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ses_create_template/](https://www.paws-r-sdk.com/docs/ses_create_template/) for full documentation.
#'
#' @param Template &#91;required&#93; The content of the email, composed of a subject line, an HTML part, and
#' a text-only part.
#'
#' @keywords internal
#'
#' @rdname ses_create_template
ses_create_template <- function(Template) {
  op <- new_operation(
    name = "CreateTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_template_input(Template = Template)
  output <- .ses$create_template_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_template <- ses_create_template

#' Deletes a configuration set
#'
#' @description
#' Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_configuration_set/](https://www.paws-r-sdk.com/docs/ses_delete_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set to delete.
#'
#' @keywords internal
#'
#' @rdname ses_delete_configuration_set
ses_delete_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .ses$delete_configuration_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_configuration_set <- ses_delete_configuration_set

#' Deletes a configuration set event destination
#'
#' @description
#' Deletes a configuration set event destination. Configuration set event destinations are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_configuration_set_event_destination/](https://www.paws-r-sdk.com/docs/ses_delete_configuration_set_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set from which to delete the event
#' destination.
#' @param EventDestinationName &#91;required&#93; The name of the event destination to delete.
#'
#' @keywords internal
#'
#' @rdname ses_delete_configuration_set_event_destination
ses_delete_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName) {
  op <- new_operation(
    name = "DeleteConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName)
  output <- .ses$delete_configuration_set_event_destination_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_configuration_set_event_destination <- ses_delete_configuration_set_event_destination

#' Deletes an association between a configuration set and a custom domain
#' for open and click event tracking
#'
#' @description
#' Deletes an association between a configuration set and a custom domain for open and click event tracking.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_configuration_set_tracking_options/](https://www.paws-r-sdk.com/docs/ses_delete_configuration_set_tracking_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set from which you want to delete the
#' tracking options.
#'
#' @keywords internal
#'
#' @rdname ses_delete_configuration_set_tracking_options
ses_delete_configuration_set_tracking_options <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSetTrackingOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_configuration_set_tracking_options_input(ConfigurationSetName = ConfigurationSetName)
  output <- .ses$delete_configuration_set_tracking_options_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_configuration_set_tracking_options <- ses_delete_configuration_set_tracking_options

#' Deletes an existing custom verification email template
#'
#' @description
#' Deletes an existing custom verification email template.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_custom_verification_email_template/](https://www.paws-r-sdk.com/docs/ses_delete_custom_verification_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname ses_delete_custom_verification_email_template
ses_delete_custom_verification_email_template <- function(TemplateName) {
  op <- new_operation(
    name = "DeleteCustomVerificationEmailTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_custom_verification_email_template_input(TemplateName = TemplateName)
  output <- .ses$delete_custom_verification_email_template_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_custom_verification_email_template <- ses_delete_custom_verification_email_template

#' Deletes the specified identity (an email address or a domain) from the
#' list of verified identities
#'
#' @description
#' Deletes the specified identity (an email address or a domain) from the list of verified identities.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_identity/](https://www.paws-r-sdk.com/docs/ses_delete_identity/) for full documentation.
#'
#' @param Identity &#91;required&#93; The identity to be removed from the list of identities for the AWS
#' Account.
#'
#' @keywords internal
#'
#' @rdname ses_delete_identity
ses_delete_identity <- function(Identity) {
  op <- new_operation(
    name = "DeleteIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_identity_input(Identity = Identity)
  output <- .ses$delete_identity_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_identity <- ses_delete_identity

#' Deletes the specified sending authorization policy for the given
#' identity (an email address or a domain)
#'
#' @description
#' Deletes the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_identity_policy/](https://www.paws-r-sdk.com/docs/ses_delete_identity_policy/) for full documentation.
#'
#' @param Identity &#91;required&#93; The identity that is associated with the policy that you want to delete.
#' You can specify the identity by using its name or by using its Amazon
#' Resource Name (ARN). Examples: `user@@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' 
#' To successfully call this API, you must own the identity.
#' @param PolicyName &#91;required&#93; The name of the policy to be deleted.
#'
#' @keywords internal
#'
#' @rdname ses_delete_identity_policy
ses_delete_identity_policy <- function(Identity, PolicyName) {
  op <- new_operation(
    name = "DeleteIdentityPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_identity_policy_input(Identity = Identity, PolicyName = PolicyName)
  output <- .ses$delete_identity_policy_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_identity_policy <- ses_delete_identity_policy

#' Deletes the specified IP address filter
#'
#' @description
#' Deletes the specified IP address filter.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_receipt_filter/](https://www.paws-r-sdk.com/docs/ses_delete_receipt_filter/) for full documentation.
#'
#' @param FilterName &#91;required&#93; The name of the IP address filter to delete.
#'
#' @keywords internal
#'
#' @rdname ses_delete_receipt_filter
ses_delete_receipt_filter <- function(FilterName) {
  op <- new_operation(
    name = "DeleteReceiptFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_receipt_filter_input(FilterName = FilterName)
  output <- .ses$delete_receipt_filter_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_receipt_filter <- ses_delete_receipt_filter

#' Deletes the specified receipt rule
#'
#' @description
#' Deletes the specified receipt rule.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_receipt_rule/](https://www.paws-r-sdk.com/docs/ses_delete_receipt_rule/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set that contains the receipt rule to
#' delete.
#' @param RuleName &#91;required&#93; The name of the receipt rule to delete.
#'
#' @keywords internal
#'
#' @rdname ses_delete_receipt_rule
ses_delete_receipt_rule <- function(RuleSetName, RuleName) {
  op <- new_operation(
    name = "DeleteReceiptRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_receipt_rule_input(RuleSetName = RuleSetName, RuleName = RuleName)
  output <- .ses$delete_receipt_rule_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_receipt_rule <- ses_delete_receipt_rule

#' Deletes the specified receipt rule set and all of the receipt rules it
#' contains
#'
#' @description
#' Deletes the specified receipt rule set and all of the receipt rules it contains.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_receipt_rule_set/](https://www.paws-r-sdk.com/docs/ses_delete_receipt_rule_set/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set to delete.
#'
#' @keywords internal
#'
#' @rdname ses_delete_receipt_rule_set
ses_delete_receipt_rule_set <- function(RuleSetName) {
  op <- new_operation(
    name = "DeleteReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_receipt_rule_set_input(RuleSetName = RuleSetName)
  output <- .ses$delete_receipt_rule_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_receipt_rule_set <- ses_delete_receipt_rule_set

#' Deletes an email template
#'
#' @description
#' Deletes an email template.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_template/](https://www.paws-r-sdk.com/docs/ses_delete_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the template to be deleted.
#'
#' @keywords internal
#'
#' @rdname ses_delete_template
ses_delete_template <- function(TemplateName) {
  op <- new_operation(
    name = "DeleteTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_template_input(TemplateName = TemplateName)
  output <- .ses$delete_template_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_template <- ses_delete_template

#' Deprecated
#'
#' @description
#' Deprecated. Use the [`delete_identity`][ses_delete_identity] operation to delete email addresses and domains.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_delete_verified_email_address/](https://www.paws-r-sdk.com/docs/ses_delete_verified_email_address/) for full documentation.
#'
#' @param EmailAddress &#91;required&#93; An email address to be removed from the list of verified addresses.
#'
#' @keywords internal
#'
#' @rdname ses_delete_verified_email_address
ses_delete_verified_email_address <- function(EmailAddress) {
  op <- new_operation(
    name = "DeleteVerifiedEmailAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_verified_email_address_input(EmailAddress = EmailAddress)
  output <- .ses$delete_verified_email_address_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_verified_email_address <- ses_delete_verified_email_address

#' Returns the metadata and receipt rules for the receipt rule set that is
#' currently active
#'
#' @description
#' Returns the metadata and receipt rules for the receipt rule set that is currently active.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_describe_active_receipt_rule_set/](https://www.paws-r-sdk.com/docs/ses_describe_active_receipt_rule_set/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname ses_describe_active_receipt_rule_set
ses_describe_active_receipt_rule_set <- function() {
  op <- new_operation(
    name = "DescribeActiveReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$describe_active_receipt_rule_set_input()
  output <- .ses$describe_active_receipt_rule_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$describe_active_receipt_rule_set <- ses_describe_active_receipt_rule_set

#' Returns the details of the specified configuration set
#'
#' @description
#' Returns the details of the specified configuration set. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ses_describe_configuration_set/](https://www.paws-r-sdk.com/docs/ses_describe_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set to describe.
#' @param ConfigurationSetAttributeNames A list of configuration set attributes to return.
#'
#' @keywords internal
#'
#' @rdname ses_describe_configuration_set
ses_describe_configuration_set <- function(ConfigurationSetName, ConfigurationSetAttributeNames = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$describe_configuration_set_input(ConfigurationSetName = ConfigurationSetName, ConfigurationSetAttributeNames = ConfigurationSetAttributeNames)
  output <- .ses$describe_configuration_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$describe_configuration_set <- ses_describe_configuration_set

#' Returns the details of the specified receipt rule
#'
#' @description
#' Returns the details of the specified receipt rule.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_describe_receipt_rule/](https://www.paws-r-sdk.com/docs/ses_describe_receipt_rule/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set that the receipt rule belongs to.
#' @param RuleName &#91;required&#93; The name of the receipt rule.
#'
#' @keywords internal
#'
#' @rdname ses_describe_receipt_rule
ses_describe_receipt_rule <- function(RuleSetName, RuleName) {
  op <- new_operation(
    name = "DescribeReceiptRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$describe_receipt_rule_input(RuleSetName = RuleSetName, RuleName = RuleName)
  output <- .ses$describe_receipt_rule_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$describe_receipt_rule <- ses_describe_receipt_rule

#' Returns the details of the specified receipt rule set
#'
#' @description
#' Returns the details of the specified receipt rule set.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_describe_receipt_rule_set/](https://www.paws-r-sdk.com/docs/ses_describe_receipt_rule_set/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set to describe.
#'
#' @keywords internal
#'
#' @rdname ses_describe_receipt_rule_set
ses_describe_receipt_rule_set <- function(RuleSetName) {
  op <- new_operation(
    name = "DescribeReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$describe_receipt_rule_set_input(RuleSetName = RuleSetName)
  output <- .ses$describe_receipt_rule_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$describe_receipt_rule_set <- ses_describe_receipt_rule_set

#' Returns the email sending status of the Amazon SES account for the
#' current region
#'
#' @description
#' Returns the email sending status of the Amazon SES account for the current region.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_account_sending_enabled/](https://www.paws-r-sdk.com/docs/ses_get_account_sending_enabled/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname ses_get_account_sending_enabled
ses_get_account_sending_enabled <- function() {
  op <- new_operation(
    name = "GetAccountSendingEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_account_sending_enabled_input()
  output <- .ses$get_account_sending_enabled_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_account_sending_enabled <- ses_get_account_sending_enabled

#' Returns the custom email verification template for the template name you
#' specify
#'
#' @description
#' Returns the custom email verification template for the template name you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_custom_verification_email_template/](https://www.paws-r-sdk.com/docs/ses_get_custom_verification_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template that you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname ses_get_custom_verification_email_template
ses_get_custom_verification_email_template <- function(TemplateName) {
  op <- new_operation(
    name = "GetCustomVerificationEmailTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_custom_verification_email_template_input(TemplateName = TemplateName)
  output <- .ses$get_custom_verification_email_template_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_custom_verification_email_template <- ses_get_custom_verification_email_template

#' Returns the current status of Easy DKIM signing for an entity
#'
#' @description
#' Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified that these tokens have been published.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_identity_dkim_attributes/](https://www.paws-r-sdk.com/docs/ses_get_identity_dkim_attributes/) for full documentation.
#'
#' @param Identities &#91;required&#93; A list of one or more verified identities - email addresses, domains, or
#' both.
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_dkim_attributes
ses_get_identity_dkim_attributes <- function(Identities) {
  op <- new_operation(
    name = "GetIdentityDkimAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_dkim_attributes_input(Identities = Identities)
  output <- .ses$get_identity_dkim_attributes_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_dkim_attributes <- ses_get_identity_dkim_attributes

#' Returns the custom MAIL FROM attributes for a list of identities (email
#' addresses : domains)
#'
#' @description
#' Returns the custom MAIL FROM attributes for a list of identities (email addresses : domains).
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_identity_mail_from_domain_attributes/](https://www.paws-r-sdk.com/docs/ses_get_identity_mail_from_domain_attributes/) for full documentation.
#'
#' @param Identities &#91;required&#93; A list of one or more identities.
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_mail_from_domain_attributes
ses_get_identity_mail_from_domain_attributes <- function(Identities) {
  op <- new_operation(
    name = "GetIdentityMailFromDomainAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_mail_from_domain_attributes_input(Identities = Identities)
  output <- .ses$get_identity_mail_from_domain_attributes_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_mail_from_domain_attributes <- ses_get_identity_mail_from_domain_attributes

#' Given a list of verified identities (email addresses and/or domains),
#' returns a structure describing identity notification attributes
#'
#' @description
#' Given a list of verified identities (email addresses and/or domains), returns a structure describing identity notification attributes.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_identity_notification_attributes/](https://www.paws-r-sdk.com/docs/ses_get_identity_notification_attributes/) for full documentation.
#'
#' @param Identities &#91;required&#93; A list of one or more identities. You can specify an identity by using
#' its name or by using its Amazon Resource Name (ARN). Examples:
#' `user@@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_notification_attributes
ses_get_identity_notification_attributes <- function(Identities) {
  op <- new_operation(
    name = "GetIdentityNotificationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_notification_attributes_input(Identities = Identities)
  output <- .ses$get_identity_notification_attributes_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_notification_attributes <- ses_get_identity_notification_attributes

#' Returns the requested sending authorization policies for the given
#' identity (an email address or a domain)
#'
#' @description
#' Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_identity_policies/](https://www.paws-r-sdk.com/docs/ses_get_identity_policies/) for full documentation.
#'
#' @param Identity &#91;required&#93; The identity for which the policies will be retrieved. You can specify
#' an identity by using its name or by using its Amazon Resource Name
#' (ARN). Examples: `user@@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' 
#' To successfully call this API, you must own the identity.
#' @param PolicyNames &#91;required&#93; A list of the names of policies to be retrieved. You can retrieve a
#' maximum of 20 policies at a time. If you do not know the names of the
#' policies that are attached to the identity, you can use
#' [`list_identity_policies`][ses_list_identity_policies].
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_policies
ses_get_identity_policies <- function(Identity, PolicyNames) {
  op <- new_operation(
    name = "GetIdentityPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_policies_input(Identity = Identity, PolicyNames = PolicyNames)
  output <- .ses$get_identity_policies_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_policies <- ses_get_identity_policies

#' Given a list of identities (email addresses and/or domains), returns the
#' verification status and (for domain identities) the verification token
#' for each identity
#'
#' @description
#' Given a list of identities (email addresses and/or domains), returns the verification status and (for domain identities) the verification token for each identity.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_identity_verification_attributes/](https://www.paws-r-sdk.com/docs/ses_get_identity_verification_attributes/) for full documentation.
#'
#' @param Identities &#91;required&#93; A list of identities.
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_verification_attributes
ses_get_identity_verification_attributes <- function(Identities) {
  op <- new_operation(
    name = "GetIdentityVerificationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_verification_attributes_input(Identities = Identities)
  output <- .ses$get_identity_verification_attributes_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_verification_attributes <- ses_get_identity_verification_attributes

#' Provides the sending limits for the Amazon SES account
#'
#' @description
#' Provides the sending limits for the Amazon SES account.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_send_quota/](https://www.paws-r-sdk.com/docs/ses_get_send_quota/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname ses_get_send_quota
ses_get_send_quota <- function() {
  op <- new_operation(
    name = "GetSendQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_send_quota_input()
  output <- .ses$get_send_quota_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_send_quota <- ses_get_send_quota

#' Provides sending statistics for the current AWS Region
#'
#' @description
#' Provides sending statistics for the current AWS Region. The result is a list of data points, representing the last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of time.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_send_statistics/](https://www.paws-r-sdk.com/docs/ses_get_send_statistics/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname ses_get_send_statistics
ses_get_send_statistics <- function() {
  op <- new_operation(
    name = "GetSendStatistics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_send_statistics_input()
  output <- .ses$get_send_statistics_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_send_statistics <- ses_get_send_statistics

#' Displays the template object (which includes the Subject line, HTML part
#' and text part) for the template you specify
#'
#' @description
#' Displays the template object (which includes the Subject line, HTML part and text part) for the template you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_get_template/](https://www.paws-r-sdk.com/docs/ses_get_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the template you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname ses_get_template
ses_get_template <- function(TemplateName) {
  op <- new_operation(
    name = "GetTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_template_input(TemplateName = TemplateName)
  output <- .ses$get_template_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_template <- ses_get_template

#' Provides a list of the configuration sets associated with your Amazon
#' SES account in the current AWS Region
#'
#' @description
#' Provides a list of the configuration sets associated with your Amazon SES account in the current AWS Region. For information about using configuration sets, see [Monitoring Your Amazon SES Sending Activity](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html) in the *Amazon SES Developer Guide.*
#'
#' See [https://www.paws-r-sdk.com/docs/ses_list_configuration_sets/](https://www.paws-r-sdk.com/docs/ses_list_configuration_sets/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_configuration_sets`][ses_list_configuration_sets] to indicate the
#' position of the configuration set in the configuration set list.
#' @param MaxItems The number of configuration sets to return.
#'
#' @keywords internal
#'
#' @rdname ses_list_configuration_sets
ses_list_configuration_sets <- function(NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListConfigurationSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_configuration_sets_input(NextToken = NextToken, MaxItems = MaxItems)
  output <- .ses$list_configuration_sets_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_configuration_sets <- ses_list_configuration_sets

#' Lists the existing custom verification email templates for your account
#' in the current AWS Region
#'
#' @description
#' Lists the existing custom verification email templates for your account in the current AWS Region.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_list_custom_verification_email_templates/](https://www.paws-r-sdk.com/docs/ses_list_custom_verification_email_templates/) for full documentation.
#'
#' @param NextToken An array the contains the name and creation time stamp for each template
#' in your Amazon SES account.
#' @param MaxResults The maximum number of custom verification email templates to return.
#' This value must be at least 1 and less than or equal to 50. If you do
#' not specify a value, or if you specify a value less than 1 or greater
#' than 50, the operation will return up to 50 results.
#'
#' @keywords internal
#'
#' @rdname ses_list_custom_verification_email_templates
ses_list_custom_verification_email_templates <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCustomVerificationEmailTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_custom_verification_email_templates_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .ses$list_custom_verification_email_templates_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_custom_verification_email_templates <- ses_list_custom_verification_email_templates

#' Returns a list containing all of the identities (email addresses and
#' domains) for your AWS account in the current AWS Region, regardless of
#' verification status
#'
#' @description
#' Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current AWS Region, regardless of verification status.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_list_identities/](https://www.paws-r-sdk.com/docs/ses_list_identities/) for full documentation.
#'
#' @param IdentityType The type of the identities to list. Possible values are "EmailAddress"
#' and "Domain". If this parameter is omitted, then all identities will be
#' listed.
#' @param NextToken The token to use for pagination.
#' @param MaxItems The maximum number of identities per page. Possible values are 1-1000
#' inclusive.
#'
#' @keywords internal
#'
#' @rdname ses_list_identities
ses_list_identities <- function(IdentityType = NULL, NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListIdentities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_identities_input(IdentityType = IdentityType, NextToken = NextToken, MaxItems = MaxItems)
  output <- .ses$list_identities_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_identities <- ses_list_identities

#' Returns a list of sending authorization policies that are attached to
#' the given identity (an email address or a domain)
#'
#' @description
#' Returns a list of sending authorization policies that are attached to the given identity (an email address or a domain). This API returns only a list. If you want the actual policy content, you can use [`get_identity_policies`][ses_get_identity_policies].
#'
#' See [https://www.paws-r-sdk.com/docs/ses_list_identity_policies/](https://www.paws-r-sdk.com/docs/ses_list_identity_policies/) for full documentation.
#'
#' @param Identity &#91;required&#93; The identity that is associated with the policy for which the policies
#' will be listed. You can specify an identity by using its name or by
#' using its Amazon Resource Name (ARN). Examples: `user@@example.com`,
#' `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' 
#' To successfully call this API, you must own the identity.
#'
#' @keywords internal
#'
#' @rdname ses_list_identity_policies
ses_list_identity_policies <- function(Identity) {
  op <- new_operation(
    name = "ListIdentityPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_identity_policies_input(Identity = Identity)
  output <- .ses$list_identity_policies_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_identity_policies <- ses_list_identity_policies

#' Lists the IP address filters associated with your AWS account in the
#' current AWS Region
#'
#' @description
#' Lists the IP address filters associated with your AWS account in the current AWS Region.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_list_receipt_filters/](https://www.paws-r-sdk.com/docs/ses_list_receipt_filters/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname ses_list_receipt_filters
ses_list_receipt_filters <- function() {
  op <- new_operation(
    name = "ListReceiptFilters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_receipt_filters_input()
  output <- .ses$list_receipt_filters_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_receipt_filters <- ses_list_receipt_filters

#' Lists the receipt rule sets that exist under your AWS account in the
#' current AWS Region
#'
#' @description
#' Lists the receipt rule sets that exist under your AWS account in the current AWS Region. If there are additional receipt rule sets to be retrieved, you will receive a `NextToken` that you can provide to the next call to [`list_receipt_rule_sets`][ses_list_receipt_rule_sets] to retrieve the additional entries.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_list_receipt_rule_sets/](https://www.paws-r-sdk.com/docs/ses_list_receipt_rule_sets/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_receipt_rule_sets`][ses_list_receipt_rule_sets] to indicate the
#' position in the receipt rule set list.
#'
#' @keywords internal
#'
#' @rdname ses_list_receipt_rule_sets
ses_list_receipt_rule_sets <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListReceiptRuleSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_receipt_rule_sets_input(NextToken = NextToken)
  output <- .ses$list_receipt_rule_sets_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_receipt_rule_sets <- ses_list_receipt_rule_sets

#' Lists the email templates present in your Amazon SES account in the
#' current AWS Region
#'
#' @description
#' Lists the email templates present in your Amazon SES account in the current AWS Region.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_list_templates/](https://www.paws-r-sdk.com/docs/ses_list_templates/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_templates`][ses_list_templates] to indicate the position in the
#' list of email templates.
#' @param MaxItems The maximum number of templates to return. This value must be at least 1
#' and less than or equal to 10. If you do not specify a value, or if you
#' specify a value less than 1 or greater than 10, the operation will
#' return up to 10 results.
#'
#' @keywords internal
#'
#' @rdname ses_list_templates
ses_list_templates <- function(NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_templates_input(NextToken = NextToken, MaxItems = MaxItems)
  output <- .ses$list_templates_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_templates <- ses_list_templates

#' Deprecated
#'
#' @description
#' Deprecated. Use the [`list_identities`][ses_list_identities] operation to list the email addresses and domains associated with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_list_verified_email_addresses/](https://www.paws-r-sdk.com/docs/ses_list_verified_email_addresses/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname ses_list_verified_email_addresses
ses_list_verified_email_addresses <- function() {
  op <- new_operation(
    name = "ListVerifiedEmailAddresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_verified_email_addresses_input()
  output <- .ses$list_verified_email_addresses_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_verified_email_addresses <- ses_list_verified_email_addresses

#' Adds or updates the delivery options for a configuration set
#'
#' @description
#' Adds or updates the delivery options for a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_put_configuration_set_delivery_options/](https://www.paws-r-sdk.com/docs/ses_put_configuration_set_delivery_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to specify the delivery
#' options for.
#' @param DeliveryOptions Specifies whether messages that use the configuration set are required
#' to use Transport Layer Security (TLS).
#'
#' @keywords internal
#'
#' @rdname ses_put_configuration_set_delivery_options
ses_put_configuration_set_delivery_options <- function(ConfigurationSetName, DeliveryOptions = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetDeliveryOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$put_configuration_set_delivery_options_input(ConfigurationSetName = ConfigurationSetName, DeliveryOptions = DeliveryOptions)
  output <- .ses$put_configuration_set_delivery_options_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$put_configuration_set_delivery_options <- ses_put_configuration_set_delivery_options

#' Adds or updates a sending authorization policy for the specified
#' identity (an email address or a domain)
#'
#' @description
#' Adds or updates a sending authorization policy for the specified identity (an email address or a domain).
#'
#' See [https://www.paws-r-sdk.com/docs/ses_put_identity_policy/](https://www.paws-r-sdk.com/docs/ses_put_identity_policy/) for full documentation.
#'
#' @param Identity &#91;required&#93; The identity that the policy will apply to. You can specify an identity
#' by using its name or by using its Amazon Resource Name (ARN). Examples:
#' `user@@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' 
#' To successfully call this API, you must own the identity.
#' @param PolicyName &#91;required&#93; The name of the policy.
#' 
#' The policy name cannot exceed 64 characters and can only include
#' alphanumeric characters, dashes, and underscores.
#' @param Policy &#91;required&#93; The text of the policy in JSON format. The policy cannot exceed 4 KB.
#' 
#' For information about the syntax of sending authorization policies, see
#' the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/).
#'
#' @keywords internal
#'
#' @rdname ses_put_identity_policy
ses_put_identity_policy <- function(Identity, PolicyName, Policy) {
  op <- new_operation(
    name = "PutIdentityPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$put_identity_policy_input(Identity = Identity, PolicyName = PolicyName, Policy = Policy)
  output <- .ses$put_identity_policy_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$put_identity_policy <- ses_put_identity_policy

#' Reorders the receipt rules within a receipt rule set
#'
#' @description
#' Reorders the receipt rules within a receipt rule set.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_reorder_receipt_rule_set/](https://www.paws-r-sdk.com/docs/ses_reorder_receipt_rule_set/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set to reorder.
#' @param RuleNames &#91;required&#93; A list of the specified receipt rule set's receipt rules in the order
#' that you want to put them.
#'
#' @keywords internal
#'
#' @rdname ses_reorder_receipt_rule_set
ses_reorder_receipt_rule_set <- function(RuleSetName, RuleNames) {
  op <- new_operation(
    name = "ReorderReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$reorder_receipt_rule_set_input(RuleSetName = RuleSetName, RuleNames = RuleNames)
  output <- .ses$reorder_receipt_rule_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$reorder_receipt_rule_set <- ses_reorder_receipt_rule_set

#' Generates and sends a bounce message to the sender of an email you
#' received through Amazon SES
#'
#' @description
#' Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use this API on an email up to 24 hours after you receive it.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_send_bounce/](https://www.paws-r-sdk.com/docs/ses_send_bounce/) for full documentation.
#'
#' @param OriginalMessageId &#91;required&#93; The message ID of the message to be bounced.
#' @param BounceSender &#91;required&#93; The address to use in the "From" header of the bounce message. This must
#' be an identity that you have verified with Amazon SES.
#' @param Explanation Human-readable text for the bounce message to explain the failure. If
#' not specified, the text will be auto-generated based on the bounced
#' recipient information.
#' @param MessageDsn Message-related DSN fields. If not specified, Amazon SES will choose the
#' values.
#' @param BouncedRecipientInfoList &#91;required&#93; A list of recipients of the bounced message, including the information
#' required to create the Delivery Status Notifications (DSNs) for the
#' recipients. You must specify at least one `BouncedRecipientInfo` in the
#' list.
#' @param BounceSenderArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the address in the "From" header of the bounce.
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#'
#' @keywords internal
#'
#' @rdname ses_send_bounce
ses_send_bounce <- function(OriginalMessageId, BounceSender, Explanation = NULL, MessageDsn = NULL, BouncedRecipientInfoList, BounceSenderArn = NULL) {
  op <- new_operation(
    name = "SendBounce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_bounce_input(OriginalMessageId = OriginalMessageId, BounceSender = BounceSender, Explanation = Explanation, MessageDsn = MessageDsn, BouncedRecipientInfoList = BouncedRecipientInfoList, BounceSenderArn = BounceSenderArn)
  output <- .ses$send_bounce_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_bounce <- ses_send_bounce

#' Composes an email message to multiple destinations
#'
#' @description
#' Composes an email message to multiple destinations. The message body is created using an email template.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_send_bulk_templated_email/](https://www.paws-r-sdk.com/docs/ses_send_bulk_templated_email/) for full documentation.
#'
#' @param Source &#91;required&#93; The email address that is sending the email. This email address must be
#' either individually verified with Amazon SES, or from a domain that has
#' been verified with Amazon SES. For information about verifying
#' identities, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html).
#' 
#' If you are sending on behalf of another user and have been permitted to
#' do so by a sending authorization policy, then you must also specify the
#' `SourceArn` parameter. For more information about sending authorization,
#' see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' 
#' Amazon SES does not support the SMTPUTF8 extension, as described in
#' [RFC6531](https://datatracker.ietf.org/doc/html/rfc6531). For this
#' reason, the *local part* of a source email address (the part of the
#' email address that precedes the @@ sign) may only contain [7-bit ASCII
#' characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If
#' the *domain part* of an address (the part after the @@ sign) contains
#' non-ASCII characters, they must be encoded using Punycode, as described
#' in [RFC3492](https://datatracker.ietf.org/doc/html/rfc3492.html). The
#' sender name (also known as the *friendly name*) may contain non-ASCII
#' characters. These characters must be encoded using MIME encoded-word
#' syntax, as described in [RFC
#' 2047](https://datatracker.ietf.org/doc/html/rfc2047). MIME encoded-word
#' syntax uses the following form: `=?charset?encoding?encoded-text?=`.
#' @param SourceArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to send for the email address specified in the `Source`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to send from `user@@example.com`, then
#' you would specify the `SourceArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `Source` to be `user@@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' @param ReplyToAddresses The reply-to email address(es) for the message. If the recipient replies
#' to the message, each reply-to address will receive the reply.
#' @param ReturnPath The email address that bounces and complaints will be forwarded to when
#' feedback forwarding is enabled. If the message cannot be delivered to
#' the recipient, then an error message will be returned from the
#' recipient's ISP; this message will then be forwarded to the email
#' address specified by the `ReturnPath` parameter. The `ReturnPath`
#' parameter is never overwritten. This email address must be either
#' individually verified with Amazon SES, or from a domain that has been
#' verified with Amazon SES.
#' @param ReturnPathArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the `ReturnPath`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to use `feedback@@example.com`, then you
#' would specify the `ReturnPathArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `ReturnPath` to be `feedback@@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' @param ConfigurationSetName The name of the configuration set to use when you send an email using
#' [`send_bulk_templated_email`][ses_send_bulk_templated_email].
#' @param DefaultTags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send to a destination using
#' [`send_bulk_templated_email`][ses_send_bulk_templated_email].
#' @param Template &#91;required&#93; The template to use when sending this email.
#' @param TemplateArn The ARN of the template to use when sending this email.
#' @param DefaultTemplateData A list of replacement values to apply to the template when replacement
#' data is not specified in a Destination object. These values act as a
#' default or fallback option when no other data is available.
#' 
#' The template data is a JSON object, typically consisting of key-value
#' pairs in which the keys correspond to replacement tags in the email
#' template.
#' @param Destinations &#91;required&#93; One or more `Destination` objects. All of the recipients in a
#' `Destination` will receive the same version of the email. You can
#' specify up to 50 `Destination` objects within a `Destinations` array.
#'
#' @keywords internal
#'
#' @rdname ses_send_bulk_templated_email
ses_send_bulk_templated_email <- function(Source, SourceArn = NULL, ReplyToAddresses = NULL, ReturnPath = NULL, ReturnPathArn = NULL, ConfigurationSetName = NULL, DefaultTags = NULL, Template, TemplateArn = NULL, DefaultTemplateData = NULL, Destinations) {
  op <- new_operation(
    name = "SendBulkTemplatedEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_bulk_templated_email_input(Source = Source, SourceArn = SourceArn, ReplyToAddresses = ReplyToAddresses, ReturnPath = ReturnPath, ReturnPathArn = ReturnPathArn, ConfigurationSetName = ConfigurationSetName, DefaultTags = DefaultTags, Template = Template, TemplateArn = TemplateArn, DefaultTemplateData = DefaultTemplateData, Destinations = Destinations)
  output <- .ses$send_bulk_templated_email_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_bulk_templated_email <- ses_send_bulk_templated_email

#' Adds an email address to the list of identities for your Amazon SES
#' account in the current AWS Region and attempts to verify it
#'
#' @description
#' Adds an email address to the list of identities for your Amazon SES account in the current AWS Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_send_custom_verification_email/](https://www.paws-r-sdk.com/docs/ses_send_custom_verification_email/) for full documentation.
#'
#' @param EmailAddress &#91;required&#93; The email address to verify.
#' @param TemplateName &#91;required&#93; The name of the custom verification email template to use when sending
#' the verification email.
#' @param ConfigurationSetName Name of a configuration set to use when sending the verification email.
#'
#' @keywords internal
#'
#' @rdname ses_send_custom_verification_email
ses_send_custom_verification_email <- function(EmailAddress, TemplateName, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "SendCustomVerificationEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_custom_verification_email_input(EmailAddress = EmailAddress, TemplateName = TemplateName, ConfigurationSetName = ConfigurationSetName)
  output <- .ses$send_custom_verification_email_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_custom_verification_email <- ses_send_custom_verification_email

#' Composes an email message and immediately queues it for sending
#'
#' @description
#' Composes an email message and immediately queues it for sending. In order to send email using the [`send_email`][ses_send_email] operation, your message must meet the following requirements:
#'
#' See [https://www.paws-r-sdk.com/docs/ses_send_email/](https://www.paws-r-sdk.com/docs/ses_send_email/) for full documentation.
#'
#' @param Source &#91;required&#93; The email address that is sending the email. This email address must be
#' either individually verified with Amazon SES, or from a domain that has
#' been verified with Amazon SES. For information about verifying
#' identities, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html).
#' 
#' If you are sending on behalf of another user and have been permitted to
#' do so by a sending authorization policy, then you must also specify the
#' `SourceArn` parameter. For more information about sending authorization,
#' see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' 
#' Amazon SES does not support the SMTPUTF8 extension, as described in
#' [RFC6531](https://datatracker.ietf.org/doc/html/rfc6531). For this
#' reason, the *local part* of a source email address (the part of the
#' email address that precedes the @@ sign) may only contain [7-bit ASCII
#' characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If
#' the *domain part* of an address (the part after the @@ sign) contains
#' non-ASCII characters, they must be encoded using Punycode, as described
#' in [RFC3492](https://datatracker.ietf.org/doc/html/rfc3492.html). The
#' sender name (also known as the *friendly name*) may contain non-ASCII
#' characters. These characters must be encoded using MIME encoded-word
#' syntax, as described in [RFC
#' 2047](https://datatracker.ietf.org/doc/html/rfc2047). MIME encoded-word
#' syntax uses the following form: `=?charset?encoding?encoded-text?=`.
#' @param Destination &#91;required&#93; The destination for this email, composed of To:, CC:, and BCC: fields.
#' @param Message &#91;required&#93; The message to be sent.
#' @param ReplyToAddresses The reply-to email address(es) for the message. If the recipient replies
#' to the message, each reply-to address will receive the reply.
#' @param ReturnPath The email address that bounces and complaints will be forwarded to when
#' feedback forwarding is enabled. If the message cannot be delivered to
#' the recipient, then an error message will be returned from the
#' recipient's ISP; this message will then be forwarded to the email
#' address specified by the `ReturnPath` parameter. The `ReturnPath`
#' parameter is never overwritten. This email address must be either
#' individually verified with Amazon SES, or from a domain that has been
#' verified with Amazon SES.
#' @param SourceArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to send for the email address specified in the `Source`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to send from `user@@example.com`, then
#' you would specify the `SourceArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `Source` to be `user@@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' @param ReturnPathArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the `ReturnPath`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to use `feedback@@example.com`, then you
#' would specify the `ReturnPathArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `ReturnPath` to be `feedback@@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' @param Tags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using [`send_email`][ses_send_email]. Tags correspond to
#' characteristics of the email that you define, so that you can publish
#' email sending events.
#' @param ConfigurationSetName The name of the configuration set to use when you send an email using
#' [`send_email`][ses_send_email].
#'
#' @keywords internal
#'
#' @rdname ses_send_email
ses_send_email <- function(Source, Destination, Message, ReplyToAddresses = NULL, ReturnPath = NULL, SourceArn = NULL, ReturnPathArn = NULL, Tags = NULL, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "SendEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_email_input(Source = Source, Destination = Destination, Message = Message, ReplyToAddresses = ReplyToAddresses, ReturnPath = ReturnPath, SourceArn = SourceArn, ReturnPathArn = ReturnPathArn, Tags = Tags, ConfigurationSetName = ConfigurationSetName)
  output <- .ses$send_email_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_email <- ses_send_email

#' Composes an email message and immediately queues it for sending
#'
#' @description
#' Composes an email message and immediately queues it for sending.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_send_raw_email/](https://www.paws-r-sdk.com/docs/ses_send_raw_email/) for full documentation.
#'
#' @param Source The identity's email address. If you do not provide a value for this
#' parameter, you must specify a "From" address in the raw text of the
#' message. (You can also specify both.)
#' 
#' Amazon SES does not support the SMTPUTF8 extension, as described
#' in[RFC6531](https://datatracker.ietf.org/doc/html/rfc6531). For this
#' reason, the *local part* of a source email address (the part of the
#' email address that precedes the @@ sign) may only contain [7-bit ASCII
#' characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If
#' the *domain part* of an address (the part after the @@ sign) contains
#' non-ASCII characters, they must be encoded using Punycode, as described
#' in [RFC3492](https://datatracker.ietf.org/doc/html/rfc3492.html). The
#' sender name (also known as the *friendly name*) may contain non-ASCII
#' characters. These characters must be encoded using MIME encoded-word
#' syntax, as described in [RFC
#' 2047](https://datatracker.ietf.org/doc/html/rfc2047). MIME encoded-word
#' syntax uses the following form: `=?charset?encoding?encoded-text?=`.
#' 
#' If you specify the `Source` parameter and have feedback forwarding
#' enabled, then bounces and complaints will be sent to this email address.
#' This takes precedence over any Return-Path header that you might include
#' in the raw text of the message.
#' @param Destinations A list of destinations for the message, consisting of To:, CC:, and BCC:
#' addresses.
#' @param RawMessage &#91;required&#93; The raw email message itself. The message has to meet the following
#' criteria:
#' 
#' -   The message has to contain a header and a body, separated by a blank
#'     line.
#' 
#' -   All of the required header fields must be present in the message.
#' 
#' -   Each part of a multipart MIME message must be formatted properly.
#' 
#' -   Attachments must be of a content type that Amazon SES supports. For
#'     a list on unsupported content types, see [Unsupported Attachment
#'     Types](https://docs.aws.amazon.com/ses/latest/dg/Welcome.html) in
#'     the *Amazon SES Developer Guide*.
#' 
#' -   The entire message must be base64-encoded.
#' 
#' -   If any of the MIME parts in your message contain content that is
#'     outside of the 7-bit ASCII character range, we highly recommend that
#'     you encode that content. For more information, see [Sending Raw
#'     Email](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html)
#'     in the *Amazon SES Developer Guide*.
#' 
#' -   Per [RFC
#'     5321](https://datatracker.ietf.org/doc/html/rfc5321#section-4.5.3.1.6),
#'     the maximum length of each line of text, including the \<CRLF\>,
#'     must not exceed 1,000 characters.
#' @param FromArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to specify a particular "From" address in the header of
#' the raw email.
#' 
#' Instead of using this parameter, you can use the X-header
#' `X-SES-FROM-ARN` in the raw message of the email. If you use both the
#' `FromArn` parameter and the corresponding X-header, Amazon SES uses the
#' value of the `FromArn` parameter.
#' 
#' For information about when to use this parameter, see the description of
#' [`send_raw_email`][ses_send_raw_email] in this guide, or see the [Amazon
#' SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
#' @param SourceArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to send for the email address specified in the `Source`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to send from `user@@example.com`, then
#' you would specify the `SourceArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `Source` to be `user@@example.com`.
#' 
#' Instead of using this parameter, you can use the X-header
#' `X-SES-SOURCE-ARN` in the raw message of the email. If you use both the
#' `SourceArn` parameter and the corresponding X-header, Amazon SES uses
#' the value of the `SourceArn` parameter.
#' 
#' For information about when to use this parameter, see the description of
#' [`send_raw_email`][ses_send_raw_email] in this guide, or see the [Amazon
#' SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
#' @param ReturnPathArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the `ReturnPath`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to use `feedback@@example.com`, then you
#' would specify the `ReturnPathArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `ReturnPath` to be `feedback@@example.com`.
#' 
#' Instead of using this parameter, you can use the X-header
#' `X-SES-RETURN-PATH-ARN` in the raw message of the email. If you use both
#' the `ReturnPathArn` parameter and the corresponding X-header, Amazon SES
#' uses the value of the `ReturnPathArn` parameter.
#' 
#' For information about when to use this parameter, see the description of
#' [`send_raw_email`][ses_send_raw_email] in this guide, or see the [Amazon
#' SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
#' @param Tags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using [`send_raw_email`][ses_send_raw_email]. Tags
#' correspond to characteristics of the email that you define, so that you
#' can publish email sending events.
#' @param ConfigurationSetName The name of the configuration set to use when you send an email using
#' [`send_raw_email`][ses_send_raw_email].
#'
#' @keywords internal
#'
#' @rdname ses_send_raw_email
ses_send_raw_email <- function(Source = NULL, Destinations = NULL, RawMessage, FromArn = NULL, SourceArn = NULL, ReturnPathArn = NULL, Tags = NULL, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "SendRawEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_raw_email_input(Source = Source, Destinations = Destinations, RawMessage = RawMessage, FromArn = FromArn, SourceArn = SourceArn, ReturnPathArn = ReturnPathArn, Tags = Tags, ConfigurationSetName = ConfigurationSetName)
  output <- .ses$send_raw_email_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_raw_email <- ses_send_raw_email

#' Composes an email message using an email template and immediately queues
#' it for sending
#'
#' @description
#' Composes an email message using an email template and immediately queues it for sending.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_send_templated_email/](https://www.paws-r-sdk.com/docs/ses_send_templated_email/) for full documentation.
#'
#' @param Source &#91;required&#93; The email address that is sending the email. This email address must be
#' either individually verified with Amazon SES, or from a domain that has
#' been verified with Amazon SES. For information about verifying
#' identities, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html).
#' 
#' If you are sending on behalf of another user and have been permitted to
#' do so by a sending authorization policy, then you must also specify the
#' `SourceArn` parameter. For more information about sending authorization,
#' see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' 
#' Amazon SES does not support the SMTPUTF8 extension, as described in
#' [RFC6531](https://datatracker.ietf.org/doc/html/rfc6531). For this
#' reason, the *local part* of a source email address (the part of the
#' email address that precedes the @@ sign) may only contain [7-bit ASCII
#' characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If
#' the *domain part* of an address (the part after the @@ sign) contains
#' non-ASCII characters, they must be encoded using Punycode, as described
#' in [RFC3492](https://datatracker.ietf.org/doc/html/rfc3492.html). The
#' sender name (also known as the *friendly name*) may contain non-ASCII
#' characters. These characters must be encoded using MIME encoded-word
#' syntax, as described in[RFC
#' 2047](https://datatracker.ietf.org/doc/html/rfc2047). MIME encoded-word
#' syntax uses the following form: `=?charset?encoding?encoded-text?=`.
#' @param Destination &#91;required&#93; The destination for this email, composed of To:, CC:, and BCC: fields. A
#' Destination can include up to 50 recipients across these three fields.
#' @param ReplyToAddresses The reply-to email address(es) for the message. If the recipient replies
#' to the message, each reply-to address will receive the reply.
#' @param ReturnPath The email address that bounces and complaints will be forwarded to when
#' feedback forwarding is enabled. If the message cannot be delivered to
#' the recipient, then an error message will be returned from the
#' recipient's ISP; this message will then be forwarded to the email
#' address specified by the `ReturnPath` parameter. The `ReturnPath`
#' parameter is never overwritten. This email address must be either
#' individually verified with Amazon SES, or from a domain that has been
#' verified with Amazon SES.
#' @param SourceArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to send for the email address specified in the `Source`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to send from `user@@example.com`, then
#' you would specify the `SourceArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `Source` to be `user@@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' @param ReturnPathArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the `ReturnPath`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to use `feedback@@example.com`, then you
#' would specify the `ReturnPathArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `ReturnPath` to be `feedback@@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
#' @param Tags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using [`send_templated_email`][ses_send_templated_email].
#' Tags correspond to characteristics of the email that you define, so that
#' you can publish email sending events.
#' @param ConfigurationSetName The name of the configuration set to use when you send an email using
#' [`send_templated_email`][ses_send_templated_email].
#' @param Template &#91;required&#93; The template to use when sending this email.
#' @param TemplateArn The ARN of the template to use when sending this email.
#' @param TemplateData &#91;required&#93; A list of replacement values to apply to the template. This parameter is
#' a JSON object, typically consisting of key-value pairs in which the keys
#' correspond to replacement tags in the email template.
#'
#' @keywords internal
#'
#' @rdname ses_send_templated_email
ses_send_templated_email <- function(Source, Destination, ReplyToAddresses = NULL, ReturnPath = NULL, SourceArn = NULL, ReturnPathArn = NULL, Tags = NULL, ConfigurationSetName = NULL, Template, TemplateArn = NULL, TemplateData) {
  op <- new_operation(
    name = "SendTemplatedEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_templated_email_input(Source = Source, Destination = Destination, ReplyToAddresses = ReplyToAddresses, ReturnPath = ReturnPath, SourceArn = SourceArn, ReturnPathArn = ReturnPathArn, Tags = Tags, ConfigurationSetName = ConfigurationSetName, Template = Template, TemplateArn = TemplateArn, TemplateData = TemplateData)
  output <- .ses$send_templated_email_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_templated_email <- ses_send_templated_email

#' Sets the specified receipt rule set as the active receipt rule set
#'
#' @description
#' Sets the specified receipt rule set as the active receipt rule set.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_set_active_receipt_rule_set/](https://www.paws-r-sdk.com/docs/ses_set_active_receipt_rule_set/) for full documentation.
#'
#' @param RuleSetName The name of the receipt rule set to make active. Setting this value to
#' null disables all email receiving.
#'
#' @keywords internal
#'
#' @rdname ses_set_active_receipt_rule_set
ses_set_active_receipt_rule_set <- function(RuleSetName = NULL) {
  op <- new_operation(
    name = "SetActiveReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_active_receipt_rule_set_input(RuleSetName = RuleSetName)
  output <- .ses$set_active_receipt_rule_set_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_active_receipt_rule_set <- ses_set_active_receipt_rule_set

#' Enables or disables Easy DKIM signing of email sent from an identity
#'
#' @description
#' Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM signing is enabled for a domain, then Amazon SES uses DKIM to sign all email that it sends from addresses on that domain. If Easy DKIM signing is enabled for an email address, then Amazon SES uses DKIM to sign all email it sends from that address.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_set_identity_dkim_enabled/](https://www.paws-r-sdk.com/docs/ses_set_identity_dkim_enabled/) for full documentation.
#'
#' @param Identity &#91;required&#93; The identity for which DKIM signing should be enabled or disabled.
#' @param DkimEnabled &#91;required&#93; Sets whether DKIM signing is enabled for an identity. Set to `true` to
#' enable DKIM signing for this identity; `false` to disable it.
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_dkim_enabled
ses_set_identity_dkim_enabled <- function(Identity, DkimEnabled) {
  op <- new_operation(
    name = "SetIdentityDkimEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_dkim_enabled_input(Identity = Identity, DkimEnabled = DkimEnabled)
  output <- .ses$set_identity_dkim_enabled_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_dkim_enabled <- ses_set_identity_dkim_enabled

#' Given an identity (an email address or a domain), enables or disables
#' whether Amazon SES forwards bounce and complaint notifications as email
#'
#' @description
#' Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification Service (Amazon SNS) topics are specified for both bounces and complaints.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_set_identity_feedback_forwarding_enabled/](https://www.paws-r-sdk.com/docs/ses_set_identity_feedback_forwarding_enabled/) for full documentation.
#'
#' @param Identity &#91;required&#93; The identity for which to set bounce and complaint notification
#' forwarding. Examples: `user@@example.com`, `example.com`.
#' @param ForwardingEnabled &#91;required&#93; Sets whether Amazon SES will forward bounce and complaint notifications
#' as email. `true` specifies that Amazon SES will forward bounce and
#' complaint notifications as email, in addition to any Amazon SNS topic
#' publishing otherwise specified. `false` specifies that Amazon SES will
#' publish bounce and complaint notifications only through Amazon SNS. This
#' value can only be set to `false` when Amazon SNS topics are set for both
#' `Bounce` and `Complaint` notification types.
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_feedback_forwarding_enabled
ses_set_identity_feedback_forwarding_enabled <- function(Identity, ForwardingEnabled) {
  op <- new_operation(
    name = "SetIdentityFeedbackForwardingEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_feedback_forwarding_enabled_input(Identity = Identity, ForwardingEnabled = ForwardingEnabled)
  output <- .ses$set_identity_feedback_forwarding_enabled_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_feedback_forwarding_enabled <- ses_set_identity_feedback_forwarding_enabled

#' Given an identity (an email address or a domain), sets whether Amazon
#' SES includes the original email headers in the Amazon Simple
#' Notification Service (Amazon SNS) notifications of a specified type
#'
#' @description
#' Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_set_identity_headers_in_notifications_enabled/](https://www.paws-r-sdk.com/docs/ses_set_identity_headers_in_notifications_enabled/) for full documentation.
#'
#' @param Identity &#91;required&#93; The identity for which to enable or disable headers in notifications.
#' Examples: `user@@example.com`, `example.com`.
#' @param NotificationType &#91;required&#93; The notification type for which to enable or disable headers in
#' notifications.
#' @param Enabled &#91;required&#93; Sets whether Amazon SES includes the original email headers in Amazon
#' SNS notifications of the specified notification type. A value of `true`
#' specifies that Amazon SES will include headers in notifications, and a
#' value of `false` specifies that Amazon SES will not include headers in
#' notifications.
#' 
#' This value can only be set when `NotificationType` is already set to use
#' a particular Amazon SNS topic.
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_headers_in_notifications_enabled
ses_set_identity_headers_in_notifications_enabled <- function(Identity, NotificationType, Enabled) {
  op <- new_operation(
    name = "SetIdentityHeadersInNotificationsEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_headers_in_notifications_enabled_input(Identity = Identity, NotificationType = NotificationType, Enabled = Enabled)
  output <- .ses$set_identity_headers_in_notifications_enabled_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_headers_in_notifications_enabled <- ses_set_identity_headers_in_notifications_enabled

#' Enables or disables the custom MAIL FROM domain setup for a verified
#' identity (an email address or a domain)
#'
#' @description
#' Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).
#'
#' See [https://www.paws-r-sdk.com/docs/ses_set_identity_mail_from_domain/](https://www.paws-r-sdk.com/docs/ses_set_identity_mail_from_domain/) for full documentation.
#'
#' @param Identity &#91;required&#93; The verified identity for which you want to enable or disable the
#' specified custom MAIL FROM domain.
#' @param MailFromDomain The custom MAIL FROM domain that you want the verified identity to use.
#' The MAIL FROM domain must 1) be a subdomain of the verified identity, 2)
#' not be used in a "From" address if the MAIL FROM domain is the
#' destination of email feedback forwarding (for more information, see the
#' [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/dg/mail-from.html)), and
#' 3) not be used to receive emails. A value of `null` disables the custom
#' MAIL FROM setting for the identity.
#' @param BehaviorOnMXFailure The action that you want Amazon SES to take if it cannot successfully
#' read the required MX record when you send an email. If you choose
#' `UseDefaultValue`, Amazon SES will use amazonses.com (or a subdomain of
#' that) as the MAIL FROM domain. If you choose `RejectMessage`, Amazon SES
#' will return a `MailFromDomainNotVerified` error and not send the email.
#' 
#' The action specified in `BehaviorOnMXFailure` is taken when the custom
#' MAIL FROM domain setup is in the `Pending`, `Failed`, and
#' `TemporaryFailure` states.
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_mail_from_domain
ses_set_identity_mail_from_domain <- function(Identity, MailFromDomain = NULL, BehaviorOnMXFailure = NULL) {
  op <- new_operation(
    name = "SetIdentityMailFromDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_mail_from_domain_input(Identity = Identity, MailFromDomain = MailFromDomain, BehaviorOnMXFailure = BehaviorOnMXFailure)
  output <- .ses$set_identity_mail_from_domain_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_mail_from_domain <- ses_set_identity_mail_from_domain

#' Sets an Amazon Simple Notification Service (Amazon SNS) topic to use
#' when delivering notifications
#'
#' @description
#' Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use this operation, you specify a verified identity, such as an email address or domain. When you send an email that uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_set_identity_notification_topic/](https://www.paws-r-sdk.com/docs/ses_set_identity_notification_topic/) for full documentation.
#'
#' @param Identity &#91;required&#93; The identity (email address or domain) that you want to set the Amazon
#' SNS topic for.
#' 
#' You can only specify a verified identity for this parameter.
#' 
#' You can specify an identity by using its name or by using its Amazon
#' Resource Name (ARN). The following examples are all valid identities:
#' `sender@@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' @param NotificationType &#91;required&#93; The type of notifications that will be published to the specified Amazon
#' SNS topic.
#' @param SnsTopic The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter
#' is omitted from the request or a null value is passed, `SnsTopic` is
#' cleared and publishing is disabled.
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_notification_topic
ses_set_identity_notification_topic <- function(Identity, NotificationType, SnsTopic = NULL) {
  op <- new_operation(
    name = "SetIdentityNotificationTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_notification_topic_input(Identity = Identity, NotificationType = NotificationType, SnsTopic = SnsTopic)
  output <- .ses$set_identity_notification_topic_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_notification_topic <- ses_set_identity_notification_topic

#' Sets the position of the specified receipt rule in the receipt rule set
#'
#' @description
#' Sets the position of the specified receipt rule in the receipt rule set.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_set_receipt_rule_position/](https://www.paws-r-sdk.com/docs/ses_set_receipt_rule_position/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set that contains the receipt rule to
#' reposition.
#' @param RuleName &#91;required&#93; The name of the receipt rule to reposition.
#' @param After The name of the receipt rule after which to place the specified receipt
#' rule.
#'
#' @keywords internal
#'
#' @rdname ses_set_receipt_rule_position
ses_set_receipt_rule_position <- function(RuleSetName, RuleName, After = NULL) {
  op <- new_operation(
    name = "SetReceiptRulePosition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_receipt_rule_position_input(RuleSetName = RuleSetName, RuleName = RuleName, After = After)
  output <- .ses$set_receipt_rule_position_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_receipt_rule_position <- ses_set_receipt_rule_position

#' Creates a preview of the MIME content of an email when provided with a
#' template and a set of replacement data
#'
#' @description
#' Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_test_render_template/](https://www.paws-r-sdk.com/docs/ses_test_render_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the template that you want to render.
#' @param TemplateData &#91;required&#93; A list of replacement values to apply to the template. This parameter is
#' a JSON object, typically consisting of key-value pairs in which the keys
#' correspond to replacement tags in the email template.
#'
#' @keywords internal
#'
#' @rdname ses_test_render_template
ses_test_render_template <- function(TemplateName, TemplateData) {
  op <- new_operation(
    name = "TestRenderTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$test_render_template_input(TemplateName = TemplateName, TemplateData = TemplateData)
  output <- .ses$test_render_template_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$test_render_template <- ses_test_render_template

#' Enables or disables email sending across your entire Amazon SES account
#' in the current AWS Region
#'
#' @description
#' Enables or disables email sending across your entire Amazon SES account in the current AWS Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon SES account in a given AWS Region when reputation metrics (such as your bounce or complaint rates) reach certain thresholds.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_update_account_sending_enabled/](https://www.paws-r-sdk.com/docs/ses_update_account_sending_enabled/) for full documentation.
#'
#' @param Enabled Describes whether email sending is enabled or disabled for your Amazon
#' SES account in the current AWS Region.
#'
#' @keywords internal
#'
#' @rdname ses_update_account_sending_enabled
ses_update_account_sending_enabled <- function(Enabled = NULL) {
  op <- new_operation(
    name = "UpdateAccountSendingEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_account_sending_enabled_input(Enabled = Enabled)
  output <- .ses$update_account_sending_enabled_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_account_sending_enabled <- ses_update_account_sending_enabled

#' Updates the event destination of a configuration set
#'
#' @description
#' Updates the event destination of a configuration set. Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see [Monitoring Your Amazon SES Sending Activity](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html) in the *Amazon SES Developer Guide.*
#'
#' See [https://www.paws-r-sdk.com/docs/ses_update_configuration_set_event_destination/](https://www.paws-r-sdk.com/docs/ses_update_configuration_set_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination
#' that you want to update.
#' @param EventDestination &#91;required&#93; The event destination object that you want to apply to the specified
#' configuration set.
#'
#' @keywords internal
#'
#' @rdname ses_update_configuration_set_event_destination
ses_update_configuration_set_event_destination <- function(ConfigurationSetName, EventDestination) {
  op <- new_operation(
    name = "UpdateConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestination = EventDestination)
  output <- .ses$update_configuration_set_event_destination_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_configuration_set_event_destination <- ses_update_configuration_set_event_destination

#' Enables or disables the publishing of reputation metrics for emails sent
#' using a specific configuration set in a given AWS Region
#'
#' @description
#' Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a given AWS Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_update_configuration_set_reputation_metrics_enabled/](https://www.paws-r-sdk.com/docs/ses_update_configuration_set_reputation_metrics_enabled/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to update.
#' @param Enabled &#91;required&#93; Describes whether or not Amazon SES will publish reputation metrics for
#' the configuration set, such as bounce and complaint rates, to Amazon
#' CloudWatch.
#'
#' @keywords internal
#'
#' @rdname ses_update_configuration_set_reputation_metrics_enabled
ses_update_configuration_set_reputation_metrics_enabled <- function(ConfigurationSetName, Enabled) {
  op <- new_operation(
    name = "UpdateConfigurationSetReputationMetricsEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_configuration_set_reputation_metrics_enabled_input(ConfigurationSetName = ConfigurationSetName, Enabled = Enabled)
  output <- .ses$update_configuration_set_reputation_metrics_enabled_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_configuration_set_reputation_metrics_enabled <- ses_update_configuration_set_reputation_metrics_enabled

#' Enables or disables email sending for messages sent using a specific
#' configuration set in a given AWS Region
#'
#' @description
#' Enables or disables email sending for messages sent using a specific configuration set in a given AWS Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate) exceed certain thresholds.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_update_configuration_set_sending_enabled/](https://www.paws-r-sdk.com/docs/ses_update_configuration_set_sending_enabled/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to update.
#' @param Enabled &#91;required&#93; Describes whether email sending is enabled or disabled for the
#' configuration set.
#'
#' @keywords internal
#'
#' @rdname ses_update_configuration_set_sending_enabled
ses_update_configuration_set_sending_enabled <- function(ConfigurationSetName, Enabled) {
  op <- new_operation(
    name = "UpdateConfigurationSetSendingEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_configuration_set_sending_enabled_input(ConfigurationSetName = ConfigurationSetName, Enabled = Enabled)
  output <- .ses$update_configuration_set_sending_enabled_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_configuration_set_sending_enabled <- ses_update_configuration_set_sending_enabled

#' Modifies an association between a configuration set and a custom domain
#' for open and click event tracking
#'
#' @description
#' Modifies an association between a configuration set and a custom domain for open and click event tracking.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_update_configuration_set_tracking_options/](https://www.paws-r-sdk.com/docs/ses_update_configuration_set_tracking_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set for which you want to update the
#' custom tracking domain.
#' @param TrackingOptions &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname ses_update_configuration_set_tracking_options
ses_update_configuration_set_tracking_options <- function(ConfigurationSetName, TrackingOptions) {
  op <- new_operation(
    name = "UpdateConfigurationSetTrackingOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_configuration_set_tracking_options_input(ConfigurationSetName = ConfigurationSetName, TrackingOptions = TrackingOptions)
  output <- .ses$update_configuration_set_tracking_options_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_configuration_set_tracking_options <- ses_update_configuration_set_tracking_options

#' Updates an existing custom verification email template
#'
#' @description
#' Updates an existing custom verification email template.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_update_custom_verification_email_template/](https://www.paws-r-sdk.com/docs/ses_update_custom_verification_email_template/) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template that you want to
#' update.
#' @param FromEmailAddress The email address that the custom verification email is sent from.
#' @param TemplateSubject The subject line of the custom verification email.
#' @param TemplateContent The content of the custom verification email. The total size of the
#' email must be less than 10 MB. The message body may contain HTML, with
#' some limitations. For more information, see [Custom Verification Email
#' Frequently Asked
#' Questions](https://docs.aws.amazon.com/ses/latest/dg/Welcome.html#custom-verification-emails-faq)
#' in the *Amazon SES Developer Guide*.
#' @param SuccessRedirectionURL The URL that the recipient of the verification email is sent to if his
#' or her address is successfully verified.
#' @param FailureRedirectionURL The URL that the recipient of the verification email is sent to if his
#' or her address is not successfully verified.
#'
#' @keywords internal
#'
#' @rdname ses_update_custom_verification_email_template
ses_update_custom_verification_email_template <- function(TemplateName, FromEmailAddress = NULL, TemplateSubject = NULL, TemplateContent = NULL, SuccessRedirectionURL = NULL, FailureRedirectionURL = NULL) {
  op <- new_operation(
    name = "UpdateCustomVerificationEmailTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_custom_verification_email_template_input(TemplateName = TemplateName, FromEmailAddress = FromEmailAddress, TemplateSubject = TemplateSubject, TemplateContent = TemplateContent, SuccessRedirectionURL = SuccessRedirectionURL, FailureRedirectionURL = FailureRedirectionURL)
  output <- .ses$update_custom_verification_email_template_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_custom_verification_email_template <- ses_update_custom_verification_email_template

#' Updates a receipt rule
#'
#' @description
#' Updates a receipt rule.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_update_receipt_rule/](https://www.paws-r-sdk.com/docs/ses_update_receipt_rule/) for full documentation.
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set that the receipt rule belongs to.
#' @param Rule &#91;required&#93; A data structure that contains the updated receipt rule information.
#'
#' @keywords internal
#'
#' @rdname ses_update_receipt_rule
ses_update_receipt_rule <- function(RuleSetName, Rule) {
  op <- new_operation(
    name = "UpdateReceiptRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_receipt_rule_input(RuleSetName = RuleSetName, Rule = Rule)
  output <- .ses$update_receipt_rule_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_receipt_rule <- ses_update_receipt_rule

#' Updates an email template
#'
#' @description
#' Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ses_update_template/](https://www.paws-r-sdk.com/docs/ses_update_template/) for full documentation.
#'
#' @param Template &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname ses_update_template
ses_update_template <- function(Template) {
  op <- new_operation(
    name = "UpdateTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_template_input(Template = Template)
  output <- .ses$update_template_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_template <- ses_update_template

#' Returns a set of DKIM tokens for a domain identity
#'
#' @description
#' Returns a set of DKIM tokens for a domain identity.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_verify_domain_dkim/](https://www.paws-r-sdk.com/docs/ses_verify_domain_dkim/) for full documentation.
#'
#' @param Domain &#91;required&#93; The name of the domain to be verified for Easy DKIM signing.
#'
#' @keywords internal
#'
#' @rdname ses_verify_domain_dkim
ses_verify_domain_dkim <- function(Domain) {
  op <- new_operation(
    name = "VerifyDomainDkim",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$verify_domain_dkim_input(Domain = Domain)
  output <- .ses$verify_domain_dkim_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$verify_domain_dkim <- ses_verify_domain_dkim

#' Adds a domain to the list of identities for your Amazon SES account in
#' the current AWS Region and attempts to verify it
#'
#' @description
#' Adds a domain to the list of identities for your Amazon SES account in the current AWS Region and attempts to verify it. For more information about verifying domains, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
#'
#' See [https://www.paws-r-sdk.com/docs/ses_verify_domain_identity/](https://www.paws-r-sdk.com/docs/ses_verify_domain_identity/) for full documentation.
#'
#' @param Domain &#91;required&#93; The domain to be verified.
#'
#' @keywords internal
#'
#' @rdname ses_verify_domain_identity
ses_verify_domain_identity <- function(Domain) {
  op <- new_operation(
    name = "VerifyDomainIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$verify_domain_identity_input(Domain = Domain)
  output <- .ses$verify_domain_identity_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$verify_domain_identity <- ses_verify_domain_identity

#' Deprecated
#'
#' @description
#' Deprecated. Use the [`verify_email_identity`][ses_verify_email_identity] operation to verify a new email address.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_verify_email_address/](https://www.paws-r-sdk.com/docs/ses_verify_email_address/) for full documentation.
#'
#' @param EmailAddress &#91;required&#93; The email address to be verified.
#'
#' @keywords internal
#'
#' @rdname ses_verify_email_address
ses_verify_email_address <- function(EmailAddress) {
  op <- new_operation(
    name = "VerifyEmailAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$verify_email_address_input(EmailAddress = EmailAddress)
  output <- .ses$verify_email_address_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$verify_email_address <- ses_verify_email_address

#' Adds an email address to the list of identities for your Amazon SES
#' account in the current AWS region and attempts to verify it
#'
#' @description
#' Adds an email address to the list of identities for your Amazon SES account in the current AWS region and attempts to verify it. As a result of executing this operation, a verification email is sent to the specified address.
#'
#' See [https://www.paws-r-sdk.com/docs/ses_verify_email_identity/](https://www.paws-r-sdk.com/docs/ses_verify_email_identity/) for full documentation.
#'
#' @param EmailAddress &#91;required&#93; The email address to be verified.
#'
#' @keywords internal
#'
#' @rdname ses_verify_email_identity
ses_verify_email_identity <- function(EmailAddress) {
  op <- new_operation(
    name = "VerifyEmailIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$verify_email_identity_input(EmailAddress = EmailAddress)
  output <- .ses$verify_email_identity_output()
  config <- get_config()
  svc <- .ses$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$verify_email_identity <- ses_verify_email_identity
