% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_metric_data_v2}
\alias{connect_get_metric_data_v2}
\title{Gets metric data from the specified Amazon Connect instance}
\usage{
connect_get_metric_data_v2(
  ResourceArn,
  StartTime,
  EndTime,
  Interval = NULL,
  Filters,
  Groupings = NULL,
  Metrics,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource. This includes the
\code{instanceId} an Amazon Connect instance.}

\item{StartTime}{[required] The timestamp, in UNIX Epoch time format, at which to start the
reporting interval for the retrieval of historical metrics data. The
time must be before the end time timestamp. The start and end time
depends on the \code{IntervalPeriod} selected. By default the time range
between start and end time is 35 days. Historical metrics are available
for 3 months.}

\item{EndTime}{[required] The timestamp, in UNIX Epoch time format, at which to end the reporting
interval for the retrieval of historical metrics data. The time must be
later than the start time timestamp. It cannot be later than the current
timestamp.}

\item{Interval}{The interval period and timezone to apply to returned metrics.
\itemize{
\item \code{IntervalPeriod}: An aggregated grouping applied to request metrics.
Valid \code{IntervalPeriod} values are: \code{FIFTEEN_MIN} | \code{THIRTY_MIN} |
\code{HOUR} | \code{DAY} | \code{WEEK} | \code{TOTAL}.

For example, if \code{IntervalPeriod} is selected \code{THIRTY_MIN},
\code{StartTime} and \code{EndTime} differs by 1 day, then Amazon Connect
returns 48 results in the response. Each result is aggregated by the
THIRTY_MIN period. By default Amazon Connect aggregates results
based on the \code{TOTAL} interval period.

The following list describes restrictions on \code{StartTime} and
\code{EndTime} based on which \code{IntervalPeriod} is requested.
\itemize{
\item \code{FIFTEEN_MIN}: The difference between \code{StartTime} and \code{EndTime}
must be less than 3 days.
\item \code{THIRTY_MIN}: The difference between \code{StartTime} and \code{EndTime}
must be less than 3 days.
\item \code{HOUR}: The difference between \code{StartTime} and \code{EndTime} must be
less than 3 days.
\item \code{DAY}: The difference between \code{StartTime} and \code{EndTime} must be
less than 35 days.
\item \code{WEEK}: The difference between \code{StartTime} and \code{EndTime} must be
less than 35 days.
\item \code{TOTAL}: The difference between \code{StartTime} and \code{EndTime} must
be less than 35 days.
}
\item \code{TimeZone}: The timezone applied to requested metrics.
}}

\item{Filters}{[required] The filters to apply to returned metrics. You can filter on the
following resources:
\itemize{
\item Queues
\item Routing profiles
\item Agents
\item Channels
\item User hierarchy groups
\item Feature
\item Routing step expression
}

At least one filter must be passed from queues, routing profiles,
agents, or user hierarchy groups.

To filter by phone number, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html}{Create a historical metrics report}
in the \emph{Amazon Connect Administrator's Guide}.

Note the following limits:
\itemize{
\item \strong{Filter keys}: A maximum of 5 filter keys are supported in a
single request. Valid filter keys: \code{QUEUE} | \code{ROUTING_PROFILE} |
\code{AGENT} | \code{CHANNEL} | \code{AGENT_HIERARCHY_LEVEL_ONE} |
\code{AGENT_HIERARCHY_LEVEL_TWO} | \code{AGENT_HIERARCHY_LEVEL_THREE} |
\code{AGENT_HIERARCHY_LEVEL_FOUR} | \code{AGENT_HIERARCHY_LEVEL_FIVE} |
\code{FEATURE} | \code{CASE_TEMPLATE_ARN} | \code{CASE_STATUS} |
\code{contact/segmentAttributes/connect:Subtype} |
\code{ROUTING_STEP_EXPRESSION}
\item \strong{Filter values}: A maximum of 100 filter values are supported in a
single request. VOICE, CHAT, and TASK are valid \code{filterValue} for
the CHANNEL filter key. They do not count towards limitation of 100
filter values. For example, a GetMetricDataV2 request can filter by
50 queues, 35 agents, and 15 routing profiles for a total of 100
filter values, along with 3 channel filters.

\code{contact_lens_conversational_analytics} is a valid filterValue for
the \code{FEATURE} filter key. It is available only to contacts analyzed
by Contact Lens conversational analytics.

\code{connect:Chat}, \code{connect:SMS}, \code{connect:Telephony}, and
\code{connect:WebRTC} are valid \code{filterValue} examples (not exhaustive)
for the \verb{contact/segmentAttributes/connect:Subtype filter} key.

\code{ROUTING_STEP_EXPRESSION} is a valid filter key with a filter value
up to 3000 length. This filter is case and order sensitive. JSON
string fields must be sorted in ascending order and JSON array order
should be kept as is.
}}

\item{Groupings}{The grouping applied to the metrics that are returned. For example, when
results are grouped by queue, the metrics returned are grouped by queue.
The values that are returned apply to the metrics for each queue. They
are not aggregated for all queues.

If no grouping is specified, a summary of all metrics is returned.

Valid grouping keys: \code{QUEUE} | \code{ROUTING_PROFILE} | \code{AGENT} | \code{CHANNEL} |
\code{AGENT_HIERARCHY_LEVEL_ONE} | \code{AGENT_HIERARCHY_LEVEL_TWO} |
\code{AGENT_HIERARCHY_LEVEL_THREE} | \code{AGENT_HIERARCHY_LEVEL_FOUR} |
\code{AGENT_HIERARCHY_LEVEL_FIVE} | \code{CASE_TEMPLATE_ARN} | \code{CASE_STATUS} |
\code{contact/segmentAttributes/connect:Subtype} | \code{ROUTING_STEP_EXPRESSION}}

\item{Metrics}{[required] The metrics to retrieve. Specify the name, groupings, and filters for
each metric. The following historical metrics are available. For a
description of each metric, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html}{Historical metrics definitions}
in the \emph{Amazon Connect Administrator's Guide}.

\strong{ABANDONMENT_RATE}

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical}{Abandonment rate}

\strong{AGENT_ADHERENT_TIME}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical}{Adherent time}

\strong{AGENT_ANSWER_RATE}

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical}{Agent answer rate}

\strong{AGENT_NON_ADHERENT_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time}{Non-adherent time}

\strong{AGENT_NON_RESPONSE}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response}{Agent non-response}

\strong{AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

Data for this metric is available starting from October 1, 2023 0:00:00
GMT.

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical}{Agent non-response without customer abandons}

\strong{AGENT_OCCUPANCY}

Unit: Percentage

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical}{Occupancy}

\strong{AGENT_SCHEDULE_ADHERENCE}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical}{Adherence}

\strong{AGENT_SCHEDULED_TIME}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical}{Scheduled time}

\strong{AVG_ABANDON_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical}{Average queue abandon time}

\strong{AVG_ACTIVE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical}{Average active time}

\strong{AVG_AFTER_CONTACT_WORK_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical}{Average after contact work time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_AGENT_CONNECTING_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}. For now, this metric only
supports the following as \code{INITIATION_METHOD}: \code{INBOUND} | \code{OUTBOUND} |
\code{CALLBACK} | \code{API}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time}{Average agent API connecting time}

The \code{Negate} key in Metric Level Filters is not applicable for this
metric.

\strong{AVG_AGENT_PAUSE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical}{Average agent pause time}

\strong{AVG_CASE_RELATED_CONTACTS}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical}{Average contacts per case}

\strong{AVG_CASE_RESOLUTION_TIME}

Unit: Seconds

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical}{Average case resolution time}

\strong{AVG_CONTACT_DURATION}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical}{Average contact duration}

Feature is a valid filter but not a valid grouping.

\strong{AVG_CONVERSATION_DURATION}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical}{Average conversation duration}

\strong{AVG_GREETING_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical}{Average greeting time agent}

\strong{AVG_HANDLE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype,
RoutingStepExpression

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical}{Average handle time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical}{Average customer hold time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_HOLD_TIME_ALL_CONTACTS}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical}{Average customer hold time all contacts}

\strong{AVG_HOLDS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical}{Average holds}

Feature is a valid filter but not a valid grouping.

\strong{AVG_INTERACTION_AND_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical}{Average agent interaction and customer hold time}

\strong{AVG_INTERACTION_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical}{Average agent interaction time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_INTERRUPTIONS_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical}{Average interruptions agent}

\strong{AVG_INTERRUPTION_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical}{Average interruption time agent}

\strong{AVG_NON_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical}{Average non-talk time}

\strong{AVG_QUEUE_ANSWER_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical}{Average queue answer time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_RESOLUTION_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical}{Average resolution time}

\strong{AVG_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical}{Average talk time}

\strong{AVG_TALK_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical}{Average talk time agent}

\strong{AVG_TALK_TIME_CUSTOMER}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical}{Average talk time customer}

\strong{CASES_CREATED}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##cases-created-historical}{Cases created}

\strong{CONTACTS_ABANDONED}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype,
RoutingStepExpression

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical}{Contact abandoned}

\strong{CONTACTS_CREATED}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical}{Contacts created}

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_HANDLED}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}, \code{DISCONNECT_REASON}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype,
RoutingStepExpression

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical}{API contacts handled}

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical}{Contacts handled by Connected to agent}

\strong{CONTACTS_HOLD_ABANDONS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical}{Contacts hold disconnect}

\strong{CONTACTS_ON_HOLD_AGENT_DISCONNECT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical}{Contacts hold agent disconnect}

\strong{CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical}{Contacts hold customer disconnect}

\strong{CONTACTS_PUT_ON_HOLD}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical}{Contacts put on hold}

\strong{CONTACTS_TRANSFERRED_OUT_EXTERNAL}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical}{Contacts transferred out external}

\strong{CONTACTS_TRANSFERRED_OUT_INTERNAL}

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical}{Contacts transferred out internal}

\strong{CONTACTS_QUEUED}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical}{Contacts queued}

\strong{CONTACTS_QUEUED_BY_ENQUEUE}

Unit: Count

Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical}{Contacts queued by Enqueue}

\strong{CONTACTS_RESOLVED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype

Threshold: For \code{ThresholdValue} enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical}{Contacts resolved in X}

\strong{CONTACTS_TRANSFERRED_OUT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical}{Contacts transferred out}

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_TRANSFERRED_OUT_BY_AGENT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical}{Contacts transferred out by agent}

\strong{CONTACTS_TRANSFERRED_OUT_FROM_QUEUE}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical}{Contacts transferred out queue}

\strong{CURRENT_CASES}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical}{Current cases}

\strong{MAX_QUEUED_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical}{Maximum queued time}

\strong{PERCENT_CASES_FIRST_CONTACT_RESOLVED}

Unit: Percent

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical}{Cases resolved on first contact}

\strong{PERCENT_CONTACTS_STEP_EXPIRED}

Unit: Percent

Valid groupings and filters: Queue, RoutingStepExpression

UI name: Not available

\strong{PERCENT_CONTACTS_STEP_JOINED}

Unit: Percent

Valid groupings and filters: Queue, RoutingStepExpression

UI name: Not available

\strong{PERCENT_NON_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical}{Non-talk time percent}

\strong{PERCENT_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical}{Talk time percent}

\strong{PERCENT_TALK_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical}{Talk time agent percent}

\strong{PERCENT_TALK_TIME_CUSTOMER}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical}{Talk time customer percent}

\strong{REOPENED_CASE_ACTIONS}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical}{Cases reopened}

\strong{RESOLVED_CASE_ACTIONS}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historicall}{Cases resolved}

\strong{SERVICE_LEVEL}

You can include up to 20 SERVICE_LEVEL metrics in a request.

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical}{Service level X}

\strong{STEP_CONTACTS_QUEUED}

Unit: Count

Valid groupings and filters: Queue, RoutingStepExpression

UI name: Not available

\strong{SUM_AFTER_CONTACT_WORK_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical}{After contact work time}

\strong{SUM_CONNECTING_TIME_AGENT}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}. This metric only supports
the following filter keys as \code{INITIATION_METHOD}: \code{INBOUND} | \code{OUTBOUND}
| \code{CALLBACK} | \code{API}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time}{Agent API connecting time}

The \code{Negate} key in Metric Level Filters is not applicable for this
metric.

\strong{SUM_CONTACT_FLOW_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical}{Contact flow time}

\strong{SUM_CONTACT_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical}{Agent on contact time}

\strong{SUM_CONTACTS_ANSWERED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical}{Contacts answered in X seconds}

\strong{SUM_CONTACTS_ABANDONED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical}{Contacts abandoned in X seconds}

\strong{SUM_CONTACTS_DISCONNECTED}

Valid metric filter key: \code{DISCONNECT_REASON}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical}{Contact disconnected}

\strong{SUM_ERROR_STATUS_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical}{Error status time}

\strong{SUM_HANDLE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical}{Contact handle time}

\strong{SUM_HOLD_TIME}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical}{Customer hold time}

\strong{SUM_IDLE_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica}{Agent idle time}

\strong{SUM_INTERACTION_AND_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical}{Agent interaction and hold time}

\strong{SUM_INTERACTION_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical}{Agent interaction time}

\strong{SUM_NON_PRODUCTIVE_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical}{Non-Productive Time}

\strong{SUM_ONLINE_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical}{Online time}

\strong{SUM_RETRY_CALLBACK_ATTEMPTS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical}{Callback attempts}}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximum number of results to return per page.}
}
\description{
Gets metric data from the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_get_metric_data_v2/} for full documentation.
}
\keyword{internal}
