% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_reboot_cache_cluster}
\alias{elasticache_reboot_cache_cluster}
\title{Reboots some, or all, of the cache nodes within a provisioned cluster}
\usage{
elasticache_reboot_cache_cluster(CacheClusterId, CacheNodeIdsToReboot)
}
\arguments{
\item{CacheClusterId}{[required] The cluster identifier. This parameter is stored as a lowercase string.}

\item{CacheNodeIdsToReboot}{[required] A list of cache node IDs to reboot. A node ID is a numeric identifier
(0001, 0002, etc.). To reboot an entire cluster, specify all of the
cache node IDs.}
}
\description{
Reboots some, or all, of the cache nodes within a provisioned cluster.
This operation applies any modified cache parameter groups to the
cluster. The reboot operation takes place as soon as possible, and
results in a momentary outage to the cluster. During the reboot, the
cluster status is set to REBOOTING.

The reboot causes the contents of the cache (for each cache node being
rebooted) to be lost.

When the reboot is complete, a cluster event is created.

Rebooting a cluster is currently supported on Memcached and Redis
(cluster mode disabled) clusters. Rebooting is not supported on Redis
(cluster mode enabled) clusters.

If you make changes to parameters that require a Redis (cluster mode
enabled) cluster reboot for the changes to be applied, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html}{Rebooting a Cluster}
for an alternate process.
}
\section{Request syntax}{
\preformatted{svc$reboot_cache_cluster(
  CacheClusterId = "string",
  CacheNodeIdsToReboot = list(
    "string"
  )
)
}
}

\keyword{internal}
