% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_add_source_identifier_to_subscription}
\alias{rds_add_source_identifier_to_subscription}
\title{Adds a source identifier to an existing RDS event notification
subscription}
\usage{
rds_add_source_identifier_to_subscription(SubscriptionName,
  SourceIdentifier)
}
\arguments{
\item{SubscriptionName}{[required] The name of the RDS event notification subscription you want to add a
source identifier to.}

\item{SourceIdentifier}{[required] The identifier of the event source to be added.

Constraints:
\itemize{
\item If the source type is a DB instance, a \code{DBInstanceIdentifier} value
must be supplied.
\item If the source type is a DB cluster, a \code{DBClusterIdentifier} value
must be supplied.
\item If the source type is a DB parameter group, a \code{DBParameterGroupName}
value must be supplied.
\item If the source type is a DB security group, a \code{DBSecurityGroupName}
value must be supplied.
\item If the source type is a DB snapshot, a \code{DBSnapshotIdentifier} value
must be supplied.
\item If the source type is a DB cluster snapshot, a
\code{DBClusterSnapshotIdentifier} value must be supplied.
}}
}
\description{
Adds a source identifier to an existing RDS event notification
subscription.
}
\section{Request syntax}{
\preformatted{svc$add_source_identifier_to_subscription(
  SubscriptionName = "string",
  SourceIdentifier = "string"
)
}
}

\keyword{internal}
