% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_export_tasks}
\alias{rds_describe_export_tasks}
\title{Returns information about a snapshot export to Amazon S3}
\usage{
rds_describe_export_tasks(ExportTaskIdentifier, SourceArn, Filters,
  Marker, MaxRecords)
}
\arguments{
\item{ExportTaskIdentifier}{The identifier of the snapshot export task to be described.}

\item{SourceArn}{The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.}

\item{Filters}{Filters specify one or more snapshot exports to describe. The filters
are specified as name-value pairs that define what to include in the
output. Filter names and values are case-sensitive.

Supported filters include the following:
\itemize{
\item \code{export-task-identifier} - An identifier for the snapshot export
task.
\item \code{s3-bucket} - The Amazon S3 bucket the snapshot is exported to.
\item \code{source-arn} - The Amazon Resource Name (ARN) of the snapshot
exported to Amazon S3
\item \code{status} - The status of the export task. Must be lowercase, for
example, \code{complete}.
}}

\item{Marker}{An optional pagination token provided by a previous
\code{DescribeExportTasks} request. If you specify this parameter, the
response includes only records beyond the marker, up to the value
specified by the \code{MaxRecords} parameter.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified value, a pagination token called a
marker is included in the response. You can use the marker in a later
\code{DescribeExportTasks} request to retrieve the remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}
}
\description{
Returns information about a snapshot export to Amazon S3. This API
operation supports pagination.
}
\section{Request syntax}{
\preformatted{svc$describe_export_tasks(
  ExportTaskIdentifier = "string",
  SourceArn = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  Marker = "string",
  MaxRecords = 123
)
}
}

\keyword{internal}
