% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_option_group}
\alias{rds_modify_option_group}
\title{Modifies an existing option group}
\usage{
rds_modify_option_group(OptionGroupName, OptionsToInclude,
  OptionsToRemove, ApplyImmediately)
}
\arguments{
\item{OptionGroupName}{[required] The name of the option group to be modified.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group can't
be removed from a DB instance once it is associated with a DB instance}

\item{OptionsToInclude}{Options in this list are added to the option group or, if already
present, the specified configuration is used to update the existing
configuration.}

\item{OptionsToRemove}{Options in this list are removed from the option group.}

\item{ApplyImmediately}{A value that indicates whether to apply the change immediately or during
the next maintenance window for each instance associated with the option
group.}
}
\description{
Modifies an existing option group.
}
\section{Request syntax}{
\preformatted{svc$modify_option_group(
  OptionGroupName = "string",
  OptionsToInclude = list(
    list(
      OptionName = "string",
      Port = 123,
      OptionVersion = "string",
      DBSecurityGroupMemberships = list(
        "string"
      ),
      VpcSecurityGroupMemberships = list(
        "string"
      ),
      OptionSettings = list(
        list(
          Name = "string",
          Value = "string",
          DefaultValue = "string",
          Description = "string",
          ApplyType = "string",
          DataType = "string",
          AllowedValues = "string",
          IsModifiable = TRUE|FALSE,
          IsCollection = TRUE|FALSE
        )
      )
    )
  ),
  OptionsToRemove = list(
    "string"
  ),
  ApplyImmediately = TRUE|FALSE
)
}
}

\keyword{internal}
