% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_remove_from_global_cluster}
\alias{rds_remove_from_global_cluster}
\title{Detaches an Aurora secondary cluster from an Aurora global database
cluster}
\usage{
rds_remove_from_global_cluster(GlobalClusterIdentifier,
  DbClusterIdentifier)
}
\arguments{
\item{GlobalClusterIdentifier}{The cluster identifier to detach from the Aurora global database
cluster.}

\item{DbClusterIdentifier}{The Amazon Resource Name (ARN) identifying the cluster that was detached
from the Aurora global database cluster.}
}
\description{
Detaches an Aurora secondary cluster from an Aurora global database
cluster. The cluster becomes a standalone cluster with read-write
capability instead of being read-only and receiving data from a primary
cluster in a different region.

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$remove_from_global_cluster(
  GlobalClusterIdentifier = "string",
  DbClusterIdentifier = "string"
)
}
}

\keyword{internal}
