% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dax_operations.R
\name{dax_update_cluster}
\alias{dax_update_cluster}
\title{Modifies the settings for a DAX cluster}
\usage{
dax_update_cluster(ClusterName, Description, PreferredMaintenanceWindow,
  NotificationTopicArn, NotificationTopicStatus, ParameterGroupName,
  SecurityGroupIds)
}
\arguments{
\item{ClusterName}{[required] The name of the DAX cluster to be modified.}

\item{Description}{A description of the changes being made to the cluster.}

\item{PreferredMaintenanceWindow}{A range of time when maintenance of DAX cluster software will be
performed. For example: \code{sun:01:00-sun:09:00}. Cluster maintenance
normally takes less than 30 minutes, and is performed automatically
within the maintenance window.}

\item{NotificationTopicArn}{The Amazon Resource Name (ARN) that identifies the topic.}

\item{NotificationTopicStatus}{The current state of the topic.}

\item{ParameterGroupName}{The name of a parameter group for this cluster.}

\item{SecurityGroupIds}{A list of user-specified security group IDs to be assigned to each node
in the DAX cluster. If this parameter is not specified, DAX assigns the
default VPC security group to each node.}
}
\value{
A list with the following syntax:\preformatted{list(
  Cluster = list(
    ClusterName = "string",
    Description = "string",
    ClusterArn = "string",
    TotalNodes = 123,
    ActiveNodes = 123,
    NodeType = "string",
    Status = "string",
    ClusterDiscoveryEndpoint = list(
      Address = "string",
      Port = 123
    ),
    NodeIdsToRemove = list(
      "string"
    ),
    Nodes = list(
      list(
        NodeId = "string",
        Endpoint = list(
          Address = "string",
          Port = 123
        ),
        NodeCreateTime = as.POSIXct(
          "2015-01-01"
        ),
        AvailabilityZone = "string",
        NodeStatus = "string",
        ParameterGroupStatus = "string"
      )
    ),
    PreferredMaintenanceWindow = "string",
    NotificationConfiguration = list(
      TopicArn = "string",
      TopicStatus = "string"
    ),
    SubnetGroup = "string",
    SecurityGroups = list(
      list(
        SecurityGroupIdentifier = "string",
        Status = "string"
      )
    ),
    IamRoleArn = "string",
    ParameterGroup = list(
      ParameterGroupName = "string",
      ParameterApplyStatus = "string",
      NodeIdsToReboot = list(
        "string"
      )
    ),
    SSEDescription = list(
      Status = "ENABLING"|"ENABLED"|"DISABLING"|"DISABLED"
    )
  )
)
}
}
\description{
Modifies the settings for a DAX cluster. You can use this action to
change one or more cluster configuration parameters by specifying the
parameters and the new values.
}
\section{Request syntax}{
\preformatted{svc$update_cluster(
  ClusterName = "string",
  Description = "string",
  PreferredMaintenanceWindow = "string",
  NotificationTopicArn = "string",
  NotificationTopicStatus = "string",
  ParameterGroupName = "string",
  SecurityGroupIds = list(
    "string"
  )
)
}
}

\keyword{internal}
