% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_delete_table}
\alias{dynamodb_delete_table}
\title{The DeleteTable operation deletes a table and all of its items}
\usage{
dynamodb_delete_table(TableName)
}
\arguments{
\item{TableName}{[required] The name of the table to delete.}
}
\value{
A list with the following syntax:\preformatted{list(
  TableDescription = list(
    AttributeDefinitions = list(
      list(
        AttributeName = "string",
        AttributeType = "S"|"N"|"B"
      )
    ),
    TableName = "string",
    KeySchema = list(
      list(
        AttributeName = "string",
        KeyType = "HASH"|"RANGE"
      )
    ),
    TableStatus = "CREATING"|"UPDATING"|"DELETING"|"ACTIVE"|"INACCESSIBLE_ENCRYPTION_CREDENTIALS"|"ARCHIVING"|"ARCHIVED",
    CreationDateTime = as.POSIXct(
      "2015-01-01"
    ),
    ProvisionedThroughput = list(
      LastIncreaseDateTime = as.POSIXct(
        "2015-01-01"
      ),
      LastDecreaseDateTime = as.POSIXct(
        "2015-01-01"
      ),
      NumberOfDecreasesToday = 123,
      ReadCapacityUnits = 123,
      WriteCapacityUnits = 123
    ),
    TableSizeBytes = 123,
    ItemCount = 123,
    TableArn = "string",
    TableId = "string",
    BillingModeSummary = list(
      BillingMode = "PROVISIONED"|"PAY_PER_REQUEST",
      LastUpdateToPayPerRequestDateTime = as.POSIXct(
        "2015-01-01"
      )
    ),
    LocalSecondaryIndexes = list(
      list(
        IndexName = "string",
        KeySchema = list(
          list(
            AttributeName = "string",
            KeyType = "HASH"|"RANGE"
          )
        ),
        Projection = list(
          ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
          NonKeyAttributes = list(
            "string"
          )
        ),
        IndexSizeBytes = 123,
        ItemCount = 123,
        IndexArn = "string"
      )
    ),
    GlobalSecondaryIndexes = list(
      list(
        IndexName = "string",
        KeySchema = list(
          list(
            AttributeName = "string",
            KeyType = "HASH"|"RANGE"
          )
        ),
        Projection = list(
          ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
          NonKeyAttributes = list(
            "string"
          )
        ),
        IndexStatus = "CREATING"|"UPDATING"|"DELETING"|"ACTIVE",
        Backfilling = TRUE|FALSE,
        ProvisionedThroughput = list(
          LastIncreaseDateTime = as.POSIXct(
            "2015-01-01"
          ),
          LastDecreaseDateTime = as.POSIXct(
            "2015-01-01"
          ),
          NumberOfDecreasesToday = 123,
          ReadCapacityUnits = 123,
          WriteCapacityUnits = 123
        ),
        IndexSizeBytes = 123,
        ItemCount = 123,
        IndexArn = "string"
      )
    ),
    StreamSpecification = list(
      StreamEnabled = TRUE|FALSE,
      StreamViewType = "NEW_IMAGE"|"OLD_IMAGE"|"NEW_AND_OLD_IMAGES"|"KEYS_ONLY"
    ),
    LatestStreamLabel = "string",
    LatestStreamArn = "string",
    GlobalTableVersion = "string",
    Replicas = list(
      list(
        RegionName = "string",
        ReplicaStatus = "CREATING"|"CREATION_FAILED"|"UPDATING"|"DELETING"|"ACTIVE"|"REGION_DISABLED"|"INACCESSIBLE_ENCRYPTION_CREDENTIALS",
        ReplicaStatusDescription = "string",
        ReplicaStatusPercentProgress = "string",
        KMSMasterKeyId = "string",
        ProvisionedThroughputOverride = list(
          ReadCapacityUnits = 123
        ),
        GlobalSecondaryIndexes = list(
          list(
            IndexName = "string",
            ProvisionedThroughputOverride = list(
              ReadCapacityUnits = 123
            )
          )
        ),
        ReplicaInaccessibleDateTime = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    RestoreSummary = list(
      SourceBackupArn = "string",
      SourceTableArn = "string",
      RestoreDateTime = as.POSIXct(
        "2015-01-01"
      ),
      RestoreInProgress = TRUE|FALSE
    ),
    SSEDescription = list(
      Status = "ENABLING"|"ENABLED"|"DISABLING"|"DISABLED"|"UPDATING",
      SSEType = "AES256"|"KMS",
      KMSMasterKeyArn = "string",
      InaccessibleEncryptionDateTime = as.POSIXct(
        "2015-01-01"
      )
    ),
    ArchivalSummary = list(
      ArchivalDateTime = as.POSIXct(
        "2015-01-01"
      ),
      ArchivalReason = "string",
      ArchivalBackupArn = "string"
    )
  )
)
}
}
\description{
The \code{\link[=dynamodb_delete_table]{delete_table}} operation deletes a table
and all of its items. After a \code{\link[=dynamodb_delete_table]{delete_table}}
request, the specified table is in the \code{DELETING} state until DynamoDB
completes the deletion. If the table is in the \code{ACTIVE} state, you can
delete it. If a table is in \code{CREATING} or \code{UPDATING} states, then
DynamoDB returns a \code{ResourceInUseException}. If the specified table does
not exist, DynamoDB returns a \code{ResourceNotFoundException}. If table is
already in the \code{DELETING} state, no error is returned.

DynamoDB might continue to accept data read and write operations, such
as \code{\link[=dynamodb_get_item]{get_item}} and \code{\link[=dynamodb_put_item]{put_item}},
on a table in the \code{DELETING} state until the table deletion is complete.

When you delete a table, any indexes on that table are also deleted.

If you have DynamoDB Streams enabled on the table, then the
corresponding stream on that table goes into the \code{DISABLED} state, and
the stream is automatically deleted after 24 hours.

Use the \code{\link[=dynamodb_describe_table]{describe_table}} action to check the
status of the table.
}
\section{Request syntax}{
\preformatted{svc$delete_table(
  TableName = "string"
)
}
}

\examples{
\dontrun{
# This example deletes the Music table.
svc$delete_table(
  TableName = "Music"
)
}

}
\keyword{internal}
