% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_db_cluster_snapshot}
\alias{neptune_create_db_cluster_snapshot}
\title{Creates a snapshot of a DB cluster}
\usage{
neptune_create_db_cluster_snapshot(DBClusterSnapshotIdentifier,
  DBClusterIdentifier, Tags)
}
\arguments{
\item{DBClusterSnapshotIdentifier}{[required] The identifier of the DB cluster snapshot. This parameter is stored as a
lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1-snapshot1}}

\item{DBClusterIdentifier}{[required] The identifier of the DB cluster to create a snapshot for. This
parameter is not case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing DBCluster.
}

Example: \code{my-cluster1}}

\item{Tags}{The tags to be assigned to the DB cluster snapshot.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBClusterSnapshot = list(
    AvailabilityZones = list(
      "string"
    ),
    DBClusterSnapshotIdentifier = "string",
    DBClusterIdentifier = "string",
    SnapshotCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    Engine = "string",
    AllocatedStorage = 123,
    Status = "string",
    Port = 123,
    VpcId = "string",
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    MasterUsername = "string",
    EngineVersion = "string",
    LicenseModel = "string",
    SnapshotType = "string",
    PercentProgress = 123,
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DBClusterSnapshotArn = "string",
    SourceDBClusterSnapshotArn = "string",
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE
  )
)
}
}
\description{
Creates a snapshot of a DB cluster.
}
\section{Request syntax}{
\preformatted{svc$create_db_cluster_snapshot(
  DBClusterSnapshotIdentifier = "string",
  DBClusterIdentifier = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
