% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_instance_to_point_in_time}
\alias{rds_restore_db_instance_to_point_in_time}
\title{Restores a DB instance to an arbitrary point in time}
\usage{
rds_restore_db_instance_to_point_in_time(SourceDBInstanceIdentifier,
  TargetDBInstanceIdentifier, RestoreTime, UseLatestRestorableTime,
  DBInstanceClass, Port, AvailabilityZone, DBSubnetGroupName, MultiAZ,
  PubliclyAccessible, AutoMinorVersionUpgrade, LicenseModel, DBName,
  Engine, Iops, OptionGroupName, CopyTagsToSnapshot, Tags, StorageType,
  TdeCredentialArn, TdeCredentialPassword, VpcSecurityGroupIds, Domain,
  DomainIAMRoleName, EnableIAMDatabaseAuthentication,
  EnableCloudwatchLogsExports, ProcessorFeatures,
  UseDefaultProcessorFeatures, DBParameterGroupName, DeletionProtection,
  SourceDbiResourceId)
}
\arguments{
\item{SourceDBInstanceIdentifier}{The identifier of the source DB instance from which to restore.

Constraints:
\itemize{
\item Must match the identifier of an existing DB instance.
}}

\item{TargetDBInstanceIdentifier}{[required] The name of the new DB instance to be created.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}}

\item{RestoreTime}{The date and time to restore from.

Valid Values: Value must be a time in Universal Coordinated Time (UTC)
format

Constraints:
\itemize{
\item Must be before the latest restorable time for the DB instance
\item Can't be specified if the \code{UseLatestRestorableTime} parameter is
enabled
}

Example: \code{2009-09-07T23:45:00Z}}

\item{UseLatestRestorableTime}{A value that indicates whether the DB instance is restored from the
latest backup time. By default, the DB instance is not restored from the
latest backup time.

Constraints: Can't be specified if the \code{RestoreTime} parameter is
provided.}

\item{DBInstanceClass}{The compute and memory capacity of the Amazon RDS DB instance, for
example, \code{db.m4.large}. Not all DB instance classes are available in all
AWS Regions, or for all database engines. For the full list of DB
instance classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide.}

Default: The same DBInstanceClass as the original DB instance.}

\item{Port}{The port number on which the database accepts connections.

Constraints: Value must be \code{1150-65535}

Default: The same port as the original DB instance.}

\item{AvailabilityZone}{The Availability Zone (AZ) where the DB instance will be created.

Default: A random, system-chosen Availability Zone.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the
DB instance is a Multi-AZ deployment.

Example: \code{us-east-1a}}

\item{DBSubnetGroupName}{The DB subnet group name to use for the new instance.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mySubnetgroup}}

\item{MultiAZ}{A value that indicates whether the DB instance is a Multi-AZ deployment.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the
DB instance is a Multi-AZ deployment.}

\item{PubliclyAccessible}{A value that indicates whether the DB instance is publicly accessible.
When the DB instance is publicly accessible, it is an Internet-facing
instance with a publicly resolvable DNS name, which resolves to a public
IP address. When the DB instance is not publicly accessible, it is an
internal instance with a DNS name that resolves to a private IP address.
For more information, see CreateDBInstance.}

\item{AutoMinorVersionUpgrade}{A value that indicates whether minor version upgrades are applied
automatically to the DB instance during the maintenance window.}

\item{LicenseModel}{License model information for the restored DB instance.

Default: Same as source.

Valid values: \code{license-included} \| \code{bring-your-own-license} \|
\code{general-public-license}}

\item{DBName}{The database name for the restored DB instance.

This parameter is not used for the MySQL or MariaDB engines.}

\item{Engine}{The database engine to use for the new instance.

Default: The same as source

Constraint: Must be compatible with the engine of the source

Valid Values:
\itemize{
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-se2}
\item \code{oracle-se1}
\item \code{oracle-se}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
be initially allocated for the DB instance.

Constraints: Must be an integer greater than 1000.

\strong{SQL Server}

Setting the IOPS value for the SQL Server database engine is not
supported.}

\item{OptionGroupName}{The name of the option group to be used for the restored DB instance.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group
can't be removed from a DB instance once it is associated with a DB
instance}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the restored DB
instance to snapshots of the DB instance. By default, tags are not
copied.}

\item{Tags}{}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

Valid values: \code{standard | gp2 | io1}

If you specify \code{io1}, you must also include a value for the \code{Iops}
parameter.

Default: \code{io1} if the \code{Iops} parameter is specified, otherwise \code{gp2}}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB instance.

Default: The default EC2 VPC security group for the DB subnet group's
VPC.}

\item{Domain}{Specify the Active Directory Domain to restore the instance in.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of AWS Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled.

You can enable IAM database authentication for the following database
engines
\itemize{
\item For MySQL 5.6, minor version 5.6.34 or higher
\item For MySQL 5.7, minor version 5.7.16 or higher
}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB instance is to export to
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.}

\item{UseDefaultProcessorFeatures}{A value that indicates whether the DB instance class of the DB instance
uses its default processor features.}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.
If this argument is omitted, the default DBParameterGroup for the
specified engine is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DBParameterGroup.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{DeletionProtection}{A value that indicates whether the DB instance has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is disabled. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}

\item{SourceDbiResourceId}{The resource ID of the source DB instance from which to restore.}
}
\description{
Restores a DB instance to an arbitrary point in time. You can restore to
any point in time before the time identified by the LatestRestorableTime
property. You can restore to a point up to the number of days specified
by the BackupRetentionPeriod property.
}
\details{
The target database is created with most of the original configuration,
but in a system-selected Availability Zone, with the default security
group, the default subnet group, and the default DB parameter group. By
default, the new DB instance is created as a single-AZ deployment except
when the instance is a SQL Server instance that has an option group that
is associated with mirroring; in this case, the instance becomes a
mirrored deployment and not a single-AZ deployment.

This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For
Aurora, use \code{RestoreDBClusterToPointInTime}.
}
\section{Request syntax}{
\preformatted{svc$restore_db_instance_to_point_in_time(
  SourceDBInstanceIdentifier = "string",
  TargetDBInstanceIdentifier = "string",
  RestoreTime = as.POSIXct(
    "2015-01-01"
  ),
  UseLatestRestorableTime = TRUE|FALSE,
  DBInstanceClass = "string",
  Port = 123,
  AvailabilityZone = "string",
  DBSubnetGroupName = "string",
  MultiAZ = TRUE|FALSE,
  PubliclyAccessible = TRUE|FALSE,
  AutoMinorVersionUpgrade = TRUE|FALSE,
  LicenseModel = "string",
  DBName = "string",
  Engine = "string",
  Iops = 123,
  OptionGroupName = "string",
  CopyTagsToSnapshot = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  StorageType = "string",
  TdeCredentialArn = "string",
  TdeCredentialPassword = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Domain = "string",
  DomainIAMRoleName = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  ProcessorFeatures = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  UseDefaultProcessorFeatures = TRUE|FALSE,
  DBParameterGroupName = "string",
  DeletionProtection = TRUE|FALSE,
  SourceDbiResourceId = "string"
)
}
}

\keyword{internal}
