% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_start_db_cluster}
\alias{rds_start_db_cluster}
\title{Starts an Amazon Aurora DB cluster that was stopped using the AWS
console, the stop-db-cluster AWS CLI command, or the StopDBCluster
action}
\usage{
rds_start_db_cluster(DBClusterIdentifier)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier of the Amazon Aurora DB cluster to be started.
This parameter is stored as a lowercase string.}
}
\description{
Starts an Amazon Aurora DB cluster that was stopped using the AWS
console, the stop-db-cluster AWS CLI command, or the StopDBCluster
action.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html}{Stopping and Starting an Aurora Cluster}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$start_db_cluster(
  DBClusterIdentifier = "string"
)
}
}

\keyword{internal}
