% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_db_clusters}
\alias{docdb_describe_db_clusters}
\title{Returns information about provisioned Amazon DocumentDB DB clusters}
\usage{
docdb_describe_db_clusters(DBClusterIdentifier, Filters, MaxRecords,
  Marker)
}
\arguments{
\item{DBClusterIdentifier}{The user-provided DB cluster identifier. If this parameter is specified,
information from only the specific DB cluster is returned. This
parameter isn't case sensitive.

Constraints:
\itemize{
\item If provided, must match an existing \code{DBClusterIdentifier}.
}}

\item{Filters}{A filter that specifies one or more DB clusters to describe.

Supported filters:
\itemize{
\item \code{db-cluster-id} - Accepts DB cluster identifiers and DB cluster
Amazon Resource Names (ARNs). The results list only includes
information about the DB clusters identified by these ARNs.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
(marker) is included in the response so that the remaining results can
be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns information about provisioned Amazon DocumentDB DB clusters.
This API operation supports pagination.
}
\section{Request syntax}{
\preformatted{svc$describe_db_clusters(
  DBClusterIdentifier = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
