% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_cluster_snapshots}
\alias{redshift_describe_cluster_snapshots}
\title{Returns one or more snapshot objects, which contain metadata about your
cluster snapshots}
\usage{
redshift_describe_cluster_snapshots(ClusterIdentifier,
  SnapshotIdentifier, SnapshotType, StartTime, EndTime, MaxRecords,
  Marker, OwnerAccount, TagKeys, TagValues, ClusterExists,
  SortingEntities)
}
\arguments{
\item{ClusterIdentifier}{The identifier of the cluster which generated the requested snapshots.}

\item{SnapshotIdentifier}{The snapshot identifier of the snapshot about which to return
information.}

\item{SnapshotType}{The type of snapshots for which you are requesting information. By
default, snapshots of all types are returned.

Valid Values: \code{automated} \\| \code{manual}}

\item{StartTime}{A value that requests only snapshots created at or after the specified
time. The time value is specified in ISO 8601 format. For more
information about ISO 8601, go to the \href{http://en.wikipedia.org/wiki/ISO_8601}{ISO8601 Wikipedia page.}

Example: \verb{2012-07-16T18:00:00Z}}

\item{EndTime}{A time value that requests only snapshots created at or before the
specified time. The time value is specified in ISO 8601 format. For more
information about ISO 8601, go to the \href{http://en.wikipedia.org/wiki/ISO_8601}{ISO8601 Wikipedia page.}

Example: \verb{2012-07-16T18:00:00Z}}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a DescribeClusterSnapshots
request exceed the value specified in \code{MaxRecords}, AWS returns a value
in the \code{Marker} field of the response. You can retrieve the next set of
response records by providing the returned marker value in the \code{Marker}
parameter and retrying the request.}

\item{OwnerAccount}{The AWS customer account used to create or copy the snapshot. Use this
field to filter the results to snapshots owned by a particular account.
To describe snapshots you own, either specify your AWS customer account,
or do not specify the parameter.}

\item{TagKeys}{A tag key or keys for which you want to return all matching cluster
snapshots that are associated with the specified key or keys. For
example, suppose that you have snapshots that are tagged with keys
called \code{owner} and \code{environment}. If you specify both of these tag keys
in the request, Amazon Redshift returns a response with the snapshots
that have either or both of these tag keys associated with them.}

\item{TagValues}{A tag value or values for which you want to return all matching cluster
snapshots that are associated with the specified tag value or values.
For example, suppose that you have snapshots that are tagged with values
called \code{admin} and \code{test}. If you specify both of these tag values in
the request, Amazon Redshift returns a response with the snapshots that
have either or both of these tag values associated with them.}

\item{ClusterExists}{A value that indicates whether to return snapshots only for an existing
cluster. You can perform table-level restore only by using a snapshot of
an existing cluster, that is, a cluster that has not been deleted.
Values for this parameter work as follows:
\itemize{
\item If \code{ClusterExists} is set to \code{true}, \code{ClusterIdentifier} is
required.
\item If \code{ClusterExists} is set to \code{false} and \code{ClusterIdentifier} isn\'t
specified, all snapshots associated with deleted clusters (orphaned
snapshots) are returned.
\item If \code{ClusterExists} is set to \code{false} and \code{ClusterIdentifier} is
specified for a deleted cluster, snapshots associated with that
cluster are returned.
\item If \code{ClusterExists} is set to \code{false} and \code{ClusterIdentifier} is
specified for an existing cluster, no snapshots are returned.
}}

\item{SortingEntities}{}
}
\description{
Returns one or more snapshot objects, which contain metadata about your
cluster snapshots. By default, this operation returns information about
all snapshots of all clusters that are owned by you AWS customer
account. No information is returned for snapshots owned by inactive AWS
customer accounts.
}
\details{
If you specify both tag keys and tag values in the same request, Amazon
Redshift returns all snapshots that match any combination of the
specified keys and values. For example, if you have \code{owner} and
\code{environment} for tag keys, and \code{admin} and \code{test} for tag values, all
snapshots that have any combination of those values are returned. Only
snapshots that you own are returned in the response; shared snapshots
are not returned with the tag key and tag value request parameters.

If both tag keys and values are omitted from the request, snapshots are
returned regardless of whether they have tag keys or values associated
with them.
}
\section{Request syntax}{
\preformatted{svc$describe_cluster_snapshots(
  ClusterIdentifier = "string",
  SnapshotIdentifier = "string",
  SnapshotType = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  MaxRecords = 123,
  Marker = "string",
  OwnerAccount = "string",
  TagKeys = list(
    "string"
  ),
  TagValues = list(
    "string"
  ),
  ClusterExists = TRUE|FALSE,
  SortingEntities = list(
    list(
      Attribute = "SOURCE_TYPE"|"TOTAL_SIZE"|"CREATE_TIME",
      SortOrder = "ASC"|"DESC"
    )
  )
)
}
}

\keyword{internal}
