% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_list_table_storage_optimizers}
\alias{lakeformation_list_table_storage_optimizers}
\title{Returns the configuration of all storage optimizers associated with a
specified table}
\usage{
lakeformation_list_table_storage_optimizers(
  CatalogId = NULL,
  DatabaseName,
  TableName,
  StorageOptimizerType = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{CatalogId}{The Catalog ID of the table.}

\item{DatabaseName}{[required] Name of the database where the table is present.}

\item{TableName}{[required] Name of the table.}

\item{StorageOptimizerType}{The specific type of storage optimizers to list. The supported value is
\code{compaction}.}

\item{MaxResults}{The number of storage optimizers to return on each call.}

\item{NextToken}{A continuation token, if this is a continuation call.}
}
\description{
Returns the configuration of all storage optimizers associated with a specified table.

See \url{https://paws-r.github.io/docs/lakeformation/list_table_storage_optimizers.html} for full documentation.
}
\keyword{internal}
