% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_snapshots}
\alias{rds_describe_db_snapshots}
\title{Returns information about DB snapshots}
\usage{
rds_describe_db_snapshots(
  DBInstanceIdentifier = NULL,
  DBSnapshotIdentifier = NULL,
  SnapshotType = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  IncludeShared = NULL,
  IncludePublic = NULL,
  DbiResourceId = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{The ID of the DB instance to retrieve the list of DB snapshots for. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing DBInstance.
}}

\item{DBSnapshotIdentifier}{A specific DB snapshot identifier to describe. This value is stored as a
lowercase string.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing DBSnapshot.
\item If this identifier is for an automated snapshot, the \code{SnapshotType}
parameter must also be specified.
}}

\item{SnapshotType}{The type of snapshots to be returned. You can specify one of the
following values:
\itemize{
\item \code{automated} - Return all DB snapshots that have been automatically
taken by Amazon RDS for my Amazon Web Services account.
\item \code{manual} - Return all DB snapshots that have been taken by my Amazon
Web Services account.
\item \code{shared} - Return all manual DB snapshots that have been shared to
my Amazon Web Services account.
\item \code{public} - Return all DB snapshots that have been marked as public.
\item \code{awsbackup} - Return the DB snapshots managed by the Amazon Web
Services Backup service.

For information about Amazon Web Services Backup, see the \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html}{\emph{Amazon Web Services Backup Developer Guide.}}

The \code{awsbackup} type does not apply to Aurora.
}

If you don't specify a \code{SnapshotType} value, then both automated and
manual snapshots are returned. Shared and public DB snapshots are not
included in the returned results by default. You can include shared
snapshots with these results by enabling the \code{IncludeShared} parameter.
You can include public snapshots with these results by enabling the
\code{IncludePublic} parameter.

The \code{IncludeShared} and \code{IncludePublic} parameters don't apply for
\code{SnapshotType} values of \code{manual} or \code{automated}. The \code{IncludePublic}
parameter doesn't apply when \code{SnapshotType} is set to \code{shared}. The
\code{IncludeShared} parameter doesn't apply when \code{SnapshotType} is set to
\code{public}.}

\item{Filters}{A filter that specifies one or more DB snapshots to describe.

Supported filters:
\itemize{
\item \code{db-instance-id} - Accepts DB instance identifiers and DB instance
Amazon Resource Names (ARNs).
\item \code{db-snapshot-id} - Accepts DB snapshot identifiers.
\item \code{dbi-resource-id} - Accepts identifiers of source DB instances.
\item \code{snapshot-type} - Accepts types of DB snapshots.
\item \code{engine} - Accepts names of database engines.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_db_snapshots]{describe_db_snapshots}} request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}

\item{IncludeShared}{A value that indicates whether to include shared manual DB cluster
snapshots from other Amazon Web Services accounts that this Amazon Web
Services account has been given permission to copy or restore. By
default, these snapshots are not included.

You can give an Amazon Web Services account permission to restore a
manual DB snapshot from another Amazon Web Services account by using the
\code{\link[=rds_modify_db_snapshot_attribute]{modify_db_snapshot_attribute}} API
action.

This setting doesn't apply to RDS Custom.}

\item{IncludePublic}{A value that indicates whether to include manual DB cluster snapshots
that are public and can be copied or restored by any Amazon Web Services
account. By default, the public snapshots are not included.

You can share a manual DB snapshot as public by using the
\code{\link[=rds_modify_db_snapshot_attribute]{modify_db_snapshot_attribute}} API.

This setting doesn't apply to RDS Custom.}

\item{DbiResourceId}{A specific DB resource ID to describe.}
}
\description{
Returns information about DB snapshots. This API action supports pagination.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_db_snapshots/} for full documentation.
}
\keyword{internal}
